/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.geom.Rectangle2D;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class Dataset {
    private GeographicDataset m_dataset;
    private Row m_datasetRow;
    private int m_datasetRowCount;

    public Dataset(GeographicDataset geographicDataset) throws MapyrusException {
        this.m_dataset = geographicDataset;
        this.m_datasetRow = geographicDataset.fetch();
        this.m_datasetRowCount = 0;
    }

    public String getProjection() {
        return this.m_dataset.getProjection();
    }

    public Rectangle2D.Double getWorlds() {
        return this.m_dataset.getWorlds();
    }

    public String[] getFieldNames() {
        return this.m_dataset.getFieldNames();
    }

    public boolean hasMoreRows() {
        return this.m_datasetRow != null;
    }

    public Row fetchRow() throws MapyrusException {
        if (this.m_datasetRow == null) {
            throw new MapyrusException(MapyrusMessages.get("norows"));
        }
        Row row = this.m_datasetRow;
        this.m_datasetRow = this.m_dataset.fetch();
        ++this.m_datasetRowCount;
        return row;
    }

    public int getFetchCount() {
        return this.m_datasetRowCount;
    }

    public void close() throws MapyrusException {
        try {
            if (this.m_dataset != null) {
                this.m_dataset.close();
            }
        }
        catch (MapyrusException mapyrusException) {
            throw mapyrusException;
        }
        finally {
            this.m_dataset = null;
            this.m_datasetRow = null;
            this.m_datasetRowCount = 0;
        }
    }
}

