/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextfileDataset
implements GeographicDataset {
    private LineNumberReader m_reader;
    private String m_filename;
    private Process m_process;
    private Character m_delimiter;
    private String m_comment;
    private int m_maxFields;

    private String readLine() throws IOException {
        String string;
        while ((string = this.m_reader.readLine()) != null && this.m_comment.length() > 0 && string.startsWith(this.m_comment)) {
        }
        return string;
    }

    public TextfileDataset(String string, String string2, InputStream inputStream) throws FileNotFoundException, IOException, MapyrusException {
        Object object;
        if (string.equals("-")) {
            this.m_reader = new LineNumberReader(new InputStreamReader(inputStream));
        } else if (string.endsWith("|")) {
            object = string.substring(0, string.length() - 1).trim();
            String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{object} : new String[]{"sh", "-c", object};
            this.m_process = Runtime.getRuntime().exec(stringArray);
            this.m_reader = new LineNumberReader(new InputStreamReader(this.m_process.getInputStream()));
        } else {
            object = new FileOrURL(string);
            this.m_reader = ((FileOrURL)object).getReader();
        }
        this.m_filename = string;
        this.m_delimiter = null;
        this.m_comment = "#";
        this.m_maxFields = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("comment=")) {
                this.m_comment = string3.substring(8);
                continue;
            }
            if (!string3.startsWith("delimiter=") || string3.length() != 11) continue;
            this.m_delimiter = new Character(string3.charAt(10));
        }
    }

    @Override
    public String getProjection() {
        return "";
    }

    @Override
    public Hashtable<String, String> getMetadata() {
        return new Hashtable<String, String>();
    }

    @Override
    public String[] getFieldNames() {
        return null;
    }

    @Override
    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(-180.0, -90.0, 180.0, 90.0);
    }

    private boolean readNextRow(Row row) throws MapyrusException {
        int n;
        String string;
        try {
            string = this.readLine();
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage() + ": " + this.m_filename);
        }
        if (string == null) {
            return false;
        }
        row.clear();
        Argument argument = new Argument(1, string);
        row.add(argument);
        if (this.m_delimiter == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                row.add(new Argument(1, string2));
            }
        } else {
            n = this.m_delimiter.charValue();
            int n2 = 0;
            int n3 = string.indexOf(n);
            if (n3 < 0) {
                row.add(argument);
            } else {
                while (n3 >= 0) {
                    if (n2 == n3) {
                        row.add(Argument.emptyString);
                    } else {
                        row.add(new Argument(1, string.substring(n2, n3)));
                    }
                    n2 = n3 + 1;
                    n3 = string.indexOf(n, n2);
                }
                row.add(new Argument(1, string.substring(n2)));
            }
        }
        if ((n = this.m_maxFields - row.size()) > 0) {
            while (n-- > 0) {
                row.add(Argument.emptyString);
            }
        } else if (n < 0) {
            this.m_maxFields = row.size();
        }
        return true;
    }

    @Override
    public Row fetch() throws MapyrusException {
        Row row = new Row();
        Row row2 = this.readNextRow(row) ? row : null;
        return row2;
    }

    @Override
    public void close() throws MapyrusException {
        block14: {
            try {
                if (this.m_process != null) {
                    while (this.m_reader.read() > 0) {
                    }
                }
                if (this.m_process == null) break block14;
                try {
                    int n = this.m_process.waitFor();
                    if (n != 0) {
                        throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + this.m_filename);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new MapyrusException(interruptedException.getMessage());
                }
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
            finally {
                try {
                    this.m_reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

