/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusMessages;

public class MapyrusEditorPanel
extends JTabbedPane
implements KeyListener {
    static final long serialVersionUID = 13057L;
    private static final Color LINE_NUMBERING_COLOR = new Color(139, 0, 0);
    private HashMap<JScrollPane, JTextArea> m_textAreas = new HashMap();
    private HashSet<JScrollPane> m_editedScrollPanes = new HashSet();
    private Font m_font = null;
    private int m_tabSequenceNumber = 0;

    public MapyrusEditorPanel() {
        this.setPreferredSize(new Dimension(640, 120));
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    private JComponent createLineNumberingComponent(JScrollPane jScrollPane, JTextArea jTextArea) {
        final Font font = jTextArea.getFont();
        JComponent jComponent = new JComponent(){
            static final long serialVersionUID = 1L;

            public void paintComponent(Graphics graphics) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = fontMetrics.getHeight();
                int n2 = 3;
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setColor(Color.LIGHT_GRAY);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(LINE_NUMBERING_COLOR);
                int n3 = rectangle.y / n + 1;
                int n4 = n3 + rectangle.height / n;
                int n5 = rectangle.y / n * n + n - n2;
                for (int i = n3; i <= n4; ++i) {
                    String string = String.valueOf(i);
                    graphics.drawString(string, 0, n5);
                    n5 += n;
                }
            }
        };
        jComponent.setPreferredSize(new Dimension(34, 0x3FFFFFFF));
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTab(String string, String string2, Color color) {
        JTextArea jTextArea = new JTextArea();
        if (color != null) {
            jTextArea.setBackground(color);
        }
        jTextArea.addKeyListener(this);
        if (this.m_font != null) {
            jTextArea.setFont(this.m_font);
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JComponent jComponent = this.createLineNumberingComponent(jScrollPane, jTextArea);
        jScrollPane.setRowHeaderView(jComponent);
        this.m_textAreas.put(jScrollPane, jTextArea);
        if (string != null) {
            int n;
            CharSequence charSequence;
            Object object;
            Reader reader = null;
            try {
                object = new FileOrURL(string);
                reader = ((FileOrURL)object).getReader();
                charSequence = new StringBuffer();
                char[] cArray = new char[512];
                while ((n = reader.read(cArray)) > 0) {
                    ((StringBuffer)charSequence).append(cArray, 0, n);
                }
                jTextArea.setText(((StringBuffer)charSequence).toString());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), "Mapyrus", 0);
                return;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (string2 == null) {
                object = new File(string);
                string2 = ((File)object).getName();
                charSequence = "." + "Mapyrus".toLowerCase();
                if (string2.toLowerCase().endsWith((String)charSequence)) {
                    string2 = string2.substring(0, string2.length() - ((String)charSequence).length());
                }
                int n2 = this.getTabCount();
                for (n = 0; n < n2; ++n) {
                    if (!this.getTitleAt(n).equalsIgnoreCase(string2)) continue;
                    ++this.m_tabSequenceNumber;
                    string2 = string2 + "_" + this.m_tabSequenceNumber;
                    break;
                }
            }
            this.add(string2, jScrollPane);
            this.setToolTipTextAt(this.getTabCount() - 1, string);
        } else {
            if (string2 == null) {
                string2 = MapyrusMessages.get("untitled");
                if (++this.m_tabSequenceNumber > 1) {
                    string2 = string2 + "_" + this.m_tabSequenceNumber;
                }
            }
            this.add(string2, jScrollPane);
            this.setToolTipTextAt(this.getTabCount() - 1, string2 + "." + "Mapyrus".toLowerCase());
        }
        this.setSelectedComponent(jScrollPane);
    }

    public void appendToSelectedTextArea(String string) {
        JTextArea jTextArea = this.getSelectedTextArea();
        if (jTextArea != null) {
            jTextArea.append(string);
        }
    }

    private JTextArea getSelectedTextArea() {
        JTextArea jTextArea = null;
        JScrollPane jScrollPane = (JScrollPane)this.getSelectedComponent();
        if (jScrollPane != null) {
            jTextArea = this.m_textAreas.get(jScrollPane);
        }
        return jTextArea;
    }

    public String getSelectedTabContents() {
        String string = "";
        JTextArea jTextArea = this.getSelectedTextArea();
        if (jTextArea != null) {
            string = jTextArea.getText();
        }
        return string;
    }

    public String getSelectedTabTitle() {
        String string = "";
        int n = this.getSelectedIndex();
        if (n >= 0) {
            string = this.getTitleAt(n);
        }
        return string;
    }

    public String getSelectedTabFilename() {
        String string = "";
        int n = this.getSelectedIndex();
        if (n >= 0) {
            string = this.getToolTipTextAt(n);
        }
        return string;
    }

    public void closeSelectedTab() {
        JScrollPane jScrollPane = (JScrollPane)this.getSelectedComponent();
        if (jScrollPane != null) {
            this.m_textAreas.remove(jScrollPane);
            this.remove(jScrollPane);
        }
    }

    public boolean isSelectedTabEdited() {
        boolean bl = false;
        JScrollPane jScrollPane = (JScrollPane)this.getSelectedComponent();
        if (jScrollPane != null) {
            bl = this.m_editedScrollPanes.contains(jScrollPane);
        }
        return bl;
    }

    public void setSelectedTabEdited(boolean bl) {
        JScrollPane jScrollPane = (JScrollPane)this.getSelectedComponent();
        if (jScrollPane != null) {
            if (bl) {
                this.m_editedScrollPanes.add(jScrollPane);
            } else {
                this.m_editedScrollPanes.remove(jScrollPane);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.setSelectedTabEdited(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

