/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.util.ArrayList;
import java.util.HashMap;
import org.mapyrus.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statement {
    public static final int CONDITIONAL = 2;
    public static final int REPEAT_LOOP = 3;
    public static final int WHILE_LOOP = 4;
    public static final int FOR_LOOP = 5;
    public static final int BLOCK = 6;
    public static final int COLOR = 9;
    public static final int BLEND = 10;
    public static final int LINESTYLE = 11;
    public static final int FONT = 12;
    public static final int JUSTIFY = 13;
    public static final int MOVE = 14;
    public static final int DRAW = 15;
    public static final int RDRAW = 16;
    public static final int ARC = 17;
    public static final int CIRCLE = 18;
    public static final int ELLIPSE = 19;
    public static final int CYLINDER = 20;
    public static final int RAINDROP = 21;
    public static final int BEZIER = 22;
    public static final int SINEWAVE = 23;
    public static final int WEDGE = 24;
    public static final int SPIRAL = 25;
    public static final int BOX = 26;
    public static final int ROUNDEDBOX = 27;
    public static final int BOX3D = 28;
    public static final int CHESSBOARD = 29;
    public static final int HEXAGON = 30;
    public static final int PENTAGON = 31;
    public static final int TRIANGLE = 32;
    public static final int STAR = 33;
    public static final int ADDPATH = 34;
    public static final int CLEARPATH = 35;
    public static final int CLOSEPATH = 36;
    public static final int SAMPLEPATH = 37;
    public static final int STRIPEPATH = 38;
    public static final int SHIFTPATH = 39;
    public static final int PARALLELPATH = 40;
    public static final int SELECTPATH = 41;
    public static final int REVERSEPATH = 42;
    public static final int SINKHOLE = 43;
    public static final int GUILLOTINE = 44;
    public static final int STROKE = 45;
    public static final int FILL = 46;
    public static final int GRADIENTFILL = 47;
    public static final int EVENTSCRIPT = 48;
    public static final int PROTECT = 49;
    public static final int UNPROTECT = 50;
    public static final int CLIP = 51;
    public static final int LABEL = 52;
    public static final int FLOWLABEL = 53;
    public static final int TABLE = 54;
    public static final int TREE = 55;
    public static final int ICON = 56;
    public static final int GEOIMAGE = 57;
    public static final int EPS = 58;
    public static final int SVG = 59;
    public static final int SVGCODE = 60;
    public static final int PDF = 61;
    public static final int SCALE = 62;
    public static final int ROTATE = 63;
    public static final int WORLDS = 64;
    public static final int DATASET = 65;
    public static final int FETCH = 66;
    public static final int NEWPAGE = 67;
    public static final int ENDPAGE = 68;
    public static final int SETOUTPUT = 69;
    public static final int PRINT = 70;
    public static final int LOCAL = 71;
    public static final int LET = 72;
    public static final int EVAL = 73;
    public static final int KEY = 74;
    public static final int LEGEND = 75;
    public static final int MIMETYPE = 76;
    public static final int HTTPRESPONSE = 77;
    public static final int CALL = 1000;
    public static final int RETURN = 1001;
    private int m_type;
    private ArrayList<Statement> m_thenStatements;
    private ArrayList<Statement> m_elseStatements;
    private ArrayList<Statement> m_loopStatements;
    private String m_blockName;
    private ArrayList<Statement> m_statementBlock;
    private ArrayList<String> m_parameters;
    private Expression[] m_expressions;
    private Expression m_forHashMapExpression;
    private String m_filename;
    private int m_lineNumber;
    private static HashMap<String, Integer> m_statementTypeLookup = new HashMap(100);

    private int getStatementType(String string) {
        Integer n = m_statementTypeLookup.get(string.toLowerCase());
        int n2 = n == null ? 1000 : n;
        return n2;
    }

    public Statement(String string, Expression[] expressionArray) {
        this.m_type = this.getStatementType(string);
        if (this.m_type == 1000) {
            this.m_blockName = string;
        }
        this.m_expressions = expressionArray;
    }

    public Statement(String string, ArrayList<String> arrayList, ArrayList<Statement> arrayList2) {
        this.m_blockName = string;
        this.m_parameters = arrayList;
        this.m_statementBlock = arrayList2;
        this.m_type = 6;
    }

    public Statement(Expression expression, ArrayList<Statement> arrayList, ArrayList<Statement> arrayList2) {
        this.m_type = 2;
        this.m_expressions = new Expression[1];
        this.m_expressions[0] = expression;
        this.m_thenStatements = arrayList;
        this.m_elseStatements = arrayList2;
    }

    public Statement(Expression expression, ArrayList<Statement> arrayList, boolean bl) {
        this.m_type = bl ? 4 : 3;
        this.m_expressions = new Expression[1];
        this.m_expressions[0] = expression;
        this.m_loopStatements = arrayList;
    }

    public Statement(Expression expression, Expression expression2, ArrayList<Statement> arrayList) {
        this.m_type = 5;
        this.m_expressions = new Expression[1];
        this.m_expressions[0] = expression;
        this.m_forHashMapExpression = expression2;
        this.m_loopStatements = arrayList;
    }

    public void setFilenameAndLineNumber(String string, int n) {
        this.m_filename = string;
        this.m_lineNumber = n;
    }

    public String getFilenameAndLineNumber() {
        return this.m_filename + ":" + this.m_lineNumber;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public int getType() {
        return this.m_type;
    }

    public Expression[] getExpressions() {
        return this.m_expressions;
    }

    public ArrayList<Statement> getThenStatements() {
        return this.m_thenStatements;
    }

    public ArrayList<Statement> getElseStatements() {
        return this.m_elseStatements;
    }

    public ArrayList<Statement> getLoopStatements() {
        return this.m_loopStatements;
    }

    public Expression getForHashMap() {
        return this.m_forHashMapExpression;
    }

    public String getBlockName() {
        return this.m_blockName;
    }

    public ArrayList<String> getBlockParameters() {
        return this.m_parameters;
    }

    public ArrayList<Statement> getStatementBlock() {
        return this.m_statementBlock;
    }

    static {
        m_statementTypeLookup.put("color", 9);
        m_statementTypeLookup.put("colour", 9);
        m_statementTypeLookup.put("blend", 10);
        m_statementTypeLookup.put("linestyle", 11);
        m_statementTypeLookup.put("font", 12);
        m_statementTypeLookup.put("justify", 13);
        m_statementTypeLookup.put("move", 14);
        m_statementTypeLookup.put("draw", 15);
        m_statementTypeLookup.put("rdraw", 16);
        m_statementTypeLookup.put("arc", 17);
        m_statementTypeLookup.put("circle", 18);
        m_statementTypeLookup.put("ellipse", 19);
        m_statementTypeLookup.put("cylinder", 20);
        m_statementTypeLookup.put("raindrop", 21);
        m_statementTypeLookup.put("bezier", 22);
        m_statementTypeLookup.put("sinewave", 23);
        m_statementTypeLookup.put("wedge", 24);
        m_statementTypeLookup.put("spiral", 25);
        m_statementTypeLookup.put("box", 26);
        m_statementTypeLookup.put("roundedbox", 27);
        m_statementTypeLookup.put("box3d", 28);
        m_statementTypeLookup.put("chessboard", 29);
        m_statementTypeLookup.put("hexagon", 30);
        m_statementTypeLookup.put("pentagon", 31);
        m_statementTypeLookup.put("triangle", 32);
        m_statementTypeLookup.put("star", 33);
        m_statementTypeLookup.put("addpath", 34);
        m_statementTypeLookup.put("clearpath", 35);
        m_statementTypeLookup.put("closepath", 36);
        m_statementTypeLookup.put("samplepath", 37);
        m_statementTypeLookup.put("stripepath", 38);
        m_statementTypeLookup.put("shiftpath", 39);
        m_statementTypeLookup.put("parallelpath", 40);
        m_statementTypeLookup.put("selectpath", 41);
        m_statementTypeLookup.put("reversepath", 42);
        m_statementTypeLookup.put("sinkhole", 43);
        m_statementTypeLookup.put("guillotine", 44);
        m_statementTypeLookup.put("stroke", 45);
        m_statementTypeLookup.put("fill", 46);
        m_statementTypeLookup.put("gradientfill", 47);
        m_statementTypeLookup.put("eventscript", 48);
        m_statementTypeLookup.put("protect", 49);
        m_statementTypeLookup.put("unprotect", 50);
        m_statementTypeLookup.put("clip", 51);
        m_statementTypeLookup.put("label", 52);
        m_statementTypeLookup.put("flowlabel", 53);
        m_statementTypeLookup.put("table", 54);
        m_statementTypeLookup.put("tree", 55);
        m_statementTypeLookup.put("icon", 56);
        m_statementTypeLookup.put("geoimage", 57);
        m_statementTypeLookup.put("eps", 58);
        m_statementTypeLookup.put("svg", 59);
        m_statementTypeLookup.put("svgcode", 60);
        m_statementTypeLookup.put("pdf", 61);
        m_statementTypeLookup.put("scale", 62);
        m_statementTypeLookup.put("rotate", 63);
        m_statementTypeLookup.put("worlds", 64);
        m_statementTypeLookup.put("dataset", 65);
        m_statementTypeLookup.put("fetch", 66);
        m_statementTypeLookup.put("newpage", 67);
        m_statementTypeLookup.put("endpage", 68);
        m_statementTypeLookup.put("setoutput", 69);
        m_statementTypeLookup.put("print", 70);
        m_statementTypeLookup.put("local", 71);
        m_statementTypeLookup.put("let", 72);
        m_statementTypeLookup.put("eval", 73);
        m_statementTypeLookup.put("key", 74);
        m_statementTypeLookup.put("legend", 75);
        m_statementTypeLookup.put("mimetype", 76);
        m_statementTypeLookup.put("httpresponse", 77);
        m_statementTypeLookup.put("return", 1001);
    }
}

