/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.Preprocessor;
import org.mapyrus.function.Function;
import org.mapyrus.function.FunctionTable;
import org.mapyrus.function.UserFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expression {
    private static final int NO_OPERATION = 0;
    private static final int PLUS_OPERATION = 1;
    private static final int CONCAT_OPERATION = 2;
    private static final int MINUS_OPERATION = 3;
    private static final int MULTIPLY_OPERATION = 4;
    private static final int REPEAT_OPERATION = 5;
    private static final int DIVIDE_OPERATION = 6;
    private static final int MODULO_OPERATION = 7;
    private static final int LEXICAL_EQUALS_OPERATION = 100;
    private static final int LEXICAL_NOT_EQUALS_OPERATION = 101;
    private static final int LEXICAL_GREATER_THAN_OPERATION = 102;
    private static final int LEXICAL_LESS_THAN_OPERATION = 103;
    private static final int LEXICAL_GREATER_EQUAL_OPERATION = 104;
    private static final int LEXICAL_LESS_EQUAL_OPERATION = 105;
    private static final int NUMERIC_EQUALS_OPERATION = 200;
    private static final int NUMERIC_NOT_EQUALS_OPERATION = 201;
    private static final int NUMERIC_GREATER_THAN_OPERATION = 202;
    private static final int NUMERIC_LESS_THAN_OPERATION = 203;
    private static final int NUMERIC_GREATER_EQUAL_OPERATION = 204;
    private static final int NUMERIC_LESS_EQUAL_OPERATION = 205;
    private static final int CONDITIONAL_OPERATION = 300;
    private static final int ASSIGN_OPERATION = 400;
    private static final int PRE_INCREMENT_OPERATION = 401;
    private static final int PRE_DECREMENT_OPERATION = 402;
    private static final int POST_INCREMENT_OPERATION = 403;
    private static final int POST_DECREMENT_OPERATION = 404;
    private static final int AND_OPERATION = 500;
    private static final int OR_OPERATION = 501;
    private static final int NOT_OPERATION = 502;
    private static final int HASHMAP_REFERENCE = 600;
    private ExpressionTreeNode m_exprTree;

    private ExpressionTreeNode parseAssignment(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block3: {
            int n;
            expressionTreeNode = this.parseOrBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 61) {
                int n2 = preprocessor.read();
                preprocessor.unread(n2);
                if (n2 != 61) {
                    if (expressionTreeNode.m_isLeaf ? expressionTreeNode.m_leafArg == null || expressionTreeNode.m_leafArg.getType() != 3 : expressionTreeNode.m_operation != 600) {
                        throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
                    }
                    ExpressionTreeNode expressionTreeNode2 = this.parseOrBoolean(preprocessor, hashMap);
                    expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 400, expressionTreeNode2);
                    continue;
                }
                preprocessor.unread(n);
                break block3;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseOrBoolean(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block2: {
            int n;
            expressionTreeNode = this.parseAndBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 111 || n == 79) {
                int n2 = preprocessor.read();
                if (n2 == 114 || n2 == 82) {
                    ExpressionTreeNode expressionTreeNode2 = this.parseAndBoolean(preprocessor, hashMap);
                    expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 501, expressionTreeNode2);
                    continue;
                }
                preprocessor.unread(n2);
                preprocessor.unread(n);
                break block2;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseAndBoolean(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block4: {
            int n;
            expressionTreeNode = this.parseNotBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 97 || n == 65) {
                int n2 = preprocessor.read();
                if (n2 == 110 || n2 == 78) {
                    int n3 = preprocessor.read();
                    if (n3 == 100 || n3 == 68) {
                        ExpressionTreeNode expressionTreeNode2 = this.parseNotBoolean(preprocessor, hashMap);
                        expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 500, expressionTreeNode2);
                        continue;
                    }
                    preprocessor.unread(n3);
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                } else {
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                }
                break block4;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseNotBoolean(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode = null;
        int n = preprocessor.readNonSpace();
        if (n == 110 || n == 78) {
            int n2 = preprocessor.read();
            if (n2 == 111 || n2 == 79) {
                int n3 = preprocessor.read();
                if (n3 == 116 || n3 == 84) {
                    int n4 = preprocessor.read();
                    if (!Character.isLetterOrDigit((char)n4) && n4 != 95 && n4 != 46) {
                        ExpressionTreeNode expressionTreeNode2 = this.parseNotBoolean(preprocessor, hashMap);
                        expressionTreeNode = new ExpressionTreeNode(expressionTreeNode2, 502, null);
                    } else {
                        preprocessor.unread(n4);
                        preprocessor.unread(n3);
                        preprocessor.unread(n2);
                        preprocessor.unread(n);
                    }
                } else {
                    preprocessor.unread(n3);
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                }
            } else {
                preprocessor.unread(n2);
                preprocessor.unread(n);
            }
        } else {
            preprocessor.unread(n);
        }
        if (expressionTreeNode == null) {
            expressionTreeNode = this.parseConditional(preprocessor, hashMap);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseConditional(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseComparison(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 63) {
            ExpressionTreeNode expressionTreeNode2 = this.parseAssignment(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n == 58) {
                ExpressionTreeNode expressionTreeNode3 = this.parseAssignment(preprocessor, hashMap);
                expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 300, expressionTreeNode2, expressionTreeNode3);
                continue;
            }
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidconditional"));
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseComparison(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseExpression(preprocessor, hashMap);
        while (true) {
            int n2;
            int n3 = 0;
            n = preprocessor.readNonSpace();
            if (n == 60 || n == 62 || n == 33 || n == 61) {
                n2 = preprocessor.read();
                if (n2 == 61) {
                    n3 = n == 61 ? 200 : (n == 33 ? 201 : (n == 60 ? 205 : 204));
                } else {
                    preprocessor.unread(n2);
                    if (n == 60) {
                        n3 = 203;
                    } else if (n == 62) {
                        n3 = 202;
                    }
                }
            } else if (n == 108 || n == 101 || n == 103 || n == 110) {
                n2 = preprocessor.read();
                if (n == 110 && n2 == 101) {
                    n3 = 101;
                } else if (n == 101 && n2 == 113) {
                    n3 = 100;
                } else if (n == 108 && n2 == 116) {
                    n3 = 103;
                } else if (n == 108 && n2 == 101) {
                    n3 = 105;
                } else if (n == 103 && n2 == 116) {
                    n3 = 102;
                } else if (n == 103 && n2 == 101) {
                    n3 = 104;
                } else {
                    preprocessor.unread(n2);
                }
            }
            if (n3 == 0) break;
            ExpressionTreeNode expressionTreeNode2 = this.parseExpression(preprocessor, hashMap);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n3, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseExpression(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseTerm(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 43 || n == 45 || n == 46) {
            ExpressionTreeNode expressionTreeNode2 = this.parseTerm(preprocessor, hashMap);
            int n2 = n == 43 ? 1 : (n == 45 ? 3 : 2);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseTerm(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseUnary(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 42 || n == 47 || n == 120 || n == 37) {
            int n2 = n == 42 ? 4 : (n == 47 ? 6 : (n == 37 ? 7 : 5));
            ExpressionTreeNode expressionTreeNode2 = this.parseUnary(preprocessor, hashMap);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseUnary(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        int n = preprocessor.readNonSpace();
        if (n != 43 && n != 45) {
            preprocessor.unread(n);
        } else {
            int n2 = preprocessor.read();
            preprocessor.unread(n2);
            if (n2 == n) {
                preprocessor.unread(n);
                n = 32;
            }
        }
        ExpressionTreeNode expressionTreeNode = this.parsePlusPlus(preprocessor, hashMap);
        if (n == 45) {
            ExpressionTreeNode expressionTreeNode2 = new ExpressionTreeNode(Argument.numericMinusOne);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode2, 4, expressionTreeNode);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parsePlusPlus(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        int n;
        int n2 = 0;
        int n3 = preprocessor.readNonSpace();
        if (n3 == 43 || n3 == 45) {
            n = preprocessor.read();
            if (n == n3) {
                n2 = n3 == 43 ? 401 : 402;
            } else {
                preprocessor.unread(n);
                preprocessor.unread(n3);
            }
        } else {
            preprocessor.unread(n3);
        }
        ExpressionTreeNode expressionTreeNode = this.parseHashMapReference(preprocessor, hashMap);
        n3 = preprocessor.readNonSpace();
        if (n3 == 43 || n3 == 45) {
            n = preprocessor.read();
            if (n == n3) {
                if (n2 != 0) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                }
                n2 = n3 == 43 ? 403 : 404;
            } else {
                preprocessor.unread(n);
                preprocessor.unread(n3);
            }
        } else {
            preprocessor.unread(n3);
        }
        if (n2 != 0) {
            if (!(expressionTreeNode.m_isLeaf && expressionTreeNode.m_leafArg.getType() == 3 || expressionTreeNode.m_operation == 600)) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
            }
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, null);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseHashMapReference(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseArray(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 91) {
            ExpressionTreeNode expressionTreeNode2 = this.parseAssignment(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n != 93) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": ']'");
            }
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 600, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseArray(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        int n = preprocessor.readNonSpace();
        if (n == 91) {
            ArrayList<ExpressionTreeNode> arrayList = new ArrayList<ExpressionTreeNode>();
            n = preprocessor.readNonSpace();
            if (n != 93) {
                preprocessor.unread(n);
                int n2 = 1;
                boolean bl = true;
                do {
                    expressionTreeNode = this.parseAssignment(preprocessor, hashMap);
                    n = preprocessor.readNonSpace();
                    if (n == 58) {
                        if (n2 == 1) {
                            bl = true;
                        } else if (!bl) {
                            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidarray"));
                        }
                        if (expressionTreeNode.m_isLeaf && expressionTreeNode.m_leafArg == null) {
                            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("nestedhashmap"));
                        }
                        arrayList.add(expressionTreeNode);
                        expressionTreeNode = this.parseAssignment(preprocessor, hashMap);
                        if (expressionTreeNode.m_isLeaf && expressionTreeNode.m_leafArg == null) {
                            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("nestedhashmap"));
                        }
                        arrayList.add(expressionTreeNode);
                    } else {
                        if (n2 == 1) {
                            bl = false;
                        } else if (bl) {
                            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidarray"));
                        }
                        if (expressionTreeNode.m_isLeaf && expressionTreeNode.m_leafArg == null) {
                            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("nestedhashmap"));
                        }
                        preprocessor.unread(n);
                        String string = Integer.toString(n2);
                        arrayList.add(new ExpressionTreeNode(new Argument(1, string)));
                        arrayList.add(expressionTreeNode);
                    }
                    ++n2;
                } while ((n = preprocessor.readNonSpace()) == 44);
                if (n != 93) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidarray"));
                }
            }
            expressionTreeNode = new ExpressionTreeNode(arrayList);
        } else {
            preprocessor.unread(n);
            expressionTreeNode = this.parseFactor(preprocessor, hashMap);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseFactor(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        StringBuffer stringBuffer = new StringBuffer();
        int n = preprocessor.readNonSpace();
        if (n == 39 || n == 34) {
            int n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while ((n = preprocessor.read()) != n2 || bl2) {
                if (n == -1) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
                }
                if (bl3) {
                    if (Character.isDigit((char)n) && n < 56 && n3 < 3) {
                        n4 *= 8;
                        n4 += n - 48;
                        ++n3;
                    } else {
                        stringBuffer.append((char)n4);
                        bl3 = false;
                    }
                } else if (bl) {
                    if (n5 < 4) {
                        int n7;
                        if (n >= 48 && n <= 57) {
                            n7 = n - 48;
                        } else if (n >= 65 && n <= 70) {
                            n7 = n - 65 + 10;
                        } else if (n >= 97 && n <= 102) {
                            n7 = n - 97 + 10;
                        } else {
                            String string = "";
                            if (n6 != 0) {
                                string = Integer.toHexString(n6);
                            }
                            throw new MapyrusException(MapyrusMessages.get("invalidunicode") + ": " + string + (char)n);
                        }
                        n6 <<= 4;
                        n6 += n7;
                        ++n5;
                    } else {
                        stringBuffer.append((char)n6);
                        bl = false;
                    }
                }
                if (bl3 || bl) continue;
                if (bl2) {
                    if (n == 110) {
                        stringBuffer.append(Constants.LINE_SEPARATOR);
                    } else if (n == 116) {
                        stringBuffer.append("\t");
                    } else if (Character.isDigit((char)n)) {
                        if (n >= 56) {
                            throw new MapyrusException(MapyrusMessages.get("invalidoctal") + ": \\" + (char)n);
                        }
                        bl3 = true;
                        n4 = n - 48;
                        n3 = 1;
                    } else if (n == 117) {
                        bl = true;
                        n5 = 0;
                        n6 = 0;
                    } else if (n != 114) {
                        stringBuffer.append((char)n);
                    }
                    bl2 = false;
                    continue;
                }
                if (n == 92) {
                    bl2 = true;
                    continue;
                }
                stringBuffer.append((char)n);
            }
            if (bl3) {
                stringBuffer.append((char)n4);
            }
            if (bl) {
                if (n5 == 4) {
                    stringBuffer.append((char)n6);
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidunicode") + ": " + Integer.toHexString(n6));
                }
            }
            return new ExpressionTreeNode(new Argument(1, stringBuffer.toString()));
        }
        if (Character.isDigit((char)n) || n == 46) {
            boolean bl = false;
            while (Character.isDigit((char)n)) {
                bl = true;
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            if (n == 46) {
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            while (Character.isDigit((char)n)) {
                bl = true;
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            if (!bl) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidnumber"));
            }
            if (n == 101 || n == 69) {
                stringBuffer.append((char)n);
                n = preprocessor.read();
                if (n == 43 || n == 45) {
                    stringBuffer.append((char)n);
                    n = preprocessor.read();
                }
                if (!Character.isDigit((char)n)) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidnumber"));
                }
                while (Character.isDigit((char)n)) {
                    stringBuffer.append((char)n);
                    n = preprocessor.read();
                }
            }
            preprocessor.unread(n);
            double d = 0.0;
            try {
                d = Double.parseDouble(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new ExpressionTreeNode(new Argument(d));
        }
        if (n == -1) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (n == 40) {
            expressionTreeNode = this.parseAssignment(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n != 41) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unmatchedbracket"));
            }
        } else if (Character.isLetter((char)n) || n == 36) {
            stringBuffer.append((char)n);
            n = preprocessor.read();
            while (n != -1 && (n == 46 || n == 95 || n == 58 || Character.isLetterOrDigit((char)n))) {
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            Function function = FunctionTable.getFunction(stringBuffer.toString());
            if (function == null) {
                function = hashMap.get(stringBuffer.toString());
            }
            if (function != null) {
                if (Character.isWhitespace((char)n)) {
                    n = preprocessor.readNonSpace();
                }
                if (n != 40) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '('");
                }
                int n8 = function.getMinArgumentCount();
                int n9 = function.getMaxArgumentCount();
                ArrayList<ExpressionTreeNode> arrayList = new ArrayList<ExpressionTreeNode>(4);
                for (int i = 0; i < n9; ++i) {
                    n = preprocessor.readNonSpace();
                    if (n == 41) {
                        if (i < n8) {
                            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + stringBuffer.toString());
                        }
                        preprocessor.unread(n);
                        break;
                    }
                    if (i == 0) {
                        preprocessor.unread(n);
                    } else if (n != 44) {
                        throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + stringBuffer.toString());
                    }
                    ExpressionTreeNode expressionTreeNode2 = this.parseAssignment(preprocessor, hashMap);
                    arrayList.add(expressionTreeNode2);
                }
                if ((n = preprocessor.readNonSpace()) != 41) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + stringBuffer.toString());
                }
                expressionTreeNode = new ExpressionTreeNode(function, arrayList);
            } else {
                preprocessor.unread(n);
                expressionTreeNode = new ExpressionTreeNode(new Argument(3, stringBuffer.toString()));
            }
        } else {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
        }
        return expressionTreeNode;
    }

    public Expression(Preprocessor preprocessor, HashMap<String, UserFunction> hashMap) throws IOException, MapyrusException {
        this.m_exprTree = this.parseAssignment(preprocessor, hashMap);
    }

    public Argument evaluate(ContextStack contextStack, String string) throws MapyrusException, InterruptedException {
        return this.m_exprTree.evaluate(contextStack, string);
    }

    public String getVariableName() {
        if (this.m_exprTree.m_isLeaf && this.m_exprTree.m_leafArg.getType() == 3) {
            return this.m_exprTree.m_leafArg.getVariableName();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            ContextStack contextStack = new ContextStack();
            HashMap<String, UserFunction> hashMap = new HashMap<String, UserFunction>();
            contextStack.defineVariable("pi", new Argument(3.1415));
            Preprocessor preprocessor = new Preprocessor(stringArray[0]);
            Expression expression = new Expression(preprocessor, hashMap);
            preprocessor.read();
            Expression expression2 = new Expression(preprocessor, hashMap);
            Argument argument = expression.evaluate(contextStack, "test");
            Argument argument2 = expression2.evaluate(contextStack, "test");
            if (argument.getType() == 0) {
                System.out.println("a1=" + argument.getNumericValue());
            } else {
                System.out.println("a1 = " + argument.getStringValue());
            }
            if (argument2.getType() == 0) {
                System.out.println("a2=" + argument2.getNumericValue());
            } else {
                System.out.println("a2 = " + argument2.getStringValue());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (MapyrusException mapyrusException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionTreeNode {
        boolean m_isLeaf;
        Argument m_leafArg;
        int m_operation;
        ArrayList<ExpressionTreeNode> m_branches;
        boolean m_isFunction;
        Function m_function;

        public ExpressionTreeNode(Argument argument) {
            this.m_isLeaf = true;
            this.m_isFunction = false;
            this.m_leafArg = argument;
        }

        public ExpressionTreeNode(ExpressionTreeNode expressionTreeNode, int n, ExpressionTreeNode expressionTreeNode2) {
            this.m_isFunction = false;
            this.m_isLeaf = false;
            this.m_branches = new ArrayList(2);
            this.m_branches.add(expressionTreeNode);
            this.m_branches.add(expressionTreeNode2);
            this.m_operation = n;
        }

        public ExpressionTreeNode(ExpressionTreeNode expressionTreeNode, int n, ExpressionTreeNode expressionTreeNode2, ExpressionTreeNode expressionTreeNode3) {
            this.m_isFunction = false;
            this.m_isLeaf = false;
            this.m_branches = new ArrayList(3);
            this.m_branches.add(expressionTreeNode);
            this.m_branches.add(expressionTreeNode2);
            this.m_branches.add(expressionTreeNode3);
            this.m_operation = n;
        }

        public ExpressionTreeNode(ArrayList<ExpressionTreeNode> arrayList) {
            this.m_isFunction = false;
            this.m_isLeaf = true;
            this.m_leafArg = null;
            this.m_branches = arrayList;
        }

        public ExpressionTreeNode(Function function, ArrayList<ExpressionTreeNode> arrayList) {
            this.m_isLeaf = false;
            this.m_isFunction = true;
            this.m_function = function;
            this.m_branches = arrayList;
        }

        public Argument evaluate(ContextStack contextStack, String string) throws MapyrusException, InterruptedException {
            return this.traverse(this, contextStack, string);
        }

        private Argument evaluateFunction(ContextStack contextStack, String string) throws MapyrusException, InterruptedException {
            Argument argument;
            int n = this.m_branches.size();
            ArrayList<Argument> arrayList = new ArrayList<Argument>(n);
            for (int i = 0; i < n; ++i) {
                ExpressionTreeNode expressionTreeNode = this.m_branches.get(i);
                arrayList.add(this.traverse(expressionTreeNode, contextStack, string));
            }
            try {
                argument = this.m_function.evaluate(contextStack, arrayList);
            }
            catch (MapyrusException mapyrusException) {
                throw new MapyrusException(this.m_function.getName() + ": " + mapyrusException.getMessage());
            }
            return argument;
        }

        private Argument traverse(ExpressionTreeNode expressionTreeNode, ContextStack contextStack, String string) throws MapyrusException, InterruptedException {
            Argument argument;
            boolean bl = false;
            double d = 0.0;
            String string2 = null;
            if (expressionTreeNode.m_isLeaf) {
                if (expressionTreeNode.m_leafArg == null) {
                    argument = this.traverseArray(expressionTreeNode.m_branches, contextStack, string);
                } else if (expressionTreeNode.m_leafArg.getType() == 3) {
                    argument = contextStack.getVariableValue(expressionTreeNode.m_leafArg.getVariableName(), string);
                    if (argument == null) {
                        argument = Argument.emptyString;
                    }
                } else {
                    argument = expressionTreeNode.m_leafArg;
                }
            } else if (expressionTreeNode.m_isFunction) {
                argument = expressionTreeNode.evaluateFunction(contextStack, string);
            } else if (expressionTreeNode.m_operation == 502) {
                double d2;
                ExpressionTreeNode expressionTreeNode2 = expressionTreeNode.m_branches.get(0);
                Argument argument2 = this.traverse(expressionTreeNode2, contextStack, string);
                argument = argument2.getType() == 0 ? (NumericalAnalysis.equals(d2 = argument2.getNumericValue(), 0.0) ? Argument.numericOne : Argument.numericZero) : (argument2.getStringValue().length() == 0 ? Argument.numericOne : Argument.numericZero);
            } else if (expressionTreeNode.m_operation == 400 || expressionTreeNode.m_operation == 401 || expressionTreeNode.m_operation == 402 || expressionTreeNode.m_operation == 403 || expressionTreeNode.m_operation == 404) {
                Object object;
                Argument argument3;
                ExpressionTreeNode expressionTreeNode3 = expressionTreeNode.m_branches.get(0);
                Argument argument4 = null;
                if (expressionTreeNode.m_operation == 401) {
                    argument3 = this.traverse(expressionTreeNode3, contextStack, string);
                    argument3 = new Argument(argument3.getNumericValue() + 1.0);
                } else if (expressionTreeNode.m_operation == 402) {
                    argument3 = this.traverse(expressionTreeNode3, contextStack, string);
                    argument3 = new Argument(argument3.getNumericValue() - 1.0);
                } else if (expressionTreeNode.m_operation == 403) {
                    argument4 = this.traverse(expressionTreeNode3, contextStack, string);
                    if (argument4 == Argument.emptyString) {
                        argument4 = Argument.numericZero;
                    }
                    argument3 = new Argument(argument4.getNumericValue() + 1.0);
                } else if (expressionTreeNode.m_operation == 404) {
                    argument4 = this.traverse(expressionTreeNode3, contextStack, string);
                    if (argument4 == Argument.emptyString) {
                        argument4 = Argument.numericZero;
                    }
                    argument3 = new Argument(argument4.getNumericValue() - 1.0);
                } else {
                    object = expressionTreeNode.m_branches.get(1);
                    argument3 = this.traverse((ExpressionTreeNode)object, contextStack, string);
                }
                if (expressionTreeNode3.m_isLeaf) {
                    object = expressionTreeNode3.m_leafArg.getVariableName();
                    contextStack.defineVariable((String)object, argument3);
                } else if (expressionTreeNode3.m_operation == 600 && expressionTreeNode3.m_branches.get((int)0).m_isLeaf) {
                    object = expressionTreeNode3.m_branches.get(0);
                    String string3 = null;
                    if (object != null) {
                        string3 = ((ExpressionTreeNode)object).m_leafArg.getVariableName();
                    }
                    if (string3 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidvariable"));
                    }
                    Argument argument5 = this.traverse(expressionTreeNode3.m_branches.get(1), contextStack, string);
                    if (argument5.getType() != 0 && argument5.getType() != 1) {
                        throw new MapyrusException(MapyrusMessages.get("invalidhashmapkey"));
                    }
                    if (argument3.getType() == 2) {
                        throw new MapyrusException(MapyrusMessages.get("nestedhashmap"));
                    }
                    contextStack.defineHashMapEntry(string3, argument5.getStringValue(), argument3);
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidvariable"));
                }
                argument = expressionTreeNode.m_operation == 403 || expressionTreeNode.m_operation == 404 ? argument4 : argument3;
            } else if (expressionTreeNode.m_operation == 600) {
                Argument argument6;
                Object object;
                ExpressionTreeNode expressionTreeNode4 = expressionTreeNode.m_branches.get(0);
                ExpressionTreeNode expressionTreeNode5 = expressionTreeNode.m_branches.get(1);
                if (expressionTreeNode4.m_isLeaf && expressionTreeNode4.m_leafArg != null && expressionTreeNode4.m_leafArg.getType() == 3) {
                    object = expressionTreeNode4.m_leafArg.getVariableName();
                    argument6 = contextStack.getVariableValue((String)object, string);
                } else if (expressionTreeNode4.m_isLeaf && expressionTreeNode4.m_leafArg == null) {
                    argument6 = this.traverseArray(expressionTreeNode4.m_branches, contextStack, string);
                } else if (expressionTreeNode4.m_isFunction) {
                    argument6 = this.traverse(expressionTreeNode4, contextStack, string);
                } else {
                    throw new MapyrusException(MapyrusMessages.get("variableexpected"));
                }
                object = this.traverse(expressionTreeNode5, contextStack, string);
                if (((Argument)object).getType() != 0 && ((Argument)object).getType() != 1) {
                    throw new MapyrusException(MapyrusMessages.get("invalidhashmapkey"));
                }
                argument = argument6 == null || argument6.getType() != 2 ? Argument.emptyString : argument6.getHashMapEntry(((Argument)object).getStringValue());
            } else if (expressionTreeNode.m_operation == 300) {
                ExpressionTreeNode expressionTreeNode6 = expressionTreeNode.m_branches.get(0);
                Argument argument7 = this.traverse(expressionTreeNode6, contextStack, string);
                if (argument7.getNumericValue() != 0.0) {
                    ExpressionTreeNode expressionTreeNode7 = expressionTreeNode.m_branches.get(1);
                    argument = this.traverse(expressionTreeNode7, contextStack, string);
                } else {
                    ExpressionTreeNode expressionTreeNode8 = expressionTreeNode.m_branches.get(2);
                    argument = this.traverse(expressionTreeNode8, contextStack, string);
                }
            } else {
                ExpressionTreeNode expressionTreeNode9 = expressionTreeNode.m_branches.get(0);
                ExpressionTreeNode expressionTreeNode10 = expressionTreeNode.m_branches.get(1);
                Argument argument8 = this.traverse(expressionTreeNode9, contextStack, string);
                Argument argument9 = this.traverse(expressionTreeNode10, contextStack, string);
                switch (expressionTreeNode.m_operation) {
                    case 1: {
                        d = argument8.getNumericValue() + argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 2: {
                        string2 = argument8.toString() + argument9.toString();
                        bl = true;
                        break;
                    }
                    case 3: {
                        d = argument8.getNumericValue() - argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 4: {
                        d = argument8.getNumericValue() * argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 5: {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = (int)Math.floor(argument9.getNumericValue());
                        for (int i = 0; i < n; ++i) {
                            stringBuffer.append(argument8.toString());
                        }
                        string2 = stringBuffer.toString();
                        bl = true;
                        break;
                    }
                    case 6: {
                        d = argument8.getNumericValue() / argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 7: {
                        d = NumericalAnalysis.fmod(argument8.getNumericValue(), argument9.getNumericValue());
                        bl = false;
                        break;
                    }
                    case 200: {
                        double d3 = argument8.getNumericValue();
                        double d4 = argument9.getNumericValue();
                        d = NumericalAnalysis.equals(d3, d4) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 201: {
                        double d5 = argument8.getNumericValue();
                        double d6 = argument9.getNumericValue();
                        d = NumericalAnalysis.equals(d5, d6) ? 0.0 : 1.0;
                        bl = false;
                        break;
                    }
                    case 202: {
                        double d7 = argument8.getNumericValue();
                        double d8 = argument9.getNumericValue();
                        d = d7 > d8 && !NumericalAnalysis.equals(d7, d8) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 204: {
                        double d9 = argument8.getNumericValue();
                        double d10 = argument9.getNumericValue();
                        d = d9 > d10 || NumericalAnalysis.equals(d9, d10) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 203: {
                        double d11 = argument8.getNumericValue();
                        double d12 = argument9.getNumericValue();
                        d = d11 < d12 && !NumericalAnalysis.equals(d11, d12) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 205: {
                        double d13 = argument8.getNumericValue();
                        double d14 = argument9.getNumericValue();
                        d = d13 < d14 || NumericalAnalysis.equals(d13, d14) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 500: {
                        d = argument8.getNumericValue() != 0.0 && argument9.getNumericValue() != 0.0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 501: {
                        d = argument8.getNumericValue() != 0.0 || argument9.getNumericValue() != 0.0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 100: {
                        d = argument8.toString().equals(argument9.toString()) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 101: {
                        d = argument8.toString().equals(argument9.toString()) ? 0.0 : 1.0;
                        bl = false;
                        break;
                    }
                    case 102: {
                        d = argument8.toString().compareTo(argument9.toString()) > 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 104: {
                        d = argument8.toString().compareTo(argument9.toString()) >= 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 103: {
                        d = argument8.toString().compareTo(argument9.toString()) < 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 105: {
                        d = argument8.toString().compareTo(argument9.toString()) <= 0 ? 1.0 : 0.0;
                        bl = false;
                    }
                }
                if (!bl) {
                    if (Double.isInfinite(d) || Double.isNaN(d)) {
                        throw new MapyrusException(MapyrusMessages.get("numericoverflow"));
                    }
                    argument = d == 0.0 ? Argument.numericZero : (d == 1.0 ? Argument.numericOne : new Argument(d));
                } else {
                    argument = string2.length() == 0 ? Argument.emptyString : new Argument(1, string2);
                }
            }
            return argument;
        }

        private Argument traverseArray(ArrayList<ExpressionTreeNode> arrayList, ContextStack contextStack, String string) throws MapyrusException, InterruptedException {
            Argument argument = new Argument();
            for (int i = 0; i < arrayList.size(); i += 2) {
                ExpressionTreeNode expressionTreeNode = arrayList.get(i);
                Argument argument2 = this.traverse(expressionTreeNode, contextStack, string);
                expressionTreeNode = arrayList.get(i + 1);
                Argument argument3 = this.traverse(expressionTreeNode, contextStack, string);
                if (argument3.getType() == 2) {
                    throw new MapyrusException(MapyrusMessages.get("nestedhashmap"));
                }
                argument.addHashMapEntry(argument2.getStringValue(), argument3);
            }
            return argument;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            ExpressionTreeNode expressionTreeNode;
            if (this.m_isLeaf) {
                if (this.m_leafArg != null) {
                    return this.m_leafArg.toString();
                }
                StringBuffer stringBuffer = new StringBuffer("[");
                String string = "";
                boolean bl = true;
                for (ExpressionTreeNode expressionTreeNode2 : this.m_branches) {
                    if (bl) {
                        stringBuffer.append(string);
                        string = ",";
                    } else {
                        stringBuffer.append(":");
                    }
                    stringBuffer.append("'");
                    stringBuffer.append(expressionTreeNode2.toString());
                    stringBuffer.append("'");
                    bl = !bl;
                }
                stringBuffer.append("]");
                return stringBuffer.toString();
            }
            String string = "";
            switch (this.m_operation) {
                case 1: {
                    string = "+";
                    break;
                }
                case 2: {
                    string = ".";
                    break;
                }
                case 3: {
                    string = "-";
                    break;
                }
                case 4: {
                    string = "*";
                    break;
                }
                case 5: {
                    string = "x";
                    break;
                }
                case 6: {
                    string = "/";
                    break;
                }
                case 7: {
                    string = "%";
                    break;
                }
                case 100: {
                    string = "eq";
                    break;
                }
                case 101: {
                    string = "ne";
                    break;
                }
                case 102: {
                    string = "gt";
                    break;
                }
                case 103: {
                    string = "lt";
                    break;
                }
                case 104: {
                    string = "ge";
                    break;
                }
                case 105: {
                    string = "le";
                    break;
                }
                case 200: {
                    string = "==";
                    break;
                }
                case 201: {
                    string = "!=";
                    break;
                }
                case 202: {
                    string = ">";
                    break;
                }
                case 203: {
                    string = "<";
                    break;
                }
                case 204: {
                    string = ">=";
                    break;
                }
                case 205: {
                    string = "<=";
                    break;
                }
                case 300: {
                    string = "?";
                    break;
                }
                case 400: {
                    string = "=";
                    break;
                }
                case 401: 
                case 403: {
                    string = "++";
                    break;
                }
                case 402: 
                case 404: {
                    string = "--";
                    break;
                }
                case 500: {
                    string = "and";
                    break;
                }
                case 501: {
                    string = "or";
                    break;
                }
                case 502: {
                    string = "not";
                    break;
                }
                case 600: {
                    string = "[";
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            ExpressionTreeNode expressionTreeNode3 = this.m_branches.get(0);
            if (this.m_operation == 401 || this.m_operation == 402) {
                stringBuffer.append(string);
                string = "";
            }
            stringBuffer.append(expressionTreeNode3.toString());
            stringBuffer.append(' ');
            stringBuffer.append(string);
            stringBuffer.append(' ');
            if (this.m_operation != 502 && this.m_operation != 401 && this.m_operation != 402) {
                expressionTreeNode = this.m_branches.get(1);
                stringBuffer.append(expressionTreeNode.toString());
            }
            if (this.m_operation == 600) {
                stringBuffer.append(']');
            }
            if (this.m_operation != 300) return stringBuffer.toString();
            expressionTreeNode = this.m_branches.get(2);
            stringBuffer.append(" : ").append(expressionTreeNode.toString());
            return stringBuffer.toString();
        }
    }
}

