/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class PostScriptFont {
    private static final int LINE_LENGTH = 30;
    private String m_fontName;
    private StringBuffer m_fileContents;

    public PostScriptFont(String string, boolean bl) throws IOException, MapyrusException {
        if (bl) {
            if (!string.toLowerCase().endsWith(".pfb")) {
                throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
            }
        } else if (!string.toLowerCase().endsWith(".pfa")) {
            throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
        }
        if (bl) {
            this.readPfbFile(string);
        } else {
            this.readPfaFile(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPfbFile(String string) throws IOException, MapyrusException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            int n = 0;
            if (bufferedInputStream.read(byArray) != byArray.length) {
                throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            while (byArray[1] != 3) {
                if (byArray[0] != -128) {
                    throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
                }
                if (bufferedInputStream.read(byArray2) != byArray2.length) {
                    throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                }
                int n2 = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN).getInt();
                n += n2;
                byte[] byArray3 = new byte[n2];
                if (bufferedInputStream.read(byArray3) != byArray3.length) {
                    throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                }
                arrayList.add(byArray3);
                if (bufferedInputStream.read(byArray) == byArray.length) continue;
                throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            if (arrayList.size() < 3) {
                throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
            }
            this.m_fileContents = new StringBuffer(131072);
            this.m_fileContents.append("<< /Type /FontFile /Length ");
            long l = n * 2 + Constants.LINE_SEPARATOR.length();
            this.m_fileContents.append(l += (long)(n / 30 * Constants.LINE_SEPARATOR.length()));
            this.m_fileContents.append(Constants.LINE_SEPARATOR);
            this.m_fileContents.append("/Length1 ");
            this.m_fileContents.append(((byte[])arrayList.get(0)).length);
            this.m_fileContents.append(" /Length2 ");
            this.m_fileContents.append(((byte[])arrayList.get(1)).length);
            this.m_fileContents.append(" /Length3 ");
            this.m_fileContents.append(((byte[])arrayList.get(2)).length);
            this.m_fileContents.append(" /Filter /ASCIIHexDecode >>");
            this.m_fileContents.append(Constants.LINE_SEPARATOR);
            this.m_fileContents.append("stream");
            this.m_fileContents.append(Constants.LINE_SEPARATOR);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2;
                int n4;
                byte[] byArray4 = (byte[])arrayList.get(i);
                for (n4 = 0; n4 < byArray4.length; ++n4) {
                    if (i == 0 && (byArray4[n4] == 13 || byArray4[n4] == 10 || byArray4[n4] == 9 || byArray4[n4] >= 32)) {
                        stringBuffer.append((char)byArray4[n4]);
                    }
                    if ((string2 = Integer.toHexString(byArray4[n4] & 0xFF)).length() < 2) {
                        this.m_fileContents.append('0');
                    }
                    this.m_fileContents.append(string2);
                    if (++n3 % 30 != 0) continue;
                    this.m_fileContents.append(Constants.LINE_SEPARATOR);
                }
                if (i != 0) continue;
                n4 = stringBuffer.indexOf("\n/FontName");
                if (n4 < 0) {
                    n4 = stringBuffer.indexOf("\r/FontName");
                }
                if (n4 < 0) {
                    throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
                }
                string2 = stringBuffer.substring(n4 + 10);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
                }
                this.m_fontName = stringTokenizer.nextToken();
                if (!this.m_fontName.startsWith("/")) continue;
                this.m_fontName = this.m_fontName.substring(1);
            }
            this.m_fileContents.append(Constants.LINE_SEPARATOR);
            this.m_fileContents.append("endstream");
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPfaFile(String string) throws IOException, MapyrusException {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
            }
            this.m_fileContents = new StringBuffer(131072);
            this.m_fileContents.append(string3);
            this.m_fileContents.append(Constants.LINE_SEPARATOR);
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                this.m_fileContents.append(string2);
                this.m_fileContents.append(Constants.LINE_SEPARATOR);
                if (!string2.startsWith("/FontName") || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 2) continue;
                stringTokenizer.nextToken();
                this.m_fontName = stringTokenizer.nextToken();
                if (!this.m_fontName.startsWith("/")) continue;
                this.m_fontName = this.m_fontName.substring(1);
            }
            if (this.m_fontName == null) {
                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public String getName() {
        return this.m_fontName;
    }

    public String toString() {
        return "PostScript Font " + this.m_fontName;
    }

    public String getFontDefinition() {
        return this.m_fileContents.toString();
    }
}

