/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.Context;
import org.mapyrus.Dataset;
import org.mapyrus.LRUCache;
import org.mapyrus.LegendEntry;
import org.mapyrus.LegendEntryList;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.MimeTypes;
import org.mapyrus.Row;
import org.mapyrus.Throttle;
import org.mapyrus.dataset.DatasetFactory;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.font.StringDimension;
import org.mapyrus.image.Bitmap;
import org.mapyrus.image.ImageIOWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextStack {
    private static final int MAX_STACK_LENGTH = 30;
    private static final String INTERNAL_VARIABLE_PREFIX = "Mapyrus.";
    private static final String PATH_VARIABLE = "path";
    private static final String WORLDS_VARIABLE = "worlds";
    private static final String DATASET_VARIABLE = "dataset";
    private static final String PAGE_VARIABLE = "page";
    private static final String SCREEN_VARIABLE = "screen";
    private static final String IMAGEMAP_VARIABLE = "imagemap";
    private LinkedList<Context> m_stack = new LinkedList();
    private LegendEntryList m_legendEntries;
    private LRUCache<String, BufferedImage> m_iconCache;
    private long m_startTime;
    private Throttle m_throttle;
    private Point m_imagemapPoint;
    private String m_HTTPResponse;

    public ContextStack() {
        this.m_stack.add(new Context());
        this.m_startTime = System.currentTimeMillis();
        this.m_throttle = new Throttle();
        this.m_imagemapPoint = null;
        this.m_legendEntries = new LegendEntryList();
        this.m_iconCache = new LRUCache(64);
        this.m_HTTPResponse = "HTTP/1.0 200 OK" + Constants.LINE_SEPARATOR + "Content-Type" + ": " + MimeTypes.get("html") + Constants.LINE_SEPARATOR;
    }

    private Context getCurrentContext() {
        return this.m_stack.getLast();
    }

    private int popContext() throws IOException, MapyrusException {
        int n = this.m_stack.size();
        if (n > 0) {
            Context context = this.m_stack.removeLast();
            int n2 = context.closeContext();
            if (--n > 0 && n2 != 0) {
                this.getCurrentContext().setAttributesChanged(n2);
            }
        }
        return n;
    }

    private void pushContext(String string) throws MapyrusException {
        if (this.m_stack.size() == 30) {
            throw new MapyrusException(MapyrusMessages.get("recursion"));
        }
        this.m_stack.add(new Context(this.getCurrentContext(), string));
    }

    public void setImagemapPoint(Point point) {
        this.m_imagemapPoint = point;
    }

    public void setOutputFormat(String string, String string2, double d, double d2, String string3, PrintStream printStream, Throttle throttle) throws IOException, MapyrusException {
        this.getCurrentContext().setOutputFormat(string, string2, d, d2, string3, printStream, throttle);
    }

    public void setOutputFormat(BufferedImage bufferedImage, PrintWriter printWriter, String string) throws IOException, MapyrusException {
        this.getCurrentContext().setOutputFormat(bufferedImage, printWriter, string);
    }

    public void setOutputFormat(BufferedImage bufferedImage, String string) throws IOException, MapyrusException {
        this.getCurrentContext().setOutputFormat(bufferedImage, string);
    }

    public void closeOutputFormat() throws IOException, MapyrusException {
        this.getCurrentContext().closeOutputFormat();
    }

    public void setLinestyle(double d, int n, int n2, double d2, float[] fArray) {
        this.getCurrentContext().setLinestyle(d, n, n2, d2, fArray);
    }

    public void setColor(Color color) {
        this.getCurrentContext().setColor(color);
    }

    public void setBlend(String string) {
        this.getCurrentContext().setBlend(string);
    }

    public Color getColor() {
        Color color = this.getCurrentContext().getColor();
        return color;
    }

    public void setFont(String string, double d, double d2, double d3) {
        this.getCurrentContext().setFont(string, d, d2, d3);
    }

    public void setJustify(int n) {
        this.getCurrentContext().setJustify(n);
    }

    public void setScaling(double d) throws MapyrusException {
        if (d == 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invalidscaling"));
        }
        if (d != 1.0) {
            this.getCurrentContext().setScaling(d);
        }
    }

    public void setTranslation(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.getCurrentContext().setTranslation(d, d2);
        }
    }

    public void setRotation(double d) {
        if (d != 0.0) {
            this.getCurrentContext().setRotation(d);
        }
    }

    public void setWorlds(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, boolean bl) throws MapyrusException {
        this.getCurrentContext().setWorlds(d, d2, d3, d4, d5, d6, d7, d8, n, bl);
    }

    public Rectangle2D.Double getWorlds() throws MapyrusException {
        Rectangle2D.Double double_ = this.getCurrentContext().getWorldExtents();
        return double_;
    }

    public Argument transformToWorlds(Argument argument) throws MapyrusException {
        Argument argument2 = this.getCurrentContext().transformToWorlds(argument);
        return argument2;
    }

    public Argument transformToPage(Argument argument) throws MapyrusException {
        Argument argument2 = this.getCurrentContext().transformToPage(argument);
        return argument2;
    }

    public void setDataset(String string, String string2, String string3, InputStream inputStream) throws MapyrusException {
        GeographicDataset geographicDataset = DatasetFactory.open(string, string2, string3, inputStream, this.m_throttle);
        this.getCurrentContext().setDataset(geographicDataset);
    }

    public void setStdout(PrintStream printStream) throws IOException {
        this.getCurrentContext().setStdout(printStream);
    }

    public void moveTo(double d, double d2) throws MapyrusException {
        this.getCurrentContext().moveTo(d, d2);
    }

    public void lineTo(double d, double d2) throws MapyrusException {
        this.getCurrentContext().lineTo(d, d2);
    }

    public void rlineTo(double d, double d2) throws MapyrusException {
        this.getCurrentContext().rlineTo(d, d2);
    }

    public void arcTo(int n, double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().arcTo(n, d, d2, d3, d4);
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) throws MapyrusException {
        this.getCurrentContext().curveTo(d, d2, d3, d4, d5, d6);
    }

    public void sineWaveTo(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().sineWaveTo(d, d2, d3, d4);
    }

    public void ellipseTo(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().ellipseTo(d, d2, d3, d4);
    }

    public void clearPath() {
        this.getCurrentContext().clearPath();
    }

    public void closePath() {
        this.getCurrentContext().closePath();
    }

    public void drawIcon(String string, double d) throws IOException, MapyrusException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        BufferedImage bufferedImage = (BufferedImage)this.m_iconCache.get(string);
        if (bufferedImage == null) {
            if (string.length() >= 3) {
                char c = string.charAt(0);
                char c2 = Character.toLowerCase(string.charAt(1));
                if (c == '#') {
                    bl = true;
                    n = 0;
                } else if (c == '0' && c2 == 'x') {
                    bl = true;
                    n = 0;
                } else if (!(c != '0' && c != '1' || c2 != '0' && c2 != '1')) {
                    bl = true;
                    n = 1;
                } else if (string.startsWith("resource:")) {
                    bl2 = true;
                    string = string.substring(9);
                }
            }
            if (bl) {
                Bitmap bitmap = new Bitmap(string, n, this.getCurrentContext().getColor());
                bufferedImage = bitmap.getBufferedImage();
            } else {
                try {
                    URL uRL;
                    if (bl2) {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        uRL = classLoader.getResource(string);
                    } else {
                        if (!this.m_throttle.isIOAllowed()) {
                            throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
                        }
                        uRL = new URL(string);
                    }
                    bufferedImage = ImageIOWrapper.read(uRL, this.getCurrentContext().getColor());
                }
                catch (MalformedURLException malformedURLException) {
                    bufferedImage = ImageIOWrapper.read(new File(string), this.getCurrentContext().getColor());
                }
                if (bufferedImage == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidformat") + ": " + string);
                }
            }
            if (!bl && bufferedImage.getHeight() * bufferedImage.getWidth() <= 16384) {
                this.m_iconCache.put(string, bufferedImage);
            }
        }
        this.getCurrentContext().drawIcon(bufferedImage, d);
    }

    public void drawGeoImage(String string, String string2, Throttle throttle) throws IOException, MapyrusException {
        if (!this.m_throttle.isIOAllowed()) {
            throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
        }
        this.getCurrentContext().drawGeoImage(string, string2, throttle);
    }

    public void drawEPS(String string, double d) throws IOException, MapyrusException {
        if (!this.m_throttle.isIOAllowed()) {
            throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
        }
        this.getCurrentContext().drawEPS(string, d);
    }

    public void drawSVG(String string, double d) throws IOException, MapyrusException {
        if (!this.m_throttle.isIOAllowed()) {
            throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
        }
        this.getCurrentContext().drawSVG(string, d);
    }

    public void addSVGCode(String string) throws IOException, MapyrusException {
        this.getCurrentContext().addSVGCode(string);
    }

    public void drawPDF(String string, int n, double d) throws IOException, MapyrusException {
        if (!this.m_throttle.isIOAllowed()) {
            throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
        }
        this.getCurrentContext().drawPDF(string, n, d);
    }

    public void samplePath(double d, double d2) throws MapyrusException {
        this.getCurrentContext().samplePath(d, d2);
    }

    public void stripePath(double d, double d2) {
        this.getCurrentContext().stripePath(d, d2);
    }

    public void translatePath(double d, double d2) {
        this.getCurrentContext().translatePath(d, d2);
    }

    public void parallelPath(double[] dArray) throws MapyrusException {
        this.getCurrentContext().parallelPath(dArray);
    }

    public void selectPath(double[] dArray, double[] dArray2) throws MapyrusException {
        this.getCurrentContext().selectPath(dArray, dArray2);
    }

    public void reversePath() throws MapyrusException {
        this.getCurrentContext().reversePath();
    }

    public void createSinkhole() {
        this.getCurrentContext().createSinkhole();
    }

    public void guillotine(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().guillotine(d, d2, d3, d4);
    }

    public void protect(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().setPageMask(d, d2, d3, d4, 1);
    }

    public void protect(Argument argument) throws MapyrusException {
        this.getCurrentContext().setPageMask(argument, 1);
    }

    public void protect() throws MapyrusException {
        this.getCurrentContext().setPageMask(1);
    }

    public void unprotect(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().setPageMask(d, d2, d3, d4, 0);
    }

    public void unprotect(Argument argument) throws MapyrusException {
        this.getCurrentContext().setPageMask(argument, 0);
    }

    public void unprotect() throws MapyrusException {
        this.getCurrentContext().setPageMask(0);
    }

    public boolean isProtected(double d, double d2, double d3, double d4) throws MapyrusException {
        boolean bl = this.getCurrentContext().isPageMaskAllZero(d, d2, d3, d4);
        return !bl;
    }

    public boolean isProtected(Argument argument) throws MapyrusException {
        boolean bl = this.getCurrentContext().isPageMaskAllZero(argument);
        return !bl;
    }

    public boolean isProtected() throws MapyrusException {
        boolean bl = this.getCurrentContext().isPageMaskAllZero();
        return !bl;
    }

    public void stroke(String string) throws IOException, MapyrusException {
        this.getCurrentContext().stroke(string);
    }

    public void fill(String string) throws IOException, MapyrusException {
        this.getCurrentContext().fill(string);
    }

    public void gradientFill(Color color, Color color2, Color color3, Color color4, Color color5) throws IOException, MapyrusException {
        this.getCurrentContext().gradientFill(color, color2, color3, color4, color5);
    }

    public void setEventScript(String string) throws IOException, MapyrusException {
        this.getCurrentContext().setEventScript(string);
    }

    public void clipOutside() throws MapyrusException {
        this.getCurrentContext().clipOutside();
    }

    public void clipInside() {
        this.getCurrentContext().clipInside();
    }

    public void label(String string) throws IOException, MapyrusException {
        this.getCurrentContext().label(string);
    }

    public void flowLabel(double d, double d2, boolean bl, String string) throws IOException, MapyrusException {
        this.getCurrentContext().flowLabel(d, d2, bl, string);
    }

    public void drawTable(String string, ArrayList<Argument> arrayList) throws IOException, MapyrusException {
        this.getCurrentContext().drawTable(string, arrayList);
    }

    public void drawTree(String string, Argument argument) throws IOException, MapyrusException {
        this.getCurrentContext().drawTree(string, argument);
    }

    public int getMoveToCount() {
        int n = this.getCurrentContext().getMoveToCount();
        return n;
    }

    public int getLineToCount() {
        int n = this.getCurrentContext().getLineToCount();
        return n;
    }

    public ArrayList<Double> getMoveToRotations() {
        return this.getCurrentContext().getMoveToRotations();
    }

    public ArrayList<Point2D> getMoveTos() throws MapyrusException {
        return this.getCurrentContext().getMoveTos();
    }

    public StringDimension getStringDimension(String string) throws MapyrusException {
        StringDimension stringDimension;
        try {
            stringDimension = this.getCurrentContext().getStringDimension(string, true);
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        return stringDimension;
    }

    public double getResolution() throws MapyrusException {
        double d = this.getCurrentContext().getResolution();
        return d;
    }

    public Row fetchRow() throws MapyrusException {
        Dataset dataset = this.getCurrentContext().getDataset();
        if (dataset == null) {
            throw new MapyrusException(MapyrusMessages.get("nodataset"));
        }
        return dataset.fetchRow();
    }

    public String[] getDatasetFieldNames() throws MapyrusException {
        Dataset dataset = this.getCurrentContext().getDataset();
        if (dataset == null) {
            throw new MapyrusException(MapyrusMessages.get("nodataset"));
        }
        String[] stringArray = dataset.getFieldNames();
        return stringArray;
    }

    public PrintStream getStdout() {
        return this.getCurrentContext().getStdout();
    }

    private Argument getBoundingBoxVariable(String string, Rectangle2D rectangle2D) {
        Argument argument = rectangle2D == null ? Argument.numericZero : (string.equals("min.x") ? new Argument(rectangle2D.getMinX()) : (string.equals("min.y") ? new Argument(rectangle2D.getMinY()) : (string.equals("max.x") ? new Argument(rectangle2D.getMaxX()) : (string.equals("max.y") ? new Argument(rectangle2D.getMaxY()) : (string.equals("center.x") || string.equals("centre.x") ? new Argument(rectangle2D.getCenterX()) : (string.equals("center.y") || string.equals("centre.y") ? new Argument(rectangle2D.getCenterY()) : (string.equals("width") ? new Argument(rectangle2D.getWidth()) : (string.equals("height") ? new Argument(rectangle2D.getHeight()) : null))))))));
        return argument;
    }

    private Argument setTwoDigitNumber(int n) {
        Argument argument = n >= 10 ? new Argument(1, Integer.toString(n)) : new Argument(1, "0" + Integer.toString(n));
        return argument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Argument getVariableValue(String string, String string2) throws MapyrusException {
        Argument argument = null;
        if (string.startsWith(INTERNAL_VARIABLE_PREFIX) && string.length() > INTERNAL_VARIABLE_PREFIX.length() && !string.equals("Mapyrus.http.header")) {
            char c = string.charAt(INTERNAL_VARIABLE_PREFIX.length());
            if (c == 'f' && string.equals("Mapyrus.fetch.more")) {
                Dataset dataset = this.getCurrentContext().getDataset();
                if (dataset == null) return Argument.numericZero;
                if (!dataset.hasMoreRows()) return Argument.numericZero;
                return Argument.numericOne;
            }
            if (c == 'f' && string.equals("Mapyrus.fetch.count")) {
                Dataset dataset = this.getCurrentContext().getDataset();
                if (dataset != null) return new Argument(dataset.getFetchCount());
                return Argument.numericZero;
            }
            if (c == 't' && string.equals("Mapyrus.timer")) {
                return new Argument((double)(System.currentTimeMillis() - this.m_startTime) / 1000.0);
            }
            if (c == 't' && string.startsWith("Mapyrus.time.")) {
                String string3 = string.substring(INTERNAL_VARIABLE_PREFIX.length() + "time.".length());
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (string3.equals("hour")) {
                    return this.setTwoDigitNumber(gregorianCalendar.get(11));
                }
                if (string3.equals("minute")) {
                    return this.setTwoDigitNumber(gregorianCalendar.get(12));
                }
                if (string3.equals("second")) {
                    return this.setTwoDigitNumber(gregorianCalendar.get(13));
                }
                if (string3.equals("day")) {
                    return this.setTwoDigitNumber(gregorianCalendar.get(5));
                }
                if (string3.equals("day.name")) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
                    return new Argument(1, simpleDateFormat.format(gregorianCalendar.getTime()));
                }
                if (string3.equals("month")) {
                    return this.setTwoDigitNumber(gregorianCalendar.get(2) + 1);
                }
                if (string3.equals("month.name")) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM");
                    return new Argument(1, simpleDateFormat.format(gregorianCalendar.getTime()));
                }
                if (string3.equals("week.of.year")) {
                    return new Argument(gregorianCalendar.get(3));
                }
                if (string3.equals("day.of.week")) {
                    int n = gregorianCalendar.get(7);
                    int n2 = n == 2 ? 1 : (n == 3 ? 2 : (n == 4 ? 3 : (n == 5 ? 4 : (n == 6 ? 5 : (n == 7 ? 6 : 7)))));
                    return new Argument(n2);
                }
                if (string3.equals("year")) {
                    return new Argument(gregorianCalendar.get(1));
                }
                if (!string3.equals("stamp")) return null;
                return new Argument(1, gregorianCalendar.getTime().toString());
            }
            if (c == 'v' && string.equals("Mapyrus.version")) {
                return new Argument(1, Constants.getVersion());
            }
            if (c == 'f' && string.equals("Mapyrus.freeMemory")) {
                return new Argument(Runtime.getRuntime().freeMemory());
            }
            if (c == 't' && string.equals("Mapyrus.totalMemory")) {
                return new Argument(Runtime.getRuntime().totalMemory());
            }
            if (c == 'f' && string.equals("Mapyrus.filename")) {
                return new Argument(1, string2);
            }
            if (c == 'r' && string.equals("Mapyrus.rotation")) {
                return new Argument(Math.toDegrees(this.getCurrentContext().getRotation()));
            }
            if (c == 's' && string.equals("Mapyrus.scale")) {
                return new Argument(this.getCurrentContext().getScaling());
            }
            if (c == 'k' && string.equals("Mapyrus.key.count")) {
                return new Argument(this.m_legendEntries.size());
            }
            if (c == 'k' && string.equals("Mapyrus.key.next")) {
                LegendEntry legendEntry = this.m_legendEntries.first();
                if (legendEntry != null) return new Argument(1, legendEntry.getBlockName());
                return Argument.emptyString;
            }
            if (string.startsWith("Mapyrus.page.")) {
                String string4 = string.substring(INTERNAL_VARIABLE_PREFIX.length() + PAGE_VARIABLE.length() + 1);
                if (string4.equals("width")) {
                    return new Argument(this.getCurrentContext().getPageWidth());
                }
                if (string4.equals("height")) {
                    return new Argument(this.getCurrentContext().getPageHeight());
                }
                if (string4.equals("format")) {
                    return new Argument(1, this.getCurrentContext().getPageFormat());
                }
                if (string4.equals("resolution.mm")) {
                    return new Argument(this.getCurrentContext().getResolution());
                }
                if (!string4.equals("resolution.dpi")) return null;
                return new Argument(25.4 / this.getCurrentContext().getResolution());
            }
            if (string.startsWith("Mapyrus.screen.")) {
                String string5 = string.substring(INTERNAL_VARIABLE_PREFIX.length() + SCREEN_VARIABLE.length() + 1);
                if (string5.equals("width")) {
                    return new Argument(Constants.getScreenWidth());
                }
                if (string5.equals("height")) {
                    return new Argument(Constants.getScreenHeight());
                }
                if (string5.equals("resolution.dpi")) {
                    return new Argument(Constants.getScreenResolution());
                }
                if (!string5.equals("resolution.mm")) return null;
                return new Argument(25.4 / (double)Constants.getScreenResolution());
            }
            if (string.startsWith("Mapyrus.path.")) {
                String string6 = string.substring(INTERNAL_VARIABLE_PREFIX.length() + PATH_VARIABLE.length() + 1);
                if (string6.equals("length")) {
                    return new Argument(this.getCurrentContext().getPathLength());
                }
                if (string6.equals("area")) {
                    return new Argument(this.getCurrentContext().getPathArea());
                }
                if (string6.equals("centroid.x")) {
                    return new Argument(this.getCurrentContext().getPathCentroid().getX());
                }
                if (string6.equals("centroid.y")) {
                    return new Argument(this.getCurrentContext().getPathCentroid().getY());
                }
                if (string6.equals("start.x")) {
                    return new Argument(this.getCurrentContext().getPathStartPoint().getX());
                }
                if (string6.equals("start.y")) {
                    return new Argument(this.getCurrentContext().getPathStartPoint().getY());
                }
                if (string6.equals("end.x")) {
                    return new Argument(this.getCurrentContext().getPathEndPoint().getX());
                }
                if (string6.equals("end.y")) {
                    return new Argument(this.getCurrentContext().getPathEndPoint().getY());
                }
                if (string6.equals("start.angle")) {
                    double d = this.getCurrentContext().getPathStartAngle();
                    return new Argument(Math.toDegrees(d));
                }
                if (string6.equals("end.angle")) {
                    double d = this.getCurrentContext().getPathEndAngle();
                    return new Argument(Math.toDegrees(d));
                }
                Rectangle2D rectangle2D = this.getCurrentContext().getBounds2D();
                return this.getBoundingBoxVariable(string6, rectangle2D);
            }
            if (string.equals("Mapyrus.path")) {
                return this.getCurrentContext().getPathArgument();
            }
            if (string.startsWith("Mapyrus.worlds.")) {
                Rectangle2D.Double double_ = this.getCurrentContext().getWorldExtents();
                String string7 = string.substring(INTERNAL_VARIABLE_PREFIX.length() + WORLDS_VARIABLE.length() + 1);
                if (!string7.equals("scale")) return this.getBoundingBoxVariable(string7, double_);
                return new Argument(this.getCurrentContext().getWorldScale());
            }
            if (string.startsWith("Mapyrus.dataset.")) {
                Dataset dataset = this.getCurrentContext().getDataset();
                if (dataset == null) {
                    return Argument.emptyString;
                }
                String string8 = string.substring(INTERNAL_VARIABLE_PREFIX.length() + DATASET_VARIABLE.length() + 1);
                if (string8.equals("projection")) {
                    String string9 = dataset.getProjection();
                    if (string9 != null) return new Argument(1, string9);
                    return Argument.emptyString;
                }
                if (string8.equals("fieldnames")) {
                    String[] stringArray = dataset.getFieldNames();
                    argument = new Argument();
                    int n = 0;
                    while (n < stringArray.length) {
                        argument.addHashMapEntry(String.valueOf(n + 1), new Argument(1, stringArray[n]));
                        ++n;
                    }
                    return argument;
                }
                Rectangle2D.Double double_ = dataset.getWorlds();
                return this.getBoundingBoxVariable(string8, double_);
            }
            if (string.equals("Mapyrus.imagemap.x")) {
                if (this.m_imagemapPoint != null) return new Argument(this.m_imagemapPoint.x);
                return Argument.numericMinusOne;
            }
            if (!string.equals("Mapyrus.imagemap.y")) return argument;
            if (this.m_imagemapPoint != null) return new Argument(this.m_imagemapPoint.y);
            return Argument.numericMinusOne;
        }
        Context context = this.m_stack.getLast();
        if (this.m_stack.size() > 1 && context.hasLocalScope(string)) {
            return context.getVariableValue(string);
        }
        context = this.m_stack.getFirst();
        argument = context.getVariableValue(string);
        String string10 = null;
        try {
            if (argument != null) return argument;
            try {
                string10 = System.getProperty(string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                if (string10 == null) {
                    string10 = System.getenv(string);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string10 == null) return argument;
            double d = Double.parseDouble(string10);
            return new Argument(d);
        }
        catch (NumberFormatException numberFormatException) {
            return new Argument(1, string10);
        }
    }

    public void setLocalScope(String string) throws MapyrusException {
        this.getCurrentContext().setLocalScope(string);
    }

    public void defineVariable(String string, Argument argument) {
        Context context = this.getCurrentContext();
        Context context2 = context.hasLocalScope(string) ? context : this.m_stack.getFirst();
        context2.defineVariable(string, argument);
    }

    public void defineHashMapEntry(String string, String string2, Argument argument) {
        Context context = this.getCurrentContext();
        Context context2 = context.hasLocalScope(string) ? context : this.m_stack.getFirst();
        context2.defineHashMapEntry(string, string2, argument);
    }

    public void addLegendEntry(String string, int n, Argument[] argumentArray, int n2, int n3) {
        String string2 = this.getCurrentContext().getBlockName();
        if (string2 != null) {
            this.m_legendEntries.add(string2, argumentArray, n2, n3, n, string);
        }
    }

    public LegendEntryList getLegendEntries() {
        return this.m_legendEntries;
    }

    public void setHTTPReponse(String string) {
        this.m_HTTPResponse = string;
    }

    public String getHTTPResponse() {
        return this.m_HTTPResponse;
    }

    public void saveState(String string) throws MapyrusException {
        this.pushContext(string);
    }

    public void restoreState() throws IOException, MapyrusException {
        this.popContext();
    }

    public void closeContextStack() throws IOException, MapyrusException {
        int n = 0;
        try {
            while ((n = this.popContext()) > 0) {
            }
        }
        catch (IOException iOException) {
            do {
                try {
                    n = this.popContext();
                }
                catch (IOException iOException2) {
                }
                catch (MapyrusException mapyrusException) {
                    // empty catch block
                }
            } while (n > 0);
            throw iOException;
        }
        catch (MapyrusException mapyrusException) {
            do {
                try {
                    n = this.popContext();
                }
                catch (IOException iOException) {
                }
                catch (MapyrusException mapyrusException2) {
                    // empty catch block
                }
            } while (n > 0);
            throw mapyrusException;
        }
    }

    public void setThrottle(Throttle throttle) {
        this.m_throttle = throttle;
    }

    public Throttle getThrottle() {
        return this.m_throttle;
    }
}

