/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.DefaultFieldNames;
import org.mapyrus.Expression;
import org.mapyrus.FileOrURL;
import org.mapyrus.LegendEntry;
import org.mapyrus.LegendEntryList;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.PageSize;
import org.mapyrus.ParsedStatement;
import org.mapyrus.Preprocessor;
import org.mapyrus.Row;
import org.mapyrus.Statement;
import org.mapyrus.Throttle;
import org.mapyrus.function.UserFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter
implements Cloneable {
    private static final char ARGUMENT_SEPARATOR = ',';
    private static final char PARAM_SEPARATOR = ',';
    private static final String BEGIN_KEYWORD = "begin";
    private static final String FUNCTION_KEYWORD = "function";
    private static final String END_KEYWORD = "end";
    private static final String IF_KEYWORD = "if";
    private static final String THEN_KEYWORD = "then";
    private static final String ELSE_KEYWORD = "else";
    private static final String ELIF_KEYWORD = "elif";
    private static final String ENDIF_KEYWORD = "endif";
    private static final String WHILE_KEYWORD = "while";
    private static final String REPEAT_KEYWORD = "repeat";
    private static final String DO_KEYWORD = "do";
    private static final String DONE_KEYWORD = "done";
    private static final String FOR_KEYWORD = "for";
    private static final String IN_KEYWORD = "in";
    private static final int AT_ARGUMENT = 1;
    private static final int AT_SEPARATOR = 2;
    private static final int AT_PARAM = 3;
    private static final int AT_PARAM_SEPARATOR = 4;
    public static final String CAP_BUTT_STRING = "butt";
    public static final String CAP_ROUND_STRING = "round";
    public static final String CAP_SQUARE_STRING = "square";
    public static final String JOIN_BEVEL_STRING = "bevel";
    public static final String JOIN_MITER_STRING = "miter";
    public static final String JOIN_ROUND_STRING = "round";
    private ContextStack m_context;
    private InputStream m_stdinStream;
    private PrintStream m_stdoutStream;
    private Throttle m_throttle;
    Argument[] m_executeArgs = null;
    private HashMap<String, Statement> m_statementBlocks = new HashMap();
    private HashMap<String, UserFunction> m_userFunctions = new HashMap();
    private static HashMap<String, Integer> m_worldUnitsLookup = new HashMap();
    private static HashMap<String, ParsedStatement> m_keywordLookup;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setColor(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        int n2 = 255;
        float f = 1.0f;
        if (n == 1 || n == 2) {
            Color color;
            String string = argumentArray[0].getStringValue();
            if (n == 2) {
                f = (float)argumentArray[1].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if ((color = ColorDatabase.getColor(string, n2, contextStack.getColor())) == null) {
                throw new MapyrusException(MapyrusMessages.get("colornotfound") + ": " + string);
            }
            contextStack.setColor(color);
            return;
        } else {
            if (n != 4 && n != 5) throw new MapyrusException(MapyrusMessages.get("invalidcolor"));
            String string = argumentArray[0].getStringValue();
            float f2 = (float)argumentArray[1].getNumericValue();
            float f3 = (float)argumentArray[2].getNumericValue();
            float f4 = (float)argumentArray[3].getNumericValue();
            if (n == 5) {
                f = (float)argumentArray[4].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            } else if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if (string.equalsIgnoreCase("hsb")) {
                int n3 = Color.HSBtoRGB(f2, f3, f4);
                contextStack.setColor(new Color((n3 &= 0xFFFFFF) | n2 << 24, true));
                return;
            } else {
                if (!string.equalsIgnoreCase("rgb")) throw new MapyrusException(MapyrusMessages.get("invalidcolortype") + ": " + string);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                contextStack.setColor(new Color(f2, f3, f4, f));
            }
        }
    }

    private void setLinestyle(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        String string;
        double d = 0.1;
        double d2 = 0.0;
        float[] fArray = null;
        int n2 = 2;
        int n3 = 0;
        if (n == 0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinestyle"));
        }
        d = argumentArray[0].getNumericValue();
        if (d < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d);
        }
        if (n >= 2) {
            string = argumentArray[1].getStringValue().toLowerCase();
            if (string.equals(CAP_BUTT_STRING)) {
                n2 = 0;
            } else if (string.equals("round")) {
                n2 = 1;
            } else if (string.equals(CAP_SQUARE_STRING)) {
                n2 = 2;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidendcap") + ": " + string);
            }
        }
        if (n >= 3) {
            string = argumentArray[2].getStringValue().toLowerCase();
            if (string.equals(JOIN_BEVEL_STRING)) {
                n3 = 2;
            } else if (string.equals(JOIN_MITER_STRING)) {
                n3 = 0;
            } else if (string.equals("round")) {
                n3 = 1;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidlinejoin") + ": " + string);
            }
        }
        if (n >= 4 && (d2 = argumentArray[3].getNumericValue()) < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invaliddashphase") + ": " + d2);
        }
        if (n >= 5) {
            fArray = new float[n - 4];
            for (int i = 4; i < n; ++i) {
                fArray[i - 4] = (float)argumentArray[i].getNumericValue();
                if (!((double)fArray[i - 4] <= 0.0)) continue;
                throw new MapyrusException(MapyrusMessages.get("invaliddashpattern") + ": " + fArray[i - 4]);
            }
        }
        contextStack.setLinestyle(d, n2, n3, d2, fArray);
    }

    private void setJustify(ContextStack contextStack, String string) {
        int n = (string = string.toLowerCase()).indexOf("center") >= 0 || string.indexOf("centre") >= 0 ? 2 : (string.indexOf("right") >= 0 ? 4 : 1);
        n = string.indexOf("top") >= 0 ? (n |= 8) : (string.indexOf("middle") >= 0 ? (n |= 0x10) : (n |= 0x20));
        contextStack.setJustify(n);
    }

    private void setFont(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        double d;
        double d2 = 0.0;
        double d3 = 1.0;
        if (n == 2 || n == 3) {
            d = argumentArray[1].getNumericValue();
            if (d <= 0.0) {
                throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d);
            }
            if (n == 3) {
                String string = argumentArray[2].getStringValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2;
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("outlinewidth=")) {
                        string2 = string3.substring(13);
                        try {
                            d2 = Double.parseDouble(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + string2);
                        }
                        if (!(d2 < 0.0)) continue;
                        throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d2);
                    }
                    if (!string3.startsWith("linespacing=")) continue;
                    string2 = string3.substring(12);
                    try {
                        d3 = Double.parseDouble(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidspacing") + ": " + string2);
                    }
                }
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidfont"));
        }
        contextStack.setFont(argumentArray[0].getStringValue(), d, d2, d3);
    }

    private void displayLegend(Statement statement, ContextStack contextStack, double d) throws MapyrusException, IOException, InterruptedException {
        LegendEntryList legendEntryList = contextStack.getLegendEntries();
        ArrayList<Point2D> arrayList = contextStack.getMoveTos();
        legendEntryList.ignoreAdditions();
        long l = Math.min(legendEntryList.size(), arrayList.size());
        int n = 0;
        while ((long)n < l) {
            int n2;
            LegendEntry legendEntry = legendEntryList.pop();
            String string = legendEntry.getBlockName();
            Statement statement2 = this.m_statementBlocks.get(string);
            if (statement2 == null) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
            }
            ArrayList<String> arrayList2 = statement2.getBlockParameters();
            if (legendEntry.getBlockArgs().length != arrayList2.size()) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
            }
            contextStack.saveState(string);
            Point2D.Float float_ = (Point2D.Float)arrayList.get(n);
            contextStack.setTranslation(float_.x, float_.y);
            contextStack.clearPath();
            contextStack.moveTo(d * 1.1 + 2.0, d / 2.0);
            String string2 = legendEntry.getDescription();
            while ((n2 = string2.indexOf("(#)")) >= 0) {
                string2 = string2.substring(0, n2 + 1) + legendEntry.getReferenceCount() + string2.substring(n2 + 2);
            }
            contextStack.label(string2);
            contextStack.clearPath();
            if (legendEntry.getType() == 1) {
                contextStack.setTranslation(d / 2.0, d / 2.0);
                contextStack.moveTo(0.0, 0.0);
            } else if (legendEntry.getType() == 2) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 3) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d / 3.0, d);
                contextStack.lineTo(d * 2.0 / 3.0, 0.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 4) {
                contextStack.moveTo(0.0, 0.0);
                contextStack.lineTo(0.0, d);
                contextStack.lineTo(d, d);
                contextStack.lineTo(d, 0.0);
                contextStack.lineTo(0.0, 0.0);
            }
            if (legendEntry.getType() == 4) {
                contextStack.saveState(string);
            }
            this.makeCall(statement2, arrayList2, legendEntry.getBlockArgs());
            if (legendEntry.getType() == 4) {
                contextStack.restoreState();
                contextStack.setColor(Color.BLACK);
                contextStack.setLinestyle(0.1, 0, 2, 0.0, null);
                contextStack.stroke(null);
            }
            contextStack.restoreState();
            ++n;
        }
        legendEntryList.acceptAdditions();
    }

    private int addGeometryToPath(ContextStack contextStack, double[] dArray, int n) throws MapyrusException {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        n += 2;
        switch (n2) {
            case 100: 
            case 101: 
            case 102: {
                for (int i = 0; i < n3; ++i) {
                    double d = dArray[n + 1];
                    double d2 = dArray[n + 2];
                    if (dArray[n] == 0.0) {
                        contextStack.moveTo(d, d2);
                    } else {
                        contextStack.lineTo(d, d2);
                    }
                    n += 3;
                }
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                for (int i = 0; i < n3; ++i) {
                    n = this.addGeometryToPath(contextStack, dArray, n);
                }
                break;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute(Statement statement, ContextStack contextStack) throws MapyrusException, IOException, InterruptedException {
        int n;
        double d = 0.0;
        if (Thread.interrupted()) {
            throw new InterruptedException(MapyrusMessages.get("interrupted"));
        }
        this.m_throttle.sleep();
        Expression[] expressionArray = statement.getExpressions();
        int n2 = expressionArray.length;
        int n3 = statement.getType();
        if (n3 == 71) {
            for (n = 0; n < n2; ++n) {
                String string = expressionArray[n].getVariableName();
                if (string == null) {
                    throw new MapyrusException(MapyrusMessages.get("variableexpected"));
                }
                contextStack.setLocalScope(string);
            }
        } else {
            if (this.m_executeArgs == null || n2 > this.m_executeArgs.length) {
                this.m_executeArgs = new Argument[n2];
            }
            String string = statement.getFilename();
            for (int i = 0; i < n2; ++i) {
                this.m_executeArgs[i] = expressionArray[i].evaluate(contextStack, string);
            }
        }
        switch (n3) {
            case 9: {
                this.setColor(contextStack, this.m_executeArgs, n2);
                return;
            }
            case 10: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidblend"));
                contextStack.setBlend(this.m_executeArgs[0].getStringValue());
                return;
            }
            case 11: {
                this.setLinestyle(contextStack, this.m_executeArgs, n2);
                return;
            }
            case 12: {
                this.setFont(contextStack, this.m_executeArgs, n2);
                return;
            }
            case 13: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidjustify"));
                this.setJustify(contextStack, this.m_executeArgs[0].getStringValue());
                return;
            }
            case 14: 
            case 15: 
            case 16: {
                if (n2 <= 0 || n2 % 2 != 0) throw new MapyrusException(MapyrusMessages.get("wrongcoordinate"));
                for (n = 0; n < n2; n += 2) {
                    if (n3 == 14) {
                        contextStack.moveTo(this.m_executeArgs[n].getNumericValue(), this.m_executeArgs[n + 1].getNumericValue());
                        continue;
                    }
                    if (n3 == 15) {
                        contextStack.lineTo(this.m_executeArgs[n].getNumericValue(), this.m_executeArgs[n + 1].getNumericValue());
                        continue;
                    }
                    contextStack.rlineTo(this.m_executeArgs[n].getNumericValue(), this.m_executeArgs[n + 1].getNumericValue());
                }
                return;
            }
            case 17: {
                if (n2 != 5) throw new MapyrusException(MapyrusMessages.get("invalidarc"));
                n = this.m_executeArgs[0].getNumericValue() > 0.0 ? 1 : -1;
                contextStack.arcTo(n, this.m_executeArgs[1].getNumericValue(), this.m_executeArgs[2].getNumericValue(), this.m_executeArgs[3].getNumericValue(), this.m_executeArgs[4].getNumericValue());
                return;
            }
            case 18: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidcircle"));
                double d2 = this.m_executeArgs[0].getNumericValue();
                double d3 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                if (!(d > 0.0)) return;
                contextStack.moveTo(d2 - d, d3);
                contextStack.arcTo(1, d2, d3, d2 - d, d3);
                contextStack.closePath();
                return;
            }
            case 19: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidellipse"));
                double d4 = this.m_executeArgs[0].getNumericValue();
                double d5 = this.m_executeArgs[1].getNumericValue();
                double d6 = this.m_executeArgs[2].getNumericValue();
                double d7 = this.m_executeArgs[3].getNumericValue();
                if (!(d6 > 0.0) || !(d7 > 0.0)) return;
                contextStack.ellipseTo(d4 - d6, d5 - d7, d4 + d6, d5 + d7);
                return;
            }
            case 20: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidcylinder"));
                double d8 = this.m_executeArgs[0].getNumericValue();
                double d9 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d10 = this.m_executeArgs[3].getNumericValue();
                if (!(d > 0.0) || !(d10 > 0.0)) return;
                double d11 = d * 0.552285;
                double d12 = d11 / 2.0;
                contextStack.moveTo(d8 - d, d9);
                contextStack.curveTo(d8 - d, d9 - d12, d8 - d11, d9 - d / 2.0, d8, d9 - d / 2.0);
                contextStack.curveTo(d8 + d11, d9 - d / 2.0, d8 + d, d9 - d12, d8 + d, d9);
                contextStack.lineTo(d8 + d, d9 + d10);
                contextStack.curveTo(d8 + d, d9 + d10 - d12, d8 + d11, d9 + d10 - d / 2.0, d8, d9 + d10 - d / 2.0);
                contextStack.curveTo(d8 - d11, d9 + d10 - d / 2.0, d8 - d, d9 + d10 - d12, d8 - d, d9 + d10);
                contextStack.closePath();
                contextStack.ellipseTo(d8 - d, d9 + d10 - d / 2.0, d8 + d, d9 + d10 + d / 2.0);
                return;
            }
            case 21: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidraindrop"));
                double d13 = this.m_executeArgs[0].getNumericValue();
                double d14 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                if (!(d > 0.0)) return;
                double d15 = d;
                contextStack.moveTo(d13 - d, d14);
                contextStack.arcTo(-1, d13, d14, d13 + d, d14);
                contextStack.curveTo(d13 + d, d14 + d15, d13, d14 + d * 3.0 - d15, d13, d14 + d * 3.0);
                contextStack.curveTo(d13, d14 + d * 3.0 - d15, d13 - d, d14 + d15, d13 - d, d14);
                contextStack.closePath();
                return;
            }
            case 22: {
                if (n2 != 6) throw new MapyrusException(MapyrusMessages.get("invalidbezier"));
                double d16 = this.m_executeArgs[0].getNumericValue();
                double d17 = this.m_executeArgs[1].getNumericValue();
                double d18 = this.m_executeArgs[2].getNumericValue();
                double d19 = this.m_executeArgs[3].getNumericValue();
                double d20 = this.m_executeArgs[4].getNumericValue();
                double d21 = this.m_executeArgs[5].getNumericValue();
                contextStack.curveTo(d16, d17, d18, d19, d20, d21);
                return;
            }
            case 23: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidsinewave"));
                double d22 = this.m_executeArgs[0].getNumericValue();
                double d23 = this.m_executeArgs[1].getNumericValue();
                double d24 = this.m_executeArgs[2].getNumericValue();
                double d25 = this.m_executeArgs[3].getNumericValue();
                contextStack.sineWaveTo(d22, d23, d24, d25);
                return;
            }
            case 24: {
                if (n2 != 5 && n2 != 6) throw new MapyrusException(MapyrusMessages.get("invalidwedge"));
                double d26 = this.m_executeArgs[0].getNumericValue();
                double d27 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d28 = this.m_executeArgs[3].getNumericValue();
                double d29 = this.m_executeArgs[4].getNumericValue();
                double d30 = d28 + d29;
                double d31 = n2 == 6 ? this.m_executeArgs[5].getNumericValue() : 0.0;
                int n4 = d29 > 0.0 ? -1 : 1;
                d28 = Math.toRadians(d28);
                d30 = Math.toRadians(d30);
                if (!(d > 0.0) || d29 == 0.0) return;
                double d32 = Math.cos(d28);
                double d33 = Math.sin(d28);
                double d34 = Math.cos(d30);
                double d35 = Math.sin(d30);
                double d36 = d26 + d32 * d;
                double d37 = d27 + d33 * d;
                double d38 = d26 + d34 * d;
                double d39 = d27 + d35 * d;
                contextStack.moveTo(d26, d27);
                contextStack.lineTo(d36, d37);
                contextStack.arcTo(n4, d26, d27, d38, d39);
                contextStack.closePath();
                if (!(d31 > 0.0)) return;
                if (n4 == 1 && d32 < 0.0 || n4 == -1 && d32 > 0.0) {
                    contextStack.moveTo(d36, d37);
                    contextStack.lineTo(d36, d37 - d31);
                    contextStack.lineTo(d26, d27 - d31);
                    contextStack.lineTo(d26, d27);
                    contextStack.closePath();
                }
                if (n4 == 1 && d34 > 0.0 || n4 == -1 && d34 < 0.0) {
                    contextStack.moveTo(d38, d39);
                    contextStack.lineTo(d38, d39 - d31);
                    contextStack.lineTo(d26, d27 - d31);
                    contextStack.lineTo(d26, d27);
                    contextStack.closePath();
                }
                if (!(d33 < 0.0) && !(d35 < 0.0) && !(Math.abs(d29) > 180.0)) return;
                double d40 = d36;
                double d41 = d37;
                if (d33 > 0.0) {
                    d40 = d26 + d * (double)n4;
                    d41 = d27;
                }
                contextStack.moveTo(d40, d41);
                contextStack.lineTo(d40, d41 - d31);
                double d42 = d38;
                double d43 = d39;
                if (d35 > 0.0) {
                    d42 = d26 - d * (double)n4;
                    d43 = d27;
                }
                contextStack.arcTo(n4, d26, d27 - d31, d42, d43 - d31);
                contextStack.lineTo(d42, d43);
                contextStack.arcTo(-n4, d26, d27, d40, d41);
                contextStack.closePath();
                return;
            }
            case 25: {
                if (n2 != 5) throw new MapyrusException(MapyrusMessages.get("invalidspiral"));
                double d44 = this.m_executeArgs[0].getNumericValue();
                double d45 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d46 = this.m_executeArgs[3].getNumericValue();
                double d47 = this.m_executeArgs[4].getNumericValue();
                d47 = Math.toRadians(d47);
                if (!(d > 0.0) || d46 == 0.0) return;
                double d48 = contextStack.getResolution();
                double d49 = Math.acos((d - d48) / d);
                double d50 = d49 / (Math.PI * 2);
                d50 /= Math.abs(d46);
                double d51 = 1.0;
                int n5 = 0;
                while (d51 > 0.0) {
                    double d52 = d * d51 * Math.cos(Math.PI * 2 * d46 * d51 + d47) + d44;
                    double d53 = d * d51 * Math.sin(Math.PI * 2 * d46 * d51 + d47) + d45;
                    if (n5 == 0) {
                        contextStack.moveTo(d52, d53);
                    } else {
                        contextStack.lineTo(d52, d53);
                    }
                    d51 = 1.0 - (double)(++n5) * d50;
                }
                contextStack.lineTo(d44, d45);
                return;
            }
            case 30: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidhexagon"));
                double d54 = this.m_executeArgs[0].getNumericValue();
                double d55 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d56 = 0.8660254 * d;
                double d57 = 0.5 * d;
                if (!(d > 0.0)) return;
                contextStack.moveTo(d54 - d57, d55 - d56);
                contextStack.lineTo(d54 + d57, d55 - d56);
                contextStack.lineTo(d54 + d, d55);
                contextStack.lineTo(d54 + d57, d55 + d56);
                contextStack.lineTo(d54 - d57, d55 + d56);
                contextStack.lineTo(d54 - d, d55);
                contextStack.closePath();
                return;
            }
            case 31: {
                if (n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidpentagon"));
                double d58 = this.m_executeArgs[0].getNumericValue();
                double d59 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d60 = 0.809017 * d;
                double d61 = 0.59778525 * d;
                double d62 = 0.309017 * d;
                double d63 = 0.95105652 * d;
                if (!(d > 0.0)) return;
                contextStack.moveTo(d58 - d61, d59 - d60);
                contextStack.lineTo(d58 + d61, d59 - d60);
                contextStack.lineTo(d58 + d63, d59 + d62);
                contextStack.lineTo(d58, d59 + d);
                contextStack.lineTo(d58 - d63, d59 + d62);
                contextStack.closePath();
                return;
            }
            case 32: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidtriangle"));
                double d64 = this.m_executeArgs[0].getNumericValue();
                double d65 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                double d66 = this.m_executeArgs[3].getNumericValue();
                d66 = Math.toRadians(d66);
                double d67 = 0.5 * d;
                double d68 = 0.8660254 * d;
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(d64, d65);
                affineTransform.rotate(d66);
                Point2D.Double double_ = new Point2D.Double(0.0, d);
                affineTransform.transform(double_, double_);
                contextStack.moveTo(double_.x, double_.y);
                double_.x = d68;
                double_.y = -d67;
                affineTransform.transform(double_, double_);
                contextStack.lineTo(double_.x, double_.y);
                double_.x = -d68;
                double_.y = -d67;
                affineTransform.transform(double_, double_);
                contextStack.lineTo(double_.x, double_.y);
                contextStack.closePath();
                return;
            }
            case 33: {
                if (n2 != 4) throw new MapyrusException(MapyrusMessages.get("invalidstar"));
                double d69 = this.m_executeArgs[0].getNumericValue();
                double d70 = this.m_executeArgs[1].getNumericValue();
                d = this.m_executeArgs[2].getNumericValue();
                n = (int)this.m_executeArgs[3].getNumericValue();
                if (!(d > 0.0) || n <= 0) return;
                double d71 = Math.PI * 2 / (double)n;
                double d72 = 1.5707963267948966;
                double d73 = d71 / 3.0;
                double d74 = d * Math.sin(d73 / 2.0) / Math.sin(Math.PI - d73 / 2.0 - d71 / 2.0);
                for (int i = 0; i < n; ++i) {
                    double d75 = d69 + Math.cos(d72) * d;
                    double d76 = d70 + Math.sin(d72) * d;
                    if (i == 0) {
                        contextStack.moveTo(d75, d76);
                    } else {
                        contextStack.lineTo(d75, d76);
                    }
                    d75 = d69 + Math.cos(d72 - d71 / 2.0) * d74;
                    d76 = d70 + Math.sin(d72 - d71 / 2.0) * d74;
                    contextStack.lineTo(d75, d76);
                    d72 -= d71;
                }
                contextStack.closePath();
                return;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 44: 
            case 49: 
            case 50: {
                if (n2 == 4 || (n3 == 27 || n3 == 28 || n3 == 29) && n2 == 5) {
                    double d77;
                    double d78;
                    double d79;
                    double d80;
                    double d81;
                    double d82;
                    double d83 = this.m_executeArgs[0].getNumericValue();
                    double d84 = this.m_executeArgs[1].getNumericValue();
                    double d85 = this.m_executeArgs[2].getNumericValue();
                    double d86 = this.m_executeArgs[3].getNumericValue();
                    double d87 = 1.0;
                    double d88 = 0.0;
                    if (d83 < d85) {
                        d82 = d83;
                        d81 = d85;
                    } else {
                        d82 = d85;
                        d81 = d83;
                    }
                    if (d84 < d86) {
                        d80 = d84;
                        d79 = d86;
                    } else {
                        d80 = d86;
                        d79 = d84;
                    }
                    if (n3 == 27) {
                        d78 = d79 - d80;
                        d77 = d81 - d82;
                        if (n2 == 5) {
                            d = this.m_executeArgs[4].getNumericValue();
                            if (d > d77 / 2.0) {
                                d = d77 / 2.0;
                            }
                            if (d > d78 / 2.0) {
                                d = d78 / 2.0;
                            }
                        } else {
                            d = Math.min(d77 / 10.0, d78 / 10.0);
                        }
                        if (d <= 0.0) {
                            n3 = 26;
                        }
                    } else if (n3 == 28) {
                        d88 = Math.min(d81 - d82, d79 - d80);
                        if (n2 == 5) {
                            d88 = this.m_executeArgs[4].getNumericValue();
                        }
                    } else if (n3 == 29) {
                        if (n2 == 5) {
                            d87 = this.m_executeArgs[4].getNumericValue();
                        }
                        if (d87 <= 0.0) {
                            throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d87);
                        }
                    }
                    if (n3 == 26 || n3 == 28) {
                        contextStack.moveTo(d82, d80);
                        contextStack.lineTo(d82, d79);
                        contextStack.lineTo(d81, d79);
                        contextStack.lineTo(d81, d80);
                        contextStack.closePath();
                        if (n3 != 28) return;
                        d78 = Math.cos(Math.toRadians(30.0));
                        d77 = Math.sin(Math.toRadians(30.0));
                        d83 = d81 + d88 * d78;
                        d84 = d79 + d88 * d77;
                        contextStack.moveTo(d81, d79);
                        contextStack.lineTo(d83, d84);
                        contextStack.lineTo(d83, d84 - (d79 - d80));
                        contextStack.lineTo(d81, d80);
                        contextStack.closePath();
                        d83 = d82 + d88 * d78;
                        d84 = d79 + d88 * d77;
                        contextStack.moveTo(d82, d79);
                        contextStack.lineTo(d83, d84);
                        contextStack.lineTo(d83 + (d81 - d82), d84);
                        contextStack.lineTo(d81, d79);
                        contextStack.closePath();
                        return;
                    }
                    if (n3 == 27) {
                        contextStack.moveTo(d82, d79 - d);
                        contextStack.arcTo(1, d82 + d, d79 - d, d82 + d, d79);
                        contextStack.lineTo(d81 - d, d79);
                        contextStack.arcTo(1, d81 - d, d79 - d, d81, d79 - d);
                        contextStack.lineTo(d81, d80 + d);
                        contextStack.arcTo(1, d81 - d, d80 + d, d81 - d, d80);
                        contextStack.lineTo(d82 + d, d80);
                        contextStack.arcTo(1, d82 + d, d80 + d, d82, d80 + d);
                        contextStack.closePath();
                        return;
                    }
                    if (n3 == 29) {
                        int n6 = 0;
                        d84 = d80;
                        while (d84 < d79) {
                            d86 = d84 + d87;
                            if (d86 > d79) {
                                d86 = d79;
                            }
                            int n7 = 0;
                            d83 = d82;
                            while (d83 < d81) {
                                if ((n6 + n7) % 2 == 0) {
                                    d85 = d83 + d87;
                                    if (d85 > d81) {
                                        d85 = d81;
                                    }
                                    contextStack.moveTo(d83, d84);
                                    contextStack.lineTo(d83, d86);
                                    contextStack.lineTo(d85, d86);
                                    contextStack.lineTo(d85, d84);
                                    contextStack.closePath();
                                }
                                d83 = d82 + (double)(++n7) * d87;
                            }
                            d84 = d80 + (double)(++n6) * d87;
                        }
                        return;
                    }
                    if (n3 == 44) {
                        contextStack.guillotine(d82, d80, d81, d79);
                        return;
                    }
                    if (n3 == 49) {
                        contextStack.protect(d82, d80, d81, d79);
                        return;
                    }
                    contextStack.unprotect(d82, d80, d81, d79);
                    return;
                }
                if (n2 == 1 && (n3 == 49 || n3 == 50)) {
                    Argument argument = this.m_executeArgs[0];
                    if (n3 == 49) {
                        contextStack.protect(argument);
                        return;
                    }
                    contextStack.unprotect(argument);
                    return;
                }
                if (n2 == 0 && n3 == 49) {
                    contextStack.protect();
                    return;
                }
                if (n2 != 0 || n3 != 50) throw new MapyrusException(MapyrusMessages.get("invalidbox"));
                contextStack.unprotect();
                return;
            }
            case 34: {
                for (n = 0; n < n2; ++n) {
                    double[] dArray = this.m_executeArgs[n].getGeometryValue();
                    this.addGeometryToPath(contextStack, dArray, 0);
                }
                return;
            }
            case 35: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.clearPath();
                return;
            }
            case 36: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.closePath();
                return;
            }
            case 37: {
                if (n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidpathsample"));
                contextStack.samplePath(this.m_executeArgs[0].getNumericValue(), this.m_executeArgs[1].getNumericValue());
                return;
            }
            case 38: {
                if (n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidpathstripe"));
                double d89 = this.m_executeArgs[1].getNumericValue();
                contextStack.stripePath(this.m_executeArgs[0].getNumericValue(), Math.toRadians(d89));
                return;
            }
            case 39: {
                if (n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidpathshift"));
                contextStack.translatePath(this.m_executeArgs[0].getNumericValue(), this.m_executeArgs[1].getNumericValue());
                return;
            }
            case 40: {
                if (n2 <= 0) throw new MapyrusException(MapyrusMessages.get("invaliddistance"));
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = this.m_executeArgs[i].getNumericValue();
                }
                contextStack.parallelPath(dArray);
                return;
            }
            case 41: {
                if (n2 <= 0 || n2 % 2 != 0) throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                double[] dArray = new double[n2 / 2];
                double[] dArray2 = new double[n2 / 2];
                for (int i = 0; i < n2 / 2; ++i) {
                    dArray[i] = this.m_executeArgs[i * 2].getNumericValue();
                    dArray2[i] = this.m_executeArgs[i * 2 + 1].getNumericValue();
                }
                contextStack.selectPath(dArray, dArray2);
                return;
            }
            case 42: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.reversePath();
                return;
            }
            case 43: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.createSinkhole();
                return;
            }
            case 45: {
                if (n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(this.m_executeArgs[0].getStringValue());
                    for (int i = 1; i < n2; ++i) {
                        stringBuffer.append(this.m_executeArgs[i].getStringValue()).append(Constants.LINE_SEPARATOR);
                    }
                    contextStack.stroke(stringBuffer.toString());
                    return;
                }
                contextStack.stroke(null);
                return;
            }
            case 46: {
                if (n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(this.m_executeArgs[0].getStringValue());
                    for (int i = 1; i < n2; ++i) {
                        stringBuffer.append(this.m_executeArgs[i].getStringValue()).append(Constants.LINE_SEPARATOR);
                    }
                    contextStack.fill(stringBuffer.toString());
                    return;
                }
                contextStack.fill(null);
                return;
            }
            case 47: {
                if (n2 != 4 && n2 != 5) throw new MapyrusException(MapyrusMessages.get("invalidgradientfill"));
                Color color = contextStack.getColor();
                Color color2 = ColorDatabase.getColor(this.m_executeArgs[0].toString(), 255, color);
                if (color2 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[0].toString());
                }
                Color color3 = ColorDatabase.getColor(this.m_executeArgs[1].toString(), 255, color);
                if (color3 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[1].toString());
                }
                Color color4 = ColorDatabase.getColor(this.m_executeArgs[2].toString(), 255, color);
                if (color4 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[2].toString());
                }
                Color color5 = ColorDatabase.getColor(this.m_executeArgs[3].toString(), 255, color);
                if (color5 == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[3].toString());
                }
                Color color6 = null;
                if (n2 == 5 && (color6 = ColorDatabase.getColor(this.m_executeArgs[4].toString(), 255, color)) == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.m_executeArgs[4].toString());
                }
                contextStack.gradientFill(color2, color3, color4, color5, color6);
                return;
            }
            case 48: {
                if (n2 < 1) throw new MapyrusException(MapyrusMessages.get("invalidscript"));
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        stringBuffer.append(Constants.LINE_SEPARATOR);
                    }
                    stringBuffer.append(this.m_executeArgs[i].toString());
                }
                contextStack.setEventScript(stringBuffer.toString());
                return;
            }
            case 51: {
                if (n2 != 1) {
                    throw new MapyrusException(MapyrusMessages.get("noclipside"));
                }
                String string = this.m_executeArgs[0].toString();
                if (string.startsWith(IN_KEYWORD) || string.startsWith("IN")) {
                    contextStack.clipInside();
                    return;
                }
                contextStack.clipOutside();
                return;
            }
            case 69: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidsetoutput"));
                try {
                    PrintStream printStream;
                    String string = this.m_executeArgs[0].getStringValue();
                    if (string.equals("-")) {
                        printStream = this.m_stdoutStream;
                    } else {
                        if (!contextStack.getThrottle().isIOAllowed()) {
                            throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
                        }
                        if (string.startsWith("|")) {
                            String string2 = string.substring(1).trim();
                            String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{string2} : new String[]{"sh", "-c", string2};
                            Process process = Runtime.getRuntime().exec(stringArray);
                            OutputStream outputStream = process.getOutputStream();
                            printStream = new PrintStream(outputStream);
                        } else {
                            FileOutputStream fileOutputStream = new FileOutputStream(string);
                            printStream = new PrintStream(fileOutputStream);
                        }
                    }
                    contextStack.setStdout(printStream);
                    return;
                }
                catch (SecurityException securityException) {
                    throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage());
                }
            }
            case 52: 
            case 53: 
            case 70: {
                int n8;
                String string = "";
                int n9 = 0;
                double d90 = 0.0;
                double d91 = 0.0;
                boolean bl = true;
                if (n3 == 53) {
                    String string3;
                    int n10;
                    if (n2 < 2) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpathoffset"));
                    }
                    d91 = this.m_executeArgs[0].getNumericValue();
                    d90 = this.m_executeArgs[1].getNumericValue();
                    n8 = 2;
                    if (n2 > 2 && (n10 = (string3 = this.m_executeArgs[2].getStringValue()).indexOf("rotate=")) >= 0) {
                        bl = string3.substring(n10 + 7).equalsIgnoreCase("true");
                        n8 = 3;
                    }
                } else {
                    n8 = 0;
                }
                if (n8 < n2) {
                    if (n2 == n8 + 1) {
                        string = this.m_executeArgs[n8].toString();
                        n9 += string.length();
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = n8; i < n2; ++i) {
                            if (i > n8) {
                                stringBuffer.append(' ');
                            }
                            String string4 = this.m_executeArgs[i].toString();
                            stringBuffer.append(string4);
                            n9 += string4.length();
                        }
                        string = stringBuffer.toString();
                    }
                }
                if (n3 == 70) {
                    PrintStream printStream = contextStack.getStdout();
                    printStream.println(string);
                    return;
                }
                if (n9 <= 0) return;
                if (n3 == 53) {
                    contextStack.flowLabel(d91, d90, bl, string);
                    return;
                }
                contextStack.label(string);
                return;
            }
            case 54: 
            case 55: {
                if (n3 == 55 && n2 == 2 || n3 == 54 && n2 >= 2) {
                    String string = this.m_executeArgs[0].getStringValue();
                    ArrayList<Argument> arrayList = new ArrayList<Argument>(n2 - 1);
                    for (int i = 1; i < n2; ++i) {
                        Argument argument;
                        if (this.m_executeArgs[i].getType() == 2) {
                            argument = this.m_executeArgs[i];
                        } else {
                            argument = new Argument();
                            argument.addHashMapEntry("1", this.m_executeArgs[i]);
                        }
                        arrayList.add(argument);
                    }
                    if (n3 == 54) {
                        contextStack.drawTable(string, arrayList);
                        return;
                    }
                    contextStack.drawTree(string, arrayList.get(0));
                    return;
                }
                if (n3 != 54) throw new MapyrusException(MapyrusMessages.get("invalidtree"));
                throw new MapyrusException(MapyrusMessages.get("invalidtable"));
            }
            case 56: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidicon"));
                double d92 = n2 == 2 ? this.m_executeArgs[1].getNumericValue() : 0.0;
                contextStack.drawIcon(this.m_executeArgs[0].getStringValue(), d92);
                return;
            }
            case 57: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidgeoimage"));
                String string = this.m_executeArgs[0].getStringValue();
                String string5 = n2 == 2 ? this.m_executeArgs[1].getStringValue() : "";
                contextStack.drawGeoImage(string, string5, this.m_throttle);
                return;
            }
            case 58: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalideps"));
                double d93 = n2 == 2 ? this.m_executeArgs[1].getNumericValue() : 0.0;
                contextStack.drawEPS(this.m_executeArgs[0].getStringValue(), d93);
                return;
            }
            case 59: {
                if (n2 != 1 && n2 != 2) throw new MapyrusException(MapyrusMessages.get("invalidsvg"));
                double d94 = n2 == 2 ? this.m_executeArgs[1].getNumericValue() : 0.0;
                contextStack.drawSVG(this.m_executeArgs[0].getStringValue(), d94);
                return;
            }
            case 60: {
                for (int i = 0; i < n2; ++i) {
                    contextStack.addSVGCode(this.m_executeArgs[i].getStringValue());
                }
                return;
            }
            case 61: {
                if (n2 != 2 && n2 != 3) throw new MapyrusException(MapyrusMessages.get("invalidpdf"));
                double d95 = n2 == 3 ? this.m_executeArgs[2].getNumericValue() : 0.0;
                long l = Math.round(this.m_executeArgs[1].getNumericValue());
                contextStack.drawPDF(this.m_executeArgs[0].getStringValue(), (int)l, d95);
                return;
            }
            case 62: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidscaling"));
                double d96 = this.m_executeArgs[0].getNumericValue();
                contextStack.setScaling(d96);
                return;
            }
            case 63: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalidrotation"));
                double d97 = this.m_executeArgs[0].getNumericValue();
                contextStack.setRotation(Math.toRadians(d97));
                return;
            }
            case 64: {
                double d98;
                double d99;
                double d100;
                double d101;
                String string;
                StringTokenizer stringTokenizer;
                double d102;
                double d103;
                double d104;
                double d105;
                if (n2 == 1 || n2 == 2) {
                    d105 = 0.0;
                    d104 = 0.0;
                    d103 = 0.0;
                    d102 = 0.0;
                    stringTokenizer = new StringTokenizer(this.m_executeArgs[0].getStringValue(), ",");
                    if (stringTokenizer.countTokens() != 4) throw new MapyrusException(MapyrusMessages.get("invalidworlds"));
                    string = "";
                    try {
                        string = stringTokenizer.nextToken();
                        d101 = Double.parseDouble(string);
                        string = stringTokenizer.nextToken();
                        d100 = Double.parseDouble(string);
                        string = stringTokenizer.nextToken();
                        d99 = Double.parseDouble(string);
                        string = stringTokenizer.nextToken();
                        d98 = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidworlds") + ": " + string);
                    }
                } else {
                    if (n2 == 4 || n2 == 5) {
                        d105 = 0.0;
                        d104 = 0.0;
                        d103 = 0.0;
                        d102 = 0.0;
                    } else {
                        if (n2 != 8 && n2 != 9) throw new MapyrusException(MapyrusMessages.get("invalidworlds"));
                        d102 = this.m_executeArgs[4].getNumericValue();
                        d103 = this.m_executeArgs[5].getNumericValue();
                        d104 = this.m_executeArgs[6].getNumericValue();
                        d105 = this.m_executeArgs[7].getNumericValue();
                    }
                    d101 = this.m_executeArgs[0].getNumericValue();
                    d100 = this.m_executeArgs[1].getNumericValue();
                    d99 = this.m_executeArgs[2].getNumericValue();
                    d98 = this.m_executeArgs[3].getNumericValue();
                }
                int n11 = 1;
                boolean bl = false;
                String string6 = n2 == 2 ? this.m_executeArgs[1].getStringValue() : (n2 == 5 ? this.m_executeArgs[4].getStringValue() : (n2 == 9 ? this.m_executeArgs[8].getStringValue() : ""));
                stringTokenizer = new StringTokenizer(string6);
                while (stringTokenizer.hasMoreTokens()) {
                    String string7;
                    string = stringTokenizer.nextToken();
                    if (string.startsWith("units=")) {
                        string7 = string.substring(6);
                        Integer n12 = m_worldUnitsLookup.get(string7);
                        if (n12 == null) {
                            throw new MapyrusException(MapyrusMessages.get("invalidworldunits") + ": " + string7);
                        }
                        n11 = n12;
                        continue;
                    }
                    if (!string.startsWith("distortion=")) continue;
                    string7 = string.substring(11);
                    bl = string7.equalsIgnoreCase("true");
                }
                contextStack.setWorlds(d101, d100, d99, d98, d102, d103, d104, d105, n11, bl);
                return;
            }
            case 65: {
                if (n2 != 2 && n2 != 3) throw new MapyrusException(MapyrusMessages.get("invaliddataset"));
                String string = "";
                if (n2 > 2) {
                    string = this.m_executeArgs[2].getStringValue();
                }
                String string8 = this.m_executeArgs[1].getStringValue();
                contextStack.setDataset(this.m_executeArgs[0].getStringValue(), string8, string, this.m_stdinStream);
                return;
            }
            case 66: {
                Row row = contextStack.fetchRow();
                String[] stringArray = contextStack.getDatasetFieldNames();
                for (int i = 0; i < row.size(); ++i) {
                    String string = stringArray != null ? stringArray[i] : DefaultFieldNames.get(i);
                    contextStack.defineVariable(string, (Argument)row.get(i));
                }
                return;
            }
            case 67: {
                int n13;
                double d106;
                double d107;
                if (n2 < 3 || n2 > 5) throw new MapyrusException(MapyrusMessages.get("invalidpage"));
                String string = this.m_executeArgs[0].getStringValue();
                String string9 = this.m_executeArgs[1].getStringValue();
                if (n2 == 3) {
                    String string10 = this.m_executeArgs[2].getStringValue();
                    PageSize pageSize = new PageSize(string10);
                    d107 = pageSize.getDimension().getX();
                    d106 = pageSize.getDimension().getY();
                    n13 = 3;
                } else if (this.m_executeArgs[2].getType() == 1) {
                    try {
                        String string11 = this.m_executeArgs[2].getStringValue();
                        PageSize pageSize = new PageSize(string11);
                        d107 = pageSize.getDimension().getX();
                        d106 = pageSize.getDimension().getY();
                        n13 = 3;
                    }
                    catch (MapyrusException mapyrusException) {
                        d107 = this.parseDimension(this.m_executeArgs[2]);
                        d106 = this.parseDimension(this.m_executeArgs[3]);
                        n13 = 4;
                    }
                } else {
                    d107 = this.parseDimension(this.m_executeArgs[2]);
                    d106 = this.parseDimension(this.m_executeArgs[3]);
                    n13 = 4;
                }
                String string12 = n13 < n2 ? this.m_executeArgs[n13].getStringValue() : "";
                if (d107 <= 1.0) {
                    throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d107);
                }
                if (d106 <= 1.0) {
                    throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d106);
                }
                contextStack.setOutputFormat(string, string9, d107, d106, string12, contextStack.getStdout(), this.m_throttle);
                return;
            }
            case 68: {
                contextStack.closeOutputFormat();
                return;
            }
            case 71: {
                return;
            }
            case 73: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("invalideval"));
                String string = this.m_executeArgs[0].getStringValue();
                StringReader stringReader = new StringReader(string);
                String string13 = statement.getFilename();
                FileOrURL fileOrURL = new FileOrURL(stringReader, string13);
                byte[] byArray = new byte[]{};
                this.interpret(contextStack, fileOrURL, new ByteArrayInputStream(byArray), contextStack.getStdout());
                return;
            }
            case 72: {
                return;
            }
            case 74: {
                if (n2 < 2) throw new MapyrusException(MapyrusMessages.get("invalidlegendentry"));
                String string = this.m_executeArgs[0].getStringValue();
                String string14 = this.m_executeArgs[1].getStringValue();
                int n14 = LegendEntry.parseTypeString(string);
                if (n14 < 0) {
                    throw new MapyrusException(MapyrusMessages.get("invalidlegendtype") + ": " + string);
                }
                this.m_context.addLegendEntry(string14, n14, this.m_executeArgs, 2, n2 - 2);
                return;
            }
            case 75: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("nolegendsize"));
                double d108 = this.m_executeArgs[0].getNumericValue();
                this.displayLegend(statement, contextStack, d108);
                return;
            }
            case 76: {
                if (n2 != 1) throw new MapyrusException(MapyrusMessages.get("nomimetype"));
                String string = this.m_executeArgs[0].getStringValue();
                String string15 = "HTTP/1.0 200 OK" + Constants.LINE_SEPARATOR + "Content-Type" + ": " + string + Constants.LINE_SEPARATOR;
                contextStack.setHTTPReponse(string15);
                return;
            }
            case 77: {
                StringBuffer stringBuffer = new StringBuffer(128);
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(this.m_executeArgs[i].getStringValue());
                    stringBuffer.append(Constants.LINE_SEPARATOR);
                }
                contextStack.setHTTPReponse(stringBuffer.toString());
            }
        }
    }

    private double parseDimension(Argument argument) throws MapyrusException {
        String string;
        int n;
        double d = 1.0;
        if (argument.getType() != 0 && (n = (string = argument.getStringValue()).length()) >= 2) {
            String string2 = string.substring(n - 2, n);
            if (string2.equals("px")) {
                d = 25.4 / (double)Constants.getScreenResolution();
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals("pt")) {
                d = 0.35277777777777775;
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals("mm")) {
                d = 1.0;
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals("cm")) {
                d = 10.0;
                argument = new Argument(1, string.substring(0, n - 2));
            } else if (string2.equals(IN_KEYWORD)) {
                d = 25.4;
                argument = new Argument(1, string.substring(0, n - 2));
            }
        }
        double d2 = argument.getNumericValue();
        return d2 *= d;
    }

    private String parseWord(int n, Preprocessor preprocessor) throws IOException, MapyrusException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter((char)n) && n != 36) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        do {
            stringBuffer.append((char)n);
        } while (Character.isLetterOrDigit((char)(n = preprocessor.read())) || n == 46 || n == 95 || n == 58);
        preprocessor.unread(n);
        return stringBuffer.toString();
    }

    private Statement parseSimpleStatement(String string, Preprocessor preprocessor) throws MapyrusException, IOException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        Statement statement = null;
        boolean bl = false;
        int n = 1;
        int n2 = preprocessor.readNonSpace();
        while (!bl) {
            if (n2 == -1 || n2 == 10 || n2 == 59) {
                bl = true;
                continue;
            }
            if (Character.isWhitespace((char)n2)) {
                n2 = preprocessor.readNonSpace();
                continue;
            }
            if (n == 2) {
                if (n2 != 44) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
                }
                n2 = preprocessor.readNonSpace();
                n = 1;
                continue;
            }
            preprocessor.unread(n2);
            Expression expression = new Expression(preprocessor, this.m_userFunctions);
            arrayList.add(expression);
            n2 = preprocessor.readNonSpace();
            n = 2;
        }
        if (n2 == -1 && arrayList.size() == 0) {
            statement = null;
        } else {
            Expression[] expressionArray = new Expression[arrayList.size()];
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i] = (Expression)arrayList.get(i);
            }
            statement = new Statement(string, expressionArray);
            statement.setFilenameAndLineNumber(preprocessor.getCurrentFilename(), preprocessor.getCurrentLineNumber());
        }
        return statement;
    }

    private ArrayList<String> parseParameters(Preprocessor preprocessor) throws IOException, MapyrusException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 3;
        int n2 = preprocessor.readNonSpace();
        while (n2 != -1 && n2 != 10 && n2 != 59) {
            if (Character.isWhitespace((char)n2)) {
                n2 = preprocessor.readNonSpace();
                continue;
            }
            if (n == 3) {
                arrayList.add(this.parseWord(n2, preprocessor));
                n = 4;
                n2 = preprocessor.readNonSpace();
                continue;
            }
            if (n2 != 44) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
            }
            n = 3;
            n2 = preprocessor.readNonSpace();
        }
        return arrayList;
    }

    private ParsedStatement parseProcedureBlock(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl2 = false;
        UserFunction userFunction = null;
        int n = preprocessor.readNonSpace();
        while (Character.isWhitespace((char)n)) {
            n = preprocessor.readNonSpace();
        }
        String string = this.parseWord(n, preprocessor);
        ArrayList<String> arrayList2 = this.parseParameters(preprocessor);
        if (bl) {
            userFunction = new UserFunction(string, arrayList2, null, this);
            this.m_userFunctions.put(string, userFunction);
        }
        do {
            ParsedStatement parsedStatement;
            if ((parsedStatement = this.parseStatementOrKeyword(preprocessor, true)) == null) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
            if (parsedStatement.isStatement()) {
                arrayList.add(parsedStatement.getStatement());
                continue;
            }
            if (parsedStatement.getKeywordType() == 1) {
                bl2 = true;
                continue;
            }
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + END_KEYWORD);
        } while (!bl2);
        if (bl) {
            userFunction.setStatements(arrayList);
        }
        Statement statement = new Statement(string, arrayList2, arrayList);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseLoopStatement(Preprocessor preprocessor, boolean bl, boolean bl2) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        Expression expression = new Expression(preprocessor, this.m_userFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 7) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DO_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() != 8) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DONE_KEYWORD);
        }
        Statement statement = new Statement(expression, arrayList, bl);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseForStatement(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        Expression expression = new Expression(preprocessor, this.m_userFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 9) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + IN_KEYWORD);
        }
        Expression expression2 = new Expression(preprocessor, this.m_userFunctions);
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 7) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DO_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() != 8) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DONE_KEYWORD);
        }
        Statement statement = new Statement(expression, expression2, arrayList);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseIfStatement(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
        boolean bl2 = true;
        Expression expression = new Expression(preprocessor, this.m_userFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 2) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + THEN_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() == 3) {
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement == null) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
            while (parsedStatement.isStatement()) {
                arrayList2.add(parsedStatement.getStatement());
                parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
                if (parsedStatement != null) continue;
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
        } else if (parsedStatement.getKeywordType() == 4) {
            parsedStatement = this.parseIfStatement(preprocessor, bl);
            if (!parsedStatement.isStatement()) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + ENDIF_KEYWORD);
            }
            arrayList2.add(parsedStatement.getStatement());
            bl2 = false;
        }
        if (bl2 && parsedStatement.getKeywordType() != 5) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + ENDIF_KEYWORD);
        }
        Statement statement = new Statement(expression, arrayList, arrayList2);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseStatementOrKeyword(Preprocessor preprocessor, boolean bl) throws MapyrusException, IOException {
        ParsedStatement parsedStatement = null;
        boolean bl2 = false;
        int n = preprocessor.readNonSpace();
        bl2 = false;
        while (!bl2) {
            if (n == -1) {
                bl2 = true;
                break;
            }
            if (Character.isWhitespace((char)n)) {
                n = preprocessor.readNonSpace();
                continue;
            }
            String string = this.parseWord(n, preprocessor);
            String string2 = string.toLowerCase();
            if (string2.equals(BEGIN_KEYWORD) || string2.equals(FUNCTION_KEYWORD)) {
                if (bl) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("nestedproc"));
                }
                parsedStatement = this.parseProcedureBlock(preprocessor, string2.equals(FUNCTION_KEYWORD));
            } else if (string2.equals(IF_KEYWORD)) {
                parsedStatement = this.parseIfStatement(preprocessor, bl);
            } else if (string2.equals(WHILE_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, true, bl);
            } else if (string2.equals(REPEAT_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, false, bl);
            } else if (string2.equals(FOR_KEYWORD)) {
                parsedStatement = this.parseForStatement(preprocessor, bl);
            } else {
                parsedStatement = m_keywordLookup.get(string2);
                if (parsedStatement == null) {
                    Statement statement = this.parseSimpleStatement(string, preprocessor);
                    parsedStatement = new ParsedStatement(statement);
                } else {
                    n = preprocessor.readNonSpace();
                    if (n != -1 && n != 59) {
                        preprocessor.unread(n);
                    }
                }
            }
            bl2 = true;
        }
        return parsedStatement;
    }

    private Statement parseStatement(Preprocessor preprocessor) throws IOException, MapyrusException {
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, false);
        if (parsedStatement == null) {
            return null;
        }
        if (!parsedStatement.isStatement()) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        return parsedStatement.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(ContextStack contextStack, FileOrURL fileOrURL, InputStream inputStream, PrintStream printStream) throws IOException, InterruptedException, MapyrusException {
        boolean bl = this.m_throttle.isIOAllowed();
        Preprocessor preprocessor = new Preprocessor(fileOrURL, bl);
        this.m_stdinStream = inputStream;
        this.m_stdoutStream = printStream;
        this.m_context = contextStack;
        contextStack.setStdout(printStream);
        contextStack.setThrottle(this.m_throttle);
        try {
            Statement statement;
            while ((statement = this.parseStatement(preprocessor)) != null) {
                Argument argument = this.executeStatement(statement);
                if (argument == null) continue;
                break;
            }
        }
        finally {
            preprocessor.close();
        }
    }

    private void makeCall(Statement statement, ArrayList<String> arrayList, Argument[] argumentArray) throws IOException, InterruptedException, MapyrusException {
        Statement statement2;
        for (int i = 0; i < argumentArray.length; ++i) {
            String string = arrayList.get(i);
            this.m_context.setLocalScope(string);
            this.m_context.defineVariable(string, argumentArray[i]);
        }
        ArrayList<Statement> arrayList2 = statement.getStatementBlock();
        for (int i = 0; i < arrayList2.size() && this.executeStatement(statement2 = arrayList2.get(i)) == null; ++i) {
        }
    }

    public Argument executeStatement(Statement statement) throws IOException, MapyrusException, InterruptedException {
        Argument argument;
        block31: {
            int n;
            block35: {
                Argument argument2;
                block34: {
                    Argument argument3;
                    block33: {
                        Argument argument4;
                        block32: {
                            block30: {
                                n = statement.getType();
                                argument = null;
                                if (n != 6) break block30;
                                this.m_statementBlocks.put(statement.getBlockName(), statement);
                                break block31;
                            }
                            if (n != 1001) break block32;
                            Expression[] expressionArray = statement.getExpressions();
                            if (expressionArray.length > 1) {
                                throw new MapyrusException(MapyrusMessages.get("invalidexpression"));
                            }
                            argument = expressionArray.length == 0 ? Argument.emptyString : expressionArray[0].evaluate(this.m_context, statement.getFilename());
                            break block31;
                        }
                        if (n != 2) break block33;
                        Expression[] expressionArray = statement.getExpressions();
                        try {
                            argument4 = expressionArray[0].evaluate(this.m_context, statement.getFilename());
                        }
                        catch (MapyrusException mapyrusException) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                        }
                        if (argument4.getType() != 0) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                        }
                        ArrayList<Statement> arrayList = argument4.getNumericValue() != 0.0 ? statement.getThenStatements() : statement.getElseStatements();
                        if (arrayList == null) break block31;
                        for (int i = 0; i < arrayList.size() && (argument = this.executeStatement(statement = arrayList.get(i))) == null; ++i) {
                        }
                        break block31;
                    }
                    if (n != 4 && n != 3) break block34;
                    Expression[] expressionArray = statement.getExpressions();
                    ArrayList<Statement> arrayList = statement.getLoopStatements();
                    try {
                        argument3 = expressionArray[0].evaluate(this.m_context, statement.getFilename());
                    }
                    catch (MapyrusException mapyrusException) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                    }
                    if (argument3.getType() != 0) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                    }
                    int n2 = 0;
                    if (n == 3) {
                        double d = argument3.getNumericValue();
                        n2 = NumericalAnalysis.equals(d, (double)((int)d)) ? (int)Math.round(d) : (int)argument3.getNumericValue();
                    }
                    int n3 = n;
                    for (int i = 0; argument == null && (n3 == 4 && argument3.getNumericValue() != 0.0 || n3 == 3 && i < n2); ++i) {
                        Statement statement2;
                        for (int j = 0; j < arrayList.size() && (argument = this.executeStatement(statement2 = arrayList.get(j))) == null; ++j) {
                        }
                        if (arrayList.isEmpty()) {
                            this.m_throttle.sleep();
                        }
                        if (n3 != 4 || argument != null || (argument3 = expressionArray[0].evaluate(this.m_context, statement.getFilename())).getType() == 0) continue;
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                    }
                    break block31;
                }
                if (n != 5) break block35;
                Expression[] expressionArray = statement.getExpressions();
                Expression expression = statement.getForHashMap();
                ArrayList<Statement> arrayList = statement.getLoopStatements();
                String string = expressionArray[0].getVariableName();
                try {
                    argument2 = expression.evaluate(this.m_context, statement.getFilename());
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                if (string == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
                }
                if (argument2.getType() != 2) break block31;
                Object[] objectArray = argument2.getHashMapKeys();
                boolean bl = false;
                for (int i = 0; i < objectArray.length && !bl; ++i) {
                    Statement statement3;
                    String string2 = (String)objectArray[i];
                    this.m_context.defineVariable(string, new Argument(1, string2));
                    for (int j = 0; j < arrayList.size() && (argument = this.executeStatement(statement3 = arrayList.get(j))) == null; ++j) {
                    }
                }
                break block31;
            }
            if (n == 1000) {
                int n4;
                Argument[] argumentArray;
                String string = statement.getBlockName();
                Statement statement4 = this.m_statementBlocks.get(string);
                if (statement4 == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
                }
                ArrayList<String> arrayList = statement4.getBlockParameters();
                Expression[] expressionArray = statement.getExpressions();
                if (expressionArray.length != arrayList.size()) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
                }
                try {
                    argumentArray = new Argument[expressionArray.length];
                    for (n4 = 0; n4 < argumentArray.length; ++n4) {
                        argumentArray[n4] = expressionArray[n4].evaluate(this.m_context, statement.getFilename());
                    }
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                n4 = this.m_context.getMoveToCount();
                int n5 = this.m_context.getLineToCount();
                if (n4 > 0 && n5 == 0) {
                    ArrayList<Point2D> arrayList2 = this.m_context.getMoveTos();
                    ArrayList<Double> arrayList3 = this.m_context.getMoveToRotations();
                    for (int i = 0; i < n4; ++i) {
                        this.m_context.saveState(string);
                        Point2D.Float float_ = (Point2D.Float)arrayList2.get(i);
                        this.m_context.setTranslation(float_.x, float_.y);
                        this.m_context.clearPath();
                        double d = arrayList3.get(i);
                        this.m_context.setRotation(d);
                        this.makeCall(statement4, arrayList, argumentArray);
                        this.m_context.restoreState();
                    }
                } else {
                    this.m_context.saveState(string);
                    this.makeCall(statement4, arrayList, argumentArray);
                    this.m_context.restoreState();
                }
            } else {
                try {
                    this.execute(statement, this.m_context);
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                catch (IOException iOException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + iOException.getMessage());
                }
            }
        }
        return argument;
    }

    public Interpreter() {
        this.m_throttle = new Throttle();
    }

    public void setThrottle(Throttle throttle) {
        this.m_throttle = throttle;
    }

    public Throttle getThrottle() {
        return this.m_throttle;
    }

    public Object clone() {
        Interpreter interpreter = new Interpreter();
        interpreter.m_executeArgs = null;
        interpreter.m_context = null;
        interpreter.m_throttle = this.m_throttle.clone();
        interpreter.m_statementBlocks = new HashMap(this.m_statementBlocks.size());
        interpreter.m_statementBlocks.putAll(this.m_statementBlocks);
        interpreter.m_userFunctions = new HashMap(this.m_userFunctions.size());
        for (String string : this.m_userFunctions.keySet()) {
            UserFunction userFunction = this.m_userFunctions.get(string);
            interpreter.m_userFunctions.put(string, userFunction.clone(interpreter));
        }
        interpreter.m_stdinStream = null;
        interpreter.m_stdoutStream = null;
        return interpreter;
    }

    static {
        m_worldUnitsLookup.put("m", 1);
        m_worldUnitsLookup.put("metres", 1);
        m_worldUnitsLookup.put("meters", 1);
        m_worldUnitsLookup.put("feet", 2);
        m_worldUnitsLookup.put("foot", 2);
        m_worldUnitsLookup.put("ft", 2);
        m_worldUnitsLookup.put("degrees", 3);
        m_worldUnitsLookup.put("degree", 3);
        m_worldUnitsLookup.put("deg", 3);
        m_keywordLookup = new HashMap();
        m_keywordLookup.put(END_KEYWORD, new ParsedStatement(1));
        m_keywordLookup.put(THEN_KEYWORD, new ParsedStatement(2));
        m_keywordLookup.put(ELSE_KEYWORD, new ParsedStatement(3));
        m_keywordLookup.put(ELIF_KEYWORD, new ParsedStatement(4));
        m_keywordLookup.put(ENDIF_KEYWORD, new ParsedStatement(5));
        m_keywordLookup.put(DO_KEYWORD, new ParsedStatement(7));
        m_keywordLookup.put(DONE_KEYWORD, new ParsedStatement(8));
        m_keywordLookup.put(IN_KEYWORD, new ParsedStatement(9));
    }
}

