/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Argument
implements Comparable<Argument>,
Cloneable {
    public static final int NUMERIC = 0;
    public static final int STRING = 1;
    public static final int HASHMAP = 2;
    public static final int VARIABLE = 3;
    public static final int GEOMETRY = 4;
    public static final int GEOMETRY_POINT = 100;
    public static final int GEOMETRY_LINESTRING = 101;
    public static final int GEOMETRY_POLYGON = 102;
    public static final int GEOMETRY_MULTIPOINT = 103;
    public static final int GEOMETRY_MULTILINESTRING = 104;
    public static final int GEOMETRY_MULTIPOLYGON = 105;
    public static final int GEOMETRY_COLLECTION = 106;
    public static final int MOVETO = 0;
    public static final int LINETO = 1;
    public static final Argument numericZero = new Argument(0.0);
    public static final Argument numericOne = new Argument(1.0);
    public static final Argument numericMinusOne = new Argument(-1.0);
    public static final Argument emptyString = new Argument(1, "");
    public static final Argument emptyGeometry = new Argument(100, new double[]{100.0, 0.0});
    private int m_type;
    private double m_numericValue;
    private String m_stringValue;
    private String m_varname;
    private double[] m_geometryValue;
    private Rectangle2D.Double m_geometryBoundingBox;
    private HashMap<String, Argument> m_hashMap;

    public Argument(double d) {
        this.m_type = 0;
        this.m_numericValue = d;
    }

    public Argument(int n, String string) {
        this.m_type = n;
        if (n == 1) {
            this.m_stringValue = string;
        } else {
            this.m_varname = string;
        }
        this.m_numericValue = Double.NaN;
        this.m_geometryValue = null;
    }

    public Argument() {
        this.m_type = 2;
        this.m_hashMap = new HashMap();
    }

    public Argument(int n, double[] dArray) {
        this.m_type = n;
        this.m_geometryValue = dArray;
    }

    private int parseCoordinateList(String string, StringTokenizer stringTokenizer, int n, boolean bl) throws MapyrusException {
        String string2;
        int n2 = n;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        while (!bl4 && !bl2 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            bl4 = string2.equals("(");
            bl2 = string2.equals("EMPTY");
        }
        if (bl4) {
            while (!bl3 && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                char c = string2.charAt(0);
                if (Character.isDigit(c) || c == '-' || c == '.') {
                    try {
                        if (!bl6) {
                            if (bl) {
                                this.m_geometryValue[n2] = 100.0;
                                this.m_geometryValue[n2 + 1] = 1.0;
                                this.m_geometryValue[n2 + 2] = 0.0;
                                n2 += 3;
                            } else if (n3 == 0) {
                                this.m_geometryValue[n2] = 0.0;
                                ++n2;
                            } else {
                                this.m_geometryValue[n2] = 1.0;
                                ++n2;
                            }
                            this.m_geometryValue[n2] = Double.parseDouble(string2);
                            ++n2;
                            bl6 = true;
                            continue;
                        }
                        if (!bl5) {
                            this.m_geometryValue[n2] = Double.parseDouble(string2);
                            ++n2;
                            bl5 = true;
                            ++n3;
                            continue;
                        }
                        throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                    }
                }
                if (c == ')' && bl5) {
                    bl3 = true;
                    continue;
                }
                if (c == ',' && bl5) {
                    bl5 = false;
                    bl6 = false;
                    continue;
                }
                if (c == ' ') continue;
                throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
            }
        }
        if (bl4 && !bl3 || bl6 && !bl5) {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
        }
        return n3;
    }

    private int parseRing(String string, StringTokenizer stringTokenizer, int n, boolean bl) throws MapyrusException {
        String string2;
        int n2 = 0;
        int n3 = n + 1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        bl3 = false;
        while (!bl3 && !bl4 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            bl3 = string2.equals("(");
            bl4 = string2.equals("EMPTY");
        }
        if (!bl4) {
            while (bl3 && !bl2 && stringTokenizer.hasMoreTokens()) {
                int n4;
                if (bl) {
                    this.m_geometryValue[n3] = 101.0;
                    n4 = this.parseCoordinateList(string, stringTokenizer, ++n3 + 1, false);
                    this.m_geometryValue[n3] = n4;
                    ++n3;
                    ++n2;
                } else {
                    n4 = this.parseCoordinateList(string, stringTokenizer, n3, false);
                    n2 += n4;
                }
                n3 += n4 * 3;
                bl3 = false;
                while (!bl3 && !bl2 && stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    bl3 = string2.equals(",");
                    bl2 = string2.equals(")");
                }
            }
            if (!bl2) {
                throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
            }
        }
        this.m_geometryValue[n] = n2;
        return n3;
    }

    private int parseGeometry(String string, StringTokenizer stringTokenizer, int n) throws MapyrusException {
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            while (string2.equals(" ") && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (string2.equals("POINT")) {
                this.m_geometryValue[n] = 100.0;
                int n2 = this.parseCoordinateList(string, stringTokenizer, ++n + 1, false);
                this.m_geometryValue[n] = n2;
                ++n;
                n += n2 * 3;
            } else if (string2.equals("LINESTRING")) {
                this.m_geometryValue[n] = 101.0;
                int n3 = this.parseCoordinateList(string, stringTokenizer, ++n + 1, false);
                this.m_geometryValue[n] = n3;
                ++n;
                n += n3 * 3;
            } else if (string2.equals("MULTIPOINT")) {
                this.m_geometryValue[n] = 103.0;
                int n4 = this.parseCoordinateList(string, stringTokenizer, ++n + 1, true);
                this.m_geometryValue[n] = n4;
                ++n;
                n += n4 * 5;
            } else {
                if (string2.equals("POLYGON")) {
                    this.m_geometryValue[n] = 102.0;
                } else if (string2.equals("MULTILINESTRING")) {
                    this.m_geometryValue[n] = 104.0;
                } else if (string2.equals("MULTIPOLYGON")) {
                    this.m_geometryValue[n] = 105.0;
                } else if (string2.equals("GEOMETRYCOLLECTION")) {
                    this.m_geometryValue[n] = 106.0;
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                }
                if (this.m_geometryValue[n] == 102.0) {
                    n = this.parseRing(string, stringTokenizer, n + 1, false);
                } else if (this.m_geometryValue[n] == 104.0) {
                    n = this.parseRing(string, stringTokenizer, n + 1, true);
                } else {
                    String string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    while (!bl3 && !bl && stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        bl3 = string3.equals("(");
                        bl = string3.equals("EMPTY");
                    }
                    int n5 = (int)this.m_geometryValue[n];
                    int n6 = 0;
                    int n7 = n + 1;
                    n += 2;
                    while (bl3 && !bl2 && stringTokenizer.hasMoreTokens()) {
                        if (n5 == 105) {
                            this.m_geometryValue[n] = 102.0;
                            n = this.parseRing(string, stringTokenizer, n + 1, false);
                        } else {
                            n = this.parseGeometry(string, stringTokenizer, n);
                        }
                        ++n6;
                        boolean bl4 = false;
                        while (!bl4 && !bl2 && stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            if (string3.equals(",")) {
                                bl4 = true;
                                continue;
                            }
                            if (!string3.equals(")")) continue;
                            bl2 = true;
                        }
                    }
                    this.m_geometryValue[n7] = n6;
                    if (bl3 && !bl2) {
                        throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                    }
                }
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
        }
        return n;
    }

    public Argument(String string) throws MapyrusException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",() ", true);
        this.m_geometryValue = new double[stringTokenizer.countTokens() + 1];
        this.parseGeometry(string, stringTokenizer, 0);
        this.m_type = (int)this.m_geometryValue[0];
    }

    public int getType() {
        int n = this.m_type == 0 || this.m_type == 1 || this.m_type == 3 || this.m_type == 2 ? this.m_type : 4;
        return n;
    }

    public double getNumericValue() throws MapyrusException {
        if (this.m_type == 1) {
            if (Double.isNaN(this.m_numericValue)) {
                try {
                    this.m_numericValue = Double.parseDouble(this.m_stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_numericValue = 0.0;
                }
            }
        } else {
            if (this.m_type == 2) {
                throw new MapyrusException(MapyrusMessages.get("hashmapnotnumeric"));
            }
            if (this.m_type != 0) {
                throw new MapyrusException(MapyrusMessages.get("geometrynotnumeric"));
            }
        }
        return this.m_numericValue;
    }

    public String getStringValue() {
        return this.toString();
    }

    public String getVariableName() {
        return this.m_varname;
    }

    public double[] getGeometryValue() throws MapyrusException {
        if (this.m_type == 0 || this.m_type == 2 || this.m_type == 3) {
            throw new MapyrusException(MapyrusMessages.get("invalidgeometry"));
        }
        if (this.m_geometryValue == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.m_stringValue, ",() ", true);
            this.m_geometryValue = new double[stringTokenizer.countTokens() + 1];
            this.parseGeometry(this.m_stringValue, stringTokenizer, 0);
        }
        return this.m_geometryValue;
    }

    private Rectangle2D.Double getGeometryBoundingBox(double[] dArray, int[] nArray, Rectangle2D.Double double_) {
        int n = nArray[0];
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        if (n3 == 0) {
            n += 2;
        } else {
            switch (n2) {
                case 100: {
                    double d = dArray[n + 3];
                    double d2 = dArray[n + 4];
                    if (double_ == null) {
                        double_ = new Rectangle2D.Double(d, d2, 0.0, 0.0);
                    } else {
                        double_.add(d, d2);
                    }
                    n += 5;
                    break;
                }
                case 101: 
                case 102: {
                    double d = dArray[n + 3];
                    double d3 = dArray[n + 4];
                    if (double_ == null) {
                        double_ = new Rectangle2D.Double(d, d3, 0.0, 0.0);
                    } else {
                        double_.add(d, d3);
                    }
                    int n4 = 6;
                    for (int i = 1; i < n3; ++i) {
                        d = dArray[n + n4];
                        d3 = dArray[n + n4 + 1];
                        double_.add(d, d3);
                        n4 += 3;
                    }
                    n += 2 + n3 * 3;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    nArray[0] = n += 2;
                    for (int i = 0; i < n3; ++i) {
                        double_ = this.getGeometryBoundingBox(dArray, nArray, double_);
                    }
                    n = nArray[0];
                }
            }
        }
        nArray[0] = n;
        return double_;
    }

    public Rectangle2D.Double getGeometryBoundingBox() throws MapyrusException {
        Rectangle2D.Double double_ = this.m_geometryBoundingBox;
        if (double_ == null) {
            double[] dArray = this.getGeometryValue();
            int[] nArray = new int[]{0};
            double_ = this.getGeometryBoundingBox(dArray, nArray, null);
            if (dArray[0] != 100.0) {
                this.m_geometryBoundingBox = double_;
            }
        }
        return double_;
    }

    private int transformGeometry(AffineTransform affineTransform, double[] dArray, double[] dArray2, int n) throws MapyrusException {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        if (n3 == 0) {
            n += 2;
        } else {
            switch (n2) {
                case 100: {
                    affineTransform.transform(dArray, n + 3, dArray2, n + 3, 1);
                    n += 5;
                    break;
                }
                case 101: 
                case 102: {
                    int n4 = n + 3;
                    for (int i = 0; i < n3; ++i) {
                        affineTransform.transform(dArray, n4, dArray2, n4, 1);
                        n4 += 3;
                    }
                    n += 2 + n3 * 3;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    n += 2;
                    for (int i = 0; i < n3; ++i) {
                        n = this.transformGeometry(affineTransform, dArray, dArray2, n);
                    }
                    break;
                }
            }
        }
        return n;
    }

    public Argument transformGeometry(AffineTransform affineTransform) throws MapyrusException {
        double[] dArray = this.getGeometryValue();
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        this.transformGeometry(affineTransform, dArray, dArray2, 0);
        Argument argument = new Argument((int)dArray2[0], dArray2);
        return argument;
    }

    public Argument getHashMapEntry(String string) {
        Argument argument = this.m_hashMap.get(string);
        if (argument == null) {
            argument = emptyString;
        }
        return argument;
    }

    public void addHashMapEntry(String string, Argument argument) {
        this.m_hashMap.put(string, argument);
    }

    public Object[] getHashMapKeys() {
        Object[] objectArray = new String[this.m_hashMap.size()];
        Iterator<String> iterator = this.m_hashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n++] = iterator.next();
        }
        Arrays.sort(objectArray, new NumericAndStringComparator());
        return objectArray;
    }

    public Object[] getHashMapKeysSortedByValue() {
        Object[] objectArray = this.m_hashMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                Argument argument;
                Argument argument2 = this.m_hashMap.get(objectArray[i]);
                if (argument2.compareTo(argument = this.m_hashMap.get(objectArray[j])) <= 0) continue;
                Object object = objectArray[i];
                objectArray[i] = objectArray[j];
                objectArray[j] = object;
            }
        }
        return objectArray;
    }

    public int getHashMapSize() {
        return this.m_hashMap.size();
    }

    private int createOGCWKT(double[] dArray, int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        int n4 = n + 2;
        if (bl) {
            if (n2 == 100) {
                stringBuffer.append("POINT ");
            } else if (n2 == 101) {
                stringBuffer.append("LINESTRING ");
            } else if (n2 == 102) {
                stringBuffer.append("POLYGON ");
            } else if (n2 == 103) {
                stringBuffer.append("MULTIPOINT ");
            } else if (n2 == 104) {
                stringBuffer.append("MULTILINESTRING ");
            } else if (n2 == 105) {
                stringBuffer.append("MULTIPOLYGON ");
            } else {
                stringBuffer.append("GEOMETRYCOLLECTION ");
            }
        }
        if (n3 == 0) {
            stringBuffer.append("EMPTY ");
        } else if (n2 == 100) {
            if (bl) {
                stringBuffer.append("(");
            }
            stringBuffer.append(dArray[n4 + 1]);
            stringBuffer.append(" ");
            stringBuffer.append(dArray[n4 + 2]);
            if (bl) {
                stringBuffer.append(")");
            }
            n4 += 3;
        } else if (n2 == 101 || n2 == 102) {
            if (n2 == 102) {
                stringBuffer.append("(");
            }
            for (int i = 0; i < n3; ++i) {
                if (dArray[n4] == 0.0) {
                    if (i > 0) {
                        stringBuffer.append("), ");
                    }
                    stringBuffer.append("(");
                } else if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.m_geometryValue[n4 + 1]);
                stringBuffer.append(" ");
                stringBuffer.append(this.m_geometryValue[n4 + 2]);
                n4 += 3;
            }
            if (n2 == 101) {
                stringBuffer.append(")");
            } else {
                stringBuffer.append("))");
            }
        } else {
            stringBuffer.append("( ");
            boolean bl2 = n2 == 106;
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                n4 = this.createOGCWKT(dArray, n4, stringBuffer, bl2);
            }
            stringBuffer.append(")");
        }
        return n4;
    }

    public String getGeoJSONValue() throws MapyrusException {
        double[] dArray = this.getGeometryValue();
        StringBuffer stringBuffer = new StringBuffer();
        this.createGeoJSON(dArray, 0, stringBuffer, true);
        String string = stringBuffer.toString().trim();
        return string;
    }

    private int createGeoJSON(double[] dArray, int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        int n4 = n + 2;
        if (bl) {
            stringBuffer.append("{\"type\": ");
            if (n2 == 100) {
                stringBuffer.append("\"Point\"");
            } else if (n2 == 101) {
                stringBuffer.append("\"LineString\"");
            } else if (n2 == 102) {
                stringBuffer.append("\"Polygon\"");
            } else if (n2 == 103) {
                stringBuffer.append("\"MultiPoint\"");
            } else if (n2 == 104) {
                stringBuffer.append("\"MultiLineString\"");
            } else if (n2 == 105) {
                stringBuffer.append("\"MultiPolygon\"");
            } else {
                stringBuffer.append("\"GeometryCollection\", \"geometries\": ");
            }
            if (n2 != 106) {
                stringBuffer.append(", \"coordinates\": ");
            }
        }
        if (n3 == 0) {
            stringBuffer.append("null");
        } else if (n2 == 100) {
            stringBuffer.append("[");
            stringBuffer.append(dArray[n4 + 1]);
            stringBuffer.append(", ");
            stringBuffer.append(dArray[n4 + 2]);
            stringBuffer.append("]");
            n4 += 3;
        } else if (n2 == 101 || n2 == 102) {
            if (n2 == 102) {
                stringBuffer.append("[");
            }
            for (int i = 0; i < n3; ++i) {
                if (dArray[n4] == 0.0) {
                    if (i > 0) {
                        stringBuffer.append("], ");
                    }
                    stringBuffer.append("[");
                } else if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("[");
                stringBuffer.append(this.m_geometryValue[n4 + 1]);
                stringBuffer.append(", ");
                stringBuffer.append(this.m_geometryValue[n4 + 2]);
                stringBuffer.append("]");
                n4 += 3;
            }
            if (n2 == 101) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append("]]");
            }
        } else {
            boolean bl2 = n2 == 106;
            stringBuffer.append("[");
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                n4 = this.createGeoJSON(dArray, n4, stringBuffer, bl2);
            }
            stringBuffer.append("]");
        }
        if (bl) {
            stringBuffer.append("}");
        }
        return n4;
    }

    private String escapeQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (c > '\u007f') {
                stringBuffer.append("\\u").append(String.format("%04X", c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = null;
        if (this.m_type == 1) {
            string = this.m_stringValue;
        } else if (this.m_type == 3) {
            string = this.m_varname;
        } else if (this.m_type == 0) {
            double d = this.m_numericValue >= 0.0 ? this.m_numericValue : -this.m_numericValue;
            DecimalFormat decimalFormat = d != 0.0 && (d < 0.01 || d > 1.0E7) ? new DecimalFormat("#.################E0", Constants.US_DECIMAL_FORMAT_SYMBOLS) : new DecimalFormat("#.################", Constants.US_DECIMAL_FORMAT_SYMBOLS);
            string = decimalFormat.format(this.m_numericValue);
        } else if (this.m_type == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = this.getHashMapKeys();
            boolean bl = this.isSequentialKeys(objectArray);
            if (bl) {
                stringBuffer.append("[");
            } else {
                stringBuffer.append("{");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                if (!bl) {
                    stringBuffer.append("\"");
                    object = objectArray[i].toString();
                    stringBuffer.append(this.escapeQuotes((String)object));
                    stringBuffer.append("\": ");
                }
                object = this.m_hashMap.get(objectArray[i]);
                String string2 = ((Argument)object).getStringValue();
                int n = ((Argument)object).getType();
                if (n == 1) {
                    string2 = this.escapeQuotes(string2);
                }
                if (n != 2 && n != 0) {
                    stringBuffer.append("\"");
                }
                stringBuffer.append(string2);
                if (n == 2 || n == 0) continue;
                stringBuffer.append("\"");
            }
            if (bl) {
                stringBuffer.append("]");
            } else {
                stringBuffer.append("}");
            }
            string = stringBuffer.toString();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            this.createOGCWKT(this.m_geometryValue, 0, stringBuffer, true);
            string = stringBuffer.toString().trim();
        }
        return string;
    }

    private boolean isSequentialKeys(Object[] objectArray) {
        boolean bl = true;
        for (int i = 0; i < objectArray.length && bl; ++i) {
            if (objectArray[i].toString().equals(Integer.toString(i + 1))) continue;
            bl = false;
        }
        return bl;
    }

    public Object clone() {
        Argument argument;
        if (this.m_type == 1 || this.m_type == 3) {
            argument = new Argument(this.m_type, this.m_stringValue);
        } else if (this.m_type == 0) {
            argument = new Argument(this.m_numericValue);
        } else if (this.m_type == 2) {
            argument = new Argument();
            argument.m_hashMap = new HashMap(this.m_hashMap.size());
            for (String string : this.m_hashMap.keySet()) {
                argument.m_hashMap.put(string, this.m_hashMap.get(string));
            }
        } else {
            argument = new Argument(this.m_type, this.m_geometryValue);
        }
        return argument;
    }

    @Override
    public int compareTo(Argument argument) {
        int n;
        if (this.getType() == 0 && argument.getType() == 0) {
            double d = 1.0;
            double d2 = 0.0;
            try {
                d = this.getNumericValue();
                d2 = argument.getNumericValue();
            }
            catch (MapyrusException mapyrusException) {
                // empty catch block
            }
            n = NumericalAnalysis.equals(d, d2) ? 0 : (d > d2 ? 1 : -1);
        } else {
            String string = this.getStringValue();
            String string2 = argument.getStringValue();
            n = string.compareTo(string2);
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NumericAndStringComparator
    implements Comparator<String> {
        private NumericAndStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            try {
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt(string2);
                n = n2 - n3;
            }
            catch (NumberFormatException numberFormatException) {
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

