/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.function;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mapyrus.Argument;
import org.mapyrus.ContextStack;
import org.mapyrus.LRUCache;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Match
implements Function {
    private static final int MAX_COMPILED_REGEX = 100;
    private static LRUCache<String, Pattern> m_regexCache = new LRUCache(100);

    public static synchronized Pattern compileRegex(String string) throws MapyrusException {
        Pattern pattern = (Pattern)m_regexCache.get(string);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new MapyrusException(MapyrusMessages.get("invalidregex") + ": " + patternSyntaxException.getMessage());
            }
            m_regexCache.put(string, pattern);
        }
        return pattern;
    }

    @Override
    public Argument evaluate(ContextStack contextStack, ArrayList<Argument> arrayList) throws MapyrusException {
        int n;
        Argument argument = arrayList.get(0);
        Argument argument2 = arrayList.get(1);
        Pattern pattern = Match.compileRegex(argument2.toString());
        Matcher matcher = pattern.matcher(argument.toString());
        Argument argument3 = matcher.find() ? ((n = matcher.start() + 1) == 1 ? Argument.numericOne : new Argument(n)) : Argument.numericZero;
        return argument3;
    }

    @Override
    public int getMaxArgumentCount() {
        return 2;
    }

    @Override
    public int getMinArgumentCount() {
        return 2;
    }

    @Override
    public String getName() {
        return "match";
    }
}

