/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GradientFillFactory {
    private static final int IMAGE_SIZE = 300;
    private static BufferedImage m_lastImage = null;
    private static Color m_lastC1 = Color.BLACK;
    private static Color m_lastC2 = Color.BLACK;
    private static Color m_lastC3 = Color.BLACK;
    private static Color m_lastC4 = Color.BLACK;
    private static Color m_lastC5 = Color.BLACK;
    private static short[] m_c1Weightings = new short[90000];
    private static short[] m_c2Weightings = new short[90000];
    private static short[] m_c3Weightings = new short[90000];
    private static short[] m_c4Weightings = new short[90000];
    private static short[] m_c5Weightings = new short[90000];

    private static double power8(double d) {
        return d * d * d * d * d * d * d * d;
    }

    public static synchronized BufferedImage getImage(Color color, Color color2, Color color3, Color color4, Color color5) {
        if (color.equals(m_lastC1) && color2.equals(m_lastC2) && color3.equals(m_lastC3) && color4.equals(m_lastC4) && (color5 == null && m_lastC5 == null || color5 != null && m_lastC5 != null && color5.equals(m_lastC5))) {
            BufferedImage bufferedImage = m_lastImage;
        } else {
            BufferedImage bufferedImage = new BufferedImage(300, 300, 1);
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int i = 0; i < 300; ++i) {
                for (int j = 0; j < 300; ++j) {
                    int n = i * 300 + j;
                    short s = m_c1Weightings[n];
                    short s2 = m_c2Weightings[n];
                    short s3 = m_c3Weightings[n];
                    short s4 = m_c4Weightings[n];
                    short s5 = m_c5Weightings[n];
                    float f4 = s + s2 + s3 + s4;
                    if (color5 != null) {
                        f = (float)s5 / (f4 += (float)s5) * (float)color5.getRed();
                        f2 = (float)s5 / f4 * (float)color5.getGreen();
                        f3 = (float)s5 / f4 * (float)color5.getBlue();
                    }
                    float f5 = (float)s / f4 * (float)color.getRed() + (float)s2 / f4 * (float)color2.getRed() + (float)s3 / f4 * (float)color3.getRed() + (float)s4 / f4 * (float)color4.getRed() + f;
                    float f6 = (float)s / f4 * (float)color.getGreen() + (float)s2 / f4 * (float)color2.getGreen() + (float)s3 / f4 * (float)color3.getGreen() + (float)s4 / f4 * (float)color4.getGreen() + f2;
                    float f7 = (float)s / f4 * (float)color.getBlue() + (float)s2 / f4 * (float)color2.getBlue() + (float)s3 / f4 * (float)color3.getBlue() + (float)s4 / f4 * (float)color4.getBlue() + f3;
                    int n2 = (int)f5 << 16 | (int)f6 << 8 | (int)f7;
                    bufferedImage.setRGB(j, i, n2);
                }
            }
            m_lastImage = bufferedImage;
            m_lastC1 = color;
            m_lastC2 = color2;
            m_lastC3 = color3;
            m_lastC4 = color4;
            m_lastC5 = color5;
        }
        return m_lastImage;
    }

    public static void main(String[] stringArray) {
        try {
            BufferedImage bufferedImage = GradientFillFactory.getImage(Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.RED);
            ImageIO.write((RenderedImage)bufferedImage, "png", new File("/tmp/a.png"));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        System.out.println("Finished");
    }

    static {
        int n = 180000;
        for (int i = 0; i < 300; ++i) {
            for (int j = 0; j < 300; ++j) {
                int n2 = j * j + i * i;
                int n3 = (300 - j) * (300 - j) + i * i;
                int n4 = j * j + (300 - i) * (300 - i);
                int n5 = (300 - j) * (300 - j) + (300 - i) * (300 - i);
                int n6 = (150 - j) * (150 - j) + (150 - i) * (150 - i);
                int n7 = i * 300 + j;
                GradientFillFactory.m_c1Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n4 / (double)n));
                GradientFillFactory.m_c2Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n5 / (double)n));
                GradientFillFactory.m_c3Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n2 / (double)n));
                GradientFillFactory.m_c4Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n3 / (double)n));
                GradientFillFactory.m_c5Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n6 / (double)n));
            }
        }
    }
}

