/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.Dataset;
import org.mapyrus.GeometricPath;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.OutputFormat;
import org.mapyrus.PageMask;
import org.mapyrus.Throttle;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.font.StringDimension;
import org.mapyrus.geom.Sinkhole;
import org.mapyrus.geom.SutherlandHodgman;
import org.mapyrus.image.GradientFillFactory;
import org.mapyrus.image.ImageFilter;
import org.mapyrus.image.ImageIOWrapper;
import org.mapyrus.image.MapyrusExternalImage;
import org.mapyrus.io.GeoImageBoundingBox;
import org.mapyrus.io.ImageClippingFile;
import org.mapyrus.io.TFWFile;
import org.mapyrus.io.WMSRequestBoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    public static final int WORLD_UNITS_METRES = 1;
    public static final int WORLD_UNITS_FEET = 2;
    public static final int WORLD_UNITS_DEGREES = 3;
    private static final int ATTRIBUTE_FONT = 1;
    private static final int ATTRIBUTE_JUSTIFY = 2;
    private static final int ATTRIBUTE_COLOR = 4;
    private static final int ATTRIBUTE_BLEND = 8;
    private static final int ATTRIBUTE_LINESTYLE = 16;
    private static final int ATTRIBUTE_CLIP = 32;
    private static final int DEFAULT_RESOLUTION = 96;
    private static final float MITER_LIMIT = 10.0f;
    private static final int N_SINE_WAVE_STEPS = 20;
    private Color m_color;
    private String m_blend;
    private BasicStroke m_linestyle;
    private int m_justify;
    private String m_fontName;
    private double m_fontSize;
    private double m_fontRotation;
    private double m_fontOutlineWidth;
    private double m_fontLineSpacing;
    private int m_attributesPending;
    private int m_attributesChanged;
    private AffineTransform m_ctm;
    private double m_scaling;
    private double m_rotation;
    private AffineTransform m_worldCtm;
    private Rectangle2D.Double m_worldExtents;
    private Rectangle2D.Double m_pageWorldExtents;
    private int m_worldUnits;
    private GeometricPath m_path;
    private GeometricPath m_existingPath;
    private ArrayList<GeometricPath> m_clippingPaths;
    private HashMap<String, Argument> m_vars;
    private HashSet<String> m_localVars;
    private OutputFormat m_outputFormat;
    private boolean m_outputDefined;
    private boolean m_datasetDefined;
    private Dataset m_dataset;
    private PrintStream m_stdoutStream;
    private boolean m_stdoutStreamDefined;
    private String m_blockName;
    private static Hashtable<String, GeoImageBoundingBox> m_imageBoundsCache = new Hashtable();

    private void initialiseContext(Context context) {
        this.m_color = Color.BLACK;
        this.m_blend = "Normal";
        this.m_linestyle = new BasicStroke(0.1f);
        this.m_justify = 33;
        this.m_fontName = "SansSerif";
        this.m_fontSize = 5.0;
        this.m_fontRotation = 0.0;
        this.m_fontOutlineWidth = 0.0;
        this.m_fontLineSpacing = 1.0;
        this.m_existingPath = null;
        this.m_path = null;
        this.m_clippingPaths = null;
        this.m_ctm = new AffineTransform();
        this.m_scaling = 1.0;
        this.m_rotation = 0.0;
        this.m_attributesPending = 63;
        this.m_attributesChanged = 0;
        this.m_worldCtm = null;
        this.m_pageWorldExtents = null;
    }

    public Context() {
        this.m_vars = null;
        this.m_localVars = null;
        this.m_outputFormat = null;
        this.m_outputDefined = false;
        this.m_datasetDefined = false;
        this.m_dataset = null;
        this.m_stdoutStream = null;
        this.m_stdoutStreamDefined = false;
        this.m_blockName = null;
        this.initialiseContext(this);
    }

    public Context(Context context, String string) {
        this.m_color = context.m_color;
        this.m_blend = context.m_blend;
        this.m_linestyle = context.m_linestyle;
        this.m_justify = context.m_justify;
        this.m_fontName = context.m_fontName;
        this.m_fontSize = context.m_fontSize;
        this.m_fontRotation = context.m_fontRotation;
        this.m_fontOutlineWidth = context.m_fontOutlineWidth;
        this.m_fontLineSpacing = context.m_fontLineSpacing;
        this.m_ctm = new AffineTransform(context.m_ctm);
        this.m_worldCtm = null;
        this.m_scaling = context.m_scaling;
        this.m_rotation = context.m_rotation;
        this.m_dataset = context.m_dataset;
        this.m_vars = null;
        this.m_localVars = null;
        this.m_path = null;
        this.m_existingPath = context.m_path != null ? context.m_path : context.m_existingPath;
        this.m_clippingPaths = context.m_clippingPaths != null ? new ArrayList<GeometricPath>(context.m_clippingPaths) : null;
        this.m_outputFormat = context.m_outputFormat;
        this.m_outputDefined = false;
        if (this.m_outputFormat != null) {
            this.m_outputFormat.saveState();
        }
        this.m_datasetDefined = false;
        this.m_stdoutStream = context.m_stdoutStream;
        this.m_stdoutStreamDefined = false;
        this.m_attributesPending = context.m_attributesPending;
        this.m_attributesChanged = 0;
        this.m_blockName = string;
    }

    private GeometricPath getDefinedPath() {
        GeometricPath geometricPath = this.m_path != null ? this.m_path : this.m_existingPath;
        return geometricPath;
    }

    public double getPageWidth() {
        double d = this.m_outputFormat == null ? 0.0 : this.m_outputFormat.getPageWidth();
        return d;
    }

    public double getPageHeight() {
        double d = this.m_outputFormat == null ? 0.0 : this.m_outputFormat.getPageHeight();
        return d;
    }

    public String getPageFormat() {
        String string = this.m_outputFormat == null ? "" : this.m_outputFormat.getPageFormat();
        return string;
    }

    public double getResolution() throws MapyrusException {
        double d = this.m_outputFormat == null ? 0.26458333333333334 : this.m_outputFormat.getResolution();
        return d;
    }

    private void setGraphicsAttributes(int n) throws IOException, MapyrusException {
        int n2 = ~n;
        if ((this.m_attributesPending & 1 & n) != 0) {
            this.m_outputFormat.setFontAttribute(this.m_fontName, this.m_fontSize, this.m_fontRotation, this.m_fontOutlineWidth, this.m_fontLineSpacing);
        }
        if ((this.m_attributesPending & 2 & n) != 0) {
            this.m_outputFormat.setJustifyAttribute(this.m_justify);
        }
        if ((this.m_attributesPending & 4 & n) != 0) {
            this.m_outputFormat.setColorAttribute(this.m_color);
        }
        if ((this.m_attributesPending & 8 & n) != 0) {
            this.m_outputFormat.setBlendAttribute(this.m_blend);
        }
        if ((this.m_attributesPending & 0x10 & n) != 0) {
            this.m_outputFormat.setLinestyleAttribute(this.m_linestyle);
        }
        if ((this.m_attributesPending & 0x20 & n) != 0) {
            this.m_outputFormat.setClipAttribute(this.m_clippingPaths);
        }
        this.m_attributesPending &= n2;
    }

    public void setAttributesChanged(int n) {
        this.m_attributesPending |= n;
        this.m_attributesChanged |= n;
    }

    public void setOutputFormat(String string, String string2, double d, double d2, String string3, PrintStream printStream, Throttle throttle) throws IOException, MapyrusException {
        this.closeOutputFormat();
        this.initialiseContext(this);
        this.m_outputFormat = new OutputFormat(string2, string, d, d2, string3, printStream, throttle);
        this.m_outputDefined = true;
    }

    public void setOutputFormat(BufferedImage bufferedImage, PrintWriter printWriter, String string) throws IOException, MapyrusException {
        this.setOutputFormat(bufferedImage, string);
        if (printWriter != null) {
            this.m_outputFormat.setImageMapWriter(printWriter);
        }
    }

    public void setOutputFormat(BufferedImage bufferedImage, String string) throws IOException, MapyrusException {
        this.closeOutputFormat();
        this.initialiseContext(this);
        this.m_outputFormat = new OutputFormat(bufferedImage, string);
        this.m_outputDefined = true;
    }

    public void closeOutputFormat() throws IOException, MapyrusException {
        boolean bl;
        if (this.m_outputFormat != null && !this.m_outputDefined && (bl = this.m_outputFormat.restoreState())) {
            this.m_attributesChanged = 0;
        }
        if (this.m_outputDefined) {
            this.m_outputFormat.closeOutputFormat();
            this.m_outputFormat = null;
            this.m_outputDefined = false;
        }
    }

    public int closeContext() throws IOException, MapyrusException {
        this.closeOutputFormat();
        if (this.m_datasetDefined) {
            this.m_dataset.close();
        }
        this.m_dataset = null;
        if (this.m_stdoutStreamDefined) {
            if (this.m_stdoutStream == System.out) {
                this.m_stdoutStream.flush();
            } else {
                this.m_stdoutStream.close();
            }
            this.m_stdoutStreamDefined = false;
            this.m_stdoutStream = null;
        }
        this.m_existingPath = null;
        this.m_path = null;
        this.m_clippingPaths = null;
        this.m_vars = null;
        this.m_localVars = null;
        return this.m_attributesChanged;
    }

    public void setLinestyle(double d, int n, int n2, double d2, float[] fArray) {
        if (fArray == null) {
            this.m_linestyle = new BasicStroke((float)(d * this.m_scaling), n, n2, 10.0f);
        } else {
            int n3 = 0;
            while (n3 < fArray.length) {
                int n4 = n3++;
                fArray[n4] = (float)((double)fArray[n4] * this.m_scaling);
            }
            this.m_linestyle = new BasicStroke((float)(d * this.m_scaling), n, n2, 10.0f, fArray, (float)d2);
        }
        this.m_attributesPending |= 0x10;
        this.m_attributesChanged |= 0x10;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
        this.m_attributesPending |= 4;
        this.m_attributesChanged |= 4;
    }

    public void setBlend(String string) {
        this.m_blend = string;
        this.m_attributesPending |= 8;
        this.m_attributesChanged |= 8;
    }

    public void setFont(String string, double d, double d2, double d3) {
        this.m_fontName = string;
        this.m_fontSize = d * this.m_scaling;
        this.m_fontRotation = this.m_rotation;
        this.m_fontOutlineWidth = d2 * this.m_scaling;
        this.m_fontLineSpacing = d3;
        this.m_attributesChanged |= 1;
        this.m_attributesPending |= 1;
    }

    private double addFontRotation(double d) {
        double d2 = this.m_fontRotation;
        this.m_fontRotation += d;
        this.m_attributesChanged |= 1;
        this.m_attributesPending |= 1;
        return d2;
    }

    public int setJustify(int n) {
        int n2 = this.m_justify;
        this.m_justify = n;
        this.m_attributesChanged |= 2;
        this.m_attributesPending |= 2;
        return n2;
    }

    public void setScaling(double d) {
        this.m_ctm.scale(d, d);
        this.m_scaling *= d;
    }

    public void setTranslation(double d, double d2) {
        this.m_ctm.translate(d, d2);
    }

    public void setRotation(double d) {
        this.m_ctm.rotate(d);
        this.m_rotation += d;
        this.m_rotation = Math.IEEEremainder(this.m_rotation, Math.PI * 2);
    }

    public void setWorlds(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, boolean bl) throws MapyrusException {
        if (this.m_outputFormat == null) {
            throw new MapyrusException(MapyrusMessages.get("nooutput"));
        }
        double d9 = d3 - d;
        double d10 = d4 - d2;
        if (d7 == 0.0 && d8 == 0.0) {
            d7 = this.m_outputFormat.getPageWidth();
            d8 = this.m_outputFormat.getPageHeight();
        }
        double d11 = d7 - d5;
        double d12 = d8 - d6;
        if (d11 <= 0.0 || d12 <= 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invalidpagerange"));
        }
        if (d9 == 0.0 || d10 == 0.0) {
            throw new MapyrusException(MapyrusMessages.get("zeroworldrange"));
        }
        double d13 = Math.abs(d10 / d9);
        double d14 = d12 / d11;
        if (!bl) {
            if (d13 > d14) {
                double d15 = (d + d3) / 2.0;
                d = d15 - d9 / 2.0 * (d13 / d14);
                d3 = d15 + d9 / 2.0 * (d13 / d14);
            } else if (d13 < d14) {
                double d16 = (d2 + d4) / 2.0;
                d2 = d16 - d10 / 2.0 * (d14 / d13);
                d4 = d16 + d10 / 2.0 * (d14 / d13);
            }
        }
        this.m_worldExtents = new Rectangle2D.Double(Math.min(d, d3), Math.min(d2, d4), Math.abs(d3 - d), Math.abs(d4 - d2));
        d9 = d3 - d;
        d10 = d4 - d2;
        this.m_worldCtm = new AffineTransform();
        this.m_worldCtm.scale(this.m_outputFormat.getPageWidth() / ((d3 += d9 / d11 * (this.m_outputFormat.getPageWidth() - d7)) - (d -= d9 / d11 * d5)), this.m_outputFormat.getPageHeight() / ((d4 += d10 / d12 * (this.m_outputFormat.getPageHeight() - d8)) - (d2 -= d10 / d12 * d6)));
        this.m_worldCtm.translate(-d, -d2);
        this.m_pageWorldExtents = new Rectangle2D.Double(Math.min(d, d3), Math.min(d2, d4), Math.abs(d3 - d), Math.abs(d4 - d2));
        this.m_worldUnits = n;
    }

    public Argument transformToWorlds(Argument argument) throws MapyrusException {
        AffineTransform affineTransform = null;
        Argument argument2 = argument;
        try {
            if (this.m_worldCtm != null) {
                affineTransform = this.m_worldCtm.createInverse();
                argument2 = argument.transformGeometry(affineTransform);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return argument2;
    }

    public Argument transformToPage(Argument argument) throws MapyrusException {
        Argument argument2 = argument;
        if (this.m_worldCtm != null) {
            argument2 = argument.transformGeometry(this.m_worldCtm);
        }
        return argument2;
    }

    public void setDataset(GeographicDataset geographicDataset) throws MapyrusException {
        if (this.m_dataset != null && this.m_datasetDefined) {
            this.m_dataset.close();
        }
        this.m_dataset = new Dataset(geographicDataset);
        this.m_datasetDefined = true;
    }

    public void setStdout(PrintStream printStream) throws IOException {
        if (printStream != this.m_stdoutStream) {
            if (this.m_stdoutStream != null && this.m_stdoutStreamDefined) {
                if (this.m_stdoutStream == System.out) {
                    this.m_stdoutStream.flush();
                } else {
                    this.m_stdoutStream.close();
                }
            }
            this.m_stdoutStream = printStream;
            this.m_stdoutStreamDefined = true;
        }
    }

    public double getScaling() {
        return this.m_scaling;
    }

    public double getRotation() {
        return this.m_rotation;
    }

    public Rectangle2D.Double getWorldExtents() throws MapyrusException {
        Rectangle2D.Double double_ = this.m_worldExtents != null ? this.m_worldExtents : (this.m_outputFormat != null ? new Rectangle2D.Double(0.0, 0.0, this.m_outputFormat.getPageWidth(), this.m_outputFormat.getPageHeight()) : new Rectangle2D.Double());
        return double_;
    }

    public double getWorldScale() {
        double d;
        if (this.m_outputFormat != null && this.m_worldCtm != null) {
            double d2 = this.m_pageWorldExtents.width;
            d2 = this.m_worldUnits == 1 ? (d2 *= 1000.0) : (this.m_worldUnits == 2 ? (d2 *= 304.8) : (d2 *= 1.1E8));
            d = d2 / this.m_outputFormat.getPageWidth();
        } else {
            d = 1.0;
        }
        return d;
    }

    public Dataset getDataset() {
        return this.m_dataset;
    }

    public PrintStream getStdout() {
        return this.m_stdoutStream;
    }

    public String getBlockName() {
        return this.m_blockName;
    }

    public void moveTo(double d, double d2) throws MapyrusException {
        double[] dArray = new double[2];
        float[] fArray = new float[2];
        dArray[0] = d;
        dArray[1] = d2;
        if (this.m_worldCtm != null) {
            this.m_worldCtm.transform(dArray, 0, dArray, 0, 1);
        }
        this.m_ctm.transform(dArray, 0, fArray, 0, 1);
        if (this.m_path == null) {
            this.m_path = new GeometricPath();
        }
        this.m_path.moveTo(fArray[0], fArray[1], 0.0);
    }

    public void lineTo(double d, double d2) throws MapyrusException {
        double[] dArray = new double[2];
        float[] fArray = new float[2];
        dArray[0] = d;
        dArray[1] = d2;
        if (this.m_path == null || this.m_path.getMoveToCount() == 0) {
            throw new MapyrusException(MapyrusMessages.get("nomoveto"));
        }
        if (this.m_worldCtm != null) {
            this.m_worldCtm.transform(dArray, 0, dArray, 0, 1);
        }
        this.m_ctm.transform(dArray, 0, fArray, 0, 1);
        if (this.m_path == null) {
            this.m_path = new GeometricPath();
        }
        this.m_path.lineTo(fArray[0], fArray[1]);
    }

    public void rlineTo(double d, double d2) throws MapyrusException {
        if (this.m_path == null || this.m_path.getMoveToCount() == 0) {
            throw new MapyrusException(MapyrusMessages.get("nomoveto"));
        }
        try {
            Point2D point2D = this.m_path.getShape().getCurrentPoint();
            if (this.m_worldCtm != null) {
                this.m_worldCtm.inverseTransform(point2D, point2D);
            }
            this.m_ctm.inverseTransform(point2D, point2D);
            this.lineTo(d += point2D.getX(), d2 += point2D.getY());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new MapyrusException(noninvertibleTransformException.getMessage());
        }
    }

    public void arcTo(int n, double d, double d2, double d3, double d4) throws MapyrusException {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        float[] fArray = new float[4];
        dArray[0] = d;
        dArray[1] = d2;
        dArray2[0] = d3;
        dArray2[1] = d4;
        if (this.m_path == null || this.m_path.getMoveToCount() == 0) {
            throw new MapyrusException(MapyrusMessages.get("noarcstart"));
        }
        if (this.m_worldCtm != null) {
            this.m_worldCtm.transform(dArray, 0, dArray, 0, 1);
            this.m_worldCtm.transform(dArray2, 0, dArray2, 0, 1);
        }
        this.m_ctm.transform(dArray, 0, fArray, 0, 1);
        this.m_ctm.transform(dArray2, 0, fArray, 2, 1);
        this.m_path.arcTo(n, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) throws MapyrusException {
        double[] dArray = new double[6];
        float[] fArray = new float[6];
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
        dArray[4] = d5;
        dArray[5] = d6;
        if (this.m_path == null || this.m_path.getMoveToCount() == 0) {
            throw new MapyrusException(MapyrusMessages.get("nobezierstart"));
        }
        if (this.m_worldCtm != null) {
            this.m_worldCtm.transform(dArray, 0, dArray, 0, dArray.length / 2);
        }
        this.m_ctm.transform(dArray, 0, fArray, 0, dArray.length / 2);
        this.m_path.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    public void sineWaveTo(double d, double d2, double d3, double d4) throws MapyrusException {
        if (this.m_path == null || this.m_path.getMoveToCount() == 0) {
            throw new MapyrusException(MapyrusMessages.get("nosinewavestart"));
        }
        try {
            Point2D point2D = this.m_path.getShape().getCurrentPoint();
            if (this.m_worldCtm != null) {
                this.m_worldCtm.inverseTransform(point2D, point2D);
            }
            this.m_ctm.inverseTransform(point2D, point2D);
            double d5 = d - point2D.getX();
            double d6 = d2 - point2D.getY();
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            if (d7 > 0.0 && d3 > 0.0) {
                double d8 = Math.atan2(d6, d5);
                double d9 = Math.cos(d8 + 1.5707963267948966);
                double d10 = Math.sin(d8 + 1.5707963267948966);
                int n = 0;
                while ((double)n < d3) {
                    double d11 = point2D.getX() + (double)n / d3 * d5;
                    double d12 = point2D.getY() + (double)n / d3 * d6;
                    double d13 = d3 - (double)n;
                    if (d13 > 1.0) {
                        d13 = 1.0;
                    }
                    for (int i = 0; i <= 20; ++i) {
                        double d14 = d11 + (double)i / 20.0 * (d5 * d13 / d3);
                        double d15 = d12 + (double)i / 20.0 * (d6 * d13 / d3);
                        double d16 = Math.sin((double)i / 20.0 * (Math.PI * 2) * d13) * d4;
                        this.lineTo(d14 += d9 * d16, d15 += d10 * d16);
                    }
                    ++n;
                }
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new MapyrusException(noninvertibleTransformException.getMessage());
        }
    }

    public void ellipseTo(double d, double d2, double d3, double d4) throws MapyrusException {
        double[] dArray = new double[4];
        float[] fArray = new float[4];
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
        if (this.m_worldCtm != null) {
            this.m_worldCtm.transform(dArray, 0, dArray, 0, 2);
        }
        this.m_ctm.transform(dArray, 0, fArray, 0, 2);
        if (this.m_path == null) {
            this.m_path = new GeometricPath();
        }
        this.m_path.ellipseTo((fArray[0] + fArray[2]) / 2.0f, (fArray[1] + fArray[3]) / 2.0f, (dArray[2] - dArray[0]) * this.m_scaling, (dArray[3] - dArray[1]) * this.m_scaling, this.m_rotation);
    }

    public void clearPath() {
        if (this.m_path != null) {
            this.m_path.reset();
        } else {
            this.m_existingPath = null;
        }
    }

    public void closePath() {
        if (this.m_path != null) {
            this.m_path.closePath();
        } else if (this.m_existingPath != null) {
            this.m_path = new GeometricPath(this.m_existingPath);
            this.m_path.closePath();
        }
    }

    public void samplePath(double d, double d2) throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        double d3 = this.getResolution();
        if (geometricPath != null) {
            this.m_path = geometricPath.samplePath(d * this.m_scaling, d2 * this.m_scaling, d3);
        }
    }

    public void stripePath(double d, double d2) {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null) {
            this.m_path = geometricPath.stripePath(d * this.m_scaling, d2 + this.m_rotation);
        }
    }

    public void createSinkhole() {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null) {
            Point2D point2D = Sinkhole.calculate(geometricPath.getShape());
            this.m_path = new GeometricPath();
            this.m_path.moveTo((float)point2D.getX(), (float)point2D.getY(), 0.0);
        }
    }

    public void guillotine(double d, double d2, double d3, double d4) throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null) {
            double[] dArray = new double[4];
            float[] fArray = new float[6];
            dArray[0] = d;
            dArray[1] = d2;
            dArray[2] = d3;
            dArray[3] = d4;
            if (this.m_worldCtm != null) {
                this.m_worldCtm.transform(dArray, 0, dArray, 0, 2);
            }
            this.m_ctm.transform(dArray, 0, fArray, 0, 2);
            double d5 = this.getResolution();
            d = Math.min(fArray[0], fArray[2]);
            d2 = Math.min(fArray[1], fArray[3]);
            d3 = Math.max(fArray[0], fArray[2]);
            d4 = Math.max(fArray[1], fArray[3]);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
            if (geometricPath.getLineToCount() == 0 && geometricPath.getMoveToCount() > 0) {
                ArrayList<Point2D> arrayList = geometricPath.getMoveTos();
                ArrayList<Double> arrayList2 = geometricPath.getMoveToRotations();
                this.m_path = new GeometricPath();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Point2D.Float float_ = (Point2D.Float)arrayList.get(i);
                    if (double_.outcode(float_) != 0) continue;
                    Double d6 = arrayList2.get(i);
                    this.m_path.moveTo(float_.x, float_.y, d6);
                }
                return;
            }
            GeneralPath generalPath = geometricPath.getShape();
            Rectangle2D rectangle2D = generalPath.getBounds2D();
            if (double_.contains(rectangle2D)) {
                return;
            }
            if (!double_.intersects(rectangle2D)) {
                this.m_path = new GeometricPath();
                return;
            }
            GeneralPath generalPath2 = SutherlandHodgman.clip(generalPath, double_, d5);
            if (this.m_path == geometricPath) {
                this.m_path.reset();
            } else {
                this.m_path = new GeometricPath();
            }
            float[] fArray2 = fArray;
            PathIterator pathIterator = generalPath2.getPathIterator(Constants.IDENTITY_MATRIX);
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(fArray2);
                if (n == 0) {
                    this.m_path.moveTo(fArray2[0], fArray2[1], 0.0);
                } else if (n == 1) {
                    this.m_path.lineTo(fArray2[0], fArray2[1]);
                } else if (n == 4) {
                    this.m_path.closePath();
                }
                pathIterator.next();
            }
        }
    }

    public void setPageMask(double d, double d2, double d3, double d4, int n) throws MapyrusException {
        double[] dArray = new double[4];
        float[] fArray = new float[6];
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
        if (this.m_worldCtm != null) {
            this.m_worldCtm.transform(dArray, 0, dArray, 0, 2);
        }
        this.m_ctm.transform(dArray, 0, fArray, 0, 2);
        if (this.m_outputFormat != null) {
            PageMask pageMask = this.m_outputFormat.getPageMask();
            pageMask.setValue(Math.round(fArray[0]), Math.round(fArray[1]), Math.round(fArray[2]), Math.round(fArray[3]), n);
        }
    }

    public void setPageMask(Argument argument, int n) throws MapyrusException {
        if (this.m_outputFormat != null) {
            PageMask pageMask = this.m_outputFormat.getPageMask();
            GeometricPath geometricPath = new GeometricPath();
            double[] dArray = argument.getGeometryValue();
            this.addGeometryToPath(dArray, 0, geometricPath);
            pageMask.setValue(geometricPath.getShape(), n);
        }
    }

    public void setPageMask(int n) throws MapyrusException {
        GeometricPath geometricPath;
        if (this.m_outputFormat != null && (geometricPath = this.getDefinedPath()) != null) {
            PageMask pageMask = this.m_outputFormat.getPageMask();
            pageMask.setValue(geometricPath.getShape(), n);
        }
    }

    public boolean isPageMaskAllZero(double d, double d2, double d3, double d4) throws MapyrusException {
        boolean bl = true;
        if (this.m_outputFormat != null) {
            double[] dArray = new double[4];
            float[] fArray = new float[4];
            dArray[0] = d;
            dArray[1] = d2;
            dArray[2] = d3;
            dArray[3] = d4;
            if (this.m_worldCtm != null) {
                this.m_worldCtm.transform(dArray, 0, dArray, 0, 2);
            }
            this.m_ctm.transform(dArray, 0, fArray, 0, 2);
            PageMask pageMask = this.m_outputFormat.getPageMask();
            bl = pageMask.isAllZero(Math.round(fArray[0]), Math.round(fArray[1]), Math.round(fArray[2]), Math.round(fArray[3]));
        }
        return bl;
    }

    private int addGeometryToPath(double[] dArray, int n, GeometricPath geometricPath) throws MapyrusException {
        double[] dArray2 = new double[2];
        float[] fArray = new float[2];
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        n += 2;
        switch (n2) {
            case 100: 
            case 101: 
            case 102: {
                for (int i = 0; i < n3; ++i) {
                    dArray2[0] = dArray[n + 1];
                    dArray2[1] = dArray[n + 2];
                    if (this.m_worldCtm != null) {
                        this.m_worldCtm.transform(dArray2, 0, dArray2, 0, 1);
                    }
                    this.m_ctm.transform(dArray2, 0, fArray, 0, 1);
                    if (dArray[n] == 0.0) {
                        geometricPath.moveTo(fArray[0], fArray[1], 0.0);
                    } else {
                        geometricPath.lineTo(fArray[0], fArray[1]);
                    }
                    n += 3;
                }
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                for (int i = 0; i < n3; ++i) {
                    n = this.addGeometryToPath(dArray, n, geometricPath);
                }
                break;
            }
        }
        return n;
    }

    public boolean isPageMaskAllZero(Argument argument) throws MapyrusException {
        boolean bl = true;
        if (this.m_outputFormat != null) {
            double[] dArray = argument.getGeometryValue();
            GeometricPath geometricPath = new GeometricPath();
            this.addGeometryToPath(dArray, 0, geometricPath);
            PageMask pageMask = this.m_outputFormat.getPageMask();
            bl = pageMask.isAllZero(geometricPath.getShape());
        }
        return bl;
    }

    public boolean isPageMaskAllZero() throws MapyrusException {
        boolean bl = true;
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null) {
            PageMask pageMask = this.m_outputFormat.getPageMask();
            bl = pageMask.isAllZero(geometricPath.getShape());
        }
        return bl;
    }

    public void translatePath(double d, double d2) {
        GeometricPath geometricPath = this.getDefinedPath();
        double[] dArray = new double[]{d, d2};
        if (!this.m_ctm.isIdentity()) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.m_rotation);
            affineTransform.scale(this.m_scaling, this.m_scaling);
            affineTransform.transform(dArray, 0, dArray, 0, 1);
        }
        if (geometricPath != null) {
            this.m_path = geometricPath.translatePath(dArray[0], dArray[1]);
        }
    }

    public void parallelPath(double[] dArray) throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        double d = this.getResolution();
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * this.m_scaling;
        }
        if (geometricPath != null) {
            this.m_path = geometricPath.parallelPath(dArray, d);
        }
    }

    public void selectPath(double[] dArray, double[] dArray2) throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        double d = this.getResolution();
        if (geometricPath != null) {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n;
                dArray[n2] = dArray[n2] * this.m_scaling;
                int n3 = n++;
                dArray2[n3] = dArray2[n3] * this.m_scaling;
            }
            this.m_path = geometricPath.selectPath(dArray, dArray2, d);
        }
    }

    public void reversePath() throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        double d = this.getResolution();
        if (geometricPath != null) {
            this.m_path = geometricPath.reversePath(d);
        }
    }

    public void drawIcon(BufferedImage bufferedImage, double d) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.setGraphicsAttributes(32);
            this.m_outputFormat.drawIcon(geometricPath.getMoveTos(), bufferedImage, d, this.m_rotation, this.m_scaling);
        }
    }

    public void drawGeoImage(String string, String string2, Throttle throttle) throws IOException, MapyrusException {
        BufferedImage bufferedImage;
        GeoImageBoundingBox geoImageBoundingBox;
        Object object;
        Object object2;
        Object object3;
        Rectangle2D.Double double_ = this.m_pageWorldExtents;
        if (double_ == null) {
            double_ = this.getWorldExtents();
        }
        boolean bl = false;
        URL uRL = null;
        GeometricPath geometricPath = null;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        MapyrusExternalImage mapyrusExternalImage = null;
        while (stringTokenizer.hasMoreTokens()) {
            object3 = stringTokenizer.nextToken();
            if (((String)object3).startsWith("clipfile=")) {
                object2 = ((String)object3).substring(9);
                object = new ImageClippingFile((String)object2, this.m_worldCtm);
                geometricPath = ((ImageClippingFile)object).getClippingPolygon();
                continue;
            }
            if (((String)object3).startsWith("hue=")) {
                object2 = ((String)object3).substring(4);
                try {
                    f = Float.parseFloat((String)object2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidnumber") + ": " + (String)object2);
                }
            }
            if (((String)object3).startsWith("saturation=")) {
                object2 = ((String)object3).substring(11);
                try {
                    f2 = Float.parseFloat((String)object2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidnumber") + ": " + (String)object2);
                }
            }
            if (((String)object3).startsWith("brightness=")) {
                object2 = ((String)object3).substring(11);
                try {
                    f3 = Float.parseFloat((String)object2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidnumber") + ": " + (String)object2);
                }
            }
            if (!((String)object3).startsWith("readerclass=")) continue;
            object2 = ((String)object3).substring(12);
            mapyrusExternalImage = new MapyrusExternalImage((String)object2, string, string2);
        }
        if (mapyrusExternalImage == null) {
            try {
                uRL = new URL(string);
                object3 = uRL.getQuery();
                if (object3 != null) {
                    bl = ((String)object3).toUpperCase().indexOf("REQUEST=GETMAP") >= 0;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((geoImageBoundingBox = m_imageBoundsCache.get(string)) != null && !geoImageBoundingBox.getBounds().intersects(double_)) {
            return;
        }
        if (uRL != null) {
            try {
                bufferedImage = ImageIOWrapper.read(uRL, this.getColor());
            }
            catch (IOException iOException) {
                throw new MapyrusException(MapyrusMessages.get("cannotopenurl") + ": " + uRL + Constants.LINE_SEPARATOR + iOException.getMessage());
            }
        } else {
            bufferedImage = mapyrusExternalImage != null ? mapyrusExternalImage.read() : ImageIOWrapper.read(new File(string), this.getColor());
        }
        if (bufferedImage == null) {
            throw new MapyrusException(MapyrusMessages.get("invalidformat") + ": " + string);
        }
        if (geoImageBoundingBox == null) {
            geoImageBoundingBox = bl ? new WMSRequestBoundingBox(uRL) : (mapyrusExternalImage != null ? mapyrusExternalImage : new TFWFile(string, bufferedImage));
            if (!bl && mapyrusExternalImage == null) {
                m_imageBoundsCache.put(string, geoImageBoundingBox);
            }
        }
        object3 = geoImageBoundingBox.getBounds();
        object2 = new double[4];
        object = this.m_path;
        ArrayList<GeometricPath> arrayList = this.m_clippingPaths != null ? new ArrayList<GeometricPath>(this.m_clippingPaths) : null;
        if (geometricPath != null) {
            this.m_outputFormat.saveState();
            this.m_path = geometricPath;
            this.clipInside();
        }
        this.setGraphicsAttributes(32);
        if (double_.getBounds().contains((Rectangle2D)object3)) {
            object2[0] = ((RectangularShape)object3).getMinX();
            object2[1] = ((RectangularShape)object3).getMinY();
            object2[2] = ((RectangularShape)object3).getMaxX();
            object2[3] = ((RectangularShape)object3).getMaxY();
            if (this.m_worldCtm != null) {
                this.m_worldCtm.transform((double[])object2, 0, (double[])object2, 0, 2);
            }
            if (f != 1.0f || f2 != 1.0f || f3 != 1.0f) {
                ImageFilter.filter(bufferedImage, f, f2, f3, throttle);
            }
            this.m_outputFormat.drawGeoImage(bufferedImage, (double)object2[0], (double)object2[1], (double)(object2[2] - object2[0]), (double)(object2[3] - object2[1]));
        } else if (double_.intersects((Rectangle2D)object3)) {
            double d = (double_.getMinX() - ((RectangularShape)object3).getMinX()) / ((RectangularShape)object3).getWidth();
            double d2 = (double_.getMinY() - ((RectangularShape)object3).getMinY()) / ((RectangularShape)object3).getHeight();
            double d3 = (double_.getMaxX() - ((RectangularShape)object3).getMinX()) / ((RectangularShape)object3).getWidth();
            double d4 = (double_.getMaxY() - ((RectangularShape)object3).getMinY()) / ((RectangularShape)object3).getHeight();
            if (d > 1.0) {
                d = 1.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            if (d2 > 1.0) {
                d2 = 1.0;
            } else if (d2 < 0.0) {
                d2 = 0.0;
            }
            if (d3 > 1.0) {
                d3 = 1.0;
            } else if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d4 > 1.0) {
                d4 = 1.0;
            } else if (d4 < 0.0) {
                d4 = 0.0;
            }
            double d5 = ((RectangularShape)object3).getMinX() + ((RectangularShape)object3).getWidth() * d;
            double d6 = (double)bufferedImage.getWidth() * d;
            double d7 = ((RectangularShape)object3).getMinY() + ((RectangularShape)object3).getHeight() * d2;
            double d8 = (double)bufferedImage.getHeight() * d2;
            double d9 = ((RectangularShape)object3).getMinX() + ((RectangularShape)object3).getWidth() * d3;
            double d10 = (double)bufferedImage.getWidth() * d3;
            double d11 = ((RectangularShape)object3).getMinY() + ((RectangularShape)object3).getHeight() * d4;
            double d12 = (double)bufferedImage.getHeight() * d4;
            object2[0] = d5;
            object2[1] = d7;
            object2[2] = d9;
            object2[3] = d11;
            if (this.m_worldCtm != null) {
                this.m_worldCtm.transform((double[])object2, 0, (double[])object2, 0, 2);
            }
            int n = (int)Math.round(d10 - d6);
            int n2 = (int)Math.round(d12 - d8);
            double d13 = (double)bufferedImage.getHeight() - d12;
            int n3 = (int)Math.round(d6);
            int n4 = (int)Math.round(d13);
            int n5 = Math.max(n, 1);
            int n6 = Math.max(1, n2);
            if (n3 + n5 > bufferedImage.getWidth()) {
                --n3;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 + n6 > bufferedImage.getHeight()) {
                --n4;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            bufferedImage = bufferedImage.getSubimage(n3, n4, n5, n6);
            if (f != 1.0f || f2 != 1.0f || f3 != 1.0f) {
                ImageFilter.filter(bufferedImage, f, f2, f3, throttle);
            }
            this.m_outputFormat.drawGeoImage(bufferedImage, (double)object2[0], (double)object2[1], (double)(object2[2] - object2[0]), (double)(object2[3] - object2[1]));
        }
        if (geometricPath != null) {
            this.m_path = object;
            this.m_clippingPaths = arrayList;
            if (!this.m_outputFormat.restoreState()) {
                this.m_attributesChanged |= 0x20;
                this.m_attributesPending |= 0x20;
            }
        }
    }

    public void drawEPS(String string, double d) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.setGraphicsAttributes(32);
            this.m_outputFormat.drawEPS(geometricPath.getMoveTos(), string, d, this.m_rotation, this.m_scaling);
        }
    }

    public void drawSVG(String string, double d) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.setGraphicsAttributes(32);
            this.m_outputFormat.drawSVG(geometricPath.getMoveTos(), string, d, this.m_rotation, this.m_scaling);
        }
    }

    public void addSVGCode(String string) throws IOException, MapyrusException {
        this.m_outputFormat.addSVGCode(string);
    }

    public void drawPDF(String string, int n, double d) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.setGraphicsAttributes(32);
            this.m_outputFormat.drawPDF(geometricPath.getMoveTos(), string, n, d, this.m_rotation, this.m_scaling);
        }
    }

    public void beginPDFGroup(String string) {
        if (this.m_outputFormat != null) {
            this.m_outputFormat.beginPDFGroup(string);
        }
    }

    public void endPDFGroup() throws MapyrusException {
        if (this.m_outputFormat != null) {
            this.m_outputFormat.endPDFGroup();
        }
    }

    public void stroke(String string) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.setGraphicsAttributes(60);
            this.m_outputFormat.stroke(geometricPath.getShape(), string);
        }
    }

    public void fill(String string) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.setGraphicsAttributes(44);
            this.m_outputFormat.fill(geometricPath.getShape(), string);
        }
    }

    public void gradientFill(Color color, Color color2, Color color3, Color color4, Color color5) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            if (this.m_outputFormat.getPageFormat().equals("svg")) {
                boolean bl = color.equals(color2);
                if (bl) {
                    this.m_outputFormat.gradientFill(geometricPath.getShape(), bl, color, color3);
                } else {
                    this.m_outputFormat.gradientFill(geometricPath.getShape(), bl, color, color2);
                }
            } else {
                Rectangle2D rectangle2D = geometricPath.getBounds2D();
                this.m_outputFormat.saveState();
                if (this.m_clippingPaths == null) {
                    this.m_clippingPaths = new ArrayList();
                }
                ArrayList<GeometricPath> arrayList = new ArrayList<GeometricPath>(this.m_clippingPaths);
                this.clipInside();
                this.setGraphicsAttributes(32);
                BufferedImage bufferedImage = GradientFillFactory.getImage(color, color2, color3, color4, color5);
                ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
                arrayList2.add(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()));
                this.m_outputFormat.drawIcon(arrayList2, bufferedImage, Math.max(rectangle2D.getWidth(), rectangle2D.getHeight()), 0.0, 1.0);
                this.m_clippingPaths = arrayList;
                this.m_outputFormat.setClipAttribute(this.m_clippingPaths);
                this.m_outputFormat.restoreState();
            }
        }
    }

    public void setEventScript(String string) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.m_outputFormat.setEventScript(geometricPath.getShape(), string);
        }
    }

    public void clipOutside() throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            float f = (float)this.m_outputFormat.getPageWidth();
            float f2 = (float)this.m_outputFormat.getPageHeight();
            GeometricPath geometricPath2 = new GeometricPath();
            geometricPath2.moveTo(0.0f, 0.0f, 0.0);
            if (geometricPath.isClockwise(this.getResolution())) {
                geometricPath2.lineTo(f, 0.0f);
                geometricPath2.lineTo(f, f2);
                geometricPath2.lineTo(0.0f, f2);
            } else {
                geometricPath2.lineTo(0.0f, f2);
                geometricPath2.lineTo(f, f2);
                geometricPath2.lineTo(f, 0.0f);
            }
            geometricPath2.closePath();
            geometricPath2.append(geometricPath, false);
            this.m_attributesPending |= 0x20;
            this.m_attributesChanged |= 0x20;
            this.m_outputFormat.clip(geometricPath2.getShape());
            if (this.m_clippingPaths == null) {
                this.m_clippingPaths = new ArrayList();
            }
            this.m_clippingPaths.add(geometricPath2);
        }
    }

    public void clipInside() {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            GeometricPath geometricPath2 = new GeometricPath(geometricPath);
            if (this.m_clippingPaths == null) {
                this.m_clippingPaths = new ArrayList();
            }
            this.m_clippingPaths.add(geometricPath2);
            this.m_attributesPending |= 0x20;
            this.m_attributesChanged |= 0x20;
            if (this.m_outputFormat != null) {
                this.m_outputFormat.clip(geometricPath2.getShape());
            }
        }
    }

    public void label(String string) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && this.m_outputFormat != null) {
            this.setGraphicsAttributes(47);
            this.m_outputFormat.label(geometricPath.getMoveTos(), string);
        }
    }

    public void flowLabel(double d, double d2, boolean bl, String string) throws IOException, MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null && geometricPath.getMoveToCount() > 0 && this.m_outputFormat != null) {
            int n;
            int n2;
            int n3;
            int n4;
            Point2D.Double double_;
            Point2D.Double double_2;
            ArrayList<Point2D> arrayList;
            d *= this.m_scaling;
            d2 *= this.m_scaling;
            int n5 = string.length();
            String[] stringArray = new String[n5];
            double[] dArray = new double[n5];
            double d3 = 0.0;
            for (int i = 0; i < n5; ++i) {
                if (i > 0) {
                    d3 += d;
                }
                stringArray[i] = string.substring(i, i + 1);
                dArray[i] = this.getStringDimension(stringArray[i], false).getWidth();
                d3 += dArray[i];
            }
            if ((this.m_justify & 4) != 0) {
                d2 -= d3;
            }
            if ((this.m_justify & 2) != 0) {
                d2 -= d3 / 2.0;
            }
            if ((arrayList = geometricPath.getSubPathPoints(d2, d3)).isEmpty()) {
                Point2D.Float float_ = (Point2D.Float)geometricPath.getMoveTos().get(0);
                double_2 = new Point2D.Double(float_.getX(), float_.getY());
                double_ = new Point2D.Double(double_2.x + Math.cos(this.m_rotation) * d3, double_2.y + Math.sin(this.m_rotation) * d3);
                arrayList.add(double_2);
                arrayList.add(double_);
            }
            double_2 = (Point2D.Double)arrayList.get(0);
            double_ = (Point2D.Double)arrayList.get(arrayList.size() - 1);
            double d4 = Math.atan2(double_.y - double_2.y, double_.x - double_2.x);
            if (bl && double_2.distanceSq(double_) > 0.0 && Math.abs(d4 + this.m_rotation) > 1.5707963267948966) {
                n4 = arrayList.size() - 1;
                n3 = 0;
                n2 = -1;
                n = 9;
            } else {
                n4 = 0;
                n3 = arrayList.size() - 1;
                n2 = 1;
                n = 33;
            }
            int n6 = 0;
            ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
            d2 = 0.0;
            while (n6 < n5 && n4 != n3) {
                boolean bl2;
                double_2 = (Point2D.Double)arrayList.get(n4);
                double_ = (Point2D.Double)arrayList.get(n4 + n2);
                double d5 = double_.x - double_2.x;
                double d6 = double_.y - double_2.y;
                double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                d4 = Math.atan2(d6, d5);
                double d8 = Math.cos(d4);
                double d9 = Math.sin(d4);
                this.addFontRotation(d4);
                int n7 = this.setJustify(n);
                this.setGraphicsAttributes(47);
                boolean bl3 = bl2 = n4 + n2 == n3;
                while (n6 < n5 && (d2 + dArray[n6] / 2.0 < d7 || bl2)) {
                    double d10 = double_2.x + d2 * d8;
                    double d11 = double_2.y + d2 * d9;
                    arrayList2.clear();
                    arrayList2.add(new Point2D.Double(d10, d11));
                    this.m_outputFormat.label(arrayList2, stringArray[n6]);
                    d2 += dArray[n6] + d;
                    ++n6;
                }
                d2 -= d7;
                n4 += n2;
                this.addFontRotation(-d4);
                this.setJustify(n7);
            }
        }
    }

    public void drawTable(String string, ArrayList<Argument> arrayList) throws IOException, MapyrusException {
        int n;
        Object object;
        Object object2;
        Object object3;
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath == null || this.m_outputFormat == null) {
            return;
        }
        double[] dArray = null;
        double d = this.getStringDimension("X", false).getHeight();
        double d2 = d / 4.0;
        Object[] objectArray = null;
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        boolean bl = true;
        double[] dArray2 = null;
        int n2 = -1;
        int n3 = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2;
            object3 = stringTokenizer.nextToken();
            if (((String)object3).startsWith("background=")) {
                object2 = ((String)object3).substring(11);
                stringTokenizer2 = new StringTokenizer((String)object2, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string2 = stringTokenizer2.nextToken();
                    object = ColorDatabase.getColor(string2, 255, this.getColor());
                    if (object == null) {
                        throw new MapyrusException(MapyrusMessages.get("colornotfound") + ": " + string2);
                    }
                    arrayList2.add((Color)object);
                }
                continue;
            }
            if (((String)object3).startsWith("borders=")) {
                object2 = ((String)object3).substring(8);
                bl = ((String)object2).equalsIgnoreCase("true");
                continue;
            }
            if (((String)object3).startsWith("justify=")) {
                object2 = ((String)object3).substring(8);
                stringTokenizer2 = new StringTokenizer((String)object2, ",");
                dArray2 = new double[arrayList.size()];
                for (int i = 0; stringTokenizer2.hasMoreTokens() && i < arrayList.size(); ++i) {
                    object = stringTokenizer2.nextToken().toLowerCase();
                    double d3 = 0.0;
                    if (((String)object).equals("right")) {
                        d3 = 1.0;
                    } else if (((String)object).equals("center") || ((String)object).equals("centre")) {
                        d3 = 0.5;
                    }
                    dArray2[i] = d3;
                }
                continue;
            }
            if (((String)object3).startsWith("sortcolumn=")) {
                object2 = ((String)object3).substring(11);
                try {
                    n2 = Integer.parseInt((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidcolumn") + ": " + (String)object2);
                }
                if (n2 >= 1 && n2 <= arrayList.size()) continue;
                throw new MapyrusException(MapyrusMessages.get("invalidcolumn") + ": " + (String)object2);
            }
            if (!((String)object3).startsWith("sortorder=") || !((String)(object3 = ((String)object3).substring(10))).startsWith("desc")) continue;
            n3 = -1;
        }
        if (n2 < 0) {
            objectArray = arrayList.get(0).getHashMapKeys();
        } else {
            object3 = arrayList.get(n2 - 1);
            objectArray = ((Argument)object3).getHashMapKeysSortedByValue();
            if (n3 < 0) {
                object2 = new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    object2[i] = objectArray[objectArray.length - i - 1];
                }
                objectArray = object2;
            }
        }
        dArray = new double[objectArray.length];
        Arrays.fill(dArray, d);
        double[] dArray3 = new double[arrayList.size()];
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = 0.0;
            object2 = arrayList.get(n);
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = ((Argument)object2).getHashMapEntry(objectArray[i].toString()).toString();
                object = this.getStringDimension(string3, false);
                if (((StringDimension)object).getWidth() > dArray3[n]) {
                    dArray3[n] = ((StringDimension)object).getWidth();
                }
                if (!(((StringDimension)object).getHeight() > dArray[i])) continue;
                dArray[i] = ((StringDimension)object).getHeight();
            }
        }
        this.m_outputFormat.saveState();
        n = this.setJustify(9);
        int n4 = 63;
        this.setGraphicsAttributes(n4);
        ArrayList<Point2D> arrayList3 = geometricPath.getMoveTos();
        for (int i = 0; i < arrayList3.size(); ++i) {
            object = (Point2D.Float)arrayList3.get(i);
            Point2D.Float float_ = (Point2D.Float)((Point2D)object).clone();
            for (int j = 0; j < arrayList.size(); ++j) {
                float_.y = ((Point2D.Float)object).y;
                double d4 = dArray3[j] / 20.0;
                if (d4 < 1.0) {
                    d4 = 1.0;
                }
                if (d4 > 20.0) {
                    d4 = 20.0;
                }
                if (dArray2 != null) {
                    if (dArray2[j] == 1.0) {
                        this.setJustify(12);
                    } else if (dArray2[j] == 0.0) {
                        this.setJustify(9);
                    } else {
                        this.setJustify(10);
                    }
                    this.setGraphicsAttributes(2);
                }
                Argument argument = arrayList.get(j);
                for (int k = 0; k < objectArray.length; ++k) {
                    Serializable serializable;
                    GeometricPath geometricPath2 = new GeometricPath();
                    float f = float_.x;
                    float f2 = (float)((double)float_.y - d2 - dArray[k] - d2);
                    float f3 = (float)((double)f + d4 + dArray3[j] + d4);
                    float f4 = float_.y;
                    geometricPath2.moveTo(f, f2, 0.0);
                    geometricPath2.lineTo(f, f4);
                    geometricPath2.lineTo(f3, f4);
                    geometricPath2.lineTo(f3, f2);
                    geometricPath2.closePath();
                    if (!arrayList2.isEmpty()) {
                        this.m_outputFormat.saveState();
                        int n5 = k * arrayList.size() + j;
                        serializable = (Color)arrayList2.get(n5 % arrayList2.size());
                        this.m_outputFormat.setColorAttribute((Color)serializable);
                        this.m_outputFormat.fill(geometricPath2.getShape(), null);
                        this.m_outputFormat.restoreState();
                        this.m_attributesChanged |= 4;
                        this.m_attributesPending |= 4;
                        this.setGraphicsAttributes(4);
                    }
                    if (bl) {
                        this.m_outputFormat.stroke(geometricPath2.getShape(), null);
                    }
                    String string4 = argument.getHashMapEntry(objectArray[k].toString()).toString();
                    serializable = new Point2D.Float();
                    serializable.x = (float)((double)float_.x + d4);
                    serializable.y = (float)((double)float_.y - d2);
                    if (dArray2 != null) {
                        serializable.x = (float)((double)serializable.x + dArray2[j] * dArray3[j]);
                    }
                    ArrayList<Point2D> arrayList4 = new ArrayList<Point2D>();
                    arrayList4.add((Point2D)((Object)serializable));
                    this.m_outputFormat.label(arrayList4, string4);
                    float_.y = (float)((double)float_.y - (d2 + dArray[k] + d2));
                }
                float_.x = (float)((double)float_.x + (d4 + dArray3[j] + d4));
            }
        }
        this.m_outputFormat.restoreState();
        this.setJustify(n);
        this.m_attributesChanged |= n4;
        this.m_attributesPending |= n4;
    }

    public void drawTree(String string, Argument argument) throws IOException, MapyrusException {
        Object[] objectArray;
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath == null || this.m_outputFormat == null) {
            return;
        }
        StringDimension stringDimension = this.getStringDimension("X", false);
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            if (!objectArray.startsWith("delimiter=")) continue;
            string2 = objectArray.substring(10);
        }
        objectArray = argument.getHashMapKeys();
        this.m_outputFormat.saveState();
        int n = this.setJustify(9);
        int n2 = 63;
        this.setGraphicsAttributes(n2);
        ArrayList<Point2D> arrayList = geometricPath.getMoveTos();
        for (int i = 0; i < arrayList.size(); ++i) {
            Point2D.Float float_ = (Point2D.Float)arrayList.get(i);
            Point2D.Float float_2 = (Point2D.Float)float_.clone();
            LinkedList linkedList = new LinkedList();
            LinkedList<Float> linkedList2 = new LinkedList<Float>();
            for (int j = 0; j < objectArray.length; ++j) {
                String string3;
                String string4;
                String string5 = argument.getHashMapEntry(objectArray[j].toString()).getStringValue();
                stringTokenizer = string2 == null ? new StringTokenizer(string5) : new StringTokenizer(string5, string2);
                LinkedList<String> linkedList3 = new LinkedList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    linkedList3.add(stringTokenizer.nextToken());
                }
                int n3 = 0;
                ListIterator listIterator = linkedList3.listIterator();
                ListIterator listIterator2 = linkedList.listIterator();
                while (listIterator.hasNext() && listIterator2.hasNext() && (string4 = (String)listIterator.next()).equals(string3 = (String)listIterator2.next())) {
                    ++n3;
                }
                for (int k = n3; k < linkedList3.size(); ++k) {
                    string3 = (String)linkedList3.get(k);
                    GeometricPath geometricPath2 = new GeometricPath();
                    float f = (float)((double)float_2.x + stringDimension.getWidth() * (double)k - stringDimension.getWidth() / 2.0);
                    float f2 = (float)((double)float_2.y - stringDimension.getHeight() / 5.0);
                    float f3 = (float)((double)f + stringDimension.getWidth() / 2.0);
                    float f4 = (float)((double)f2 - stringDimension.getHeight() / 2.0);
                    if (k < linkedList2.size()) {
                        f2 = ((Float)linkedList2.get(k)).floatValue();
                        int n4 = linkedList2.size() - k;
                        while (n4-- > 0) {
                            linkedList2.removeLast();
                        }
                    }
                    geometricPath2.moveTo(f, f2, 0.0);
                    geometricPath2.lineTo(f, f4);
                    geometricPath2.lineTo(f3, f4);
                    if (k > 0) {
                        this.m_outputFormat.stroke(geometricPath2.getShape(), null);
                    }
                    Point2D.Float float_3 = new Point2D.Float();
                    float_3.x = (float)((double)float_2.x + stringDimension.getWidth() * (double)k);
                    if (k > 0) {
                        float_3.x = (float)((double)float_3.x + stringDimension.getWidth() / 5.0);
                    }
                    float_3.y = float_2.y;
                    ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
                    arrayList2.add(float_3);
                    this.m_outputFormat.label(arrayList2, string3);
                    StringDimension stringDimension2 = this.getStringDimension(string3, false);
                    float_2.y = (float)((double)float_2.y - Math.max(stringDimension2.getHeight(), stringDimension.getHeight()));
                    linkedList2.add(k, new Float(f4));
                }
                linkedList = linkedList3;
            }
        }
        this.m_outputFormat.restoreState();
        this.setJustify(n);
        this.m_attributesChanged |= n2;
        this.m_attributesPending |= n2;
    }

    public int getMoveToCount() {
        GeometricPath geometricPath = this.getDefinedPath();
        int n = geometricPath == null ? 0 : geometricPath.getMoveToCount();
        return n;
    }

    public int getLineToCount() {
        GeometricPath geometricPath = this.getDefinedPath();
        int n = geometricPath == null ? 0 : geometricPath.getLineToCount();
        return n;
    }

    public double getPathLength() throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        double d = this.getResolution();
        double d2 = geometricPath == null ? 0.0 : geometricPath.getLength(d);
        return d2;
    }

    public double getPathArea() throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        double d = this.getResolution();
        double d2 = geometricPath == null ? 0.0 : geometricPath.getArea(d);
        return d2;
    }

    public Point2D.Double getPathCentroid() throws MapyrusException {
        GeometricPath geometricPath = this.getDefinedPath();
        double d = this.getResolution();
        Point2D.Double double_ = geometricPath == null ? new Point2D.Double() : geometricPath.getCentroid(d);
        return double_;
    }

    public double getPathStartAngle() throws MapyrusException {
        double d = 0.0;
        GeometricPath geometricPath = this.getDefinedPath();
        double d2 = this.getResolution();
        if (geometricPath != null) {
            d = geometricPath.getStartAngle(d2);
        }
        return d;
    }

    public double getPathEndAngle() throws MapyrusException {
        double d = 0.0;
        GeometricPath geometricPath = this.getDefinedPath();
        double d2 = this.getResolution();
        if (geometricPath != null) {
            d = geometricPath.getEndAngle(d2);
        }
        return d;
    }

    public Point2D getPathStartPoint() throws MapyrusException {
        Point2D point2D = null;
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null) {
            point2D = geometricPath.getStartPoint();
        }
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        return point2D;
    }

    public Point2D getPathEndPoint() throws MapyrusException {
        Point2D point2D = null;
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null) {
            point2D = geometricPath.getEndPoint();
        }
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        return point2D;
    }

    public ArrayList<Double> getMoveToRotations() {
        GeometricPath geometricPath = this.getDefinedPath();
        ArrayList<Double> arrayList = geometricPath == null ? null : geometricPath.getMoveToRotations();
        return arrayList;
    }

    public ArrayList<Point2D> getMoveTos() throws MapyrusException {
        ArrayList<Point2D> arrayList = null;
        GeometricPath geometricPath = this.getDefinedPath();
        try {
            if (geometricPath != null) {
                if (this.m_ctm.isIdentity()) {
                    arrayList = geometricPath.getMoveTos();
                } else {
                    AffineTransform affineTransform = this.m_ctm.createInverse();
                    ArrayList<Point2D> arrayList2 = geometricPath.getMoveTos();
                    arrayList = new ArrayList(arrayList2.size());
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        Point2D.Float float_ = (Point2D.Float)arrayList2.get(i);
                        arrayList.add(affineTransform.transform(float_, null));
                    }
                }
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new MapyrusException(noninvertibleTransformException.getMessage());
        }
        return arrayList;
    }

    public Rectangle2D getBounds2D() {
        GeometricPath geometricPath = this.getDefinedPath();
        Rectangle2D rectangle2D = geometricPath == null ? null : geometricPath.getBounds2D();
        return rectangle2D;
    }

    public Argument getPathArgument() throws MapyrusException {
        Argument argument = Argument.emptyGeometry;
        GeometricPath geometricPath = this.getDefinedPath();
        if (geometricPath != null) {
            argument = geometricPath.toArgument(this.getResolution());
        }
        return argument;
    }

    public Argument getVariableValue(String string) {
        Argument argument = this.m_vars == null ? null : this.m_vars.get(string);
        return argument;
    }

    public void setLocalScope(String string) {
        if (this.m_localVars == null) {
            this.m_localVars = new HashSet();
        }
        this.m_localVars.add(string);
    }

    public boolean hasLocalScope(String string) {
        return this.m_localVars != null && this.m_localVars.contains(string);
    }

    public void defineVariable(String string, Argument argument) {
        if (this.m_vars == null) {
            this.m_vars = new HashMap();
        }
        if (argument.getType() == 2) {
            argument = (Argument)argument.clone();
        }
        this.m_vars.put(string, argument);
    }

    public void defineHashMapEntry(String string, String string2, Argument argument) {
        Argument argument2;
        if (this.m_vars == null) {
            this.m_vars = new HashMap();
        }
        if ((argument2 = this.m_vars.get(string)) == null || argument2.getType() != 2) {
            argument2 = new Argument();
            this.m_vars.put(string, argument2);
        }
        argument2.addHashMapEntry(string2, argument);
    }

    public StringDimension getStringDimension(String string, boolean bl) throws IOException, MapyrusException {
        StringDimension stringDimension;
        if (this.m_outputFormat != null) {
            this.setGraphicsAttributes(1);
            stringDimension = this.m_outputFormat.getStringDimension(string, this.m_fontName, this.m_fontSize, this.m_fontLineSpacing);
            double d = stringDimension.getWidth();
            double d2 = stringDimension.getHeight();
            double d3 = stringDimension.getAscent();
            double d4 = stringDimension.getDescent();
            if (this.m_pageWorldExtents != null && bl) {
                d = d / this.m_outputFormat.getPageWidth() * this.m_pageWorldExtents.getWidth();
                d2 = d2 / this.m_outputFormat.getPageHeight() * this.m_pageWorldExtents.getHeight();
                d3 = d3 / this.m_outputFormat.getPageHeight() * this.m_pageWorldExtents.getHeight();
                d4 = d4 / this.m_outputFormat.getPageHeight() * this.m_pageWorldExtents.getHeight();
            }
            stringDimension.setSize(d /= this.m_scaling, d2 /= this.m_scaling, d3 /= this.m_scaling, d4 /= this.m_scaling);
        } else {
            stringDimension = new StringDimension();
        }
        return stringDimension;
    }
}

