/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.geom.Geometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalDataset
implements GeographicDataset {
    private String m_filename;
    private LineNumberReader m_reader;
    private String[] m_fieldNames;
    private Rectangle2D.Double m_queryExtents;

    public InternalDataset(String string, String string2) throws MapyrusException, IOException {
        StringTokenizer stringTokenizer;
        URL uRL = this.getClass().getResource(string + ".txt");
        if (uRL == null) {
            throw new MapyrusException(MapyrusMessages.get("opendataseterror") + ": " + string);
        }
        this.m_reader = new LineNumberReader(new InputStreamReader(uRL.openStream()));
        this.m_filename = string;
        String string3 = this.m_reader.readLine();
        if (string3 != null) {
            int n = string3.indexOf(35);
            if (n >= 0) {
                string3 = string3.substring(n + 1);
            }
            stringTokenizer = new StringTokenizer(string3);
            int n2 = stringTokenizer.countTokens();
            this.m_fieldNames = new String[n2 + 1];
            this.m_fieldNames[0] = "GEOMETRY";
            for (int i = 0; i < n2; ++i) {
                this.m_fieldNames[i + 1] = stringTokenizer.nextToken();
            }
        }
        double d = -3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = 3.4028234663852886E38;
        double d4 = 3.4028234663852886E38;
        stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            double d5;
            String string4 = stringTokenizer.nextToken();
            if (!string4.startsWith("xmin=") && !string4.startsWith("ymin=") && !string4.startsWith("xmax=") && !string4.startsWith("ymax=")) continue;
            String string5 = string4.substring(5);
            try {
                d5 = Double.parseDouble(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MapyrusException(MapyrusMessages.get("invalidnumber") + ": " + string5);
            }
            if (string4.startsWith("xmin=")) {
                d2 = d5;
                continue;
            }
            if (string4.startsWith("ymin=")) {
                d = d5;
                continue;
            }
            if (string4.startsWith("xmax=")) {
                d4 = d5;
                continue;
            }
            d3 = d5;
        }
        if (d2 > d4) {
            throw new MapyrusException(MapyrusMessages.get("invalidrange") + ": " + d2 + " - " + d4);
        }
        if (d > d3) {
            throw new MapyrusException(MapyrusMessages.get("invalidrange") + ": " + d + " - " + d3);
        }
        this.m_queryExtents = new Rectangle2D.Double(d2, d, d4 - d2, d3 - d);
    }

    @Override
    public String getProjection() {
        return "GEOGCS[\"wgs84\",DATUM[\"WGS_1984\",SPHEROID[\"wgs84\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.0174532925199433]]";
    }

    @Override
    public Hashtable<String, String> getMetadata() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        return hashtable;
    }

    @Override
    public String[] getFieldNames() {
        return this.m_fieldNames;
    }

    @Override
    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
    }

    private String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        while (string != null && string.startsWith("#")) {
            string = lineNumberReader.readLine();
        }
        return string;
    }

    private Argument readGeometry(String string, int n, int[] nArray, double[] dArray) throws IOException {
        dArray[0] = 3.4028234663852886E38;
        dArray[1] = 3.4028234663852886E38;
        dArray[2] = -3.4028234663852886E38;
        dArray[3] = -3.4028234663852886E38;
        double[] dArray2 = new double[n * 2 + n + 2];
        dArray2[0] = string.equals("POLYGON") ? 102.0 : (string.equals("LINESTRING") ? 101.0 : 100.0);
        dArray2[1] = n;
        int n2 = 2;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            if (i == 0) {
                bl = false;
            } else if (nArray != null && n3 < nArray.length && i == nArray[n3]) {
                bl = false;
                ++n3;
            } else {
                bl = true;
            }
            dArray2[n2++] = (double)bl;
            String string2 = this.readLine(this.m_reader);
            int n4 = string2.indexOf(32);
            int n5 = Integer.parseInt(string2.substring(0, n4));
            int n6 = Integer.parseInt(string2.substring(n4 + 1));
            double d = (double)n5 / 1000.0;
            double d2 = (double)n6 / 1000.0;
            dArray2[n2++] = d;
            dArray2[n2++] = d2;
            if (d < dArray[0]) {
                dArray[0] = d;
            }
            if (d > dArray[2]) {
                dArray[2] = d;
            }
            if (d2 < dArray[1]) {
                dArray[1] = d2;
            }
            if (!(d2 > dArray[3])) continue;
            dArray[3] = d2;
        }
        Argument argument = new Argument((int)dArray2[0], dArray2);
        return argument;
    }

    private Row readRow() throws MapyrusException, IOException {
        String string;
        Row row = null;
        double[] dArray = new double[4];
        boolean bl = false;
        while (!bl) {
            String[] stringArray;
            int[] nArray;
            int n;
            string = this.readLine(this.m_reader);
            if (string == null) {
                return null;
            }
            row = new Row();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            String string3 = "1";
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3.indexOf(47) < 0) {
                n = Integer.parseInt(string3);
                nArray = null;
            } else {
                stringArray = new StringTokenizer(string3, "/");
                n = Integer.parseInt(stringArray.nextToken());
                nArray = new int[stringArray.countTokens()];
                int n2 = 0;
                while (stringArray.hasMoreTokens()) {
                    nArray[n2] = n;
                    n += Integer.parseInt(stringArray.nextToken());
                    ++n2;
                }
            }
            row.add(null);
            stringArray = null;
            String string4 = this.readLine(this.m_reader);
            if (string4 != null) {
                stringArray = string4.split(",");
            }
            if (stringArray == null || stringArray.length != this.m_fieldNames.length - 1) {
                throw new MapyrusException(MapyrusMessages.get("missingfield") + ": " + this.m_filename + ":" + this.m_reader.getLineNumber());
            }
            for (int i = 0; i < stringArray.length; ++i) {
                row.add(new Argument(1, stringArray[i]));
            }
            Argument argument = this.readGeometry(string2, n, nArray, dArray);
            row.set(0, argument);
            bl = Geometry.overlaps(this.m_queryExtents, dArray[0], dArray[1], dArray[2], dArray[3]);
        }
        string = null;
        if (bl) {
            string = row;
        }
        return string;
    }

    @Override
    public Row fetch() throws MapyrusException {
        Row row = null;
        try {
            row = this.readRow();
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        return row;
    }

    @Override
    public void close() throws MapyrusException {
        try {
            if (this.m_reader != null) {
                this.m_reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_reader = null;
    }
}

