/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.font.CharacterMetrics;
import org.mapyrus.font.StringDimension;

public class AdobeFontMetrics {
    private static final int FULL_CHAR_SIZE = 1000;
    private static final String SPACE_GLYPH_NAME = "space";
    private String m_fontName;
    private HashMap<String, CharacterMetrics> m_charMetrics;
    private int m_firstChar;
    private int m_lastChar;
    private boolean m_isFixedPitch;
    private int m_italicAngle;
    private int m_capHeight;
    private int m_ascender;
    private int m_descender;
    private Rectangle m_fontBBox;
    private int m_flags;
    private static HashMap<Integer, ArrayList<String>> m_glyphNames;
    private static HashMap<String, Integer> m_ISOLatin1CharIndexes;

    public AdobeFontMetrics(BufferedReader bufferedReader, String string, HashSet<String> hashSet) throws IOException, MapyrusException {
        boolean bl = false;
        boolean bl2 = false;
        this.m_charMetrics = new HashMap();
        this.m_isFixedPitch = false;
        this.m_firstChar = Integer.MAX_VALUE;
        this.m_lastChar = Integer.MIN_VALUE;
        this.m_flags = 32;
        boolean bl3 = false;
        try {
            String string2 = bufferedReader.readLine();
            if (string2 == null || !string2.startsWith("StartFontMetrics")) {
                throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string);
            }
            while (!bl2 && string2 != null) {
                int n;
                int n2;
                int n3;
                StringTokenizer stringTokenizer;
                if (bl && string2.startsWith("C")) {
                    Object object;
                    stringTokenizer = new StringTokenizer(string2);
                    n3 = -1;
                    n2 = 1000;
                    n = 1000;
                    short s = 0;
                    String string3 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4.equals("C")) {
                            n3 = Integer.parseInt(stringTokenizer.nextToken());
                        } else if (string4.equals("CH")) {
                            string4 = stringTokenizer.nextToken();
                            if (string4.length() >= 2) {
                                string4 = string4.substring(1, string4.length() - 1);
                            }
                            n3 = Integer.parseInt(string4, 16);
                        } else if (string4.equals("WX")) {
                            n2 = Short.parseShort(stringTokenizer.nextToken());
                        } else if (string4.equals("N")) {
                            string3 = stringTokenizer.nextToken();
                        } else if (string4.equals("B")) {
                            stringTokenizer.nextToken();
                            s = (short)Math.round(Double.parseDouble(stringTokenizer.nextToken()));
                            stringTokenizer.nextToken();
                            n = (short)Math.round(Double.parseDouble(stringTokenizer.nextToken()));
                        }
                        string4 = stringTokenizer.nextToken();
                        while (!string4.equals(";") && stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                        }
                    }
                    if (bl3 && (object = m_ISOLatin1CharIndexes.get(string3)) != null) {
                        n3 = (Integer)object;
                    }
                    if (n3 >= 0) {
                        object = new CharacterMetrics((char)n3, (short)n2, (short)n, s);
                        while (this.m_charMetrics.containsKey(string3)) {
                            string3 = string3 + "X";
                        }
                        this.m_charMetrics.put(string3, (CharacterMetrics)object);
                        if (n3 == 32) {
                            this.m_charMetrics.put(SPACE_GLYPH_NAME, (CharacterMetrics)object);
                        }
                        if (n3 < this.m_firstChar) {
                            this.m_firstChar = n3;
                        }
                        if (n3 > this.m_lastChar) {
                            this.m_lastChar = n3;
                        }
                    }
                } else if (string2.startsWith("FontName")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_fontName = stringTokenizer.nextToken();
                    bl3 = hashSet.contains(this.m_fontName);
                } else if (string2.startsWith("IsFixedPitch") && string2.toLowerCase().indexOf("true") >= 0) {
                    this.m_isFixedPitch = true;
                    this.m_flags |= 1;
                } else if (string2.startsWith("ItalicAngle")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_italicAngle = (int)Math.round(Double.parseDouble(stringTokenizer.nextToken()));
                } else if (string2.startsWith("CapHeight")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_capHeight = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("Ascender")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_ascender = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("Descender")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_descender = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("FontBBox")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 5) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    this.m_fontBBox = new Rectangle(n4, n3, n2 - n4, n - n3);
                } else if (string2.startsWith("Weight")) {
                    stringTokenizer = new StringTokenizer(string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        if (!string5.equalsIgnoreCase("italic")) continue;
                        this.m_flags |= 0x40;
                    }
                } else if (string2.startsWith("StartCharMetrics")) {
                    bl = true;
                } else if (string2.startsWith("EndCharMetrics")) {
                    bl = false;
                    bl2 = true;
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + numberFormatException.getMessage());
        }
    }

    public String getFontName() {
        return this.m_fontName;
    }

    public int getFirstChar() {
        return this.m_firstChar;
    }

    public int getLastChar() {
        return this.m_lastChar;
    }

    public int getCharWidth(int n) {
        for (CharacterMetrics characterMetrics : this.m_charMetrics.values()) {
            if (characterMetrics.getCode() != n) continue;
            return characterMetrics.getWidth();
        }
        return 0;
    }

    public int getItalicAngle() {
        return this.m_italicAngle;
    }

    public int getCapHeight() {
        return this.m_capHeight;
    }

    public Rectangle getFontBBox() {
        return this.m_fontBBox;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public int getAscender() {
        return this.m_ascender;
    }

    public int getDescender() {
        return this.m_descender;
    }

    public String toString() {
        return "Adobe Font Metrics for " + this.m_fontName;
    }

    public StringDimension getStringDimension(String string, double d) {
        CharacterMetrics characterMetrics;
        int n = 0;
        int n2 = string.length();
        double d2 = 0.0;
        double d3 = 1000.0;
        StringDimension stringDimension = new StringDimension();
        for (int i = 0; i < n2; ++i) {
            CharacterMetrics characterMetrics2 = null;
            char c = string.charAt(i);
            ArrayList<String> arrayList = m_glyphNames.get(c);
            if (arrayList != null) {
                for (int j = 0; j < arrayList.size() && characterMetrics2 == null; ++j) {
                    characterMetrics2 = this.m_charMetrics.get(arrayList.get(j));
                }
            }
            if (characterMetrics2 != null) {
                n += characterMetrics2.getWidth();
                if ((double)characterMetrics2.getAscent() > d2) {
                    d2 = characterMetrics2.getAscent();
                }
                if (!((double)characterMetrics2.getDescent() < d3)) continue;
                d3 = characterMetrics2.getDescent();
                continue;
            }
            n += 1000;
        }
        double d4 = (double)n / 1000.0 * d;
        d2 = d2 / 1000.0 * d;
        d3 = d3 / 1000.0 * d;
        if (this.m_isFixedPitch && (characterMetrics = this.m_charMetrics.get(SPACE_GLYPH_NAME)) != null) {
            d4 = (double)string.length() * ((double)characterMetrics.getWidth() / 1000.0) * d;
        }
        stringDimension.setSize(d4, d, d2, d3);
        return stringDimension;
    }

    public char getEncodedChar(char n) {
        int n2;
        CharacterMetrics characterMetrics = null;
        ArrayList<String> arrayList = m_glyphNames.get(n);
        if (arrayList != null) {
            for (n2 = 0; n2 < arrayList.size() && characterMetrics == null; ++n2) {
                characterMetrics = this.m_charMetrics.get(arrayList.get(n2));
            }
        }
        n2 = characterMetrics != null ? characterMetrics.getCode() : n;
        return (char)n2;
    }

    static {
        m_ISOLatin1CharIndexes = new HashMap(256);
        m_ISOLatin1CharIndexes.put("Aacute", 193);
        m_ISOLatin1CharIndexes.put("Acircumflex", 194);
        m_ISOLatin1CharIndexes.put("Adieresis", 196);
        m_ISOLatin1CharIndexes.put("Agrave", 192);
        m_ISOLatin1CharIndexes.put("Aring", 197);
        m_ISOLatin1CharIndexes.put("Atilde", 195);
        m_ISOLatin1CharIndexes.put("Ccedilla", 199);
        m_ISOLatin1CharIndexes.put("Eacute", 201);
        m_ISOLatin1CharIndexes.put("Ecircumflex", 202);
        m_ISOLatin1CharIndexes.put("Edieresis", 203);
        m_ISOLatin1CharIndexes.put("Egrave", 200);
        m_ISOLatin1CharIndexes.put("Eth", 0);
        m_ISOLatin1CharIndexes.put("Iacute", 205);
        m_ISOLatin1CharIndexes.put("Icircumflex", 206);
        m_ISOLatin1CharIndexes.put("Idieresis", 207);
        m_ISOLatin1CharIndexes.put("Igrave", 204);
        m_ISOLatin1CharIndexes.put("Oacute", 211);
        m_ISOLatin1CharIndexes.put("Ocircumflex", 212);
        m_ISOLatin1CharIndexes.put("Odieresis", 214);
        m_ISOLatin1CharIndexes.put("Ograve", 210);
        m_ISOLatin1CharIndexes.put("Oslash", 216);
        m_ISOLatin1CharIndexes.put("Otilde", 213);
        m_ISOLatin1CharIndexes.put("Thorn", 222);
        m_ISOLatin1CharIndexes.put("Uacute", 218);
        m_ISOLatin1CharIndexes.put("Ucircumflex", 219);
        m_ISOLatin1CharIndexes.put("Udieresis", 220);
        m_ISOLatin1CharIndexes.put("Ugrave", 217);
        m_ISOLatin1CharIndexes.put("Yacute", 221);
        m_ISOLatin1CharIndexes.put("acircumflex", 226);
        m_ISOLatin1CharIndexes.put("acute", 225);
        m_ISOLatin1CharIndexes.put("adieresis", 228);
        m_ISOLatin1CharIndexes.put("agrave", 224);
        m_ISOLatin1CharIndexes.put("aring", 229);
        m_ISOLatin1CharIndexes.put("atilde", 227);
        m_ISOLatin1CharIndexes.put("breve", 150);
        m_ISOLatin1CharIndexes.put("brokenbar", 166);
        m_ISOLatin1CharIndexes.put("caron", 159);
        m_ISOLatin1CharIndexes.put("ccedilla", 231);
        m_ISOLatin1CharIndexes.put("cedilla", 184);
        m_ISOLatin1CharIndexes.put("cent", 162);
        m_ISOLatin1CharIndexes.put("circumflex", 147);
        m_ISOLatin1CharIndexes.put("copyright", 169);
        m_ISOLatin1CharIndexes.put("currency", 164);
        m_ISOLatin1CharIndexes.put("degree", 176);
        m_ISOLatin1CharIndexes.put("dieresis", 168);
        m_ISOLatin1CharIndexes.put("divide", 247);
        m_ISOLatin1CharIndexes.put("dotaccent", 151);
        m_ISOLatin1CharIndexes.put("dotlessi", 144);
        m_ISOLatin1CharIndexes.put("eacute", 233);
        m_ISOLatin1CharIndexes.put("ecircumflex", 234);
        m_ISOLatin1CharIndexes.put("edieresis", 235);
        m_ISOLatin1CharIndexes.put("egrave", 232);
        m_ISOLatin1CharIndexes.put("eth", 240);
        m_ISOLatin1CharIndexes.put("exclamdown", 161);
        m_ISOLatin1CharIndexes.put("germandbls", 223);
        m_ISOLatin1CharIndexes.put("grave", 145);
        m_ISOLatin1CharIndexes.put("guillemotleft", 171);
        m_ISOLatin1CharIndexes.put("guillemotright", 187);
        m_ISOLatin1CharIndexes.put("hungarumlaut", 157);
        m_ISOLatin1CharIndexes.put("hyphen", 173);
        m_ISOLatin1CharIndexes.put("iacute", 237);
        m_ISOLatin1CharIndexes.put("icircumflex", 238);
        m_ISOLatin1CharIndexes.put("idieresis", 239);
        m_ISOLatin1CharIndexes.put("igrave", 236);
        m_ISOLatin1CharIndexes.put("logicalnot", 172);
        m_ISOLatin1CharIndexes.put("macron", 175);
        m_ISOLatin1CharIndexes.put("mu", 0);
        m_ISOLatin1CharIndexes.put("multiply", 215);
        m_ISOLatin1CharIndexes.put("ntilde", 241);
        m_ISOLatin1CharIndexes.put("oacute", 243);
        m_ISOLatin1CharIndexes.put("ocircumflex", 244);
        m_ISOLatin1CharIndexes.put("odieresis", 246);
        m_ISOLatin1CharIndexes.put("ogonek", 158);
        m_ISOLatin1CharIndexes.put("ograve", 242);
        m_ISOLatin1CharIndexes.put("onehalf", 189);
        m_ISOLatin1CharIndexes.put("onequarter", 188);
        m_ISOLatin1CharIndexes.put("onesuperior", 185);
        m_ISOLatin1CharIndexes.put("ordfeminine", 170);
        m_ISOLatin1CharIndexes.put("ordmasculine", 186);
        m_ISOLatin1CharIndexes.put("oslash", 248);
        m_ISOLatin1CharIndexes.put("otilde", 245);
        m_ISOLatin1CharIndexes.put("paragraph", 182);
        m_ISOLatin1CharIndexes.put("periodcentered", 183);
        m_ISOLatin1CharIndexes.put("plusminus", 177);
        m_ISOLatin1CharIndexes.put("questiondown", 191);
        m_ISOLatin1CharIndexes.put("registered", 174);
        m_ISOLatin1CharIndexes.put("ring", 154);
        m_ISOLatin1CharIndexes.put("section", 167);
        m_ISOLatin1CharIndexes.put("sterling", 163);
        m_ISOLatin1CharIndexes.put("thorn", 254);
        m_ISOLatin1CharIndexes.put("threequarters", 190);
        m_ISOLatin1CharIndexes.put("threesuperior", 179);
        m_ISOLatin1CharIndexes.put("tilde", 148);
        m_ISOLatin1CharIndexes.put("twosuperior", 178);
        m_ISOLatin1CharIndexes.put("uacute", 250);
        m_ISOLatin1CharIndexes.put("ucircumflex", 251);
        m_ISOLatin1CharIndexes.put("udieresis", 252);
        m_ISOLatin1CharIndexes.put("ugrave", 249);
        m_ISOLatin1CharIndexes.put("yacute", 253);
        m_ISOLatin1CharIndexes.put("ydieresis", 255);
        m_ISOLatin1CharIndexes.put("yen", 165);
        String string = "org/mapyrus/font/glyphlist.txt";
        InputStream inputStream = AdobeFontMetrics.class.getClassLoader().getResourceAsStream(string);
        m_glyphNames = new HashMap(4400);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string2.startsWith("#") || (n = string2.indexOf(59)) < 0) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    int n2 = Integer.parseInt(string5, 16);
                    ArrayList<String> arrayList = m_glyphNames.get(n2);
                    if (arrayList == null) {
                        arrayList = new ArrayList(1);
                        m_glyphNames.put(n2, arrayList);
                    }
                    arrayList.add(string3);
                }
            }
        }
        catch (IOException iOException) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }
}

