/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BlendComposite
implements Composite {
    public static final BlendComposite MULTIPLY = new BlendComposite("multiply", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = nArray[i] * nArray2[i] / 256;
            }
        }
    });
    public static final BlendComposite SCREEN = new BlendComposite("screen", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = 255 - (255 - nArray[i]) * (255 - nArray2[i]) / 256;
            }
        }
    });
    public static final BlendComposite OVERLAY = new BlendComposite("overlay", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = nArray2[i] < 128 ? nArray2[i] * nArray[i] >> 7 : 255 - (255 - nArray2[i]) * (255 - nArray[i]) / 128;
            }
        }
    });
    public static final BlendComposite DARKEN = new BlendComposite("darken", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = Math.min(nArray2[i], nArray[i]);
            }
        }
    });
    public static final BlendComposite LIGHTEN = new BlendComposite("lighten", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = Math.max(nArray2[i], nArray[i]);
            }
        }
    });
    public static final BlendComposite COLORDODGE = new BlendComposite("colordodge", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                if (nArray[i] == 255) {
                    nArray3[i] = 255;
                    continue;
                }
                nArray3[i] = nArray2[i] * 256 / (255 - nArray[i]);
                if (nArray3[i] <= 255) continue;
                nArray3[i] = 255;
            }
        }
    });
    public static final BlendComposite COLORBURN = new BlendComposite("colorburn", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                if (nArray[i] == 0) {
                    nArray3[i] = 0;
                    continue;
                }
                nArray3[i] = 255 - (255 - nArray2[i]) * 256 / nArray[i];
                if (nArray3[i] >= 0) continue;
                nArray3[i] = 0;
            }
        }
    });
    public static final BlendComposite HARDLIGHT = new BlendComposite("hardlight", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = nArray[i] < 128 ? nArray[i] * nArray2[i] / 128 : 255 - (255 - nArray[i]) * (255 - nArray2[i]) / 128;
            }
        }
    });
    public static final BlendComposite SOFTLIGHT = new BlendComposite("softlight", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                if (nArray[i] < 128) {
                    nArray3[i] = nArray[i] == 0 ? 0 : 255 - (255 - nArray2[i]) * 256 / nArray[i];
                    if (nArray3[i] < 0) {
                        nArray3[i] = 0;
                    }
                } else {
                    nArray3[i] = nArray[i] == 255 ? 255 : nArray2[i] * 256 / (255 - nArray[i]);
                }
                if (nArray3[i] <= 255) continue;
                nArray3[i] = 255;
            }
        }
    });
    public static final BlendComposite DIFFERENCE = new BlendComposite("difference", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = Math.abs(nArray2[i] - nArray[i]);
            }
        }
    });
    public static final BlendComposite EXCLUSION = new BlendComposite("exclusion", new Blender(){

        @Override
        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            for (int i = 0; i < 3; ++i) {
                nArray3[i] = nArray2[i] + nArray[i] - nArray2[i] * nArray[i] / 128;
            }
        }
    });
    private String mName;
    private Blender mBlender;

    public BlendComposite(String string, Blender blender) {
        this.mName = string;
        this.mBlender = blender;
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        BlendCompositeContext blendCompositeContext = new BlendCompositeContext();
        return blendCompositeContext;
    }

    public static BlendComposite getBlendComposite(String string) {
        BlendComposite blendComposite = null;
        if (string.equals(MULTIPLY.getName())) {
            blendComposite = MULTIPLY;
        } else if (string.equals(SCREEN.getName())) {
            blendComposite = SCREEN;
        } else if (string.equals(OVERLAY.getName())) {
            blendComposite = OVERLAY;
        } else if (string.equals(DARKEN.getName())) {
            blendComposite = DARKEN;
        } else if (string.equals(LIGHTEN.getName())) {
            blendComposite = LIGHTEN;
        } else if (string.equals(COLORDODGE.getName())) {
            blendComposite = COLORDODGE;
        } else if (string.equals(COLORBURN.getName())) {
            blendComposite = COLORBURN;
        } else if (string.equals(HARDLIGHT.getName())) {
            blendComposite = HARDLIGHT;
        } else if (string.equals(SOFTLIGHT.getName())) {
            blendComposite = SOFTLIGHT;
        } else if (string.equals(DIFFERENCE.getName())) {
            blendComposite = DIFFERENCE;
        } else if (string.equals(EXCLUSION.getName())) {
            blendComposite = EXCLUSION;
        }
        return blendComposite;
    }

    public String getName() {
        return this.mName;
    }

    private class BlendCompositeContext
    implements CompositeContext {
        private BlendCompositeContext() {
        }

        @Override
        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = Math.min(raster.getWidth(), raster2.getWidth());
            int n2 = Math.min(raster.getHeight(), raster2.getHeight());
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            int[] nArray3 = new int[4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    raster.getPixel(j, i, nArray);
                    int n3 = nArray[3];
                    raster2.getPixel(j, i, nArray2);
                    BlendComposite.this.mBlender.blend(nArray, nArray2, nArray3);
                    nArray3[3] = nArray[3] + nArray2[3];
                    for (int k = 0; k < 4; ++k) {
                        if (n3 != 255) {
                            nArray3[k] = nArray2[k] + (nArray3[k] - nArray2[k]) * n3 / 256;
                        }
                        if (nArray3[k] <= 255) continue;
                        nArray3[k] = 255;
                    }
                    writableRaster.setPixel(j, i, nArray3);
                }
            }
        }

        @Override
        public void dispose() {
        }
    }

    private static interface Blender {
        public void blend(int[] var1, int[] var2, int[] var3);
    }
}

