#include <math.h>
//#include <conio.h>
//#include <process.h>
//#include <mem.h>
#include <stdio.h>
#include "matrix.h"

// These function must be presented by a program that uses this library
// because they may depend on the operation environment.
extern void quit(void);
extern void errmes(char*);

/*----------------------------------------------------------------------*/
/*	Constructor for initialization by another matrix and copying	*/
/*		when passing or returning the object by value		*/
/*----------------------------------------------------------------------*/
MATRIX::MATRIX(const MATRIX &M){

	unsigned i, j;

	AllocObject(M.height, M.length);

	for(i=0;i<M.height;i++)
		for(j=0;j<M.length;j++)
			elem[i][j]=M.elem[i][j];
}


/*----------------------------------------------------------------------*/
/*	Casting of type MATRIX to type double in case of 1x1 matrix	*/
/*	Necessary in case double a = X * Y; where X - row, Y - column	*/
/*----------------------------------------------------------------------*/
MATRIX::operator double(){

	if (height != 1 || length != 1){
		errmes("Attempt to cast to double the matrix of non-1 dimension!");
		quit();
	}
	return elem[0][0];
}


/*----------------------------------------------------------------------*/
/*		Overloaded matrix multiplication operator		*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator*(MATRIX &M1){

	MATRIX M2(height,M1.length);
	unsigned i,j,k;

	if(length!=M1.height){
		errmes("Different dimensions of multiplicated matrices in '*' operator!");
		quit();
	}

	for(i=0;i<height;i++)
		for(j=0;j<M1.length;j++){
			M2.elem[i][j]=0.0;
			for(k=0;k<length;k++) M2.elem[i][j]+=elem[i][k]*M1.elem[k][j];
		}

	return M2;
}


/*----------------------------------------------------------------------*/
/*		Overloaded matrix transposition operator		*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator!(){

	MATRIX M1(length,height);
	unsigned i,j;
	for(i=0;i<M1.height;i++)
		for(j=0;j<M1.length;j++){
			M1.elem[i][j]=elem[j][i];
		}

	return M1;
}


/*----------------------------------------------------------------------*/
/*		Overloaded matrix division operator			*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator/(double devider){

	if(fabs(devider)<DELTA){
		errmes("Attempt to divide by zero in '/' operator!");
		quit();
	}
	return (*this)*(1/devider);
}


/*----------------------------------------------------------------------*/
/*		Overloaded operator of matrix inversion			*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator~(){

	unsigned i,j,k;
	double coef;
	unsigned MaxElemNum;

	if(height!=length){
		errmes("Attempt to invert non-square matrix in '~' operator!");
		quit();
	}

	MATRIX M1,M2(height,length);

	M1=*this;

	for(i=0;i<height;i++)
		for(j=0;j<length;j++)
			M2.elem[i][j]=i==j?1:0;

	// Lower triangle
	for(k=0;k<length-1;k++){
		// Search for maximal non-zero element in column:
		for(MaxElemNum=i=k;i<height;i++){
			if(M1.elem[MaxElemNum][k] == 0. && M1.elem[i][k] != 0.
			   || M1.elem[i][k] != 0. && M1.elem[MaxElemNum][k]<M1.elem[i][k]){
			   MaxElemNum=i;
			}
		}
		// Set the row containing the found element to position k:
		if(MaxElemNum>k&&fabs(M1.elem[MaxElemNum][k])>=DELTA){
			M1.ChangeRows(k,MaxElemNum);
			M2.ChangeRows(k,MaxElemNum);
		}
		else if(fabs(M1.elem[MaxElemNum][k])<DELTA){
			errmes("Attempt to invert degenerate matrix in '~' operator!");
			quit();
		}
		// Clearing column:
		for(i=k+1;i<height;i++){
			coef=M1.elem[i][k]/M1.elem[k][k];
			for(j=0;j<length;j++){
				M1.elem[i][j]=M1.elem[i][j]-M1.elem[k][j]*coef;
				M2.elem[i][j]=M2.elem[i][j]-M2.elem[k][j]*coef;
			}
		}
	}

	// Upper triangle
	for(k=M1.length-1;k>0;k--){
		if(fabs(M1.elem[k][k])<DELTA){
			errmes("Attempt to invert degenerate matrix in '~' operator!");
			quit();
		}
		for(i=k-1;i>=0;i--){
			coef=M1.elem[i][k]/M1.elem[k][k];
			for(j=M1.length-1;j>=0;j--){
				M1.elem[i][j]=M1.elem[i][j]-M1.elem[k][j]*coef;
				M2.elem[i][j]=M2.elem[i][j]-M2.elem[k][j]*coef;
			}
		}
	}

	// Diagonal
	for(i=0;i<height;i++){
		if(fabs(M1.elem[i][i])<DELTA){
			errmes("Attempt to invert degenerate matrix in '~' operator!");
			quit();
		}
		coef=1./M1.elem[i][i];
		for(j=0;j<length;j++){
			M1.elem[i][j]*=coef;
			M2.elem[i][j]*=coef;
		}
	}

	return M2;
}


/*----------------------------------------------------------------------*/
/*		Overloaded matrix appropriation operator		*/
/*----------------------------------------------------------------------*/
MATRIX & MATRIX::operator=(MATRIX &M1){

	unsigned i,j;

	// In case the object is assigned to itself:
	if(this==&M1)return *this;

	FreeObject();

	AllocObject(M1.height, M1.length);

	for(i=0;i<M1.height;i++)
		for(j=0;j<M1.length;j++)
			elem[i][j]=M1.elem[i][j];
	return *this;
}


/*----------------------------------------------------------------------*/
/*		Overloaded matrix addition operator			*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator+(MATRIX &M1){

	unsigned i,j;

	if(M1.height!=height||M1.length!=length){
		errmes("Different matrix dimensions in '+' operator!");
		quit();
	}

	MATRIX M2(height,length);

	for(i=0;i<M1.height;i++)
		for(j=0;j<M1.length;j++)
			M2.elem[i][j]=elem[i][j]+M1.elem[i][j];
	return M2;
}


/*----------------------------------------------------------------------*/
/*		Overloaded matrix negation operator			*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator-(){

	unsigned i,j;

	MATRIX M(height,length);

	for(i=0;i<height;i++)
		for(j=0;j<length;j++)
			M.elem[i][j]=-elem[i][j];

	return M;
}


/*----------------------------------------------------------------------*/
/*		Overloaded matrix substraction operator			*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator-(MATRIX &M1){

	unsigned i,j;

	if(M1.height!=height||M1.length!=length){
		errmes("Different matrix dimensions in '-' operator!");
		quit();
	}

	MATRIX M2(height,length);

	for(i=0;i<M1.height;i++)
		for(j=0;j<M1.length;j++)
			M2.elem[i][j]=elem[i][j]-M1.elem[i][j];

	return M2;
}


/*----------------------------------------------------------------------*/
/*		Allocate matrix object of given dimension		*/
/*----------------------------------------------------------------------*/
void MATRIX::AllocObject (unsigned h, unsigned l){

	height=h; length=l;
	elem=new double* [height];
	if(elem==NULL){
		errmes("Memory not allocated for 'elem' in constructor!");
		quit();
	}
	for(unsigned i=0;i<height;i++){
		elem[i]=new double[length];
		if(elem[i]==NULL){
			errmes("Memory not allocated for 'elem[i]' in constructor!\n");
			quit();
		}
	}
}


/*----------------------------------------------------------------------*/
/*		Deallocating memory used by matrix object		*/
/*----------------------------------------------------------------------*/
void MATRIX::FreeObject (void){

	if(elem!=NULL) {
		for(unsigned i=0;i<height;i++) if (elem[i] != NULL) delete elem[i];
		delete elem;
	}
	elem = NULL;
	height = length = 0;
}


/*----------------------------------------------------------------------*/
/*	Initialization of matrix object by values from a file		*/
/*----------------------------------------------------------------------*/
void MATRIX::InitObject (FILE*fp){

	unsigned i,j;
	double buf;
	double *mult;

	FreeObject();    // Deallocating object first

	fscanf(fp,"%d%d",&height,&length);
	mult=new double[length];
	for(j=0;j<length;j++){
		if(!fscanf(fp,"%lf",&mult[j])||fabs(mult[j])>10){
			errmes("Wrong data in file!");
			quit();
		}
	}

	AllocObject(height, length);
				// Allocating object of needed dimension

	for(i=0;i<height;i++){
		for(j=0;j<length;j++){
			if(!fscanf(fp,"%lf",&buf)||fabs(buf)>1e15){
				errmes("Wrong data in file!");
				quit();
			}
			elem[i][j]=buf*mult[j];
		}
	}
	delete mult;
}


/*----------------------------------------------------------------------*/
/*			Write matrix into a given file			*/
/*----------------------------------------------------------------------*/
void MATRIX::FPrintObject (FILE*fp){

	unsigned i,j;
	for(i=0;i<height;i++){
		for(j=0;j<length;j++) fprintf(fp,"%.*f	   ",SIGNDIGITS,elem[i][j]);
		fprintf(fp,"\n");
	}
}


/*----------------------------------------------------------------------*/
/*	Overloaded operator of multiplication of matrix by scalar	*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator*(double scalar){

	unsigned i,j;
	MATRIX M1(height,length);

	for(i=0;i<height;i++)
		for(j=0;j<length;j++)
			 M1.elem[i][j]=elem[i][j]*scalar;

	return M1;
}


/*----------------------------------------------------------------------*/
/*	Overloaded operator of multiplication of scalar by matrix	*/
/*		(to provide commutativity of multiplication)		*/
/*----------------------------------------------------------------------*/
MATRIX operator*(double scalar, MATRIX &M){

	return M*scalar;
}


/*----------------------------------------------------------------------*/
/* Overloaded operator of concatenation of two matrices of equal height	*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::operator^(MATRIX &M1){

	unsigned i,j,k;
	if(height!=M1.height){
		errmes("Attempt to concatenate two matrices of different height in '^' operator!");
		quit();
	}
	MATRIX M2(height,length+M1.length);

	for(i=0;i<M2.height;i++){
		for(j=0;j<length;j++) M2.elem[i][j]=elem[i][j];
		for(j=length,k=0;j<M2.length;j++,k++) M2.elem[i][j]=M1.elem[i][k];
	}
	return M2;
}


/*----------------------------------------------------------------------*/
/*			Exchange two rows in a matrix			*/
/*----------------------------------------------------------------------*/
void MATRIX::ChangeRows(unsigned first,unsigned second){
	double tmp;
	if(first>=height||second>=height){
		errmes("Wrong argument value in 'ChangeRows' method!");
		quit();
	}
	for(unsigned j=0;j<length;j++){
		tmp=elem[first][j];
		elem[first][j]=elem[second][j];
		elem[second][j]=tmp;
	}
}


/*----------------------------------------------------------------------*/
/*		Exchange two columns in a matrix			*/
/*----------------------------------------------------------------------*/
void MATRIX::ChangeCols(unsigned first,unsigned second){
	double tmp;
	if(first>=length||second>=length){
		errmes("Wrong argument value in 'ChangeCols' method!");
		quit();
	}
	for(unsigned i=0;i<height;i++){
		tmp=elem[i][first];
		elem[i][first]=elem[i][second];
		elem[i][second]=tmp;
	}
}


/*----------------------------------------------------------------------*/
/*			Compute the norm of a matrix			*/
/*----------------------------------------------------------------------*/
double GetNorm00(MATRIX &M){
	double rowsum,
		   norma;
	norma=0;
	for(unsigned i=0;i<M.height;i++){
		rowsum=0;
		for(unsigned j=0;j<M.length;j++)rowsum+=fabs(M.elem[i][j]);
		norma+=rowsum;
	}
	return norma;
}


/*----------------------------------------------------------------------*/
/*		Cumpute the Euclude's norm of a matrix			*/
/*----------------------------------------------------------------------*/
double GetNorm2(MATRIX &M){
	double rowsum,
		   norma;
	norma=0;
	for(unsigned i=0;i<M.height;i++){
		rowsum=0;
		for(unsigned j=0;j<M.length;j++)rowsum+=M.elem[i][j]*M.elem[i][j];
		norma+=rowsum;
	}
	norma=sqrt(norma);
	return norma;
}


/*----------------------------------------------------------------------*/
/*	Produce a matrix of absolute values of elements of this matrix	*/
/*----------------------------------------------------------------------*/
MATRIX MATRIX::MatrAbs(){

	MATRIX M1(height,length);

	for(unsigned i=0;i<height;i++){
		for(unsigned j=0;j<length;j++)M1.elem[i][j]=fabs(elem[i][j]);
	}
	return M1;
}

/*----------------------------------------------------------------------*/
/*		Get the specified element's value			*/
/*----------------------------------------------------------------------*/
double MATRIX::Element( unsigned i, unsigned j ){

	if( i >= height || j >= length ){
		errmes("Wrong argument value in 'Element' method:\n\t"
			"matrix does not have an element with such index!");
		quit();
	}
	return elem[ i ][ j ];
}


/*----------------------------------------------------------------------*/
/*		Get the old value of a matrix element			*/
/*		and replace it with the given one			*/
/*----------------------------------------------------------------------*/
double MATRIX::Element( unsigned i, unsigned j, double newval){

	if( i >= height || j >= length ){
		errmes("\nWrong argument value in 'Element' method:\n\t"
			"matrix does not have an element with such index!");
		quit();
	}

	double oldval = elem[ i ][ j ];
	elem[ i ][ j ] = newval;
	return oldval;
}


///////////// METHODS FOR DERIVED CLASS VECTOR //////////////////

/*----------------------------------------------------------------------*/
/* Constructor for initialization the vector with a matrix, and also	*/
/* for implicit casting from type MATRIX to type VECTOR, because most	*/
/* of the base class's methods return matrix object while for vectors	*/
/*		a vector object will be expected			*/
/*----------------------------------------------------------------------*/
VECTOR::VECTOR(MATRIX &M){

	unsigned i;

	if(M.Height() != 1 && M.Length() != 1){
		errmes("Attempt to cast to a vector a matrix with both height and width non-1!");
		quit();
	}

	if(M.Length() == 1){	// If we cast a column to a vector
		AllocObject(M.Height(), 1);
		for (i = 0; i < M.Height(); i++) elem[i][0] = M.Element( i, 0 );
		dim = M.Height();
	}else{		  	// If we cast a row to a vector
		AllocObject(1, M.Length());
		for (i = 0; i < M.Length(); i++) elem[0][i] = M.Element( 0, i );
		dim = M.Length();
	}

}


/*----------------------------------------------------------------------*/
/*		Get the specified element's value			*/
/*----------------------------------------------------------------------*/
double VECTOR::Element( unsigned i ){

	if( i >= dim ){
		errmes("Wrong argument value in 'Element' method:\n\t"
			"vector does not have an element with such index!");
		quit();
	}
	return length == 1 ? elem[ i ][ 0 ] : elem[ 0 ][ i ];
}


/*----------------------------------------------------------------------*/
/*		Get the old vector element's value			*/
/*		and replace it with a new one				*/
/*----------------------------------------------------------------------*/
double VECTOR::Element( unsigned i, double newval){

	if( i >= dim ){
		errmes("Wrong argument value in 'Element' method:\n\t"
			"vector does not have an element with such index!");
		quit();
	}

	double oldval = length == 1 ? elem[ i ][ 0 ] : elem[ 0 ][ i ];
	(length == 1) ? elem[ i ][ 0 ]	= newval : elem[ 0 ][ i ] = newval;
	return oldval;
}

