// File_Aac - Info for AAC files
// Copyright (C) 2008-2011 MediaArea.net SARL, Info@MediaArea.net
//
// This library is free software: you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library. If not, see <http://www.gnu.org/licenses/>.
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

namespace MediaInfoLib
{

//***************************************************************************
// Huffman tables
//***************************************************************************

//---------------------------------------------------------------------------
// Optimal huffman from:
// "SELECTING AN OPTIMAL HUFFMAN DECODER FOR AAC"
// VLADIMIR Z. MESAROVIC , RAGHUNATH RAO, MIROSLAV V. DOKIC, and SACHIN DEO
// AES Convention Paper 5436

//---------------------------------------------------------------------------
//2-step 1st pass
struct hcb_struct_1
{
    int8u Offset;
    int8u Extra;
};

//2-step 2nd pass or binary
typedef int8s hcb_struct[5]; //0=bits to read (2step) or more to read (binary), 1-4: data (1-2 in case of pairs)

//---------------------------------------------------------------------------
// Scalefactor Huffman Codebook
static int8u huffman_sf[241][2]=
{
    {   1,   2 },
    {  60,   0 },
    {   1,   2 },
    {   2,   3 },
    {   3,   4 },
    {  59,   0 },
    {   3,   4 },
    {   4,   5 },
    {   5,   6 },
    {  61,   0 },
    {  58,   0 },
    {  62,   0 },
    {   3,   4 },
    {   4,   5 },
    {   5,   6 },
    {  57,   0 },
    {  63,   0 },
    {   4,   5 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {  56,   0 },
    {  64,   0 },
    {  55,   0 },
    {  65,   0 },
    {   4,   5 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {  66,   0 },
    {  54,   0 },
    {  67,   0 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  53,   0 },
    {  68,   0 },
    {  52,   0 },
    {  69,   0 },
    {  51,   0 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  70,   0 },
    {  50,   0 },
    {  49,   0 },
    {  71,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  72,   0 },
    {  48,   0 },
    {  73,   0 },
    {  47,   0 },
    {  74,   0 },
    {  46,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  76,   0 },
    {  75,   0 },
    {  77,   0 },
    {  78,   0 },
    {  45,   0 },
    {  43,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  44,   0 },
    {  79,   0 },
    {  42,   0 },
    {  41,   0 },
    {  80,   0 },
    {  40,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  81,   0 },
    {  39,   0 },
    {  82,   0 },
    {  38,   0 },
    {  83,   0 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  12,  13 },
    {  13,  14 },
    {  37,   0 },
    {  35,   0 },
    {  85,   0 },
    {  33,   0 },
    {  36,   0 },
    {  34,   0 },
    {  84,   0 },
    {  32,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  87,   0 },
    {  89,   0 },
    {  30,   0 },
    {  31,   0 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  12,  13 },
    {  13,  14 },
    {  14,  15 },
    {  15,  16 },
    {  86,   0 },
    {  29,   0 },
    {  26,   0 },
    {  27,   0 },
    {  28,   0 },
    {  24,   0 },
    {  88,   0 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  12,  13 },
    {  13,  14 },
    {  14,  15 },
    {  15,  16 },
    {  16,  17 },
    {  17,  18 },
    {  25,   0 },
    {  22,   0 },
    {  23,   0 },
    {  15,  16 },
    {  16,  17 },
    {  17,  18 },
    {  18,  19 },
    {  19,  20 },
    {  20,  21 },
    {  21,  22 },
    {  22,  23 },
    {  23,  24 },
    {  24,  25 },
    {  25,  26 },
    {  26,  27 },
    {  27,  28 },
    {  28,  29 },
    {  29,  30 },
    {  90,   0 },
    {  21,   0 },
    {  19,   0 },
    {   3,   0 },
    {   1,   0 },
    {   2,   0 },
    {   0,   0 },
    {  23,  24 },
    {  24,  25 },
    {  25,  26 },
    {  26,  27 },
    {  27,  28 },
    {  28,  29 },
    {  29,  30 },
    {  30,  31 },
    {  31,  32 },
    {  32,  33 },
    {  33,  34 },
    {  34,  35 },
    {  35,  36 },
    {  36,  37 },
    {  37,  38 },
    {  38,  39 },
    {  39,  40 },
    {  40,  41 },
    {  41,  42 },
    {  42,  43 },
    {  43,  44 },
    {  44,  45 },
    {  45,  46 },
    {  98,   0 },
    {  99,   0 },
    { 100,   0 },
    { 101,   0 },
    { 102,   0 },
    { 117,   0 },
    {  97,   0 },
    {  91,   0 },
    {  92,   0 },
    {  93,   0 },
    {  94,   0 },
    {  95,   0 },
    {  96,   0 },
    { 104,   0 },
    { 111,   0 },
    { 112,   0 },
    { 113,   0 },
    { 114,   0 },
    { 115,   0 },
    { 116,   0 },
    { 110,   0 },
    { 105,   0 },
    { 106,   0 },
    { 107,   0 },
    { 108,   0 },
    { 109,   0 },
    { 118,   0 },
    {   6,   0 },
    {   8,   0 },
    {   9,   0 },
    {  10,   0 },
    {   5,   0 },
    { 103,   0 },
    { 120,   0 },
    { 119,   0 },
    {   4,   0 },
    {   7,   0 },
    {  15,   0 },
    {  16,   0 },
    {  18,   0 },
    {  20,   0 },
    {  17,   0 },
    {  11,   0 },
    {  12,   0 },
    {  14,   0 },
    {  13,   0 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 1
static hcb_struct_1 huffman_01_1[32]=
{
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
    {  7, 0 },
    {  8, 0 },
    {  9, 2 },
    { 13, 2 },
    { 17, 2 },
    { 21, 2 },
    { 25, 2 },
    { 29, 2 },
    { 33, 4 },
    { 49, 6 }
};

static hcb_struct huffman_01[114]=
{
    {  1,  0,  0,  0,  0 },
    {  5,  1,  0,  0,  0 },
    {  5, -1,  0,  0,  0 },
    {  5,  0,  0,  0, -1 },
    {  5,  0,  1,  0,  0 },
    {  5,  0,  0,  0,  1 },
    {  5,  0,  0, -1,  0 },
    {  5,  0,  0,  1,  0 },
    {  5,  0, -1,  0,  0 },
    {  7,  1, -1,  0,  0 },
    {  7, -1,  1,  0,  0 },
    {  7,  0,  0, -1,  1 },
    {  7,  0,  1, -1,  0 },
    {  7,  0, -1,  1,  0 },
    {  7,  0,  0,  1, -1 },
    {  7,  1,  1,  0,  0 },
    {  7,  0,  0, -1, -1 },
    {  7, -1, -1,  0,  0 },
    {  7,  0, -1, -1,  0 },
    {  7,  1,  0, -1,  0 },
    {  7,  0,  1,  0, -1 },
    {  7, -1,  0,  1,  0 },
    {  7,  0,  0,  1,  1 },
    {  7,  1,  0,  1,  0 },
    {  7,  0, -1,  0,  1 },
    {  7,  0,  1,  1,  0 },
    {  7,  0,  1,  0,  1 },
    {  7, -1,  0, -1,  0 },
    {  7,  1,  0,  0,  1 },
    {  7, -1,  0,  0, -1 },
    {  7,  1,  0,  0, -1 },
    {  7, -1,  0,  0,  1 },
    {  7,  0, -1,  0, -1 },
    {  9,  1,  1, -1,  0 },
    {  9, -1,  1, -1,  0 },
    {  9,  1, -1,  1,  0 },
    {  9,  0,  1,  1, -1 },
    {  9,  0,  1, -1,  1 },
    {  9,  0, -1,  1,  1 },
    {  9,  0, -1,  1, -1 },
    {  9,  1, -1, -1,  0 },
    {  9,  1,  0, -1,  1 },
    {  9,  0,  1, -1, -1 },
    {  9, -1,  1,  1,  0 },
    {  9, -1,  0,  1, -1 },
    {  9, -1, -1,  1,  0 },
    {  9,  0, -1, -1,  1 },
    {  9,  1, -1,  0,  1 },
    {  9,  1, -1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1, -1, -1,  0 },
    {  9, -1, -1, -1,  0 },
    {  9, -1, -1, -1,  0 },
    {  9, -1, -1, -1,  0 },
    {  9,  0, -1, -1, -1 },
    {  9,  0, -1, -1, -1 },
    {  9,  0, -1, -1, -1 },
    {  9,  0, -1, -1, -1 },
    {  9,  0,  1,  1,  1 },
    {  9,  0,  1,  1,  1 },
    {  9,  0,  1,  1,  1 },
    {  9,  0,  1,  1,  1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  1,  0,  1 },
    {  9,  1,  1,  0,  1 },
    {  9,  1,  1,  0,  1 },
    {  9,  1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9,  1,  1,  1,  0 },
    {  9,  1,  1,  1,  0 },
    {  9,  1,  1,  1,  0 },
    {  9,  1,  1,  1,  0 },
    { 10, -1, -1,  0,  1 },
    { 10, -1, -1,  0,  1 },
    { 10, -1,  0, -1, -1 },
    { 10, -1,  0, -1, -1 },
    { 10,  1,  1,  0, -1 },
    { 10,  1,  1,  0, -1 },
    { 10,  1,  0, -1, -1 },
    { 10,  1,  0, -1, -1 },
    { 10, -1,  0, -1,  1 },
    { 10, -1,  0, -1,  1 },
    { 10, -1, -1,  0, -1 },
    { 10, -1, -1,  0, -1 },
    { 10, -1,  0,  1,  1 },
    { 10, -1,  0,  1,  1 },
    { 10,  1,  0,  1,  1 },
    { 10,  1,  0,  1,  1 },
    { 11,  1, -1,  1, -1 },
    { 11, -1,  1, -1,  1 },
    { 11, -1,  1,  1, -1 },
    { 11,  1, -1, -1,  1 },
    { 11,  1,  1,  1,  1 },
    { 11, -1, -1,  1,  1 },
    { 11,  1,  1, -1, -1 },
    { 11, -1, -1,  1, -1 },
    { 11, -1, -1, -1, -1 },
    { 11,  1,  1, -1,  1 },
    { 11,  1, -1,  1,  1 },
    { 11, -1,  1,  1,  1 },
    { 11, -1,  1, -1, -1 },
    { 11, -1, -1, -1,  1 },
    { 11,  1, -1, -1, -1 },
    { 11,  1,  1,  1, -1 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 2
static hcb_struct_1 huffman_02_1[] =
{
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
    {  7, 0 },
    {  8, 0 },
    {  9, 1 },
    { 11, 1 },
    { 13, 1 },
    { 15, 1 },
    { 17, 1 },
    { 19, 1 },
    { 21, 1 },
    { 23, 1 },
    { 25, 1 },
    { 27, 1 },
    { 29, 1 },
    { 31, 1 },
    { 33, 2 },
    { 37, 2 },
    { 41, 2 },
    { 45, 3 },
    { 53, 3 },
    { 61, 3 },
    { 69, 4 }
};

static hcb_struct huffman_02[86]=
{
    { 3,  0,  0,  0,  0 },
    { 4,  1,  0,  0,  0 },
    { 5, -1,  0,  0,  0 },
    { 5,  0,  0,  0,  1 },
    { 5,  0,  0, -1,  0 },
    { 5,  0,  0,  0, -1 },
    { 5,  0, -1,  0,  0 },
    { 5,  0,  0,  1,  0 },
    { 5,  0,  1,  0,  0 },
    { 6,  0, -1,  1,  0 },
    { 6, -1,  1,  0,  0 },
    { 6,  0,  1, -1,  0 },
    { 6,  0,  0,  1, -1 },
    { 6,  0,  1,  0, -1 },
    { 6,  0,  0, -1,  1 },
    { 6, -1,  0,  0, -1 },
    { 6,  1, -1,  0,  0 },
    { 6,  1,  0, -1,  0 },
    { 6, -1, -1,  0,  0 },
    { 6,  0,  0, -1, -1 },
    { 6,  1,  0,  1,  0 },
    { 6,  1,  0,  0,  1 },
    { 6,  0, -1,  0,  1 },
    { 6, -1,  0,  1,  0 },
    { 6,  0,  1,  0,  1 },
    { 6,  0, -1, -1,  0 },
    { 6, -1,  0,  0,  1 },
    { 6,  0, -1,  0, -1 },
    { 6, -1,  0, -1,  0 },
    { 6,  1,  1,  0,  0 },
    { 6,  0,  1,  1,  0 },
    { 6,  0,  0,  1,  1 },
    { 6,  1,  0,  0, -1 },
    { 7,  0,  1, -1,  1 },
    { 7,  1,  0, -1,  1 },
    { 7, -1,  1, -1,  0 },
    { 7,  0, -1,  1, -1 },
    { 7,  1, -1,  1,  0 },
    { 7,  1,  1,  0, -1 },
    { 7,  1,  0,  1,  1 },
    { 7, -1,  1,  1,  0 },
    { 7,  0, -1, -1,  1 },
    { 7,  1,  1,  1,  0 },
    { 7, -1,  0,  1, -1 },
    { 7, -1, -1, -1,  0 },
    { 7, -1,  0, -1,  1 },
    { 7, -1,  0, -1,  1 },
    { 7,  1, -1, -1,  0 },
    { 7,  1, -1, -1,  0 },
    { 7,  1,  1, -1,  0 },
    { 7,  1,  1, -1,  0 },
    { 8,  1, -1,  0,  1 },
    { 8, -1,  1,  0, -1 },
    { 8, -1, -1,  1,  0 },
    { 8, -1,  0,  1,  1 },
    { 8, -1, -1,  0,  1 },
    { 8, -1, -1,  0, -1 },
    { 8,  0, -1, -1, -1 },
    { 8,  1,  0,  1, -1 },
    { 8,  1,  0, -1, -1 },
    { 8,  0,  1, -1, -1 },
    { 8,  0,  1,  1,  1 },
    { 8, -1,  1,  0,  1 },
    { 8, -1,  0, -1, -1 },
    { 8,  0,  1,  1, -1 },
    { 8,  1, -1,  0, -1 },
    { 8,  0, -1,  1,  1 },
    { 8,  1,  1,  0,  1 },
    { 8,  1, -1,  1, -1 },
    { 8, -1,  1, -1,  1 },
    { 8, -1,  1, -1,  1 },
    { 9,  1, -1, -1,  1 },
    { 9, -1, -1, -1, -1 },
    { 9, -1,  1,  1, -1 },
    { 9, -1,  1,  1,  1 },
    { 9,  1,  1,  1,  1 },
    { 9, -1, -1,  1, -1 },
    { 9,  1, -1,  1,  1 },
    { 9, -1,  1, -1, -1 },
    { 9, -1, -1,  1,  1 },
    { 9,  1,  1, -1, -1 },
    { 9,  1, -1, -1, -1 },
    { 9, -1, -1, -1,  1 },
    { 9,  1,  1, -1,  1 },
    { 9,  1,  1,  1, -1 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 2
static hcb_struct huffman_03[161] =
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1,  1,  0 },
    { 1,  0,  0,  0,  1 },
    { 1,  0,  1,  0,  0 },
    { 1,  0,  0,  1,  0 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1,  1,  1 },
    { 1,  0,  0,  1,  1 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  0,  1,  1,  0 },
    { 1,  0,  1,  0,  1 },
    { 1,  1,  0,  1,  0 },
    { 1,  0,  1,  1,  1 },
    { 1,  1,  0,  0,  1 },
    { 1,  1,  1,  1,  0 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  1,  1,  1,  1 },
    { 1,  1,  0,  1,  1 },
    { 1,  1,  1,  0,  1 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 1,  2,  0,  0,  0 },
    { 1,  0,  0,  0,  2 },
    { 1,  0,  0,  1,  2 },
    { 1,  2,  1,  0,  0 },
    { 1,  1,  2,  1,  0 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 1,  0,  0,  2,  1 },
    { 1,  0,  1,  2,  1 },
    { 1,  1,  2,  0,  0 },
    { 1,  0,  1,  1,  2 },
    { 1,  2,  1,  1,  0 },
    { 1,  0,  0,  2,  0 },
    { 1,  0,  2,  1,  0 },
    { 1,  0,  1,  2,  0 },
    { 1,  0,  2,  0,  0 },
    { 1,  0,  1,  0,  2 },
    { 1,  2,  0,  1,  0 },
    { 1,  1,  2,  1,  1 },
    { 1,  0,  2,  1,  1 },
    { 1,  1,  1,  2,  0 },
    { 1,  1,  1,  2,  1 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 1,  1,  2,  0,  1 },
    { 1,  1,  0,  2,  0 },
    { 1,  1,  0,  2,  1 },
    { 1,  0,  2,  0,  1 },
    { 1,  2,  1,  1,  1 },
    { 1,  1,  1,  1,  2 },
    { 1,  2,  1,  0,  1 },
    { 1,  1,  0,  1,  2 },
    { 1,  0,  0,  2,  2 },
    { 1,  0,  1,  2,  2 },
    { 1,  2,  2,  1,  0 },
    { 1,  1,  2,  2,  0 },
    { 1,  1,  0,  0,  2 },
    { 1,  2,  0,  0,  1 },
    { 1,  0,  2,  2,  1 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 1,  2,  2,  0,  0 },
    { 1,  1,  2,  2,  1 },
    { 1,  1,  1,  0,  2 },
    { 1,  2,  0,  1,  1 },
    { 1,  1,  1,  2,  2 },
    { 1,  2,  2,  1,  1 },
    { 1,  0,  2,  2,  0 },
    { 1,  0,  2,  1,  2 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  1,  0,  2,  2 },
    { 1,  2,  2,  0,  1 },
    { 1,  2,  1,  2,  0 },
    { 1,  2,  2,  2,  0 },
    { 1,  0,  2,  2,  2 },
    { 1,  2,  2,  2,  1 },
    { 1,  2,  1,  2,  1 },
    { 1,  1,  2,  1,  2 },
    { 1,  1,  2,  2,  2 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 1,  0,  2,  0,  2 },
    { 1,  2,  0,  2,  0 },
    { 1,  1,  2,  0,  2 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 1,  2,  0,  2,  1 },
    { 1,  2,  1,  1,  2 },
    { 1,  2,  1,  0,  2 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 1,  2,  2,  2,  2 },
    { 1,  2,  2,  1,  2 },
    { 1,  2,  1,  2,  2 },
    { 1,  2,  0,  1,  2 },
    { 1,  2,  0,  0,  2 },
    { 0,  1,  2 },
    { 1,  2,  2,  0,  2 },
    { 1,  2,  0,  2,  2 },
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 4
static hcb_struct_1 huffman_04_1[32]=
{
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  2, 0 },
    {  3, 0 },
    {  3, 0 },
    {  4, 0 },
    {  4, 0 },
    {  5, 0 },
    {  5, 0 },
    {  6, 0 },
    {  6, 0 },
    {  7, 0 },
    {  7, 0 },
    {  8, 0 },
    {  8, 0 },
    {  9, 0 },
    {  9, 0 },
    { 10, 0 },
    { 11, 0 },
    { 12, 0 },
    { 13, 0 },
    { 14, 0 },
    { 15, 0 },
    { 16, 2 },
    { 20, 2 },
    { 24, 3 },
    { 32, 3 },
    { 40, 4 },
    { 56, 7 }
};

static hcb_struct huffman_04[185]=
{
    {  4,  1,  1,  1,  1 },
    {  4,  0,  1,  1,  1 },
    {  4,  1,  1,  0,  1 },
    {  4,  1,  1,  1,  0 },
    {  4,  1,  0,  1,  1 },
    {  4,  1,  0,  0,  0 },
    {  4,  1,  1,  0,  0 },
    {  4,  0,  0,  0,  0 },
    {  4,  0,  0,  1,  1 },
    {  4,  1,  0,  1,  0 },
    {  5,  1,  0,  0,  1 },
    {  5,  0,  1,  1,  0 },
    {  5,  0,  0,  0,  1 },
    {  5,  0,  1,  0,  1 },
    {  5,  0,  0,  1,  0 },
    {  5,  0,  1,  0,  0 },
    {  7,  2,  1,  1,  1 },
    {  7,  1,  1,  2,  1 },
    {  7,  1,  2,  1,  1 },
    {  7,  1,  1,  1,  2 },
    {  7,  2,  1,  1,  0 },
    {  7,  2,  1,  0,  1 },
    {  7,  1,  2,  1,  0 },
    {  7,  2,  0,  1,  1 },
    {  7,  0,  1,  2,  1 },
    {  7,  0,  1,  2,  1 },
    {  8,  0,  1,  1,  2 },
    {  8,  1,  1,  2,  0 },
    {  8,  0,  2,  1,  1 },
    {  8,  1,  0,  1,  2 },
    {  8,  1,  2,  0,  1 },
    {  8,  1,  1,  0,  2 },
    {  8,  1,  0,  2,  1 },
    {  8,  2,  1,  0,  0 },
    {  8,  2,  0,  1,  0 },
    {  8,  1,  2,  0,  0 },
    {  8,  2,  0,  0,  1 },
    {  8,  0,  1,  0,  2 },
    {  8,  0,  2,  1,  0 },
    {  8,  0,  0,  1,  2 },
    {  8,  0,  1,  2,  0 },
    {  8,  0,  1,  2,  0 },
    {  8,  0,  2,  0,  1 },
    {  8,  0,  2,  0,  1 },
    {  8,  1,  0,  0,  2 },
    {  8,  1,  0,  0,  2 },
    {  8,  0,  0,  2,  1 },
    {  8,  0,  0,  2,  1 },
    {  8,  1,  0,  2,  0 },
    {  8,  1,  0,  2,  0 },
    {  8,  2,  0,  0,  0 },
    {  8,  2,  0,  0,  0 },
    {  8,  0,  0,  0,  2 },
    {  8,  0,  0,  0,  2 },
    {  9,  0,  2,  0,  0 },
    {  9,  0,  0,  2,  0 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    { 10,  1,  2,  2,  0 },
    { 10,  1,  2,  2,  0 },
    { 10,  1,  2,  2,  0 },
    { 10,  1,  2,  2,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  1,  2,  2 },
    { 10,  0,  1,  2,  2 },
    { 10,  0,  1,  2,  2 },
    { 10,  0,  1,  2,  2 },
    { 10,  2,  2,  0,  1 },
    { 10,  2,  2,  0,  1 },
    { 10,  2,  2,  0,  1 },
    { 10,  2,  2,  0,  1 },
    { 10,  0,  2,  1,  2 },
    { 10,  0,  2,  1,  2 },
    { 10,  0,  2,  1,  2 },
    { 10,  0,  2,  1,  2 },
    { 10,  2,  0,  2,  1 },
    { 10,  2,  0,  2,  1 },
    { 10,  2,  0,  2,  1 },
    { 10,  2,  0,  2,  1 },
    { 10,  1,  0,  2,  2 },
    { 10,  1,  0,  2,  2 },
    { 10,  1,  0,  2,  2 },
    { 10,  1,  0,  2,  2 },
    { 10,  2,  2,  2,  1 },
    { 10,  2,  2,  2,  1 },
    { 10,  2,  2,  2,  1 },
    { 10,  2,  2,  2,  1 },
    { 10,  1,  2,  0,  2 },
    { 10,  1,  2,  0,  2 },
    { 10,  1,  2,  0,  2 },
    { 10,  1,  2,  0,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  1,  2,  2,  2 },
    { 10,  1,  2,  2,  2 },
    { 10,  1,  2,  2,  2 },
    { 10,  1,  2,  2,  2 },
    { 11,  2,  1,  2,  2 },
    { 11,  2,  1,  2,  2 },
    { 11,  2,  2,  1,  2 },
    { 11,  2,  2,  1,  2 },
    { 11,  0,  2,  2,  0 },
    { 11,  0,  2,  2,  0 },
    { 11,  2,  2,  0,  0 },
    { 11,  2,  2,  0,  0 },
    { 11,  0,  0,  2,  2 },
    { 11,  0,  0,  2,  2 },
    { 11,  2,  0,  2,  0 },
    { 11,  2,  0,  2,  0 },
    { 11,  0,  2,  0,  2 },
    { 11,  0,  2,  0,  2 },
    { 11,  2,  0,  0,  2 },
    { 11,  2,  0,  0,  2 },
    { 11,  2,  2,  2,  2 },
    { 11,  2,  2,  2,  2 },
    { 11,  0,  2,  2,  2 },
    { 11,  0,  2,  2,  2 },
    { 11,  2,  2,  2,  0 },
    { 11,  2,  2,  2,  0 },
    { 12,  2,  2,  0,  2 },
    { 12,  2,  0,  2,  2 },
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 5
static hcb_struct huffman_05[161]=
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1, -1,  0 },
    { 1,  1,  0 },
    { 1,  0,  1 },
    { 1,  0, -1 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1,  1, -1 },
    { 1, -1,  1 },
    { 1, -1, -1 },
    { 1,  1,  1 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1, -2,  0 },
    { 1,  0,  2 },
    { 1,  2,  0 },
    { 1,  0, -2 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -2, -1 },
    { 1,  2,  1 },
    { 1, -1, -2 },
    { 1,  1,  2 },
    { 1, -2,  1 },
    { 1,  2, -1 },
    { 1, -1,  2 },
    { 1,  1, -2 },
    { 1, -3,  0 },
    { 1,  3,  0 },
    { 1,  0, -3 },
    { 1,  0,  3 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -3, -1 },
    { 1,  1,  3 },
    { 1,  3,  1 },
    { 1, -1, -3 },
    { 1, -3,  1 },
    { 1,  3, -1 },
    { 1,  1, -3 },
    { 1, -1,  3 },
    { 1, -2,  2 },
    { 1,  2,  2 },
    { 1, -2, -2 },
    { 1,  2, -2 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -3, -2 },
    { 1,  3, -2 },
    { 1, -2,  3 },
    { 1,  2, -3 },
    { 1,  3,  2 },
    { 1,  2,  3 },
    { 1, -3,  2 },
    { 1, -2, -3 },
    { 1,  0, -4 },
    { 1, -4,  0 },
    { 1,  4,  1 },
    { 1,  4,  0 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -4, -1 },
    { 1,  0,  4 },
    { 1,  4, -1 },
    { 1, -1, -4 },
    { 1,  1,  4 },
    { 1, -1,  4 },
    { 1, -4,  1 },
    { 1,  1, -4 },
    { 1,  3, -3 },
    { 1, -3, -3 },
    { 1, -3,  3 },
    { 1, -2,  4 },
    { 1, -4, -2 },
    { 1,  4,  2 },
    { 1,  2, -4 },
    { 1,  2,  4 },
    { 1,  3,  3 },
    { 1, -4,  2 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1, -2, -4 },
    { 1,  4, -2 },
    { 1,  3, -4 },
    { 1, -4, -3 },
    { 1, -4,  3 },
    { 1,  3,  4 },
    { 1, -3,  4 },
    { 1,  4,  3 },
    { 1,  4, -3 },
    { 1, -3, -4 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  4, -4 },
    { 1, -4,  4 },
    { 1,  4,  4 },
    { 1, -4, -4 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 6
static hcb_struct_1 huffman_06_1[32] = {
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  2, 0 },
    {  3, 0 },
    {  3, 0 },
    {  4, 0 },
    {  4, 0 },
    {  5, 0 },
    {  5, 0 },
    {  6, 0 },
    {  6, 0 },
    {  7, 0 },
    {  7, 0 },
    {  8, 0 },
    {  8, 0 },
    {  9, 1 },
    {  11, 1 },
    {  13, 1 },
    {  15, 1 },
    {  17, 1 },
    {  19, 1 },
    {  21, 1 },
    {  23, 1 },
    {  25, 2 },
    {  29, 2 },
    {  33, 2 },
    {  37, 3 },
    {  45, 4 },
    {  61, 6 }
};

static hcb_struct huffman_06[126]=
{
    {  4,  0,  0 },
    {  4,  1,  0 },
    {  4,  0, -1 },
    {  4,  0,  1 },
    {  4, -1,  0 },
    {  4,  1,  1 },
    {  4, -1,  1 },
    {  4,  1, -1 },
    {  4, -1, -1 },
    {  6,  2, -1 },
    {  6,  2,  1 },
    {  6, -2,  1 },
    {  6, -2, -1 },
    {  6, -2,  0 },
    {  6, -1,  2 },
    {  6,  2,  0 },
    {  6,  1, -2 },
    {  6,  1,  2 },
    {  6,  0, -2 },
    {  6, -1, -2 },
    {  6,  0,  2 },
    {  6,  2, -2 },
    {  6, -2,  2 },
    {  6, -2, -2 },
    {  6,  2,  2 },
    {  7, -3,  1 },
    {  7,  3,  1 },
    {  7,  3, -1 },
    {  7, -1,  3 },
    {  7, -3, -1 },
    {  7,  1,  3 },
    {  7,  1, -3 },
    {  7, -1, -3 },
    {  7,  3,  0 },
    {  7, -3,  0 },
    {  7,  0, -3 },
    {  7,  0,  3 },
    {  7,  3,  2 },
    {  7,  3,  2 },
    {  8, -3, -2 },
    {  8, -2,  3 },
    {  8,  2,  3 },
    {  8,  3, -2 },
    {  8,  2, -3 },
    {  8, -2, -3 },
    {  8, -3,  2 },
    {  8, -3,  2 },
    {  8,  3,  3 },
    {  8,  3,  3 },
    {  9,  3, -3 },
    {  9, -3, -3 },
    {  9, -3,  3 },
    {  9,  1, -4 },
    {  9, -1, -4 },
    {  9,  4,  1 },
    {  9, -4,  1 },
    {  9, -4, -1 },
    {  9,  1,  4 },
    {  9,  4, -1 },
    {  9, -1,  4 },
    {  9,  0, -4 },
    {  9, -4,  2 },
    {  9, -4,  2 },
    {  9, -4,  2 },
    {  9, -4,  2 },
    {  9, -4, -2 },
    {  9, -4, -2 },
    {  9, -4, -2 },
    {  9, -4, -2 },
    {  9,  2,  4 },
    {  9,  2,  4 },
    {  9,  2,  4 },
    {  9,  2,  4 },
    {  9, -2, -4 },
    {  9, -2, -4 },
    {  9, -2, -4 },
    {  9, -2, -4 },
    {  9, -4,  0 },
    {  9, -4,  0 },
    {  9, -4,  0 },
    {  9, -4,  0 },
    {  9,  4,  2 },
    {  9,  4,  2 },
    {  9,  4,  2 },
    {  9,  4,  2 },
    {  9,  4, -2 },
    {  9,  4, -2 },
    {  9,  4, -2 },
    {  9,  4, -2 },
    {  9, -2,  4 },
    {  9, -2,  4 },
    {  9, -2,  4 },
    {  9, -2,  4 },
    {  9,  4,  0 },
    {  9,  4,  0 },
    {  9,  4,  0 },
    {  9,  4,  0 },
    {  9,  2, -4 },
    {  9,  2, -4 },
    {  9,  2, -4 },
    {  9,  2, -4 },
    {  9,  0,  4 },
    {  9,  0,  4 },
    {  9,  0,  4 },
    {  9,  0,  4 },
    { 10, -3, -4 },
    { 10, -3, -4 },
    { 10, -3,  4 },
    { 10, -3,  4 },
    { 10,  3, -4 },
    { 10,  3, -4 },
    { 10,  4, -3 },
    { 10,  4, -3 },
    { 10,  3,  4 },
    { 10,  3,  4 },
    { 10,  4,  3 },
    { 10,  4,  3 },
    { 10, -4,  3 },
    { 10, -4,  3 },
    { 10, -4, -3 },
    { 10, -4, -3 },
    { 11,  4,  4 },
    { 11, -4,  4 },
    { 11, -4, -4 },
    { 11,  4, -4 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 7
static hcb_struct huffman_07[127] =
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  0 },
    { 1,  0,  1 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  1 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  2,  1 },
    { 1,  1,  2 },
    { 1,  2,  0 },
    { 1,  0,  2 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1,  3,  1 },
    { 1,  1,  3 },
    { 1,  2,  2 },
    { 1,  3,  0 },
    { 1,  0,  3 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 1,  2,  3 },
    { 1,  3,  2 },
    { 1,  1,  4 },
    { 1,  4,  1 },
    { 1,  1,  5 },
    { 1,  5,  1 },
    { 1,  3,  3 },
    { 1,  2,  4 },
    { 1,  0,  4 },
    { 1,  4,  0 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1,  4,  2 },
    { 1,  2,  5 },
    { 1,  5,  2 },
    { 1,  0,  5 },
    { 1,  6,  1 },
    { 1,  5,  0 },
    { 1,  1,  6 },
    { 1,  4,  3 },
    { 1,  3,  5 },
    { 1,  3,  4 },
    { 1,  5,  3 },
    { 1,  2,  6 },
    { 1,  6,  2 },
    { 1,  1,  7 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 1,  3,  6 },
    { 1,  0,  6 },
    { 1,  6,  0 },
    { 1,  4,  4 },
    { 1,  7,  1 },
    { 1,  4,  5 },
    { 1,  7,  2 },
    { 1,  5,  4 },
    { 1,  6,  3 },
    { 1,  2,  7 },
    { 1,  7,  3 },
    { 1,  6,  4 },
    { 1,  5,  5 },
    { 1,  4,  6 },
    { 1,  3,  7 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 1,  7,  0 },
    { 1,  0,  7 },
    { 1,  6,  5 },
    { 1,  5,  6 },
    { 1,  7,  4 },
    { 1,  4,  7 },
    { 1,  5,  7 },
    { 1,  7,  5 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  7,  6 },
    { 1,  6,  6 },
    { 1,  6,  7 },
    { 1,  7,  7 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 8
static hcb_struct_1 huffman_08_1[32]=
{
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  2, 0 },
    {  3, 0 },
    {  3, 0 },
    {  4, 0 },
    {  4, 0 },
    {  5, 0 },
    {  5, 0 },
    {  6, 0 },
    {  7, 0 },
    {  8, 0 },
    {  9, 0 },
    { 10, 0 },
    { 11, 0 },
    { 12, 0 },
    { 13, 1 },
    { 15, 1 },
    { 17, 1 },
    { 19, 1 },
    { 21, 1 },
    { 23, 2 },
    { 27, 2 },
    { 31, 2 },
    { 35, 3 },
    { 43, 3 },
    { 51, 5 }
};

static hcb_struct huffman_08[83]=
{
    {  3,  1,  1 },
    {  4,  2,  1 },
    {  4,  1,  0 },
    {  4,  1,  2 },
    {  4,  0,  1 },
    {  4,  2,  2 },
    {  5,  0,  0 },
    {  5,  2,  0 },
    {  5,  0,  2 },
    {  5,  3,  1 },
    {  5,  1,  3 },
    {  5,  3,  2 },
    {  5,  2,  3 },
    {  6,  3,  3 },
    {  6,  4,  1 },
    {  6,  1,  4 },
    {  6,  4,  2 },
    {  6,  2,  4 },
    {  6,  3,  0 },
    {  6,  0,  3 },
    {  6,  4,  3 },
    {  6,  3,  4 },
    {  6,  5,  2 },
    {  7,  5,  1 },
    {  7,  2,  5 },
    {  7,  1,  5 },
    {  7,  5,  3 },
    {  7,  3,  5 },
    {  7,  4,  4 },
    {  7,  5,  4 },
    {  7,  0,  4 },
    {  7,  4,  5 },
    {  7,  4,  0 },
    {  7,  2,  6 },
    {  7,  6,  2 },
    {  7,  6,  1 },
    {  7,  6,  1 },
    {  7,  1,  6 },
    {  7,  1,  6 },
    {  8,  3,  6 },
    {  8,  6,  3 },
    {  8,  5,  5 },
    {  8,  5,  0 },
    {  8,  6,  4 },
    {  8,  0,  5 },
    {  8,  4,  6 },
    {  8,  7,  1 },
    {  8,  7,  2 },
    {  8,  2,  7 },
    {  8,  6,  5 },
    {  8,  7,  3 },
    {  8,  1,  7 },
    {  8,  1,  7 },
    {  8,  1,  7 },
    {  8,  1,  7 },
    {  8,  5,  6 },
    {  8,  5,  6 },
    {  8,  5,  6 },
    {  8,  5,  6 },
    {  8,  3,  7 },
    {  8,  3,  7 },
    {  8,  3,  7 },
    {  8,  3,  7 },
    {  9,  6,  6 },
    {  9,  6,  6 },
    {  9,  7,  4 },
    {  9,  7,  4 },
    {  9,  6,  0 },
    {  9,  6,  0 },
    {  9,  4,  7 },
    {  9,  4,  7 },
    {  9,  0,  6 },
    {  9,  0,  6 },
    {  9,  7,  5 },
    {  9,  7,  5 },
    {  9,  7,  6 },
    {  9,  7,  6 },
    {  9,  6,  7 },
    {  9,  6,  7 },
    { 10,  5,  7 },
    { 10,  7,  0 },
    { 10,  0,  7 },
    { 10,  7,  7 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 9
static hcb_struct huffman_09[337]=
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  0 },
    { 1,  0,  1 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  1 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  2,  1 },
    { 1,  1,  2 },
    { 1,  2,  0 },
    { 1,  0,  2 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1,  3,  1 },
    { 1,  2,  2 },
    { 1,  1,  3 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 1,  3,  0 },
    { 1,  0,  3 },
    { 1,  2,  3 },
    { 1,  3,  2 },
    { 1,  1,  4 },
    { 1,  4,  1 },
    { 1,  2,  4 },
    { 1,  1,  5 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 0, 26, 27 },
    { 0, 27, 28 },
    { 0, 28, 29 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 1,  4,  2 },
    { 1,  3,  3 },
    { 1,  0,  4 },
    { 1,  4,  0 },
    { 1,  5,  1 },
    { 1,  2,  5 },
    { 1,  1,  6 },
    { 1,  3,  4 },
    { 1,  5,  2 },
    { 1,  6,  1 },
    { 1,  4,  3 },
    { 0, 25, 26 },
    { 0, 26, 27 },
    { 0, 27, 28 },
    { 0, 28, 29 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 0, 40, 41 },
    { 0, 41, 42 },
    { 0, 42, 43 },
    { 0, 43, 44 },
    { 0, 44, 45 },
    { 0, 45, 46 },
    { 0, 46, 47 },
    { 0, 47, 48 },
    { 0, 48, 49 },
    { 0, 49, 50 },
    { 1,  0,  5 },
    { 1,  2,  6 },
    { 1,  5,  0 },
    { 1,  1,  7 },
    { 1,  3,  5 },
    { 1,  1,  8 },
    { 1,  8,  1 },
    { 1,  4,  4 },
    { 1,  5,  3 },
    { 1,  6,  2 },
    { 1,  7,  1 },
    { 1,  0,  6 },
    { 1,  8,  2 },
    { 1,  2,  8 },
    { 1,  3,  6 },
    { 1,  2,  7 },
    { 1,  4,  5 },
    { 1,  9,  1 },
    { 1,  1,  9 },
    { 1,  7,  2 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 0, 40, 41 },
    { 0, 41, 42 },
    { 0, 42, 43 },
    { 0, 43, 44 },
    { 0, 44, 45 },
    { 0, 45, 46 },
    { 0, 46, 47 },
    { 0, 47, 48 },
    { 0, 48, 49 },
    { 0, 49, 50 },
    { 0, 50, 51 },
    { 0, 51, 52 },
    { 0, 52, 53 },
    { 0, 53, 54 },
    { 0, 54, 55 },
    { 0, 55, 56 },
    { 0, 56, 57 },
    { 0, 57, 58 },
    { 0, 58, 59 },
    { 0, 59, 60 },
    { 1,  6,  0 },
    { 1,  5,  4 },
    { 1,  6,  3 },
    { 1,  8,  3 },
    { 1,  0,  7 },
    { 1,  9,  2 },
    { 1,  3,  8 },
    { 1,  4,  6 },
    { 1,  3,  7 },
    { 1,  0,  8 },
    { 1, 10,  1 },
    { 1,  6,  4 },
    { 1,  2,  9 },
    { 1,  5,  5 },
    { 1,  8,  0 },
    { 1,  7,  0 },
    { 1,  7,  3 },
    { 1, 10,  2 },
    { 1,  9,  3 },
    { 1,  8,  4 },
    { 1,  1, 10 },
    { 1,  7,  4 },
    { 1,  6,  5 },
    { 1,  5,  6 },
    { 1,  4,  8 },
    { 1,  4,  7 },
    { 1,  3,  9 },
    { 1, 11,  1 },
    { 1,  5,  8 },
    { 1,  9,  0 },
    { 1,  8,  5 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 0, 40, 41 },
    { 0, 41, 42 },
    { 0, 42, 43 },
    { 0, 43, 44 },
    { 0, 44, 45 },
    { 0, 45, 46 },
    { 0, 46, 47 },
    { 0, 47, 48 },
    { 0, 48, 49 },
    { 0, 49, 50 },
    { 0, 50, 51 },
    { 0, 51, 52 },
    { 0, 52, 53 },
    { 0, 53, 54 },
    { 0, 54, 55 },
    { 0, 55, 56 },
    { 0, 56, 57 },
    { 0, 57, 58 },
    { 1, 10,  3 },
    { 1,  2, 10 },
    { 1,  0,  9 },
    { 1, 11,  2 },
    { 1,  9,  4 },
    { 1,  6,  6 },
    { 1, 12,  1 },
    { 1,  4,  9 },
    { 1,  8,  6 },
    { 1,  1, 11 },
    { 1,  9,  5 },
    { 1, 10,  4 },
    { 1,  5,  7 },
    { 1,  7,  5 },
    { 1,  2, 11 },
    { 1,  1, 12 },
    { 1, 12,  2 },
    { 1, 11,  3 },
    { 1,  3, 10 },
    { 1,  5,  9 },
    { 1,  6,  7 },
    { 1,  8,  7 },
    { 1, 11,  4 },
    { 1,  0, 10 },
    { 1,  7,  6 },
    { 1, 12,  3 },
    { 1, 10,  0 },
    { 1, 10,  5 },
    { 1,  4, 10 },
    { 1,  6,  8 },
    { 1,  2, 12 },
    { 1,  9,  6 },
    { 1,  9,  7 },
    { 1,  4, 11 },
    { 1, 11,  0 },
    { 1,  6,  9 },
    { 1,  3, 11 },
    { 1,  5, 10 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 0, 26, 27 },
    { 0, 27, 28 },
    { 0, 28, 29 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 1,  8,  8 },
    { 1,  7,  8 },
    { 1, 12,  5 },
    { 1,  3, 12 },
    { 1, 11,  5 },
    { 1,  7,  7 },
    { 1, 12,  4 },
    { 1, 11,  6 },
    { 1, 10,  6 },
    { 1,  4, 12 },
    { 1,  7,  9 },
    { 1,  5, 11 },
    { 1,  0, 11 },
    { 1, 12,  6 },
    { 1,  6, 10 },
    { 1, 12,  0 },
    { 1, 10,  7 },
    { 1,  5, 12 },
    { 1,  7, 10 },
    { 1,  9,  8 },
    { 1,  0, 12 },
    { 1, 11,  7 },
    { 1,  8,  9 },
    { 1,  9,  9 },
    { 1, 10,  8 },
    { 1,  7, 11 },
    { 1, 12,  7 },
    { 1,  6, 11 },
    { 1,  8, 11 },
    { 1, 11,  8 },
    { 1,  7, 12 },
    { 1,  6, 12 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1,  8, 10 },
    { 1, 10,  9 },
    { 1,  8, 12 },
    { 1,  9, 10 },
    { 1,  9, 11 },
    { 1,  9, 12 },
    { 1, 10, 11 },
    { 1, 12,  9 },
    { 1, 10, 10 },
    { 1, 11,  9 },
    { 1, 12,  8 },
    { 1, 11, 10 },
    { 1, 12, 10 },
    { 1, 12, 11 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1, 10, 12 },
    { 1, 11, 11 },
    { 1, 11, 12 },
    { 1, 12, 12 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 10
static hcb_struct_1 huffman_10_1[64]=
{
    {   0, 0 },
    {   0, 0 },
    {   0, 0 },
    {   0, 0 },
    {   1, 0 },
    {   1, 0 },
    {   1, 0 },
    {   1, 0 },
    {   2, 0 },
    {   2, 0 },
    {   2, 0 },
    {   2, 0 },
    {   3, 0 },
    {   3, 0 },
    {   4, 0 },
    {   4, 0 },
    {   5, 0 },
    {   5, 0 },
    {   6, 0 },
    {   6, 0 },
    {   7, 0 },
    {   7, 0 },
    {   8, 0 },
    {   8, 0 },
    {   9, 0 },
    {   9, 0 },
    {  10, 0 },
    {  10, 0 },
    {  11, 0 },
    {  12, 0 },
    {  13, 0 },
    {  14, 0 },
    {  15, 0 },
    {  16, 0 },
    {  17, 0 },
    {  18, 0 },
    {  19, 0 },
    {  20, 0 },
    {  21, 0 },
    {  22, 0 },
    {  23, 0 },
    {  24, 0 },
    {  25, 1 },
    {  27, 1 },
    {  29, 1 },
    {  31, 1 },
    {  33, 1 },
    {  35, 1 },
    {  37, 1 },
    {  39, 1 },
    {  41, 2 },
    {  45, 2 },
    {  49, 2 },
    {  53, 2 },
    {  57, 2 },
    {  61, 2 },
    {  65, 3 },
    {  73, 3 },
    {  81, 3 },
    {  89, 3 },
    {  97, 4 },
    { 113, 4 },
    { 129, 4 },
    { 145, 6 }
};

static hcb_struct huffman_10[210]=
{
    {  4,  1,  1 },
    {  4,  1,  2 },
    {  4,  2,  1 },
    {  5,  2,  2 },
    {  5,  1,  0 },
    {  5,  0,  1 },
    {  5,  1,  3 },
    {  5,  3,  2 },
    {  5,  3,  1 },
    {  5,  2,  3 },
    {  5,  3,  3 },
    {  6,  2,  0 },
    {  6,  0,  2 },
    {  6,  2,  4 },
    {  6,  4,  2 },
    {  6,  1,  4 },
    {  6,  4,  1 },
    {  6,  0,  0 },
    {  6,  4,  3 },
    {  6,  3,  4 },
    {  6,  3,  0 },
    {  6,  0,  3 },
    {  6,  4,  4 },
    {  6,  2,  5 },
    {  6,  5,  2 },
    {  7,  1,  5 },
    {  7,  5,  1 },
    {  7,  5,  3 },
    {  7,  3,  5 },
    {  7,  5,  4 },
    {  7,  4,  5 },
    {  7,  6,  2 },
    {  7,  2,  6 },
    {  7,  6,  3 },
    {  7,  4,  0 },
    {  7,  6,  1 },
    {  7,  0,  4 },
    {  7,  1,  6 },
    {  7,  3,  6 },
    {  7,  5,  5 },
    {  7,  6,  4 },
    {  7,  4,  6 },
    {  7,  4,  6 },
    {  8,  6,  5 },
    {  8,  7,  2 },
    {  8,  3,  7 },
    {  8,  2,  7 },
    {  8,  5,  6 },
    {  8,  8,  2 },
    {  8,  7,  3 },
    {  8,  5,  0 },
    {  8,  7,  1 },
    {  8,  0,  5 },
    {  8,  8,  1 },
    {  8,  1,  7 },
    {  8,  8,  3 },
    {  8,  7,  4 },
    {  8,  4,  7 },
    {  8,  2,  8 },
    {  8,  6,  6 },
    {  8,  7,  5 },
    {  8,  1,  8 },
    {  8,  3,  8 },
    {  8,  8,  4 },
    {  8,  4,  8 },
    {  8,  5,  7 },
    {  8,  5,  7 },
    {  8,  8,  5 },
    {  8,  8,  5 },
    {  8,  5,  8 },
    {  8,  5,  8 },
    {  9,  7,  6 },
    {  9,  6,  7 },
    {  9,  9,  2 },
    {  9,  6,  0 },
    {  9,  6,  8 },
    {  9,  9,  3 },
    {  9,  3,  9 },
    {  9,  9,  1 },
    {  9,  2,  9 },
    {  9,  0,  6 },
    {  9,  8,  6 },
    {  9,  9,  4 },
    {  9,  4,  9 },
    {  9, 10,  2 },
    {  9,  1,  9 },
    {  9,  7,  7 },
    {  9,  8,  7 },
    {  9,  9,  5 },
    {  9,  7,  8 },
    {  9, 10,  3 },
    {  9,  5,  9 },
    {  9, 10,  4 },
    {  9,  2, 10 },
    {  9, 10,  1 },
    {  9,  3, 10 },
    {  9,  9,  6 },
    {  9,  6,  9 },
    {  9,  6,  9 },
    {  9,  8,  0 },
    {  9,  8,  0 },
    {  9,  4, 10 },
    {  9,  4, 10 },
    {  9,  7,  0 },
    {  9,  7,  0 },
    {  9, 11,  2 },
    {  9, 11,  2 },
    { 10,  7,  9 },
    { 10, 11,  3 },
    { 10, 10,  6 },
    { 10,  1, 10 },
    { 10, 11,  1 },
    { 10,  9,  7 },
    { 10,  0,  7 },
    { 10,  8,  8 },
    { 10, 10,  5 },
    { 10,  3, 11 },
    { 10,  5, 10 },
    { 10,  8,  9 },
    { 10, 11,  5 },
    { 10,  0,  8 },
    { 10, 11,  4 },
    { 10,  2, 11 },
    { 10,  7, 10 },
    { 10,  6, 10 },
    { 10, 10,  7 },
    { 10,  4, 11 },
    { 10,  1, 11 },
    { 10, 12,  2 },
    { 10,  9,  8 },
    { 10, 12,  3 },
    { 10, 11,  6 },
    { 10,  5, 11 },
    { 10, 12,  4 },
    { 10, 11,  7 },
    { 10, 12,  5 },
    { 10,  3, 12 },
    { 10,  6, 11 },
    { 10,  9,  0 },
    { 10, 10,  8 },
    { 10, 10,  0 },
    { 10, 12,  1 },
    { 10,  0,  9 },
    { 10,  4, 12 },
    { 10,  9,  9 },
    { 10, 12,  6 },
    { 10, 12,  6 },
    { 10, 12,  6 },
    { 10, 12,  6 },
    { 10,  2, 12 },
    { 10,  2, 12 },
    { 10,  2, 12 },
    { 10,  2, 12 },
    { 10,  8, 10 },
    { 10,  8, 10 },
    { 10,  8, 10 },
    { 10,  8, 10 },
    { 11,  9, 10 },
    { 11,  9, 10 },
    { 11,  1, 12 },
    { 11,  1, 12 },
    { 11, 11,  8 },
    { 11, 11,  8 },
    { 11, 12,  7 },
    { 11, 12,  7 },
    { 11,  7, 11 },
    { 11,  7, 11 },
    { 11,  5, 12 },
    { 11,  5, 12 },
    { 11,  6, 12 },
    { 11,  6, 12 },
    { 11, 10,  9 },
    { 11, 10,  9 },
    { 11,  8, 11 },
    { 11,  8, 11 },
    { 11, 12,  8 },
    { 11, 12,  8 },
    { 11,  0, 10 },
    { 11,  0, 10 },
    { 11,  7, 12 },
    { 11,  7, 12 },
    { 11, 11,  0 },
    { 11, 11,  0 },
    { 11, 10, 10 },
    { 11, 10, 10 },
    { 11, 11,  9 },
    { 11, 11,  9 },
    { 11, 11, 10 },
    { 11, 11, 10 },
    { 11,  0, 11 },
    { 11,  0, 11 },
    { 11, 11, 11 },
    { 11, 11, 11 },
    { 11,  9, 11 },
    { 11,  9, 11 },
    { 11, 10, 11 },
    { 11, 10, 11 },
    { 11, 12,  0 },
    { 11, 12,  0 },
    { 11,  8, 12 },
    { 11,  8, 12 },
    { 12, 12,  9 },
    { 12, 10, 12 },
    { 12,  9, 12 },
    { 12, 11, 12 },
    { 12, 12, 11 },
    { 12,  0, 12 },
    { 12, 12, 10 },
    { 12, 12, 12 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 11
static hcb_struct_1 huffman_11_1[32]=
{
    {   0, 0 },
    {   0, 0 },
    {   1, 0 },
    {   1, 0 },
    {   2, 0 },
    {   3, 0 },
    {   4, 0 },
    {   5, 0 },
    {   6, 0 },
    {   7, 0 },
    {   8,  1 },
    {  10, 1 },
    {  12, 1 },
    {  14, 2 },
    {  18, 2 },
    {  22, 2 },
    {  26, 2 },
    {  30, 3 },
    {  38, 3 },
    {  46, 3 },
    {  54, 3 },
    {  62, 3 },
    {  70, 3 },
    {  78, 3 },
    {  86, 4 },
    { 102, 4 },
    { 118, 4 },
    { 134, 4 },
    { 150, 5 },
    { 182, 5 },
    { 214, 5 },
    { 246, 7 }
};

static hcb_struct huffman_11[374]=
{
    { 4,  0,  0 },
    { 4,  1,  1 },
    { 5, 16, 16 },
    { 5,  1,  0 },
    { 5,  0,  1 },
    { 5,  2,  1 },
    { 5,  1,  2 },
    { 5,  2,  2 },
    { 6,  1,  3 },
    { 6,  3,  1 },
    { 6,  3,  2 },
    { 6,  2,  0 },
    { 6,  2,  3 },
    { 6,  0,  2 },
    { 6,  3,  3 },
    { 6,  3,  3 },
    { 7,  4,  1 },
    { 7,  1,  4 },
    { 7,  4,  2 },
    { 7,  2,  4 },
    { 7,  4,  3 },
    { 7,  3,  4 },
    { 7,  3,  0 },
    { 7,  0,  3 },
    { 7,  5,  1 },
    { 7,  5,  2 },
    { 7,  2,  5 },
    { 7,  4,  4 },
    { 7,  1,  5 },
    { 7,  5,  3 },
    { 7,  3,  5 },
    { 7,  3,  5 },
    { 7,  5,  4 },
    { 7,  5,  4 },
    { 8,  4,  5 },
    { 8,  6,  2 },
    { 8,  2,  6 },
    { 8,  6,  1 },
    { 8,  6,  3 },
    { 8,  3,  6 },
    { 8,  1,  6 },
    { 8,  4, 16 },
    { 8,  3, 16 },
    { 8, 16,  5 },
    { 8, 16,  3 },
    { 8, 16,  4 },
    { 8,  6,  4 },
    { 8, 16,  6 },
    { 8,  4,  0 },
    { 8,  4,  6 },
    { 8,  0,  4 },
    { 8,  2, 16 },
    { 8,  5,  5 },
    { 8,  5, 16 },
    { 8, 16,  7 },
    { 8, 16,  2 },
    { 8, 16,  8 },
    { 8,  2,  7 },
    { 8,  7,  2 },
    { 8,  3,  7 },
    { 8,  6,  5 },
    { 8,  5,  6 },
    { 8,  6, 16 },
    { 8, 16, 10 },
    { 8,  7,  3 },
    { 8,  7,  1 },
    { 8, 16,  9 },
    { 8,  7, 16 },
    { 8,  1, 16 },
    { 8,  1,  7 },
    { 8,  4,  7 },
    { 8, 16, 11 },
    { 8,  7,  4 },
    { 8, 16, 12 },
    { 8,  8, 16 },
    { 8, 16,  1 },
    { 8,  6,  6 },
    { 8,  9, 16 },
    { 8,  2,  8 },
    { 8,  5,  7 },
    { 8, 10, 16 },
    { 8, 16, 13 },
    { 8,  8,  3 },
    { 8,  8,  2 },
    { 8,  3,  8 },
    { 8,  5,  0 },
    { 8, 16, 14 },
    { 8, 16, 14 },
    { 8, 11, 16 },
    { 8, 11, 16 },
    { 8,  7,  5 },
    { 8,  7,  5 },
    { 8,  4,  8 },
    { 8,  4,  8 },
    { 8,  6,  7 },
    { 8,  6,  7 },
    { 8,  7,  6 },
    { 8,  7,  6 },
    { 8,  0,  5 },
    { 8,  0,  5 },
    { 9,  8,  4 },
    { 9, 16, 15 },
    { 9, 12, 16 },
    { 9,  1,  8 },
    { 9,  8,  1 },
    { 9, 14, 16 },
    { 9,  5,  8 },
    { 9, 13, 16 },
    { 9,  3,  9 },
    { 9,  8,  5 },
    { 9,  7,  7 },
    { 9,  2,  9 },
    { 9,  8,  6 },
    { 9,  9,  2 },
    { 9,  9,  3 },
    { 9, 15, 16 },
    { 9,  4,  9 },
    { 9,  6,  8 },
    { 9,  6,  0 },
    { 9,  9,  4 },
    { 9,  5,  9 },
    { 9,  8,  7 },
    { 9,  7,  8 },
    { 9,  1,  9 },
    { 9, 10,  3 },
    { 9,  0,  6 },
    { 9, 10,  2 },
    { 9,  9,  1 },
    { 9,  9,  5 },
    { 9,  4, 10 },
    { 9,  2, 10 },
    { 9,  9,  6 },
    { 9,  3, 10 },
    { 9,  6,  9 },
    { 9, 10,  4 },
    { 9,  8,  8 },
    { 9, 10,  5 },
    { 9,  9,  7 },
    { 9, 11,  3 },
    { 9,  1, 10 },
    { 9,  7,  0 },
    { 9, 10,  6 },
    { 9,  7,  9 },
    { 9,  3, 11 },
    { 9,  5, 10 },
    { 9, 10,  1 },
    { 9,  4, 11 },
    { 9, 11,  2 },
    { 9, 13,  2 },
    { 9,  6, 10 },
    { 9, 13,  3 },
    { 9, 13,  3 },
    { 9,  2, 11 },
    { 9,  2, 11 },
    { 9, 16,  0 },
    { 9, 16,  0 },
    { 9,  5, 11 },
    { 9,  5, 11 },
    { 9, 11,  5 },
    { 9, 11,  5 },
    { 10, 11,  4 },
    { 10,  9,  8 },
    { 10,  7, 10 },
    { 10,  8,  9 },
    { 10,  0, 16 },
    { 10,  4, 13 },
    { 10,  0,  7 },
    { 10,  3, 13 },
    { 10, 11,  6 },
    { 10, 13,  1 },
    { 10, 13,  4 },
    { 10, 12,  3 },
    { 10,  2, 13 },
    { 10, 13,  5 },
    { 10,  8, 10 },
    { 10,  6, 11 },
    { 10, 10,  8 },
    { 10, 10,  7 },
    { 10, 14,  2 },
    { 10, 12,  4 },
    { 10,  1, 11 },
    { 10,  4, 12 },
    { 10, 11,  1 },
    { 10,  3, 12 },
    { 10,  1, 13 },
    { 10, 12,  2 },
    { 10,  7, 11 },
    { 10,  3, 14 },
    { 10,  5, 12 },
    { 10,  5, 13 },
    { 10, 14,  4 },
    { 10,  4, 14 },
    { 10, 11,  7 },
    { 10, 14,  3 },
    { 10, 12,  5 },
    { 10, 13,  6 },
    { 10, 12,  6 },
    { 10,  8,  0 },
    { 10, 11,  8 },
    { 10,  2, 12 },
    { 10,  9,  9 },
    { 10, 14,  5 },
    { 10,  6, 13 },
    { 10, 10, 10 },
    { 10, 15,  2 },
    { 10,  8, 11 },
    { 10,  9, 10 },
    { 10, 14,  6 },
    { 10, 10,  9 },
    { 10,  5, 14 },
    { 10, 11,  9 },
    { 10, 14,  1 },
    { 10,  2, 14 },
    { 10,  6, 12 },
    { 10,  1, 12 },
    { 10, 13,  8 },
    { 10,  0,  8 },
    { 10, 13,  7 },
    { 10,  7, 12 },
    { 10, 12,  7 },
    { 10,  7, 13 },
    { 10, 15,  3 },
    { 10, 12,  1 },
    { 10,  6, 14 },
    { 10,  2, 15 },
    { 10, 15,  5 },
    { 10, 15,  4 },
    { 10,  1, 14 },
    { 10,  9, 11 },
    { 10,  4, 15 },
    { 10, 14,  7 },
    { 10,  8, 13 },
    { 10, 13,  9 },
    { 10,  8, 12 },
    { 10,  5, 15 },
    { 10,  3, 15 },
    { 10, 10, 11 },
    { 10, 11, 10 },
    { 10, 12,  8 },
    { 10, 15,  6 },
    { 10, 15,  7 },
    { 10,  8, 14 },
    { 10, 15,  1 },
    { 10,  7, 14 },
    { 10,  9,  0 },
    { 10,  0,  9 },
    { 10,  9, 13 },
    { 10,  9, 13 },
    { 10,  9, 13 },
    { 10,  9, 13 },
    { 10,  9, 12 },
    { 10,  9, 12 },
    { 10,  9, 12 },
    { 10,  9, 12 },
    { 10, 12,  9 },
    { 10, 12,  9 },
    { 10, 12,  9 },
    { 10, 12,  9 },
    { 10, 14,  8 },
    { 10, 14,  8 },
    { 10, 14,  8 },
    { 10, 14,  8 },
    { 10, 10, 13 },
    { 10, 10, 13 },
    { 10, 10, 13 },
    { 10, 10, 13 },
    { 10, 14,  9 },
    { 10, 14,  9 },
    { 10, 14,  9 },
    { 10, 14,  9 },
    { 10, 12, 10 },
    { 10, 12, 10 },
    { 10, 12, 10 },
    { 10, 12, 10 },
    { 10,  6, 15 },
    { 10,  6, 15 },
    { 10,  6, 15 },
    { 10,  6, 15 },
    { 10,  7, 15 },
    { 10,  7, 15 },
    { 10,  7, 15 },
    { 10,  7, 15 },
    { 11,  9, 14 },
    { 11,  9, 14 },
    { 11, 15,  8 },
    { 11, 15,  8 },
    { 11, 11, 11 },
    { 11, 11, 11 },
    { 11, 11, 14 },
    { 11, 11, 14 },
    { 11,  1, 15 },
    { 11,  1, 15 },
    { 11, 10, 12 },
    { 11, 10, 12 },
    { 11, 10, 14 },
    { 11, 10, 14 },
    { 11, 13, 11 },
    { 11, 13, 11 },
    { 11, 13, 10 },
    { 11, 13, 10 },
    { 11, 11, 13 },
    { 11, 11, 13 },
    { 11, 11, 12 },
    { 11, 11, 12 },
    { 11,  8, 15 },
    { 11,  8, 15 },
    { 11, 14, 11 },
    { 11, 14, 11 },
    { 11, 13, 12 },
    { 11, 13, 12 },
    { 11, 12, 13 },
    { 11, 12, 13 },
    { 11, 15,  9 },
    { 11, 15,  9 },
    { 11, 14, 10 },
    { 11, 14, 10 },
    { 11, 10,  0 },
    { 11, 10,  0 },
    { 11, 12, 11 },
    { 11, 12, 11 },
    { 11,  9, 15 },
    { 11,  9, 15 },
    { 11,  0, 10 },
    { 11,  0, 10 },
    { 11, 12, 12 },
    { 11, 12, 12 },
    { 11, 11,  0 },
    { 11, 11,  0 },
    { 11, 12, 14 },
    { 11, 12, 14 },
    { 11, 10, 15 },
    { 11, 10, 15 },
    { 11, 13, 13 },
    { 11, 13, 13 },
    { 11,  0, 13 },
    { 11,  0, 13 },
    { 11, 14, 12 },
    { 11, 14, 12 },
    { 11, 15, 10 },
    { 11, 15, 10 },
    { 11, 15, 11 },
    { 11, 15, 11 },
    { 11, 11, 15 },
    { 11, 11, 15 },
    { 11, 14, 13 },
    { 11, 14, 13 },
    { 11, 13,  0 },
    { 11, 13,  0 },
    { 11,  0, 11 },
    { 11,  0, 11 },
    { 11, 13, 14 },
    { 11, 13, 14 },
    { 11, 15, 12 },
    { 11, 15, 12 },
    { 11, 15, 13 },
    { 11, 15, 13 },
    { 11, 12, 15 },
    { 11, 12, 15 },
    { 11, 14,  0 },
    { 11, 14,  0 },
    { 11, 14, 14 },
    { 11, 14, 14 },
    { 11, 13, 15 },
    { 11, 13, 15 },
    { 11, 12,  0 },
    { 11, 12,  0 },
    { 11, 14, 15 },
    { 11, 14, 15 },
    { 12,  0, 14 },
    { 12,  0, 12 },
    { 12, 15, 14 },
    { 12, 15,  0 },
    { 12,  0, 15 },
    { 12, 15, 15 },
};

//---------------------------------------------------------------------------
const int8u hcb_2step_Bytes[]=
{
    0,            5,            5, 0,            5, 0,            5, 0,           5, 0,             6,            5
};

const hcb_struct_1* hcb_2step[]=
{
    0, huffman_01_1, huffman_02_1, 0, huffman_04_1, 0, huffman_06_1, 0, huffman_08_1, 0, huffman_10_1, huffman_11_1
};

//---------------------------------------------------------------------------
const int16u hcb_table_size[]=
{
    0,        114,         86,        161,        185,       161,         126,        127,        83,         337,        210,        374
};
const hcb_struct* hcb_table[]=
{
    0, huffman_01, huffman_02, huffman_03, huffman_04, huffman_05, huffman_06, huffman_07, huffman_08, huffman_09, huffman_10, huffman_11
};

//***************************************************************************
// PRED_SFB_MAX
//***************************************************************************

//---------------------------------------------------------------------------
const int8u Aac_PRED_SFB_MAX[16]=
{
    33, 33, 38, 40, 40, 40, 41, 41, 37, 37, 37, 34, 64, 64, 64, 64
};

//***************************************************************************
// swb offsets
//***************************************************************************

//---------------------------------------------------------------------------
struct Aac_swb_offset
{
    int8u  num_swb;
    int16u swb_offset[64];
};

//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_short_window_96[] =
{
    12,
    {
           0,    4,    8,   12,   16,   20,   24,   32,   40,   48,
          64,   92,  128
    }
};

const Aac_swb_offset Aac_swb_short_window_64[] =
{
    12,
    {
           0,    4,    8,   12,   16,   20,   24,   32,   40,   48,
          64,   92,  128
    }
};

const Aac_swb_offset Aac_swb_short_window_48[] =
{
    14,
    {
           0,    4,    8,   12,   16,   20,   28,   36,   44,   56,
          68,   80,   96,  112,  128
    }
};

const Aac_swb_offset Aac_swb_short_window_24[] =
{
    15,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   36,   44,
          52,   64,   76,   92,  108,  128
    }
};

const Aac_swb_offset Aac_swb_short_window_16[] =
{
    15,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   32,   40,
          48,   60,   72,   88,  108,  128
    }
};

const Aac_swb_offset Aac_swb_short_window_8[] =
{
    15,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   36,   44,
          52,   60,   72,   88,  108,  128
    }
};

const  Aac_swb_offset* Aac_swb_offset_short_window[] =
{
    Aac_swb_short_window_96,       //96000
    Aac_swb_short_window_96,       //88200
    Aac_swb_short_window_64,       //64000
    Aac_swb_short_window_48,       //48000
    Aac_swb_short_window_48,       //44100
    Aac_swb_short_window_48,       //32000
    Aac_swb_short_window_24,       //24000
    Aac_swb_short_window_24,       //22050
    Aac_swb_short_window_16,       //16000
    Aac_swb_short_window_16,       //12000
    Aac_swb_short_window_16,       //11025
    Aac_swb_short_window_8         //8000
};

//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_96[]=
{
    41,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
          40,   44,   48,   52,   56,   64,   72,   80,   88,   96,
         108,  120,  132,  144,  156,  172,  188,  212,  240,  276,
         320,  384,  448,  512,  576,  640,  704,  768,  832,  896,
         960,  1024
    }
};

const Aac_swb_offset Aac_swb_long_window_64[]=
{
    47,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
          40,   44,   48,   52,   56,   64,   72,   80,   88,  100,
         112,  124,  140,  156,  172,  192,  216,  240,  268,  304,
         344,  384,  424,  464,  504,  544,  584,  624,  664,  704,
         744,  784,  824,  864,  904,  944,  984, 1024
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_48[]=
{
    49,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
          40,   48,   56,   64,   72,   80,   88,   96,  108,  120,
         132,  144,  160,  176,  196,  216,  240,  264,  292,  320,
         352,  384,  416,  448,  480,  512,  544,  576,  608,  640,
         672,  704,  736,  768,  800,  832,  864,  896,  928, 1024
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_32[]=
{
    51,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
          40,   48,   56,   64,   72,   80,   88,   96,  108,  120,
         132,  144,  160,  176,  196,  216,  240,  264,  292,  320,
         352,  384,  416,  448,  480,  512,  544,  576,  608,  640,
         672,  704,  736,  768,  800,  832,  864,  896,  928,  960,
         992, 1024
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_24[]=
{
    47,
    {
           0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
          40,   44,   52,   60,   68,   76,   84,   92,  100,  108,
         116,  124,  136,  148,  160,  172,  188,  204,  220,  240,
         260,  284,  308,  336,  364,  396,  432,  468,  508,  552,
         600,  652,  704,  768,  832,  896,  960, 1024
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_16[]=
{
    43,
    {
           0,    8,   16,   24,   32,   40,   48,   56,   64,   72,
          80,   88,  100,  112,  124,  136,  148,  160,  172,  184,
         196,  212,  228,  244,  260,  280,  300,  320,  344,  368,
         396,  424,  456,  492,  532,  572,  616,  664,  716,  772,
         832,  896,  960, 1024
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_8[]=
{
    40,
    {
           0,   12,   24,   36,   48,   60,   72,   84,   96,  108,
         120,  132,  144,  156,  172,  188,  204,  220,  236,  252,
         268,  288,  308,  328,  348,  372,  396,  420,  448,  476,
         508,  544,  580,  620,  664,  712,  764,  820,  880,  944,
        1024
    }
};

//---------------------------------------------------------------------------
const Aac_swb_offset* Aac_swb_offset_long_window[]=
{
    Aac_swb_long_window_96,        //96000
    Aac_swb_long_window_96,        //88200
    Aac_swb_long_window_64,        //64000
    Aac_swb_long_window_48,        //48000
    Aac_swb_long_window_48,        //44100
    Aac_swb_long_window_32,        //32000
    Aac_swb_long_window_24,        //24000
    Aac_swb_long_window_24,        //22050
    Aac_swb_long_window_16,        //16000
    Aac_swb_long_window_16,        //12000
    Aac_swb_long_window_16,        //11025
    Aac_swb_long_window_8          //8000
};

} //NameSpace

