//STL
#include <iostream>
#include <vector>
#include <ctime>
using namespace std;

//MediaInfo
#include "MediaInfo/MediaInfo.h" //Staticly-loaded library (.lib or .a)
using namespace MediaInfoLib;

//ZenLib
#include "ZenLib/Thread.h" //Threads
#include "ZenLib/Ztring.h"
using namespace ZenLib;

#ifdef _WIN32
    #undef __TEXT
    #include "Windows.h" //Sleep()
#else
#endif

class Counter : public CriticalSection
{
public:
    Counter();
    void Add();
    void Remove();
    size_t Get();

private :
    size_t counter;
};

Counter::Counter()
{
    counter=0;
}

void Counter::Add()
{
    Enter();
    counter++;
    Leave();
}

void Counter::Remove()
{
    Enter();
    counter--;
    Leave();
}

size_t Counter::Get()
{
    size_t Temp;
    Enter();
    Temp=counter;
    Leave();
    return Temp;
}

class MediaInfoThread : public Thread
{
    void Entry();

public :
    String FileName;
    Counter* Count;
};

void MediaInfoThread::Entry()
{
    MediaInfo MI;
    
    for (size_t Pos=0; Pos<32; Pos++)
    {
        MI.Open(FileName);
        cout<<hex<<(size_t)this<<" "<<Pos<<endl;
    }

    Count->Remove();
}

int main(int argc, char* argv[])
{
    if (argc!=2)
    {
        cout<<argv[0]<<" FileName"<<endl;
        return 1;
    }
    
    int64u CurrentTime = (int64u)(time(0));

    Counter Count;
    vector<MediaInfoThread*> MIs;
    MIs.resize(6);
    for (size_t Pos=0; Pos<MIs.size(); Pos++)
    {
        Count.Add();
        MIs[Pos]=new MediaInfoThread();
        MIs[Pos]->FileName=Ztring().From_Local(argv[1]);
        MIs[Pos]->Count=&Count;
    }

    for (size_t Pos=0; Pos<MIs.size(); Pos++)
        MIs[Pos]->Run();
    
    while (Count.Get())
    {
        std::cout<<"."<<Count.Get()<<endl;
        #ifdef _WIN32
            ::Sleep(1000);
        #else
            sleep(1);
        #endif
    }

    for (size_t Pos=0; Pos<MIs.size(); Pos++)
        delete MIs[Pos];

    
    cout<<dec<<(int64u)(time(0))-CurrentTime<<endl;
    return 0;
}

