//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  MLanSesx.C - Aquire and release a Session on the 1-Wire Net using TMEX.
//
//  Version: 1.03
//

#include <stdio.h>
#include <windows.h>
#include "mlan.h"

// external function prototypes
extern long  far pascal TMExtendedStartSession(short, short, void far *);
extern short far pascal TMEndSession(long); 
extern short far pascal TMClose(long);
extern short far pascal TMSetup(long);

// local function prototypes
int  Aquire1WireNet(char *, char *);
void Release1WireNet(char *);
short ReadDefaultPort(void);

// keep port name for later message when closing
char  portname[128];
short PortNum=1,PortType=2;
long  SessionHandle;

//---------------------------------------------------------------------------
// Attempt to aquire a 1-Wire net port from TMEX
//
// 'port_zstr'  - zero terminated port name.  For this platform
//                use format X where X is the port number.
// 'return_msg' - zero terminated return message. 
//
// Returns: TRUE - success, COM port opened
//
int Aquire1WireNet(char *port_zstr, char *return_msg)
{
   int cnt=0;
   portname[0] = 0;

   // first read defaults
   ReadDefaultPort();

   // convert the string in port_zstr to be the port number
   PortNum = atoi(port_zstr);

   // open a session
   SessionHandle = TMExtendedStartSession(PortNum,PortType,NULL);
   
   // check the session handle
   if (SessionHandle <= 0)
   {
      cnt += sprintf(&return_msg[cnt],"Could not get TMEX session handle on"
                     " PortNum %d, PortType %d, aborting.\n",PortNum,PortType);
      return FALSE;
   }
   else
      cnt += sprintf(&return_msg[cnt],"TMEX session aquired on "
                     "PortNum %d, PortType %d.\n",PortNum,PortType);

   // setup the port
   if (TMSetup(SessionHandle) != 1)
   {
      cnt += sprintf(&return_msg[cnt],"Error setting up MicroLAN port, aborting.\n");
      cnt += sprintf(&return_msg[cnt],"Releasing TMEX MicroLAN port.\n");
      TMClose(SessionHandle);
      TMEndSession(SessionHandle);
      return FALSE;
   }
   else
      cnt += sprintf(&return_msg[cnt],"Setup successful on TMEX port.\n");

   // success
   sprintf(portname,"PortNum %d, PortType %d",PortNum,PortType);
   return TRUE;
}

//---------------------------------------------------------------------------
// Release the previously aquired a 1-Wire net.
//
// 'return_msg' - zero terminated return message. 
//
void Release1WireNet(char *return_msg)
{
   // release the TMEX port
   sprintf(return_msg,"Releasing TMEX MicroLAN %s\n",portname);
   TMClose(SessionHandle);
   TMEndSession(SessionHandle);
}

//----------------------------------------------------------------------
// Read the defualt 1-Wire Net Port
// return TRUE(1)  : Default port read
//        FALSE(0) : Error reading default port
//                                                          
short ReadDefaultPort(void)
{
   char ReturnString[256];
   HKEY GlobKey;
   DWORD dwType,size;

   // read the default PortNum and PortType from the registry 
   if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,
         "Software\\Dallas Semiconductor\\iButton TMEX\\3.00",0,
         KEY_READ,&GlobKey) == ERROR_SUCCESS)
   {
      // attempt to read the PortNum 
      size = 255;
      PortNum = 1;
      if (RegQueryValueEx(GlobKey,"DefaultPortNum",NULL,&dwType,
          &ReturnString[0],&size) == ERROR_SUCCESS)
      {
         if ((dwType == REG_SZ) || (size > 0))
            PortNum = atoi(ReturnString);
      }
      // attempt to read the PortType 
      size = 255;
      PortType = 1;
      if (RegQueryValueEx(GlobKey,"DefaultPortType",NULL,&dwType,
          &ReturnString[0],&size) == ERROR_SUCCESS)
      {
         if ((dwType == REG_SZ) || (size > 0))
            PortType = atoi(ReturnString);
      }

      // close the key
      RegCloseKey(GlobKey);
   }
   else
      return FALSE;

   // check to see that indicated PortNum/PortType is  <= 15 
   if ((PortNum > 15) || (PortType > 15))
      return FALSE;
   else
      return TRUE;
}
