//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  TODO.C - COM functions required by MLANLL.C, MLANTRNU, MLANNETU.C and
//           MLanFile.C for MLANU to communicate with the DS2480 based 
//           Universal Serial Adapter 'U'.  Fill in the platform specific code.
//
//  Version: 1.03
//
//  History: 1.00 -> 1.01  Added function msDelay. 
//
//           1.01 -> 1.02  Changed to generic OpenCOM/CloseCOM for easier 
//                         use with other platforms.
//           
//           1.02 -> 1.03  Removed caps in #includes for Linux capatibility
//                         Add function msGettick()
//

#include "mlan.h"

// exportable functions required for 
// MLANLL.C, MLANTRNU, or MLANNETU.C 
void FlushCOM(void);
int WriteCOM(int, uchar *);
int ReadCOM(int, uchar *);
void BreakCOM(void);
void msDelay(int);
void SetBaudCOM(int);
int  OpenCOM(char *);
void CloseCOM(void);
long msGettick(void);


//---------------------------------------------------------------------------
//  Description:
//     flush the rx and tx buffers
//
void FlushCOM(void)
{
   // add platform specific code here
}


//--------------------------------------------------------------------------
// Write an array of bytes to the COM port, verify that it was
// sent out.  Assume that baud rate has been set.
//
// Returns 1 for success and 0 for failure
//
int WriteCOM(int outlen, uchar *outbuf)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
// Read an array of bytes to the COM port, verify that it was
// sent out.  Assume that baud rate has been set.
//
// Returns number of characters read
//
int ReadCOM(int inlen, uchar *inbuf)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
//  Description:
//     Send a break on the com port for at least 2 ms
// 
void BreakCOM(void)
{
   // add platform specific code here
}


//--------------------------------------------------------------------------
//  Description:
//     Delay for at least 'len' ms
// 
void msDelay(int len)
{
   // add platform specific code here
}


//--------------------------------------------------------------------------
// Set the baud rate on the com port.  The possible baud rates for
// 'new_baud' are:
//
// PARMSET_9600     0x00
// PARMSET_19200    0x02
// PARMSET_57600    0x04
// PARMSET_115200   0x06
// 
void SetBaudCOM(int new_baud)
{
   // add platform specific code here
}


//---------------------------------------------------------------------------
// Attempt to open a com port.  
// Set the starting baud rate to 9600.
//
// 'port_zstr' - zero terminate port name.  Format is platform
//               dependent.
//
// Returns: TRUE - success, COM port opened
//
int OpenCOM(char *port_zstr)
{
   // add platform specific code here
   return 0;
}


//---------------------------------------------------------------------------
// Closes the connection to the port.
//
void CloseCOM(void)
{
   // add platform specific code here
}


//--------------------------------------------------------------------------
// Get the current millisecond tick count.  Does not have to represent
// an actual time, it just needs to be an incrementing timer.
//
long msGettick(void)
{
   // add platform specific code here
   return 0;
}
