/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.jboss.resource.adapter.jdbc.CachedPreparedStatement;
import org.jboss.resource.adapter.jdbc.PrivilegedProxy;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedStatement;

public class WrappedPreparedStatement
extends WrappedStatement
implements PreparedStatement {
    private final PreparedStatement ps;

    public WrappedPreparedStatement(WrappedConnection lc, PreparedStatement ps, boolean doSetQueryTimeout) {
        super(lc, ps, doSetQueryTimeout);
        if (System.getSecurityManager() != null) {
            PrivilegedProxy proxy = new PrivilegedProxy(ps);
            try {
                this.ps = (PreparedStatement)proxy.getProxy();
            }
            catch (Exception e) {
                throw new SecurityException("Failed to create PreparedStatement proxy: " + e.getMessage());
            }
        } else {
            this.ps = ps;
        }
    }

    public Statement getUnderlyingStatement() {
        if (this.ps instanceof CachedPreparedStatement) {
            return ((CachedPreparedStatement)this.ps).getUnderlyingPreparedStatement();
        }
        return this.ps;
    }

    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        try {
            this.ps.setBoolean(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setByte(int parameterIndex, byte value) throws SQLException {
        try {
            this.ps.setByte(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setShort(int parameterIndex, short value) throws SQLException {
        try {
            this.ps.setShort(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setInt(int parameterIndex, int value) throws SQLException {
        try {
            this.ps.setInt(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setLong(int parameterIndex, long value) throws SQLException {
        try {
            this.ps.setLong(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setFloat(int parameterIndex, float value) throws SQLException {
        try {
            this.ps.setFloat(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setDouble(int parameterIndex, double value) throws SQLException {
        try {
            this.ps.setDouble(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setURL(int parameterIndex, URL value) throws SQLException {
        try {
            this.ps.setURL(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setTime(int parameterIndex, Time value) throws SQLException {
        try {
            this.ps.setTime(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setTime(int parameterIndex, Time value, Calendar calendar) throws SQLException {
        try {
            this.ps.setTime(parameterIndex, value, calendar);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public boolean execute() throws SQLException {
        this.checkTransaction();
        try {
            this.setQueryTimeout();
            return this.ps.execute();
        }
        catch (SQLException e) {
            this.checkException(e);
            return false;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.ps.getMetaData();
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkTransaction();
        try {
            this.setQueryTimeout();
            ResultSet resultSet = this.ps.executeQuery();
            return this.registerResultSet(resultSet);
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public int executeUpdate() throws SQLException {
        this.checkTransaction();
        try {
            this.setQueryTimeout();
            return this.ps.executeUpdate();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.ps.addBatch();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.ps.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.ps.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        try {
            this.ps.setBigDecimal(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setString(int parameterIndex, String value) throws SQLException {
        try {
            this.ps.setString(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        try {
            this.ps.setBytes(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setDate(int parameterIndex, Date value) throws SQLException {
        try {
            this.ps.setDate(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setDate(int parameterIndex, Date value, Calendar calendar) throws SQLException {
        try {
            this.ps.setDate(parameterIndex, value, calendar);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        try {
            this.ps.setTimestamp(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp value, Calendar calendar) throws SQLException {
        try {
            this.ps.setTimestamp(parameterIndex, value, calendar);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        try {
            this.ps.setAsciiStream(parameterIndex, stream, length);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        try {
            this.ps.setUnicodeStream(parameterIndex, stream, length);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        try {
            this.ps.setBinaryStream(parameterIndex, stream, length);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.ps.clearParameters();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setObject(int parameterIndex, Object value, int sqlType, int scale) throws SQLException {
        try {
            this.ps.setObject(parameterIndex, value, sqlType, scale);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setObject(int parameterIndex, Object value, int sqlType) throws SQLException {
        try {
            this.ps.setObject(parameterIndex, value, sqlType);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setObject(int parameterIndex, Object value) throws SQLException {
        try {
            this.ps.setObject(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.ps.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setRef(int parameterIndex, Ref value) throws SQLException {
        try {
            this.ps.setRef(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        try {
            this.ps.setBlob(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setClob(int parameterIndex, Clob value) throws SQLException {
        try {
            this.ps.setClob(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setArray(int parameterIndex, Array value) throws SQLException {
        try {
            this.ps.setArray(parameterIndex, value);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.ps.getParameterMetaData();
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }
}

