<?php

//   -------------------------------------------------------------------------------
//  |                  net2ftp: a web based FTP client                              |
//  |              Copyright (c) 2003-2009 by David Gartner                         |
//  |                                                                               |
//  | This program is free software; you can redistribute it and/or                 |
//  | modify it under the terms of the GNU General Public License                   |
//  | as published by the Free Software Foundation; either version 2                |
//  | of the License, or (at your option) any later version.                        |
//  |                                                                               |
//   -------------------------------------------------------------------------------

//   -------------------------------------------------------------------------------
//  | For credits, see the credits.txt file                                         |
//   -------------------------------------------------------------------------------
//  |                                                                               |
//  |                              INSTRUCTIONS                                     |
//  |                                                                               |
//  |  The messages to translate are listed below.                                  |
//  |  The structure of each line is like this:                                     |
//  |     $message["Hello world!"] = "Hello world!";                                |
//  |                                                                               |
//  |  Keep the text between square brackets [] as it is.                           |
//  |  Translate the 2nd part, keeping the same punctuation and HTML tags.          |
//  |                                                                               |
//  |  The English message, for example                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is written in PHP!";    |
//  |  should become after translation:                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp est ecrit en PHP!";     |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is geschreven in PHP!"; |
//  |                                                                               |
//  |  Note that the variable starts with a dollar sign $, that the value is        |
//  |  enclosed in double quotes " and that the line ends with a semi-colon ;       |
//  |  Be careful when editing this file, do not erase those special characters.    |
//  |                                                                               |
//  |  Some messages also contain one or more variables which start with a percent  |
//  |  sign, for example %1\$s or %2\$s. The English message, for example           |
//  |     $messages[...] = ["The file %1\$s was copied to %2\$s "]                  |
//  |  should becomes after translation:                                            |
//  |     $messages[...] = ["Le fichier %1\$s a t copi vers %2\$s "]             |
//  |                                                                               |
//  |  When a real percent sign % is needed in the text it is entered as %%         |
//  |  otherwise it is interpreted as a variable. So no, it's not a mistake.        |
//  |                                                                               |
//  |  Between the messages to translate there is additional PHP code, for example: |
//  |      if ($net2ftp_globals["state2"] == "rename") {           // <-- PHP code  |
//  |          $net2ftp_messages["Rename file"] = "Rename file";   // <-- message   |
//  |      }                                                       // <-- PHP code  |
//  |  This code is needed to load the messages only when they are actually needed. |
//  |  There is no need to change or delete any of that PHP code; translate only    |
//  |  the message.                                                                 |
//  |                                                                               |
//  |  Thanks in advance to all the translators!                                    |
//  |  David.                                                                       |
//  |                                                                               |
//   -------------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Language settings
// -------------------------------------------------------------------------

// HTML lang attribute
$net2ftp_messages["en"] = "fr";

// HTML dir attribute: left-to-right (LTR) or right-to-left (RTL)
$net2ftp_messages["ltr"] = "ltr";

// CSS style: align left or right (use in combination with LTR or RTL)
$net2ftp_messages["left"] = "left";
$net2ftp_messages["right"] = "right";

// Encoding
$net2ftp_messages["iso-8859-1"] = "iso-8859-1";


// -------------------------------------------------------------------------
// Status messages
// -------------------------------------------------------------------------

// When translating these messages, keep in mind that the text should not be too long
// It should fit in the status textbox

$net2ftp_messages["Connecting to the FTP server"] = "Connexion au serveur FTP";
$net2ftp_messages["Logging into the FTP server"] = "Identification au serveur FTPr";
$net2ftp_messages["Setting the passive mode"] = "Rglage du mode passif";
$net2ftp_messages["Getting the FTP system type"] = "Rcupration du type de systme FTP";
$net2ftp_messages["Changing the directory"] = "Changement de rpertoire";
$net2ftp_messages["Getting the current directory"] = "Rcupration du rpertoire courant";
$net2ftp_messages["Getting the list of directories and files"] = "Obtention de la liste des rpertoires et fichiers";
$net2ftp_messages["Parsing the list of directories and files"] = "Analyse de la liste des rpertoires et fichiers";
$net2ftp_messages["Logging out of the FTP server"] = "Dconnexion du serveur FTP";
$net2ftp_messages["Getting the list of directories and files"] = "Obtention de la liste des rpertoires et fichiers";
$net2ftp_messages["Printing the list of directories and files"] = "Affichage de la liste des rpertoires et fichiers";
$net2ftp_messages["Processing the entries"] = "Traitements des lments";
$net2ftp_messages["Processing entry %1\$s"] = "Traitement de l'lment %1\$s";
$net2ftp_messages["Checking files"] = "Contrle des fichiers";
$net2ftp_messages["Transferring files to the FTP server"] = "Transfert des fichiers sur le serveur FTP";
$net2ftp_messages["Decompressing archives and transferring files"] = "Dcompression des archives et transfert des fichiers";
$net2ftp_messages["Searching the files..."] = "Recherche des fichiers...";
$net2ftp_messages["Uploading new file"] = "Upload du nouveau fichier";
$net2ftp_messages["Reading the file"] = "Lecture du fichier";
$net2ftp_messages["Parsing the file"] = "Analyse du fichier";
$net2ftp_messages["Reading the new file"] = "Lecture du nouveau fichier";
$net2ftp_messages["Reading the old file"] = "Lecture de l'ancien fichier";
$net2ftp_messages["Comparing the 2 files"] = "Comparaison des 2 fichiers";
$net2ftp_messages["Printing the comparison"] = "Affichage de la comparaison";
$net2ftp_messages["Sending FTP command %1\$s of %2\$s"] = "Envoi de la commande FTP %1\$s sur %2\$s";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Rcupration de l'archive %1\$s sur %2\$s depuis le serveur FTP";
$net2ftp_messages["Creating a temporary directory on the FTP server"] = "Cration d'un rpertoire temporaire sur le serveur FTP";
$net2ftp_messages["Setting the permissions of the temporary directory"] = "Changement des permission sur le rpertoire temporaire";
$net2ftp_messages["Copying the net2ftp installer script to the FTP server"] = "Copie du script d'installation sur le serveur FTP";
$net2ftp_messages["Script finished in %1\$s seconds"] = "Script excut en %1\$s secondes";
$net2ftp_messages["Script halted"] = "Script arrt";

// Used on various screens
$net2ftp_messages["Please wait..."] = "Merci de patienter...";


// -------------------------------------------------------------------------
// index.php
// -------------------------------------------------------------------------
$net2ftp_messages["Unexpected state string: %1\$s. Exiting."] = "tat inattendu: %1\$s. Terminaison.";
$net2ftp_messages["This beta function is not activated on this server."] = "Cette fonction est en phase de test; elle n'est pas encore active sur ce serveur.";
$net2ftp_messages["This function has been disabled by the Administrator of this website."] = "Cette fonction a t dsactive par l'Administrateur de ce site web.";


// -------------------------------------------------------------------------
// /includes/browse.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["The directory <b>%1\$s</b> does not exist or could not be selected, so the directory <b>%2\$s</b> is shown instead."] = "Le rpertoire <b>%1\$s</b> n'existe pas ou ne peux pas tre affich. Le rpertoire <b>%2\$s</b> est donc affich  la place.";
$net2ftp_messages["Your root directory <b>%1\$s</b> does not exist or could not be selected."] = "Le rpertoire racine <b>%1\$s</b> n'existe pas, ou ne peux pas tre affich.";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist."] = "Le rpertoire <b>%1\$s</b> ne peux tre affich - Il est possible que vous n'ayez pas de droits d'accs  ce rpertoire, ou bien de rpertoire n'existe pas.";
$net2ftp_messages["Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp."] = "Une entre contient des mots clef bannis, ceci pour eviter les risque phishing";
$net2ftp_messages["Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted."] = "Les fichiers trop gros ne pourrons tre tlchargs, uploads, copis, dplacs, vus ou dits; Ils ne pourrons qu'tre renomms ou effacs.";
$net2ftp_messages["Execute %1\$s in a new window"] = "Excuter %1\$s dans une nouvelle fentre";


// -------------------------------------------------------------------------
// /includes/main.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Please select at least one directory or file!"] = "Veuillez slectioner au moins un rpertoire ou un fichier !";


// -------------------------------------------------------------------------
// /includes/authorizations.inc.php
// -------------------------------------------------------------------------

// checkAuthorization()
$net2ftp_messages["The FTP server <b>%1\$s</b> is not in the list of allowed FTP servers."] = "Le serveur FTP <b>%1\$s</b> ne fait pas partie des serveur FTP autoriss.";
$net2ftp_messages["The FTP server <b>%1\$s</b> is in the list of banned FTP servers."] = "Le serveur FTP <b>%1\$s</b> fait partie des serveurs FTP bannis.";
$net2ftp_messages["The FTP server port %1\$s may not be used."] = "Le port %1\$s du seveur FTP ne peut pas tre utilis.";
$net2ftp_messages["Your IP address (%1\$s) is not in the list of allowed IP addresses."] = "Votre adresse IP (%1\$s) n'est pas dans la liste des IP autorises.";
$net2ftp_messages["Your IP address (%1\$s) is in the list of banned IP addresses."] = "Votre adresse IP (%1\$s) a t bannie de ce serveur FTP.";

// isAuthorizedDirectory()
$net2ftp_messages["Table net2ftp_users contains duplicate rows."] = "La table net2ftp_users contient des entres en double.";

// logAccess(), logLogin(), logError()
$net2ftp_messages["Unable to execute the SQL query."] = "Impossible d'excuter la requte SQL.";
$net2ftp_messages["Unable to open the system log."] = "Impossible d'ouvrir le journal systme.";
$net2ftp_messages["Unable to write a message to the system log."] = "Impossible d'crire dans le journal systme.";

// checkAdminUsernamePassword()
$net2ftp_messages["You did not enter your Administrator username or password."] = "Vous devez saisir un identifiant et un mot de passe Administrateur.";
$net2ftp_messages["Wrong username or password. Please try again."] = "Identifiant ou mot de passe invalide. Veuillez ressayer.";


// -------------------------------------------------------------------------
// /includes/consumption.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Unable to determine your IP address."] = "Impossible de dterminer votre adresse IP.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate rows."] = "La table net2ftp_log_consumption_ipaddress contient des doubles records.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate rows."] = "La table net2ftp_log_consumption_ftpserver contient des doubles records.";
$net2ftp_messages["The variable <b>consumption_ipaddress_datatransfer</b> is not numeric."] = "La variable <b>consumption_ipaddress_datatransfer</b> n'est pas numrique.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress could not be updated."] = "La table net2ftp_log_consumption_ipaddress n'a pas pu tre mise  jour.";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate entries."] = "La table net2ftp_log_consumption_ipaddress contient des lments en doubles.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver could not be updated."] = "La table net2ftp_log_consumption_ftpserver n'a pas pu tre mise  jour.";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate entries."] = "La table net2ftp_log_consumption_ftpserver contient des lments en doubles.";
$net2ftp_messages["Table net2ftp_log_access could not be updated."] = "La table net2ftp_log_access ne peut pas tre mise  jour.";
$net2ftp_messages["Table net2ftp_log_access contains duplicate entries."] = "La table net2ftp_log_access contient des lments en doubles.";


// -------------------------------------------------------------------------
// /includes/database.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Impossible de se connecter a la base MySQL. Vrifiez vos prfrences de base MySQL dans le fichier de configuration de net2ftp settings.inc.php.";
$net2ftp_messages["Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Impossible de selectionner la base MySQL. Vrifiez vos prfrences de base MySQL dans le fichier de configuration de net2ftp settings.inc.php.";


// -------------------------------------------------------------------------
// /includes/errorhandling.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["An error has occured"] = "Une erreur s'est produite";
$net2ftp_messages["Go back"] = "Revenir en arrire";
$net2ftp_messages["Go to the login page"] = "Aller  la page de connexion";


// -------------------------------------------------------------------------
// /includes/filesystem.inc.php
// -------------------------------------------------------------------------

// ftp_openconnection()
$net2ftp_messages["The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a><br />"] = "Le <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">module FTP de PHP</a> n'est pas install sur ce serveur.<br /><br /> L'administrateur de ce site devrait l'installer. Vous trouverez les instructions d'installation sur <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a><br />";
$net2ftp_messages["Unable to connect to FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Impossible de se connecter au serveur FTP <b>%1\$s</b> sur le port <b>%2\$s</b>.<br /><br />tes-vous sr que c'est la bonne adresse du serveur FTP ? Cette adresse est souvent diffrente de celle du serveur HTTP (web). Veuillez contacter votre fournisseur internet ou l'administrateur du systme pour obtenir de l'aide.<br />";
$net2ftp_messages["Unable to login to FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Impossible de se connecter au serveur FTP <b>%1\$s</b> avec le nom d'utilisateur <b>%2\$s</b>.<br /><br />tes-vous sr que votre nom d'utilisateur et mot de passe sont corrects? Veuillez contacter votre fournisseur internet ou l'administrateur du systme pour obtenir de l'aide.<br />";
$net2ftp_messages["Unable to switch to the passive mode on FTP server <b>%1\$s</b>."] = "Impossible de se mettre en mode passif sur le serveur FTP <b>%1\$s</b>.";

// ftp_openconnection2()
$net2ftp_messages["Unable to connect to the second (target) FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the second (target) FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "Impossible de se connecter au deuxime serveur FTP <b>%1\$s</b> sur le port <b>%2\$s</b>.<br /><br />tes-vous sr que c'est la bonne adresse du serveur FTP ? Cette adresse est souvent diffrente de celle du serveur HTTP (web). Veuillez contacter votre fournisseur internet ou l'administrateur du systme pour obtenir de l'aide.<br />";
$net2ftp_messages["Unable to login to the second (target) FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "Impossible de se connecter au deuxime serveur FTP <b>%1\$s</b> sur le port <b>%2\$s</b>.<br /><br />tes-vous sr que c'est la bonne adresse du serveur FTP ? Cette adresse est souvent diffrente de celle du serveur HTTP (web). Veuillez contacter votre fournisseur internet ou l'administrateur du systme pour obtenir de l'aide.<br />";
$net2ftp_messages["Unable to switch to the passive mode on the second (target) FTP server <b>%1\$s</b>."] = "Impossible de se mettre en mode passif sur le deuxime serveur FTP <b>%1\$s</b>.";

// ftp_myrename()
$net2ftp_messages["Unable to rename directory or file <b>%1\$s</b> into <b>%2\$s</b>"] = "Impossible de renommer le rpertoire/fichier <b>%1\$s</b> en <b>%2\$s</b>";

// ftp_mychmod()
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>. Note that the CHMOD command is only available on Unix FTP servers, not on Windows FTP servers."] = "Impossible d'excuter la commande <b>%1\$s</b>. Remarque : les commandes CHMOD sont uniquement possibles sur les serveurs FTP Unix, non sur les serveurs FTP Windows.";
$net2ftp_messages["Directory <b>%1\$s</b> successfully chmodded to <b>%2\$s</b>"] = "Le CHMOD du rpertoire <b>%1\$s</b> a t chang avec succs pour <b>%2\$s</b>";
$net2ftp_messages["Processing entries within directory <b>%1\$s</b>:"] = "Analyse des lments du rpertoire <b>%1\$s</b>:";
$net2ftp_messages["File <b>%1\$s</b> was successfully chmodded to <b>%2\$s</b>"] = "Le CHMOD du fichier <b>%1\$s</b> a t chang avec succs pour <b>%2\$s</b>";
$net2ftp_messages["All the selected directories and files have been processed."] = "Tous les rpertoires et fichiers slectionns ont t traits avec succs.";

// ftp_rmdir2()
$net2ftp_messages["Unable to delete the directory <b>%1\$s</b>"] = "Impossible de supprimer le rpertoire <b>%1\$s</b>";

// ftp_delete2()
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "Impossible de supprimer le fichier <b>%1\$s</b>";

// ftp_newdirectory()
$net2ftp_messages["Unable to create the directory <b>%1\$s</b>"] = "Impossible de crer le rpertoire <b>%1\$s</b>";

// ftp_readfile()
$net2ftp_messages["Unable to create the temporary file"] = "Impossible de crer le fichier temporaire";
$net2ftp_messages["Unable to get the file <b>%1\$s</b> from the FTP server and to save it as temporary file <b>%2\$s</b>.<br />Check the permissions of the %3\$s directory.<br />"] = "Impossible d'accder au fichier <b>%1\$s</b> sur le serveur FTP et de le sauvegarder comme le fichier temporaire <b>%2\$s</b>.<br />Vrifiez les permissions du rpertoire %3\$s .<br />";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "Impossible d'ouvrir le fichier temporaire. Verifiez les permissions du rpertoire %1\$s .";
$net2ftp_messages["Unable to read the temporary file"] = "Impossible de lire le fichier temporaire";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "Impossible de fermer le pointeur du fichier temporaire.";
$net2ftp_messages["Unable to delete the temporary file"] = "Impossible de supprimer le fichier temporaire";

// ftp_writefile()
$net2ftp_messages["Unable to create the temporary file. Check the permissions of the %1\$s directory."] = "Impossible de crer le fichier temporaire. Vrifiez les permissions du rpertoire %1\$s .";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "Impossible d'ouvrir le fichier temporaire. Verifiez les permissions du rpertoire %1\$s .";
$net2ftp_messages["Unable to write the string to the temporary file <b>%1\$s</b>.<br />Check the permissions of the %2\$s directory."] = "Impossible d'crire la chane de caractres dans le fichier temporaire <b>%1\$s</b>.<br />Vrifiez les permissions du rpertoire %2\$s .";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "Impossible de fermer le pointeur du fichier temporaire.";
$net2ftp_messages["Unable to put the file <b>%1\$s</b> on the FTP server.<br />You may not have write permissions on the directory."] = "Impossible de mettre le fichier <b>%1\$s</b> sur le serveur FTP.<br />Il est possible que vous ne puissiez pas d'crire dans ce rpertoire.";
$net2ftp_messages["Unable to delete the temporary file"] = "Impossible de supprimer le fichier temporaire";

// ftp_copymovedelete()
$net2ftp_messages["Processing directory <b>%1\$s</b>"] = "Traitement du rpetoire <b>%1\$s</b>";
$net2ftp_messages["The target directory <b>%1\$s</b> is the same as or a subdirectory of the source directory <b>%2\$s</b>, so this directory will be skipped"] = "Le rpertoire de destination <b>%1\$s</b> est identique ou est un sous-rpertoire du rpertoire source <b>%2\$s</b>, et donc ce rpertoire va tre omis";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped"] = "The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The directory <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing the copy/move process..."] = "Impossible de crer le sous-rpertoire <b>%1\$s</b>. Il existe peut-tre dj. Le processus de copie/dplacement continue...";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "Sous-rpertoire cible cr <b>%1\$s</b>";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected, so this directory will be skipped"] = "Le rpertoire <b>%1\$s</b> ne peut pas tre lu, il sera donc omis";
$net2ftp_messages["Unable to delete the subdirectory <b>%1\$s</b> - it may not be empty"] = "Impossible de supprimer le sous-rpertoire <b>%1\$s</b> - il n'est peut-tre pas vide";
$net2ftp_messages["Deleted subdirectory <b>%1\$s</b>"] = "Sous-rpertoire <b>%1\$s</b> effac";
$net2ftp_messages["Processing of directory <b>%1\$s</b> completed"] = "Traitement du rpertoire <b>%1\$s</b> achev";
$net2ftp_messages["The target for file <b>%1\$s</b> is the same as the source, so this file will be skipped"] = "La destination du fichier <b>%1\$s</b> est la mme que la source, donc ce fichier sera omis";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped"] = "Le fichier <b>%1\$s</b> contient un mot clef interdit, ce fichier sera omis";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, aborting the move"] = "Le fichier <b>%1\$s</b> contient un mot clef interdit, dplacement avort";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be copied, so this file will be skipped"] = "Le fichier <b>%1\$s</b> est trop gros pour tre copi, il sera omis";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be moved, aborting the move"] = "Le fichier <b>%1\$s</b> est trop gros pour tre dplac, dplacement avort";
$net2ftp_messages["Unable to copy the file <b>%1\$s</b>"] = "Impossible de copier le fichier <b>%1\$s</b>";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "Fichier <b>%1\$s</b> copi";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>, aborting the move"] = "Impossible de dplacer le fichier <b>%1\$s</b>, dplacement avort";
$net2ftp_messages["Moved file <b>%1\$s</b>"] = "Fichier <b>%1\$s</b> dplac";
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "Impossible de supprimer le fichier <b>%1\$s</b>";
$net2ftp_messages["Deleted file <b>%1\$s</b>"] = "Fichier <b>%1\$s</b> supprim";
$net2ftp_messages["All the selected directories and files have been processed."] = "Tous les rpertoires et fichiers slectionns ont t traits avec succs.";

// ftp_processfiles()

// ftp_getfile()
$net2ftp_messages["Unable to copy the remote file <b>%1\$s</b> to the local file using FTP mode <b>%2\$s</b>"] = "Impossible de copier le fichier distant <b>%1\$s</b> vers le fichier local en utilisant le mode FTP <b>%2\$s</b>";
$net2ftp_messages["Unable to delete file <b>%1\$s</b>"] = "Impossible de supprimer le fichier <b>%1\$s</b>";

// ftp_putfile()
$net2ftp_messages["The file is too big to be transferred"] = "Le fichier est trop gros pour tre transfer";
$net2ftp_messages["Daily limit reached: the file <b>%1\$s</b> will not be transferred"] = "Limite journalire atteinte: le fichier <b>%1\$s</b> ne sera pas transfr";
$net2ftp_messages["Unable to copy the local file to the remote file <b>%1\$s</b> using FTP mode <b>%2\$s</b>"] = "Impossible de copier le fichier local vers le fichier distant <b>%1\$s</b> en utilisant le mode FTP<b>%2\$s</b>";
$net2ftp_messages["Unable to delete the local file"] = "Impossible de supprimer le fichier local";

// ftp_downloadfile()
$net2ftp_messages["Unable to delete the temporary file"] = "Impossible de supprimer le fichier temporaire";
$net2ftp_messages["Unable to send the file to the browser"] = "Impossible d'envoyer le fichier au navigateur";

// ftp_zip()
$net2ftp_messages["Unable to create the temporary file"] = "Impossible de crer le fichier temporaire";
$net2ftp_messages["The zip file has been saved on the FTP server as <b>%1\$s</b>"] = "Le fichier zip a t sauvegard sur le serveur FTP en tant que <b>%1\$s</b>";
$net2ftp_messages["Requested files"] = "Fichiers demands";

$net2ftp_messages["Dear,"] = "Cher,";
$net2ftp_messages["Someone has requested the files in attachment to be sent to this email account (%1\$s)."] = "Quelqu'un a demand que les fichiers joints soient envoys  cette adresse lectronique (%1\$s).";
$net2ftp_messages["If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment."] = "Si vous n'avez aucune ide de ce que c'est ou vous ne faites pas confiance  cette personne, veuillez supprimer ce courriel sans ouvrir le fichier zip attach.";
$net2ftp_messages["Note that if you don't open the Zip file, the files inside cannot harm your computer."] = "Notez que si nous n'ouvrez pas le fichier zip, les fichiers  l'intrieur de celui-ci ne peuvent pas endommager votre ordinateur.";
$net2ftp_messages["Information about the sender: "] = "Informations  propos de l'expditeur: ";
$net2ftp_messages["IP address: "] = "Adresse IP: ";
$net2ftp_messages["Time of sending: "] = "Heure de l'envoi: ";
$net2ftp_messages["Sent via the net2ftp application installed on this website: "] = "Envoy via le programme net2ftp install sur ce serveur: ";
$net2ftp_messages["Webmaster's email: "] = "Adresse email du Webmaster: ";
$net2ftp_messages["Message of the sender: "] = "Message de l'expditeur: ";
$net2ftp_messages["net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com."] = "net2ftp est un logiciel libre, publi sous la licence GNU/GPL. Pour plus d'informations, veuillez visiter http://www.net2ftp.com.";

$net2ftp_messages["The zip file has been sent to <b>%1\$s</b>."] = "Le fichier zip a bien t envoy  <b>%1\$s</b>.";

// acceptFiles()
$net2ftp_messages["File <b>%1\$s</b> is too big. This file will not be uploaded."] = "Le fichier <b>%1\$s</b> est trop gros : il n'a donc pas t upload";
$net2ftp_messages["File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded."] = "Le fichier <b>%1\$s</b> contient un mot clef interdit. Ce fichier ne sera pas upload.";
$net2ftp_messages["Could not generate a temporary file."] = "Impossible de gnrer le fichier temporaire.";
$net2ftp_messages["File <b>%1\$s</b> could not be moved"] = "Le fichier <b>%1\$s</b> ne peut tre dplac";
$net2ftp_messages["File <b>%1\$s</b> is OK"] = "Le fichier <b>%1\$s</b> est correct";
$net2ftp_messages["Unable to move the uploaded file to the temp directory.<br /><br />The administrator of this website has to <b>chmod 777</b> the /temp directory of net2ftp."] = "Impossible de dplacer le fichier upload vers le rpertoire /temp.<br /><br />L'administrateur de ce site doit mettre le <b>chmod</b> du rpertoire /temp de net2ftp  <b>777</b>.";
$net2ftp_messages["You did not provide any file to upload."] = "Vous n'avez fourni aucun fichier  uploader.";

// ftp_transferfiles()
$net2ftp_messages["File <b>%1\$s</b> could not be transferred to the FTP server"] = "Le fichier <b>%1\$s</b> n'a pu tre transfr vers le serveur FTP";
$net2ftp_messages["File <b>%1\$s</b> has been transferred to the FTP server using FTP mode <b>%2\$s</b>"] = "Le fichier <b>%1\$s</b> a t transfr vers le serveur FTP en utilisant le mode FTP <b>%2\$s</b>";
$net2ftp_messages["Transferring files to the FTP server"] = "Transfert des fichiers sur le serveur FTP";

// ftp_unziptransferfiles()
$net2ftp_messages["Processing archive nr %1\$s: <b>%2\$s</b>"] = "Traitement de l'archive numro %1\$s: <b>%2\$s</b>";
$net2ftp_messages["Archive <b>%1\$s</b> was not processed because its filename extension was not recognized. Only zip, tar, tgz and gz archives are supported at the moment."] = "L'archive <b>%1\$s</b> n'a pas t traite parce que son extension n'a pas t reconnue. Seulement les archives zip, tar, tgz et gz sont supportes pour le moment.";
$net2ftp_messages["Unable to extract the files and directories from the archive"] = "Impossible d'extraire les fichiers et rpertoire de cette archive";
$net2ftp_messages["Archive contains filenames with ../ or ..\\ - aborting the extraction"] = "L'archive contient des noms de fichier avec ../ or ..\\ - extraction avort";
$net2ftp_messages["Created directory %1\$s"] = "Rpertoire %1\$s cr";
$net2ftp_messages["Could not create directory %1\$s"] = "Ne peut crer le rpertoire %1\$s";
$net2ftp_messages["Copied file %1\$s"] = "Fichier %1\$s copi";
$net2ftp_messages["Could not copy file %1\$s"] = "Ne peut copier le fichier %1\$s";
$net2ftp_messages["Unable to delete the temporary directory"] = "Impossible d'effacer le rpertoire temporaire";
$net2ftp_messages["Unable to delete the temporary file %1\$s"] = "Impossible d'effacer le fichier temporaire %1\$s";

// ftp_mysite()
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>"] = "Impossible d'excuter la commande de site <b>%1\$s</b>";

// shutdown()
$net2ftp_messages["Your task was stopped"] = "Votre tche a t interrompue";
$net2ftp_messages["The task you wanted to perform with net2ftp took more time than the allowed %1\$s seconds, and therefor that task was stopped."] = "La tche que vous avez tent d'excuter avec net2ftp a pris plus de temps que les %1\$s secondes permises, ce pourquoi cette tche a t interrompue.";
$net2ftp_messages["This time limit guarantees the fair use of the web server for everyone."] = "Cette limite de temps garantit un usage adquat du serveur pour tout le monde.";
$net2ftp_messages["Try to split your task in smaller tasks: restrict your selection of files, and omit the biggest files."] = "Essayez de sparer votre tche en tches plus petites: restreignez votre slection de fichiers et dslectionnez les plus gros.";
$net2ftp_messages["If you really need net2ftp to be able to handle big tasks which take a long time, consider installing net2ftp on your own server."] = "Si vous avez vraiment besoin que netftp puisse grer des tches plus lourdes, veuillez considrez d'installer net2ftp sur votre propre serveur.";

// SendMail()
$net2ftp_messages["You did not provide any text to send by email!"] = "Vous n'avez spcifi aucun texte  envoyer par courriel!";
$net2ftp_messages["You did not supply a From address."] = "Vous n'avez pas spcifi une adresse d'expditeur.";
$net2ftp_messages["You did not supply a To address."] = "Vous n'avez pas spcifi une adresse de destinataire.";
$net2ftp_messages["Due to technical problems the email to <b>%1\$s</b> could not be sent."] = "D  des problmes techniques, le courriel destin  <b>%1\$s</b> n'a pu tre envoy.";


// -------------------------------------------------------------------------
// /includes/registerglobals.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Please enter your username and password for FTP server "] = "Veuillez saisir votre nom d'utilisateur et votre mot de passe du serveur FTP ";
$net2ftp_messages["You did not fill in your login information in the popup window.<br />Click on \"Go to the login page\" below."] = "Vous n'avez pas entr correctement vos information de connexion dans la fentre pop-up.<br />Cliquez sur \"Aller  la page de connexion\" ci-dessous.";
$net2ftp_messages["Access to the net2ftp Admin panel is disabled, because no password has been set in the file settings.inc.php. Enter a password in that file, and reload this page."] = "L'accs au panneau d'administration a t dsactiv parce qu'aucun mot de passe n'a t prcis dans le fichier settings.inc.php. Prcisez un mot de passe dans ce fichier, et rechargez cette page.";
$net2ftp_messages["Please enter your Admin username and password"] = "Veuillez saisir votre nom d'utilisateur et votre mot de passe administrateur";
$net2ftp_messages["You did not fill in your login information in the popup window.<br />Click on \"Go to the login page\" below."] = "Vous n'avez pas entr correctement vos information de connexion dans la fentre pop-up.<br />Cliquez sur \"Aller  la page de connexion\" ci-dessous.";
$net2ftp_messages["Wrong username or password for the net2ftp Admin panel. The username and password can be set in the file settings.inc.php."] = "Mauvais nom d'utilisateur ou mot de passe pour le panneau d'administration de net2ftp. Le nom d'utilisateur et le mot de passe peuvent tre configurs dans le fichier settings.inc.php.";


// -------------------------------------------------------------------------
// /skins/skins.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Blue"] = "Bleu";
$net2ftp_messages["Grey"] = "Gris";
$net2ftp_messages["Black"] = "Noir";
$net2ftp_messages["Yellow"] = "Jaune";
$net2ftp_messages["Pastel"] = "Pastel";

// getMime()
$net2ftp_messages["Directory"] = "Rpertoire";
$net2ftp_messages["Symlink"] = "Lien symbolique";
$net2ftp_messages["ASP script"] = "Script ASP";
$net2ftp_messages["Cascading Style Sheet"] = "Feuille de style CSS";
$net2ftp_messages["HTML file"] = "Fichier HTML";
$net2ftp_messages["Java source file"] = "Fichier source Java";
$net2ftp_messages["JavaScript file"] = "Fichier JavaScript";
$net2ftp_messages["PHP Source"] = "Source PHP";
$net2ftp_messages["PHP script"] = "Script PHP";
$net2ftp_messages["Text file"] = "Fichier Texte";
$net2ftp_messages["Bitmap file"] = "Image bitmap";
$net2ftp_messages["GIF file"] = "Image GIF";
$net2ftp_messages["JPEG file"] = "Image JPEG";
$net2ftp_messages["PNG file"] = "Image PNG";
$net2ftp_messages["TIF file"] = "Image TIFF";
$net2ftp_messages["GIMP file"] = "Fichier GIMP";
$net2ftp_messages["Executable"] = "Excutable";
$net2ftp_messages["Shell script"] = "Script shell";
$net2ftp_messages["MS Office - Word document"] = "MS Office - Document Word";
$net2ftp_messages["MS Office - Excel spreadsheet"] = "MS Office - Tableur Excel";
$net2ftp_messages["MS Office - PowerPoint presentation"] = "MS Office - Prsentation PowerPoint ";
$net2ftp_messages["MS Office - Access database"] = "MS Office - Base de donnes Access";
$net2ftp_messages["MS Office - Visio drawing"] = "MS Office - Document Visio";
$net2ftp_messages["MS Office - Project file"] = "MS Office - Fichier de projet";
$net2ftp_messages["OpenOffice - Writer 6.0 document"] = "OpenOffice - Document Writer 6.0";
$net2ftp_messages["OpenOffice - Writer 6.0 template"] = "OpenOffice - Fichier de description Writer 6.0";
$net2ftp_messages["OpenOffice - Calc 6.0 spreadsheet"] = "OpenOffice - Tableur Calc 6.0";
$net2ftp_messages["OpenOffice - Calc 6.0 template"] = "OpenOffice - Fichier de description Calc 6.0";
$net2ftp_messages["OpenOffice - Draw 6.0 document"] = "OpenOffice - Document Draw 6.0";
$net2ftp_messages["OpenOffice - Draw 6.0 template"] = "OpenOffice - Fichier de description Draw 6.0";
$net2ftp_messages["OpenOffice - Impress 6.0 presentation"] = "OpenOffice - Prsentation Impress 6.0";
$net2ftp_messages["OpenOffice - Impress 6.0 template"] = "OpenOffice - Fichier de description Impress 6.0";
$net2ftp_messages["OpenOffice - Writer 6.0 global document"] = "OpenOffice - Document global Writer 6.0";
$net2ftp_messages["OpenOffice - Math 6.0 document"] = "OpenOffice - Document Math 6.0";
$net2ftp_messages["StarOffice - StarWriter 5.x document"] = "StarOffice - Document StarWriter 5.x";
$net2ftp_messages["StarOffice - StarWriter 5.x global document"] = "StarOffice - Document global StarWriter 5.x";
$net2ftp_messages["StarOffice - StarCalc 5.x spreadsheet"] = "StarOffice - Tableur StarCalc 5.x";
$net2ftp_messages["StarOffice - StarDraw 5.x document"] = "StarOffice - Document StarDraw 5.x";
$net2ftp_messages["StarOffice - StarImpress 5.x presentation"] = "StarOffice - Prsentation StarImpress 5.x";
$net2ftp_messages["StarOffice - StarImpress Packed 5.x file"] = "StarOffice - Fichier StarImpress 5.x paquet";
$net2ftp_messages["StarOffice - StarMath 5.x document"] = "StarOffice - Document StarMath 5.x";
$net2ftp_messages["StarOffice - StarChart 5.x document"] = "StarOffice - Document StarChart 5.x";
$net2ftp_messages["StarOffice - StarMail 5.x mail file"] = "StarOffice - Fichier mail StarMail 5.x";
$net2ftp_messages["Adobe Acrobat document"] = "Document Adobe Acrobat";
$net2ftp_messages["ARC archive"] = "Archive ARC";
$net2ftp_messages["ARJ archive"] = "Archive ARJ";
$net2ftp_messages["RPM"] = "RPM";
$net2ftp_messages["GZ archive"] = "Archive GZ";
$net2ftp_messages["TAR archive"] = "Archive TAR";
$net2ftp_messages["Zip archive"] = "Archive ZIP";
$net2ftp_messages["MOV movie file"] = "Fichier film MOV";
$net2ftp_messages["MPEG movie file"] = "Fichier film MPEG";
$net2ftp_messages["Real movie file"] = "Fichier film Real";
$net2ftp_messages["Quicktime movie file"] = "Fichier film Quicktime";
$net2ftp_messages["Shockwave flash file"] = "Fichier shockwave flash";
$net2ftp_messages["Shockwave file"] = "Fichier shockwave";
$net2ftp_messages["WAV sound file"] = "Fichier son WAV";
$net2ftp_messages["Font file"] = "Fichier de police";
$net2ftp_messages["%1\$s File"] = "Fichier %1\$s";
$net2ftp_messages["File"] = "Fichier";

// getAction()
$net2ftp_messages["Back"] = "Retour";
$net2ftp_messages["Submit"] = "Soumettre";
$net2ftp_messages["Refresh"] = "Actualiser";
$net2ftp_messages["Details"] = "Dtails";
$net2ftp_messages["Icons"] = "Icnes";
$net2ftp_messages["List"] = "Liste";
$net2ftp_messages["Logout"] = "Dconnexion";
$net2ftp_messages["Help"] = "Aide";
$net2ftp_messages["Bookmark"] = "Favoris";
$net2ftp_messages["Save"] = "Sauvegarder";
$net2ftp_messages["Default"] = "Dfaut";


// -------------------------------------------------------------------------
// /skins/[skin]/footer.template.php and statusbar.template.php
// -------------------------------------------------------------------------
$net2ftp_messages["Help Guide"] = "Aide";
$net2ftp_messages["Forums"] = "Forums";
$net2ftp_messages["License"] = "Licence";
$net2ftp_messages["Powered by"] = "Soutenu par";
$net2ftp_messages["You are now taken to the net2ftp forums. These forums are for net2ftp related topics only - not for generic webhosting questions."] = "Vous allez tre redirig sur le forum de net2ftp. Ce forum est ddi aux sujets concernant net2ftp, et pas pour des problmes d\\'hbergement web.";


// -------------------------------------------------------------------------
// Admin module
if ($net2ftp_globals["state"] == "admin") {
// -------------------------------------------------------------------------

// /modules/admin/admin.inc.php
$net2ftp_messages["Admin functions"] = "Fonctions administratives";

// /skins/[skin]/admin1.template.php
$net2ftp_messages["Version information"] = "Informations sur la version";
$net2ftp_messages["This version of net2ftp is up-to-date."] = "Cette version de net2ftp est  jour.";
$net2ftp_messages["The latest version information could not be retrieved from the net2ftp.com server. Check the security settings of your browser, which may prevent the loading of a small file from the net2ftp.com server."] = "Les informations de mise--jour n'ont pas pu tre rcupres. Veuillez vrifier les paramtres de scurit de votre navigateur, qui pourrait empcher le tlchargement d'un petit fichier depuis le serveur net2ftp.com.";
$net2ftp_messages["Logging"] = "Archivage";
$net2ftp_messages["Date from:"] = "A partir de la date : ";
$net2ftp_messages["to:"] = "jusqu' : ";
$net2ftp_messages["Empty logs"] = "Archives vides";
$net2ftp_messages["View logs"] = "Visualiser les archives";
$net2ftp_messages["Go"] = "Go";
$net2ftp_messages["Setup MySQL tables"] = "Configurer les tables MySQL";
$net2ftp_messages["Create the MySQL database tables"] = "Crer les tables de la base de donnes MySQL";

} // end admin

// -------------------------------------------------------------------------
// Admin_createtables module
if ($net2ftp_globals["state"] == "admin_createtables") {
// -------------------------------------------------------------------------

// /modules/admin_createtables/admin_createtables.inc.php
$net2ftp_messages["Admin functions"] = "Fonctions administratives";
$net2ftp_messages["The handle of file %1\$s could not be opened."] = "Le pointeur sur le fichier %1\$s n'a pas pu tre ouvert.";
$net2ftp_messages["The file %1\$s could not be opened."] = "Le fichier %1\$s n'a pas pu tre ouvert.";
$net2ftp_messages["The handle of file %1\$s could not be closed."] = "Le pointeur sur le fichier %1\$s n'a pas pu tre ferm.";
$net2ftp_messages["The connection to the server <b>%1\$s</b> could not be set up. Please check the database settings you've entered."] = "La connexion au serveur <b>%1\$s</b> a choue. Veuillez vrifier les paramtres d'accs  la base de donnes.";
$net2ftp_messages["Unable to select the database <b>%1\$s</b>."] = "Impossible de slectionner la base <b>%1\$s</b>.";
$net2ftp_messages["The SQL query nr <b>%1\$s</b> could not be executed."] = "La requte SQL n <b>%1\$s</b> n'a pas pu tre excute.";
$net2ftp_messages["The SQL query nr <b>%1\$s</b> was executed successfully."] = "La requte SQL n <b>%1\$s</b> a t excute avec succs.";

// /skins/[skin]/admin_createtables1.template.php
$net2ftp_messages["Please enter your MySQL settings:"] = "Veuillez saisir vos paramtres MySQL : ";
$net2ftp_messages["MySQL username"] = "Utilisateur MySQL";
$net2ftp_messages["MySQL password"] = "Mot de passe MySQL";
$net2ftp_messages["MySQL database"] = "Nom de la base de donnes MySQL";
$net2ftp_messages["MySQL server"] = "Serveur MySQL";
$net2ftp_messages["This SQL query is going to be executed:"] = "Cette requte SQL va tre excute : ";
$net2ftp_messages["Execute"] = "Excuter";

// /skins/[skin]/admin_createtables2.template.php
$net2ftp_messages["Settings used:"] = "Paramtres utiliss : ";
$net2ftp_messages["MySQL password length"] = "Longueur du mot de passe MySQL";
$net2ftp_messages["Results:"] = "Rsultats : ";

} // end admin_createtables


// -------------------------------------------------------------------------
// Admin_viewlogs module
if ($net2ftp_globals["state"] == "admin_viewlogs") {
// -------------------------------------------------------------------------

// /modules/admin_createtables/admin_viewlogs.inc.php
$net2ftp_messages["Admin functions"] = "Fonctions administratives";
$net2ftp_messages["Unable to execute the SQL query <b>%1\$s</b>."] = "Impossible d'excuter la requte SQL <b>%1\$s</b>.";
$net2ftp_messages["No data"] = "Aucune donnes";

} // end admin_viewlogs


// -------------------------------------------------------------------------
// Admin_emptylogs module
if ($net2ftp_globals["state"] == "admin_emptylogs") {
// -------------------------------------------------------------------------

// /modules/admin_createtables/admin_emptylogs.inc.php
$net2ftp_messages["Admin functions"] = "Fonctions administratives";
$net2ftp_messages["The table <b>%1\$s</b> was emptied successfully."] = "La table <b>%1\$s</b> a t vide avec succs.";
$net2ftp_messages["The table <b>%1\$s</b> could not be emptied."] = "La table <b>%1\$s</b> n'a pu tre vide.";
$net2ftp_messages["The table <b>%1\$s</b> was optimized successfully."] = "La table <b>%1\$s</b> a t optimise.";
$net2ftp_messages["The table <b>%1\$s</b> could not be optimized."] = "La table <b>%1\$s</b> n'a pas pu tre optimise.";

} // end admin_emptylogs


// -------------------------------------------------------------------------
// Advanced module
if ($net2ftp_globals["state"] == "advanced") {
// -------------------------------------------------------------------------

// /modules/advanced/advanced.inc.php
$net2ftp_messages["Advanced functions"] = "Options avances";

// /skins/[skin]/advanced1.template.php
$net2ftp_messages["Go"] = "Go";
$net2ftp_messages["Disabled"] = "Dsactiv";
$net2ftp_messages["Advanced FTP functions"] = "Fonctions FTP avances";
$net2ftp_messages["Send arbitrary FTP commands to the FTP server"] = "Envoyer des commandes FTP arbitraires au serveur FTP";
$net2ftp_messages["This function is available on PHP 5 only"] = "Cette fonctionnalit n'est disponible qu'avec PHP5";
$net2ftp_messages["Troubleshooting functions"] = "Fonctions de dpannage";
$net2ftp_messages["Troubleshoot net2ftp on this webserver"] = "Dpanner net2ftp sur ce serveur";
$net2ftp_messages["Troubleshoot an FTP server"] = "Dpanner un serveur FTP";
$net2ftp_messages["Test the net2ftp list parsing rules"] = "Tester les rgles d'analyse de listes de net2ftp";
$net2ftp_messages["Translation functions"] = "Fonctions de traduction";
$net2ftp_messages["Introduction to the translation functions"] = "Introduction aux fonctions de traduction";
$net2ftp_messages["Extract messages to translate from code files"] = "Extraire les messages pour traduire  partir des fichiers de code";
$net2ftp_messages["Check if there are new or obsolete messages"] = "Vrifier s'il y a de nouveaux ou dsuets messages";

$net2ftp_messages["Beta functions"] = "Fonctions Beta";
$net2ftp_messages["Send a site command to the FTP server"] = "Envoyer une commande site au serveur FTP";
$net2ftp_messages["Apache: password-protect a directory, create custom error pages"] = "Apache : protger un rpertoire par mot de passe, crer des pages d'erreur personnalises";
$net2ftp_messages["MySQL: execute an SQL query"] = "MySQL : excuter une requte SQL";


// advanced()
$net2ftp_messages["The site command functions are not available on this webserver."] = "Les fonctions de commande ne sont pas disponibles sur ce serveur.";
$net2ftp_messages["The Apache functions are not available on this webserver."] = "Les fonctions d'Apache ne sont pas disponibles sur ce serveur.";
$net2ftp_messages["The MySQL functions are not available on this webserver."] = "Les fonctions de MySQL ne sont pas disponibles sur ce serveur.";
$net2ftp_messages["Unexpected state2 string. Exiting."] = "Chaine de caracteres inattendue. Quitter.";

} // end advanced


// -------------------------------------------------------------------------
// Advanced_ftpserver module
if ($net2ftp_globals["state"] == "advanced_ftpserver") {
// -------------------------------------------------------------------------

// /modules/advanced_ftpserver/advanced_ftpserver.inc.php
$net2ftp_messages["Troubleshoot an FTP server"] = "Dpanner un serveur FTP";

// /skins/[skin]/advanced_ftpserver1.template.php
$net2ftp_messages["Connection settings:"] = "Paramtres de connexion :";
$net2ftp_messages["FTP server"] = "Serveur FTP";
$net2ftp_messages["FTP server port"] = "Port du serveur FTP";
$net2ftp_messages["Username"] = "Nom d'utilisateur";
$net2ftp_messages["Password"] = "Mot de passe";
$net2ftp_messages["Password length"] = "Longueur du mot de passe";
$net2ftp_messages["Passive mode"] = "Mode passif";
$net2ftp_messages["Directory"] = "Rpertoire";
$net2ftp_messages["Printing the result"] = "Impression du rsultat";

// /skins/[skin]/advanced_ftpserver2.template.php
$net2ftp_messages["Connecting to the FTP server: "] = "Connexion au serveur FTP : ";
$net2ftp_messages["Logging into the FTP server: "] = "Identification sur le serveur FTP : ";
$net2ftp_messages["Setting the passive mode: "] = "Rglage du mode passif : ";
$net2ftp_messages["Getting the FTP server system type: "] = "Obtention du type de systme du serveur FTP: ";
$net2ftp_messages["Changing to the directory %1\$s: "] = "Changement pour le rpertoire %1\$s: ";
$net2ftp_messages["The directory from the FTP server is: %1\$s "] = "Le rpertoire du serveur FTP est: %1\$s ";
$net2ftp_messages["Getting the raw list of directories and files: "] = "Obtention de la liste des rpertoires et fichiers: ";
$net2ftp_messages["Trying a second time to get the raw list of directories and files: "] = "Seconde tentative d'obtention de la liste des rpertoires et fichiers: ";
$net2ftp_messages["Closing the connection: "] = "Fermeture de la connexion : ";
$net2ftp_messages["Raw list of directories and files:"] = "Liste des rpertoires et fichiers : ";
$net2ftp_messages["Parsed list of directories and files:"] = "Liste des rpertoires et fichiers analyss : ";

$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["not OK"] = "pas OK";

} // end advanced_ftpserver


// -------------------------------------------------------------------------
// Advanced_parsing module
if ($net2ftp_globals["state"] == "advanced_parsing") {
// -------------------------------------------------------------------------

$net2ftp_messages["Test the net2ftp list parsing rules"] = "Tester les rgles d'analyse de listes de net2ftp";
$net2ftp_messages["Sample input"] = "Entre de test";
$net2ftp_messages["Parsed output"] = "Sortie analyse";

} // end advanced_parsing


// -------------------------------------------------------------------------
// Advanced_webserver module
if ($net2ftp_globals["state"] == "advanced_webserver") {
// -------------------------------------------------------------------------

$net2ftp_messages["Troubleshoot your net2ftp installation"] = "Dpanner votre installation net2ftp";
$net2ftp_messages["Printing the result"] = "Impression du rsultat";

$net2ftp_messages["Checking if the FTP module of PHP is installed: "] = "Vrifier si le module PHP est prsent sur ce FTP: ";
$net2ftp_messages["yes"] = "oui";
$net2ftp_messages["no - please install it!"] = "non - installez-le svp!";

$net2ftp_messages["Checking the permissions of the directory on the web server: a small file will be written to the /temp folder and then deleted."] = "Contrle des permissions du rpertoire sur le serveur : un petit fichiers va tre cr dans le rpertoire /temp puis effac.";
$net2ftp_messages["Creating filename: "] = "Nom du fichier: ";
$net2ftp_messages["OK. Filename: %1\$s"] = "Ok. Nom du fichier: %1\$s";
$net2ftp_messages["not OK"] = "pas OK";
$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["not OK. Check the permissions of the %1\$s directory"] = "Incorrect. Vrifiez les permissions du rpertoire %1\$s ";
$net2ftp_messages["Opening the file in write mode: "] = "Ouvrir le fichier en mode criture : ";
$net2ftp_messages["Writing some text to the file: "] = "crire du texte dans le fichier : ";
$net2ftp_messages["Closing the file: "] = "Fermeture du fichier : ";
$net2ftp_messages["Deleting the file: "] = "Suppression du fichier : ";

$net2ftp_messages["Testing the FTP functions"] = "Test des fonctions FTP";
$net2ftp_messages["Connecting to a test FTP server: "] = "Connexion  un serveur FTP de test : ";
$net2ftp_messages["Connecting to the FTP server: "] = "Connexion au serveur FTP : ";
$net2ftp_messages["Logging into the FTP server: "] = "Identification sur le serveur FTP : ";
$net2ftp_messages["Setting the passive mode: "] = "Rglage du mode passif : ";
$net2ftp_messages["Getting the FTP server system type: "] = "Obtention du type de systme du serveur FTP: ";
$net2ftp_messages["Changing to the directory %1\$s: "] = "Changement pour le rpertoire %1\$s: ";
$net2ftp_messages["The directory from the FTP server is: %1\$s "] = "Le rpertoire du serveur FTP est: %1\$s ";
$net2ftp_messages["Getting the raw list of directories and files: "] = "Obtention de la liste des rpertoires et fichiers: ";
$net2ftp_messages["Trying a second time to get the raw list of directories and files: "] = "Seconde tentative d'obtention de la liste des rpertoires et fichiers: ";
$net2ftp_messages["Closing the connection: "] = "Fermeture de la connexion : ";
$net2ftp_messages["Raw list of directories and files:"] = "Liste des rpertoires et fichiers : ";
$net2ftp_messages["Parsed list of directories and files:"] = "Liste des rpertoires et fichiers analyss : ";
$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["not OK"] = "pas OK";

} // end advanced_webserver


// -------------------------------------------------------------------------
// Bookmark module
if ($net2ftp_globals["state"] == "bookmark") {
// -------------------------------------------------------------------------
$net2ftp_messages["Add this link to your bookmarks:"] = "Ajouter ce lien dans mes favoris : ";
$net2ftp_messages["Internet Explorer: right-click on the link and choose \"Add to Favorites...\""] = "Internet Explorer : clic droit sur le lien et choisir \"Ajouter aux favoris...\"";
$net2ftp_messages["Netscape, Mozilla, Firefox: right-click on the link and choose \"Bookmark This Link...\""] = "Netscape, Mozilla, Firefox : clic droit sur le lien et choisir \"Marque-page sur ce lien\"";
$net2ftp_messages["Note: when you will use this bookmark, a popup window will ask you for your username and password."] = "Remarque : quand vous cliquerez ce lien, une fentre pop-up vous demandera votre nom d'utilisateur et votre mot de passe.";

} // end bookmark


// -------------------------------------------------------------------------
// Browse module
if ($net2ftp_globals["state"] == "browse") {
// -------------------------------------------------------------------------

// /modules/browse/browse.inc.php
$net2ftp_messages["Choose a directory"] = "Choisir un rpertoire";
$net2ftp_messages["Please wait..."] = "Merci de patienter...";

// browse()
$net2ftp_messages["Directories with names containing \' cannot be displayed correctly. They can only be deleted. Please go back and select another subdirectory."] = "Les rpertoires dont le nom contient \' ne peuvent pas tre affichs correctement. Ils ne peuvent qu'tre effacs , revenez en arriere et choisissez un autre sous-rpertoire.";

$net2ftp_messages["Daily limit reached: you will not be able to transfer data"] = "Limite journalire atteinte : vous ne pourrez plus transfrer des donnes";
$net2ftp_messages["In order to guarantee the fair use of the web server for everyone, the data transfer volume and script execution time are limited per user, and per day. Once this limit is reached, you can still browse the FTP server but not transfer data to/from it."] = "Afin de garantir un usage quitable du serveur web pour tout le monde, le volume de transfert de donnes ainsi que le temps d'excution du script sont limits par utilisateur, et par jour. Une fois cette limite atteinte, vous pouvez toujours naviguer le serveur FTP mais plus transfrer de donnes.";
$net2ftp_messages["If you need unlimited usage, please install net2ftp on your own web server."] = "Si vous avez besoin d'un accs illimit, veuillez installer net2ftp sur votre propre serveur web.";

// printdirfilelist()
// Keep this short, it must fit in a small button!
$net2ftp_messages["New dir"] = "Nouveau rpertoire";
$net2ftp_messages["New file"] = "Nouveau fichier";
$net2ftp_messages["HTML templates"] = "Modles HTML";
$net2ftp_messages["Upload"] = "Upload";
$net2ftp_messages["Java Upload"] = "Upload Java";
$net2ftp_messages["Flash Upload"] = "Flash Upload";
$net2ftp_messages["Install"] = "Install";
$net2ftp_messages["Advanced"] = "Avanc";
$net2ftp_messages["Copy"] = "Copier";
$net2ftp_messages["Move"] = "Dplacer";
$net2ftp_messages["Delete"] = "Effacer";
$net2ftp_messages["Rename"] = "Renommer";
$net2ftp_messages["Chmod"] = "Chmod";
$net2ftp_messages["Download"] = "Tlcharger";
$net2ftp_messages["Unzip"] = "Unzip";
$net2ftp_messages["Zip"] = "Zip";
$net2ftp_messages["Size"] = "Taille";
$net2ftp_messages["Search"] = "Rechercher";
$net2ftp_messages["Go to the parent directory"] = "Aller dans le rpertoire superieur";
$net2ftp_messages["Go"] = "Go";
$net2ftp_messages["Transform selected entries: "] = "Transformer les entres selectionnes: ";
$net2ftp_messages["Transform selected entry: "] = "Transformer l'entre selectionne: ";
$net2ftp_messages["Make a new subdirectory in directory %1\$s"] = "Crer un nouveau sous-rpertoire dans le rpertoire %1\$s";
$net2ftp_messages["Create a new file in directory %1\$s"] = "Crer un nouveau fichier dans le rpertoire %1\$s";
$net2ftp_messages["Create a website easily using ready-made templates"] = "Crer facilement un site web en utilisant un modle prt--l'emploi";
$net2ftp_messages["Upload new files in directory %1\$s"] = "Upload d'un nouveau fichier dans le rpertoire %1\$s";
$net2ftp_messages["Upload directories and files using a Java applet"] = "Upload de rpertoires et de fichiers  travers une applet Java";
$net2ftp_messages["Upload files using a Flash applet"] = "Uploader des fichiers avec une applet Flash";
$net2ftp_messages["Install software packages (requires PHP on web server)"] = "Intalle des applications web (requiert PHP sur le serveur Web)";
$net2ftp_messages["Go to the advanced functions"] = "Aller dans les fonctions avances";
$net2ftp_messages["Copy the selected entries"] = "Copier les lments selectionns";
$net2ftp_messages["Move the selected entries"] = "Dplacer les lments selectionns";
$net2ftp_messages["Delete the selected entries"] = "Effacer les lments selectionns";
$net2ftp_messages["Rename the selected entries"] = "Renommer les lments selectionns";
$net2ftp_messages["Chmod the selected entries (only works on Unix/Linux/BSD servers)"] = "Rgler le CHMOD des lments selectionns (fonctionne uniquement sur les serveurs Unix/Linux/BSD)";
$net2ftp_messages["Download a zip file containing all selected entries"] = "Tlcharger un fichier .ZIP contenant tous les lments slectionns";
$net2ftp_messages["Unzip the selected archives on the FTP server"] = "Dzipper les archives slectionnes sur le serveur FTP";
$net2ftp_messages["Zip the selected entries to save or email them"] = "Crer un fichier .ZIP pour sauvegarder les lments selectionns ou les envoyer par courriel";
$net2ftp_messages["Calculate the size of the selected entries"] = "Calculer la taille des lments selectionns";
$net2ftp_messages["Find files which contain a particular word"] = "Trouver les fichiers qui contiennent un mot en particulier";
$net2ftp_messages["Click to sort by %1\$s in descending order"] = "Cliquer pour classer par %1\$s en ordre dcroissant";
$net2ftp_messages["Click to sort by %1\$s in ascending order"] = "Cliquer pour classer par %1\$s en ordre croissant";
$net2ftp_messages["Ascending order"] = "Ordre croissant";
$net2ftp_messages["Descending order"] = "Ordre dcroissant";
$net2ftp_messages["Upload files"] = "Uploader des fichiers";
$net2ftp_messages["Up"] = "Remonter";
$net2ftp_messages["Click to check or uncheck all rows"] = "Cliquer pour cocher ou decocher tous les lments";
$net2ftp_messages["All"] = "Tous";
$net2ftp_messages["Name"] = "Nom";
$net2ftp_messages["Type"] = "Type";
//$net2ftp_messages["Size"] = "Size";
$net2ftp_messages["Owner"] = "Propritaire";
$net2ftp_messages["Group"] = "Groupe";
$net2ftp_messages["Perms"] = "Permissions";
$net2ftp_messages["Mod Time"] = "Modifi le";
$net2ftp_messages["Actions"] = "Actions";
$net2ftp_messages["Select the directory %1\$s"] = "Slectionner le rpertoire %1\$s";
$net2ftp_messages["Select the file %1\$s"] = "Slectionner le fichier %1\$s";
$net2ftp_messages["Select the symlink %1\$s"] = "Select the symlink %1\$s";
$net2ftp_messages["Go to the subdirectory %1\$s"] = "Aller dans le sous-rpertoire %1\$s";
$net2ftp_messages["Download the file %1\$s"] = "Tlcharger le fichier %1\$s";
$net2ftp_messages["Follow symlink %1\$s"] = "Follow symlink %1\$s";
$net2ftp_messages["View"] = "Voir";
$net2ftp_messages["Edit"] = "diter";
$net2ftp_messages["Update"] = "Mettre  jour";
$net2ftp_messages["Open"] = "Ouvrir";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "Voir le code source surlign du fichier %1\$s";
$net2ftp_messages["Edit the source code of file %1\$s"] = "diter le code source du fichier %1\$s";
$net2ftp_messages["Upload a new version of the file %1\$s and merge the changes"] = "Uploader une nouvelle version du fichier %1\$s et fusionner les changements";
$net2ftp_messages["View image %1\$s"] = "Voir l'image %1\$s";
$net2ftp_messages["View the file %1\$s from your HTTP web server"] = "Voir le fichier %1\$s  partir de votre serveur HTTP";
$net2ftp_messages["(Note: This link may not work if you don't have your own domain name.)"] = "(Note: Ce lien peut ne pas fonctionner si vous n'avez pas votre propre nom de domaine.)";
$net2ftp_messages["This folder is empty"] = "Ce rpertoire est vide";

// printSeparatorRow()
$net2ftp_messages["Directories"] = "Rpertoires";
$net2ftp_messages["Files"] = "Fichiers";
$net2ftp_messages["Symlinks"] = "Liens symboliques";
$net2ftp_messages["Unrecognized FTP output"] = "Sortie FTP non reconnue";
$net2ftp_messages["Number"] = "Numro";
$net2ftp_messages["Size"] = "Taille";
$net2ftp_messages["Skipped"] = "Omis";
$net2ftp_messages["Data transferred from this IP address today"] = "Donnes transferr depuis cette IP aujourd'hui";
$net2ftp_messages["Data transferred to this FTP server today"] = "Donnes transferr sur ce serveur FTP aujourd'hui";

// printLocationActions()
$net2ftp_messages["Language:"] = "Langue : ";
$net2ftp_messages["Skin:"] = "Habillement : ";
$net2ftp_messages["View mode:"] = "Mode d'affichage : ";
$net2ftp_messages["Directory Tree"] = "Chemin actuel";

// ftp2http()
$net2ftp_messages["Execute %1\$s in a new window"] = "Excuter %1\$s dans une nouvelle fentre";
$net2ftp_messages["This file is not accessible from the web"] = "Ce fichier n'est pas accessible depuis le web.";

// printDirectorySelect()
$net2ftp_messages["Double-click to go to a subdirectory:"] = "Double-cliquer pour accder  un sous-rpertoire:";
$net2ftp_messages["Choose"] = "Choisir";
$net2ftp_messages["Up"] = "Remonter";

} // end browse


// -------------------------------------------------------------------------
// Calculate size module
if ($net2ftp_globals["state"] == "calculatesize") {
// -------------------------------------------------------------------------
$net2ftp_messages["Size of selected directories and files"] = "Taille des rpertoires et fichiers slectionns";
$net2ftp_messages["The total size taken by the selected directories and files is:"] = "La taille totale des rpertoires et fichiers slectionns est de : ";
$net2ftp_messages["The number of files which were skipped is:"] = "Le nombre de fichiers omis est de : ";

} // end calculatesize


// -------------------------------------------------------------------------
// Chmod module
if ($net2ftp_globals["state"] == "chmod") {
// -------------------------------------------------------------------------
$net2ftp_messages["Chmod directories and files"] = "Changer le chmod des rpertoires et des fichiers";
$net2ftp_messages["Set all permissions"] = "tablir toutes les permissions";
$net2ftp_messages["Read"] = "Lire";
$net2ftp_messages["Write"] = "crire";
$net2ftp_messages["Execute"] = "Excuter";
$net2ftp_messages["Owner"] = "Propritaire";
$net2ftp_messages["Group"] = "Groupe";
$net2ftp_messages["Everyone"] = "Tout le monde";
$net2ftp_messages["To set all permissions to the same values, enter those permissions and click on the button \"Set all permissions\""] = "Pour rgler toutes les permissions aux mmes valeurs, entrez ces permissions et cliquez sur le bouton \"tablir toutes les permissions\"";
$net2ftp_messages["Set the permissions of directory <b>%1\$s</b> to: "] = "tablir les permissions du rpertoire <b>%1\$s</b> : ";
$net2ftp_messages["Set the permissions of file <b>%1\$s</b> to: "] = "tablir les permissions du fichier <b>%1\$s</b> : ";
$net2ftp_messages["Set the permissions of symlink <b>%1\$s</b> to: "] = "tablir les permissions du symlink <b>%1\$s</b> : ";
$net2ftp_messages["Chmod value"] = "Valeur chmod";
$net2ftp_messages["Chmod also the subdirectories within this directory"] = "tablir le chmod sur les sous-rpertoires dans ce rpertoire galement";
$net2ftp_messages["Chmod also the files within this directory"] = "tablir le chmod sur les fichiers dans ce rpertoire galement";
$net2ftp_messages["The chmod nr <b>%1\$s</b> is out of the range 000-777. Please try again."] = "Le chmod <b>%1\$s</b> est  l'extrieur de l'intervalle 000-777. Veuillez essayer  nouveau.";

} // end chmod


// -------------------------------------------------------------------------
// Clear cookies module
// -------------------------------------------------------------------------
// No messages


// -------------------------------------------------------------------------
// Copy/Move/Delete module
if ($net2ftp_globals["state"] == "copymovedelete") {
// -------------------------------------------------------------------------
$net2ftp_messages["Choose a directory"] = "Choisir un rpertoire";
$net2ftp_messages["Copy directories and files"] = "Copier les rpertoires et les fichiers";
$net2ftp_messages["Move directories and files"] = "Dplacer les rpertoires et les fichiers";
$net2ftp_messages["Delete directories and files"] = "Supprimer les rpertoires et les fichiers";
$net2ftp_messages["Are you sure you want to delete these directories and files?"] = "tes-vous sur de vouloir supprimer ces rpertoires et fichiers?";
$net2ftp_messages["All the subdirectories and files of the selected directories will also be deleted!"] = "Tous les sous-rpertoires et fichiers des rpertoires slectionns vont aussi tre supprims";
$net2ftp_messages["Set all targetdirectories"] = "tablir tous les rpertoires cible";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "Pour tablir un rpertoire cible commun, saisissez le rpertoire cible dans la bote de texte ci-dessus et cliquez sur \"tablir tous les rpertoires cible\".";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = "Remarque : le rpertoire cible doit dja exister avant que quelque chose y soit copi.";
$net2ftp_messages["Different target FTP server:"] = "Diffrent serveur FTP comme cible:";
$net2ftp_messages["Username"] = "Nom d'utilisateur";
$net2ftp_messages["Password"] = "Mot de passe";
$net2ftp_messages["Leave empty if you want to copy the files to the same FTP server."] = "Laisser vide si vous copiez les fichiers vers le mme serveur FTP.";
$net2ftp_messages["If you want to copy the files to another FTP server, enter your login data."] = "Si vous voulez copier les fichiers vers un autre serveur FTP, veuillez saisir vos informations de connexion.";
$net2ftp_messages["Leave empty if you want to move the files to the same FTP server."] = "Laissez ce champ vide si vous voulez dplacer des fichiers sur le mme serveur FTP.";
$net2ftp_messages["If you want to move the files to another FTP server, enter your login data."] = "Si vous voulez dplacer ces ficheirs sur un autre serveur FTP, veuillez saisir vos identifiants.";
$net2ftp_messages["Copy directory <b>%1\$s</b> to:"] = "Copier le rpertoire <b>%1\$s</b> vers : ";
$net2ftp_messages["Move directory <b>%1\$s</b> to:"] = "Dplacer le rpertoire <b>%1\$s</b> vers : ";
$net2ftp_messages["Directory <b>%1\$s</b>"] = "Rpertoire <b>%1\$s</b>";
$net2ftp_messages["Copy file <b>%1\$s</b> to:"] = "Copier le fichier <b>%1\$s</b> vers : ";
$net2ftp_messages["Move file <b>%1\$s</b> to:"] = "Dplacer le fichier <b>%1\$s</b> vers : ";
$net2ftp_messages["File <b>%1\$s</b>"] = "Fichier <b>%1\$s</b>";
$net2ftp_messages["Copy symlink <b>%1\$s</b> to:"] = "Copier le lien symbolique <b>%1\$s</b> vers : ";
$net2ftp_messages["Move symlink <b>%1\$s</b> to:"] = "Dplacer le lien symbolique <b>%1\$s</b> vers : ";
$net2ftp_messages["Symlink <b>%1\$s</b>"] = "Lien symbolique <b>%1\$s</b>";
$net2ftp_messages["Target directory:"] = "Rpertoire cible : ";
$net2ftp_messages["Target name:"] = "Nom de la cible : ";
$net2ftp_messages["Processing the entries:"] = "Traitement des lments : ";

} // end copymovedelete


// -------------------------------------------------------------------------
// Download file module
// -------------------------------------------------------------------------
// No messages


// -------------------------------------------------------------------------
// EasyWebsite module
if ($net2ftp_globals["state"] == "easyWebsite") {
// -------------------------------------------------------------------------
$net2ftp_messages["Create a website in 4 easy steps"] = "Crez un site web en 4 pas";
$net2ftp_messages["Template overview"] = "Aperu";
$net2ftp_messages["Template details"] = "Dtails";
$net2ftp_messages["Files are copied"] = "Fichiers sont copis";
$net2ftp_messages["Edit your pages"] = "Editez vos pages";

// Screen 1 - printTemplateOverview
$net2ftp_messages["Click on the image to view the details of a template."] = "Cliquer sur l'image pour voir les dtails d'un modle.";
$net2ftp_messages["Back to the Browse screen"] = "Revenir  la page de navigation";
$net2ftp_messages["Template"] = "Modle";
$net2ftp_messages["Copyright"] = "Copyright";
$net2ftp_messages["Click on the image to view the details of this template"] = "Cliquer sur l'image pour voir les dtails de ce modle.";

// Screen 2 - printTemplateDetails
$net2ftp_messages["The template files will be copied to your FTP server. Existing files with the same filename will be overwritten. Do you want to continue?"] = "Les fichiers du modle vont tre copis sur votre serveur FTP. Les fichiers existants ayant le mme nom seront dtruits. Voulez-vous continuer ?";
$net2ftp_messages["Install template to directory: "] = "Installer le modle dans le rpertoire : ";
$net2ftp_messages["Install"] = "Install";
$net2ftp_messages["Size"] = "Taille";
$net2ftp_messages["Preview page"] = "Afficher l'aperu de la page";
$net2ftp_messages["opens in a new window"] = "ouvre dans une nouvelle fentre";

// Screen 3
$net2ftp_messages["Please wait while the template files are being transferred to your server: "] = "Veuillez patienter pendant que les fichiers du modle sont transfrs sur le serveur: ";
$net2ftp_messages["Done."] = "Fini.";
$net2ftp_messages["Continue"] = "Continuer";

// Screen 4 - printEasyAdminPanel
$net2ftp_messages["Edit page"] = "diter la page";
$net2ftp_messages["Browse the FTP server"] = "Naviguer sur le serveur FTP";
$net2ftp_messages["Add this link to your favorites to return to this page later on!"] = "Ajouter ce lien  vos favoris pour revenir plus tard sur cette page ! ";
$net2ftp_messages["Edit website at %1\$s"] = "diter le site Web  %1\$s";
$net2ftp_messages["Internet Explorer: right-click on the link and choose \"Add to Favorites...\""] = "Internet Explorer : clic droit sur le lien et choisir \"Ajouter aux favoris...\"";
$net2ftp_messages["Netscape, Mozilla, Firefox: right-click on the link and choose \"Bookmark This Link...\""] = "Netscape, Mozilla, Firefox : clic droit sur le lien et choisir \"Marque-page sur ce lien\"";

// ftp_copy_local2ftp
$net2ftp_messages["WARNING: Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing..."] = "ATTENTION : Impossible de crer le sous-rpertoire <b>%1\$s</b>. Il est possible qu'il existe dj. On continue...";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "Sous-rpertoire cible cr <b>%1\$s</b>";
$net2ftp_messages["WARNING: Unable to copy the file <b>%1\$s</b>. Continuing..."] = "ATTENTION : impossible de copier le fichier <b>%1\$s</b>. On continue...";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "Fichier <b>%1\$s</b> copi";
}


// -------------------------------------------------------------------------
// Edit module
if ($net2ftp_globals["state"] == "edit") {
// -------------------------------------------------------------------------

// /modules/edit/edit.inc.php
$net2ftp_messages["Unable to open the template file"] = "Impossible d'ouvrir le fichier de description";
$net2ftp_messages["Unable to read the template file"] = "Impossible de lire le fichier de description";
$net2ftp_messages["Please specify a filename"] = "Veuillez spcifier un nom de fichier";
$net2ftp_messages["Status: This file has not yet been saved"] = "Statut : Ce fichier n'a pas encore t sauvegard";
$net2ftp_messages["Status: Saved on <b>%1\$s</b> using mode %2\$s"] = "Statut : Sauvegard dans <b>%1\$s</b> en utilisant le mode %2\$s";
$net2ftp_messages["Status: <b>This file could not be saved</b>"] = "Statut : <b>Ce fichier n'a pas pu tre sauvegard</b>";
$net2ftp_messages["Not yet saved"] = "Not yet saved";
$net2ftp_messages["Could not be saved"] = "Could not be saved";
$net2ftp_messages["Saved at %1\$s"] = "Saved at %1\$s";

// /skins/[skin]/edit.template.php
$net2ftp_messages["Directory: "] = "Rpertoire : ";
$net2ftp_messages["File: "] = "Fichier : ";
$net2ftp_messages["New file name: "] = "Nom du nouveau fichier : ";
$net2ftp_messages["Character encoding: "] = "Character encoding: ";
$net2ftp_messages["Note: changing the textarea type will save the changes"] = "Remarque : changer le type de la zone de texte sauvegardera les changements";
$net2ftp_messages["Copy up"] = "Copier vers le haut";
$net2ftp_messages["Copy down"] = "Copier vers le bas";

} // end if edit


// -------------------------------------------------------------------------
// Find string module
if ($net2ftp_globals["state"] == "findstring") {
// -------------------------------------------------------------------------

// /modules/findstring/findstring.inc.php 
$net2ftp_messages["Search directories and files"] = "Rechercher dans des rpertoires et fichiers";
$net2ftp_messages["Search again"] = "Rpter la recherche";
$net2ftp_messages["Search results"] = "Rsultats de la recherche";
$net2ftp_messages["Please enter a valid search word or phrase."] = "Veuillez saisir un mot ou une phrase de recherche valide.";
$net2ftp_messages["Please enter a valid filename."] = "Veuillez saisir un nom de fichier valide.";
$net2ftp_messages["Please enter a valid file size in the \"from\" textbox, for example 0."] = "Veuillez saisir une taille de fichier valide dans le champ de saisie \"de\", comme par exemple 0.";
$net2ftp_messages["Please enter a valid file size in the \"to\" textbox, for example 500000."] = "Veuillez saisir une taille de fichier valide dans le champ de saisie \"\", comme par exemple 500000.";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"from\" textbox."] = "Veuillez saisir la date en utilisant le format A-m-j dans le champ de saisie \"de\".";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"to\" textbox."] = "Veuillez saisir la date en utilisant le format A-m-j dans le champ de saisie \"\".";
$net2ftp_messages["The word <b>%1\$s</b> was not found in the selected directories and files."] = "Le mot <b>%1\$s</b> n'a pas t trouv dans les rpertoires et fichiers slectionns.";
$net2ftp_messages["The word <b>%1\$s</b> was found in the following files:"] = "Le mot <b>%1\$s</b> a t trouv dans les fichiers suivants:";

// /skins/[skin]/findstring1.template.php
$net2ftp_messages["Search for a word or phrase"] = "Rechercher un mot ou une phrase";
$net2ftp_messages["Case sensitive search"] = "Recherche sensible  la casse";
$net2ftp_messages["Restrict the search to:"] = "Restreindre la recherche :";
$net2ftp_messages["files with a filename like"] = "fichiers avec un nom de fichier comme";
$net2ftp_messages["(wildcard character is *)"] = "(caractre joker est *)";
$net2ftp_messages["files with a size"] = "fichiers avec une taille";
$net2ftp_messages["files which were last modified"] = "fichiers rcemments modifis";
$net2ftp_messages["from"] = "de";
$net2ftp_messages["to"] = "";

$net2ftp_messages["Directory"] = "Rpertoire";
$net2ftp_messages["File"] = "Fichier";
$net2ftp_messages["Line"] = "Ligne";
$net2ftp_messages["Action"] = "Action";
$net2ftp_messages["View"] = "Voir";
$net2ftp_messages["Edit"] = "diter";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "Voir le code source surlign du fichier %1\$s";
$net2ftp_messages["Edit the source code of file %1\$s"] = "diter le code source du fichier %1\$s";

} // end findstring


// -------------------------------------------------------------------------
// Help module
// -------------------------------------------------------------------------
// No messages yet


// -------------------------------------------------------------------------
// Install size module
if ($net2ftp_globals["state"] == "install") {
// -------------------------------------------------------------------------

// /modules/install/install.inc.php
$net2ftp_messages["Install software packages"] = "Install software packages";
$net2ftp_messages["Unable to open the template file"] = "Impossible d'ouvrir le fichier de description";
$net2ftp_messages["Unable to read the template file"] = "Impossible de lire le fichier de description";
$net2ftp_messages["Unable to get the list of packages"] = "Impossible de rcuprer la liste des paquets";

// /skins/blue/install1.template.php
$net2ftp_messages["The net2ftp installer script has been copied to the FTP server."] = "Le script d'installation net2ftp a t copi sur le serveur FTP.";
$net2ftp_messages["This script runs on your web server and requires PHP to be installed."] = "Ce script est lanc sur votre serveur web et requiert que PHP soit install.";
$net2ftp_messages["In order to run it, click on the link below."] = "Pour le lancer, cliquer sur le lien ci-dessous.";
$net2ftp_messages["net2ftp has tried to determine the directory mapping between the FTP server and the web server."] = "net2ftp a essay de determiner la correspondance entre le serveur FTP et votre serveur web.";
$net2ftp_messages["Should this link not be correct, enter the URL manually in your web browser."] = "Si ce lien n'est pas correct, entrer l'URL manuellement dans votre navigateur web.";

} // end install


// -------------------------------------------------------------------------
// Java upload module
if ($net2ftp_globals["state"] == "jupload") {
// -------------------------------------------------------------------------
$net2ftp_messages["Upload directories and files using a Java applet"] = "Upload de rpertoires et de fichiers  travers une applet Java";
$net2ftp_messages["Number of files:"] = "Nombre de fichiers: ";
$net2ftp_messages["Size of files:"] = "Taille des fichiers: ";
$net2ftp_messages["Add"] = "Ajouter";
$net2ftp_messages["Remove"] = "Enlever";
$net2ftp_messages["Upload"] = "Upload";
$net2ftp_messages["Add files to the upload queue"] = "Ajouter les fichiers  la file d'attente d'upload";
$net2ftp_messages["Remove files from the upload queue"] = "Supprimer les fichiers de la file d'attente d'upload";
$net2ftp_messages["Upload the files which are in the upload queue"] = "Upload les fichiers de la file d'attente";
$net2ftp_messages["Maximum server space exceeded. Please select less/smaller files."] = "L'espace disque disponible sur le serveur a t dpass. Veuillez choisir des fichiers plus petits.";
$net2ftp_messages["Total size of the files is too big. Please select less/smaller files."] = "La taille totale des fichiers est trop grande. Veuillez choisir des fichiers plus petits.";
$net2ftp_messages["Total number of files is too high. Please select fewer files."] = "Le nombre total de fichiers est trop important. Veuillez choisir moins de fichiers.";
$net2ftp_messages["Note: to use this applet, Sun's Java plugin must be installed (version 1.4 or newer)."] = "Note : pour utiliser cette applet, le plugin Java de Sun doit tre install (version 1.4 ou plus).";

} // end jupload



// -------------------------------------------------------------------------
// Login module
if ($net2ftp_globals["state"] == "login") {
// -------------------------------------------------------------------------
$net2ftp_messages["Login!"] = "Login!";
$net2ftp_messages["Once you are logged in, you will be able to:"] = "Une fois que vous vous serez identifi, vous pourrez:";
$net2ftp_messages["Navigate the FTP server"] = "Naviguer sur le serveur FTP";
$net2ftp_messages["Once you have logged in, you can browse from directory to directory and see all the subdirectories and files."] = "Une fois identifi, vous pourrez naviguer de rpertoire en rpertoire, voir tous les sous-rpertoires ainsi que les fichiers.";
$net2ftp_messages["Upload files"] = "Uploader des fichiers";
$net2ftp_messages["There are 3 different ways to upload files: the standard upload form, the upload-and-unzip functionality, and the Java Applet."] = "Il existe 3 manires diffrentes d'uploader des fichiers. Le formulaire standard, le mode upload & unzip et l'applet Java";
$net2ftp_messages["Download files"] = "Tlcharger des fichiers";
$net2ftp_messages["Click on a filename to quickly download one file.<br />Select multiple files and click on Download; the selected files will be downloaded in a zip archive."] = "Cliquer sur un fichier pour le tlcharger directement.<br>En slectionnant plusieurs fichiers, cliquer sur \"Tlcharger\" vous permettra de tlcharger tous les fichiers dans une seule archive Zip";
$net2ftp_messages["Zip files"] = "Compresser des fichiers au format Zip";
$net2ftp_messages["... and save the zip archive on the FTP server, or email it to someone."] = "... et sauvegarder cette archive zip sur le serveur FTP, ou bien l'envoyer par courriel";
$net2ftp_messages["Unzip files"] = "Unzip files";
$net2ftp_messages["Different formats are supported: .zip, .tar, .tgz and .gz."] = "Differents formats sont supports: .zip, .tar, .tgz and .gz.";
$net2ftp_messages["Install software"] = "Install software";
$net2ftp_messages["Choose from a list of popular applications (PHP required)."] = "Choisissez parmi une liste d'applications (PHP requit).";
$net2ftp_messages["Copy, move and delete"] = "Copier, dplacer ou supprimer";
$net2ftp_messages["Directories are handled recursively, meaning that their content (subdirectories and files) will also be copied, moved or deleted."] = "Les rpertoires sont traits rcursivement. Tout leur contenu (sous-rpertoires et fichiers) sera galement copi, dplac ou supprim.";
$net2ftp_messages["Copy or move to a 2nd FTP server"] = "Copier ou dplacer sur un deuxime serveur FTP";
$net2ftp_messages["Handy to import files to your FTP server, or to export files from your FTP server to another FTP server."] = "Il est facile d'importer des fichiers sur votre serveur FTP, ou bien d'exporter des fichiers depuis votre serveur FTP sur un autre serveur FTP";
$net2ftp_messages["Rename and chmod"] = "Renommer et modifier les permissions (chmod)";
$net2ftp_messages["Chmod handles directories recursively."] = "Modifier les permissions se fait de manire rcursive sur les rpertoires.";
$net2ftp_messages["View code with syntax highlighting"] = "Afficher du code avec de la coloration syntaxique";
$net2ftp_messages["PHP functions are linked to the documentation on php.net."] = "Les fonctions PHP pointent sur la documentation disponible sur php.net.";
$net2ftp_messages["Plain text editor"] = "diteur de texte brut";
$net2ftp_messages["Edit text right from your browser; every time you save the changes the new file is transferred to the FTP server."] = "diter du texte depuis votre navigateur. Chaque fois que vous sauvegardez les changements, le fichier est automatiquement transfr sur le serveur FTP.";
$net2ftp_messages["HTML editors"] = "diteurs HTML";
$net2ftp_messages["Edit HTML a What-You-See-Is-What-You-Get (WYSIWYG) form; there are 2 different editors to choose from."] = "Editer le HTML avec un formulaire WYSIWYG; vous avez le choix entre deux diteurs";
$net2ftp_messages["Code editor"] = "diteur de code";
$net2ftp_messages["Edit HTML and PHP in an editor with syntax highlighting."] = "diter du code HTML et PHP avec de la coloration syntaxique.";
$net2ftp_messages["Search for words or phrases"] = "Rechercher des mots ou des expressions";
$net2ftp_messages["Filter out files based on the filename, last modification time and filesize."] = "Filtrer les fichiers par leur nom, leur date de dernire modification ou leur taille.";
$net2ftp_messages["Calculate size"] = "Calculer la taille";
$net2ftp_messages["Calculate the size of directories and files."] = "Calculer la taille des rpertoire et des fichiers.";

$net2ftp_messages["FTP server"] = "Serveur FTP";
$net2ftp_messages["Example"] = "Exemple";
$net2ftp_messages["Port"] = "Port";
$net2ftp_messages["Username"] = "Nom d'utilisateur";
$net2ftp_messages["Password"] = "Mot de passe";
$net2ftp_messages["Anonymous"] = "Anonyme";
$net2ftp_messages["Passive mode"] = "Mode passif";
$net2ftp_messages["Initial directory"] = "Rpertoire de dpart";
$net2ftp_messages["Language"] = "Langue";
$net2ftp_messages["Skin"] = "Habillement";
$net2ftp_messages["FTP mode"] = "Mode FTP";
$net2ftp_messages["Automatic"] = "Automatique";
$net2ftp_messages["Login"] = "Soumettre";
$net2ftp_messages["Clear cookies"] = "Effacer les cookies";
$net2ftp_messages["Admin"] = "Admin";
$net2ftp_messages["Please enter an FTP server."] = "Veuillez saisir un serveur FTP.";
$net2ftp_messages["Please enter a username."] = "Veuillez saisir un nom d'utilisateur.";
$net2ftp_messages["Please enter a password."] = "Veuillez saisir un mot de passe.";

} // end login


// -------------------------------------------------------------------------
// Login module
if ($net2ftp_globals["state"] == "login_small") {
// -------------------------------------------------------------------------

$net2ftp_messages["Please enter your Administrator username and password."] = "Veuillez saisir votre identifiant et votre mot de passe Administrateur.";
$net2ftp_messages["Please enter your username and password for FTP server <b>%1\$s</b>."] = "Veuillez entrer votre identifiant et mot de passe pour le serveur FTP <b>%1\$s</b>.";
$net2ftp_messages["Username"] = "Nom d'utilisateur";
$net2ftp_messages["Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Votre session a expire, veuillez entrer votre mot de passe pour le serveur FTP  <b>%1\$s</b> pour continuer.";
$net2ftp_messages["Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Votre IP a chang, veuillez entrer votre mot de passe pour le serveur FTP <b>%1\$s</b> pour continuer.";
$net2ftp_messages["Password"] = "Mot de passe";
$net2ftp_messages["Login"] = "Soumettre";
$net2ftp_messages["Continue"] = "Continuer";

} // end login_small


// -------------------------------------------------------------------------
// Logout module
if ($net2ftp_globals["state"] == "logout") {
// -------------------------------------------------------------------------

// logout.inc.php
$net2ftp_messages["Login page"] = "Page de connexion";

// logout.template.php
$net2ftp_messages["You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>."] = "Vous vous tes dconnect du serveur FTP. Pour vous reconnecter, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">suivez ce lien</a>.";
$net2ftp_messages["Note: other users of this computer could click on the browser's Back button and access the FTP server."] = "Remarque : les autres utilisateurs de cet ordinateur peuvent encore cliquez sur le bouton \"Prcdent\" du navigateur et accder au serveur FTP.";
$net2ftp_messages["To prevent this, you must close all browser windows."] = "Pour viter ceci, il faut fermer toutes les fentres du navigateur.";
$net2ftp_messages["Close"] = "Fermer";
$net2ftp_messages["Click here to close this window"] = "Cliquer ici pour fermer cette fentre";

} // end logout


// -------------------------------------------------------------------------
// New directory module
if ($net2ftp_globals["state"] == "newdir") {
// -------------------------------------------------------------------------
$net2ftp_messages["Create new directories"] = "Crer des nouveaux rpertoires";
$net2ftp_messages["The new directories will be created in <b>%1\$s</b>."] = "Les nouveaux rpertoires seront crs dans <b>%1\$s</b>.";
$net2ftp_messages["New directory name:"] = "Nom du nouveau rpertoire:";
$net2ftp_messages["Directory <b>%1\$s</b> was successfully created."] = "Le rpertoire <b>%1\$s</b> a t cr avec succs.";
$net2ftp_messages["Directory <b>%1\$s</b> could not be created."] = "Le rpertoire <b>%1\$s</b> n'a pas pu tre cr.";

} // end newdir


// -------------------------------------------------------------------------
// Raw module
if ($net2ftp_globals["state"] == "raw") {
// -------------------------------------------------------------------------

// /modules/raw/raw.inc.php
$net2ftp_messages["Send arbitrary FTP commands"] = "Envoyer des commandes FTP arbitraires";


// /skins/[skin]/raw1.template.php
$net2ftp_messages["List of commands:"] = "Liste des commandes : ";
$net2ftp_messages["FTP server response:"] = "Rponse du serveur FTP : ";

} // end raw


// -------------------------------------------------------------------------
// Rename module
if ($net2ftp_globals["state"] == "rename") {
// -------------------------------------------------------------------------
$net2ftp_messages["Rename directories and files"] = "Renommer des rpertoires et des fichiers";
$net2ftp_messages["Old name: "] = "Ancien nom : ";
$net2ftp_messages["New name: "] = "Nouveau nom : ";
$net2ftp_messages["The new name may not contain any dots. This entry was not renamed to <b>%1\$s</b>"] = "Le nouveau nom ne doit contenir aucun point. Cette entre n'a pas t renomme en <b>%1\$s</b>";
$net2ftp_messages["The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>"] = "Le nouveau nom ne peut pas contenir de mot clef interdis. cette entre n'a pas t renomme <b>%1\$s</b>";
$net2ftp_messages["<b>%1\$s</b> was successfully renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> a t renomm avec succs en <b>%2\$s</b>";
$net2ftp_messages["<b>%1\$s</b> could not be renamed to <b>%2\$s</b>"] = "<b>%1\$s</b> n'a pu tre renomm en <b>%2\$s</b>";

} // end rename


// -------------------------------------------------------------------------
// Unzip module
if ($net2ftp_globals["state"] == "unzip") {
// -------------------------------------------------------------------------

// /modules/unzip/unzip.inc.php
$net2ftp_messages["Unzip archives"] = "Dzipper les archives";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Rcupration de l'archive %1\$s sur %2\$s depuis le serveur FTP";
$net2ftp_messages["Unable to get the archive <b>%1\$s</b> from the FTP server"] = "Impossible de rcuprer l'archive <b>%1\$s</b> depuis le serveur FTP";

// /skins/[skin]/unzip1.template.php
$net2ftp_messages["Set all targetdirectories"] = "tablir tous les rpertoires cible";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "Pour tablir un rpertoire cible commun, saisissez le rpertoire cible dans la bote de texte ci-dessus et cliquez sur \"tablir tous les rpertoires cible\".";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = "Remarque : le rpertoire cible doit dja exister avant que quelque chose y soit copi.";
$net2ftp_messages["Unzip archive <b>%1\$s</b> to:"] = "Unzip archive <b>%1\$s</b> to:";
$net2ftp_messages["Target directory:"] = "Rpertoire cible : ";
$net2ftp_messages["Use folder names (creates subdirectories automatically)"] = "Utiliser les noms des rpertoires (crer les sous-rpertoires automatiquement)";

} // end unzip


// -------------------------------------------------------------------------
// Update file module
if ($net2ftp_globals["state"] == "updatefile") {
// -------------------------------------------------------------------------
$net2ftp_messages["Update file"] = "Mettre  jour le fichier";
$net2ftp_messages["<b>WARNING: THIS FUNCTION IS STILL IN EARLY DEVELOPMENT. USE IT ONLY ON TEST FILES! YOU HAVE BEEN WARNED!"] = "<b>ATTENTION: CETTE FONCTION EN EST ENCORE  SON STADE PRIMAIRE. NE L'UTILISEZ QU'AVEC DES FICHIERS TEST VOUS AUREZ T PRVENUS !";
$net2ftp_messages["Known bugs: - erases tab characters - doesn't work well with big files (> 50kB) - was not tested yet on files containing non-standard characters</b>"] = "Bugs connus: - Effacer les tabulations - ne fonctionne pas bien avec les gros fichiers(> 50kB) - n'a pas encore t test sur des fichiers contenant des caractres non-standard</b>";
$net2ftp_messages["This function allows you to upload a new version of the selected file, to view what are the changes and to accept or reject each change. Before anything is saved, you can edit the merged files."] = "Cette fonction vous permet d'uploader une nouvelle version du fichier slectionn, pour voir quels sont les changements puis pour les accepter ou les refuser. Avant que le tout soit enregistr vous pouvez modifier les fichiers fusionns.";
$net2ftp_messages["Old file:"] = "Ancien fichier : ";
$net2ftp_messages["New file:"] = "Nouveau fichier : ";
$net2ftp_messages["Restrictions:"] = "Restrictions : ";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s kB</b> and by PHP to <b>%2\$s</b>"] = "La taille maximale d'un fichier est restreinte  <b>%1\$s kB</b> par net2ftp et  <b>%2\$s</b> par PHP";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "Le temps d'excution maximum est de <b>%1\$s secondes</b>";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "Le mode de transfert FTP (ASCII ou BINARY) sera automatiquement dtermin selon l'extension du fichier";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "Si le fichier de destination existe dja il sera remplac par celui-ci";
$net2ftp_messages["You did not provide any files or archives to upload."] = "Vous n'avez fourni aucun fichier ou archive  uploader.";
$net2ftp_messages["Unable to delete the new file"] = "Impossible de supprimer le nouveau fichier";

// printComparisonSelect()
$net2ftp_messages["Please wait..."] = "Merci de patienter...";
$net2ftp_messages["Select lines below, accept or reject changes and submit the form."] = "Slectionner les lignes ci-dessous, acceptez ou refusez les changements et soumettez le formulaire.";

} // end updatefile


// -------------------------------------------------------------------------
// Upload module
if ($net2ftp_globals["state"] == "upload") {
// -------------------------------------------------------------------------
$net2ftp_messages["Upload to directory:"] = "Uploader vers le rpertoire:";
$net2ftp_messages["Files"] = "Fichiers";
$net2ftp_messages["Archives"] = "Archives";
$net2ftp_messages["Files entered here will be transferred to the FTP server."] = "Les fichiers entrs ici seront transfrs vers le serveur FTP.";
$net2ftp_messages["Archives entered here will be decompressed, and the files inside will be transferred to the FTP server."] = "Les archives entres ici vont tre dcompresses et les fichiers  l'intrieur de celles-ci vont tre transfrs vers le serveur FTP.";
$net2ftp_messages["Add another"] = "Ajouter un autre";
$net2ftp_messages["Use folder names (creates subdirectories automatically)"] = "Utiliser les noms des rpertoires (crer les sous-rpertoires automatiquement)";

$net2ftp_messages["Choose a directory"] = "Choisir un rpertoire";
$net2ftp_messages["Please wait..."] = "Merci de patienter...";
$net2ftp_messages["Uploading... please wait..."] = "Upload en cours... Merci de patienter...";
$net2ftp_messages["If the upload takes more than the allowed <b>%1\$s seconds<\/b>, you will have to try again with less/smaller files."] = "Si l\'upload prend plus que les <b>%1\$s secondes<\/b> permises, vous devrez reessayer avec moins de fichiers ou avec des fichiers plus petits.";
$net2ftp_messages["This window will close automatically in a few seconds."] = "Cette fentre se fermera automatiquement dans quelques secondes.";
$net2ftp_messages["Close window now"] = "Fermer la fentre maintenant";

$net2ftp_messages["Upload files and archives"] = "Uploader des fichiers et des archives";
$net2ftp_messages["Upload results"] = "Rsultats de l'upload";
$net2ftp_messages["Checking files:"] = "Vrification des fichiers:";
$net2ftp_messages["Transferring files to the FTP server:"] = "Transfer des fichiers vers le serveur FTP:";
$net2ftp_messages["Decompressing archives and transferring files to the FTP server:"] = "Decompression des archives et transfer des fichiers vers le serveur FTP:";
$net2ftp_messages["Upload more files and archives"] = "Uploader plus de fichiers et d'archives";

} // end upload


// -------------------------------------------------------------------------
// Messages which are shared by upload and jupload
if ($net2ftp_globals["state"] == "upload" || $net2ftp_globals["state"] == "jupload") {
// -------------------------------------------------------------------------
$net2ftp_messages["Restrictions:"] = "Restrictions : ";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s kB</b> and by PHP to <b>%2\$s</b>"] = "La taille maximale d'un fichier est restreinte  <b>%1\$s kB</b> par net2ftp et  <b>%2\$s</b> par PHP";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "Le temps d'excution maximum est de <b>%1\$s secondes</b>";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "Le mode de transfert FTP (ASCII ou BINARY) sera automatiquement dtermin selon l'extension du fichier";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "Si le fichier de destination existe dja il sera remplac par celui-ci";

} // end upload or jupload


// -------------------------------------------------------------------------
// View module
if ($net2ftp_globals["state"] == "view") {
// -------------------------------------------------------------------------

// /modules/view/view.inc.php
$net2ftp_messages["View file %1\$s"] = "Visualiser le fichier %1\$s";
$net2ftp_messages["View image %1\$s"] = "Voir l'image %1\$s";
$net2ftp_messages["View Macromedia ShockWave Flash movie %1\$s"] = "Visualiser le film Macromedia ShockWave Flash %1\$s";
$net2ftp_messages["Image"] = "Image";

// /skins/[skin]/view1.template.php
$net2ftp_messages["Syntax highlighting powered by <a href=\"http://geshi.org\">GeSHi</a>"] = "La coloration syntaxique est ralis par <a href=\"http://geshi.org\">GeSHi</a>";
$net2ftp_messages["To save the image, right-click on it and choose 'Save picture as...'"] = "Pour sauvegarder l'image, faites un click droit sur l'image et choisissez 'Save picture as...'";

} // end view


// -------------------------------------------------------------------------
// Zip module
if ($net2ftp_globals["state"] == "zip") {
// -------------------------------------------------------------------------

// /modules/zip/zip.inc.php
$net2ftp_messages["Zip entries"] = "Entres zip";

// /skins/[skin]/zip1.template.php
$net2ftp_messages["Save the zip file on the FTP server as:"] = "Sauvegarder le fichier zip sur le serveur comme : ";
$net2ftp_messages["Email the zip file in attachment to:"] = "Envoyer le fichier zip comme attachement par courriel :";
$net2ftp_messages["Note that sending files is not anonymous: your IP address as well as the time of the sending will be added to the email."] = "Remarquez qu'envoyer des fichiers n'est pas anonyme : votre adresse IP ainsi que le temps et la date d'envoie seront ajouts au courriel.";
$net2ftp_messages["Some additional comments to add in the email:"] = "Quelques commentaires additionnels  ajouter au courriel : ";

$net2ftp_messages["You did not enter a filename for the zipfile. Go back and enter a filename."] = "Vous n'avez pas entr un nom de fichier pour le fichier zip. Retournez en arrire et entrez un nom de fichier.";
$net2ftp_messages["The email address you have entered (%1\$s) does not seem to be valid.<br />Please enter an address in the format <b>username@domain.com</b>"] = "L'adresse de courriel que vous avez saisie (%1\$s) ne semble pas tre valide.<br />Veuillez saisir une adresse du type <b>utilisateur@domaine.com</b>";

} // end zip

?>