/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.impl.ui;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import org.netbeans.modules.print.impl.ui.Paper;
import org.netbeans.modules.print.impl.util.Option;
import org.netbeans.modules.print.impl.util.UI;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Printer
implements Printable {
    private List<Paper> myPapers;

    Printer() {
    }

    void print(List<Paper> list) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.myPapers = list;
        if (printerJob == null) {
            return;
        }
        printerJob.setPrintable(this, Option.getDefault().getPageFormat());
        try {
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (PrinterException printerException) {
            String string = UI.i18n(Printer.class, "ERR_Printer_Problem", printerException.getLocalizedMessage());
            ErrorManager.getDefault().annotate((Throwable)printerException, string);
            ErrorManager.getDefault().notify(256, (Throwable)printerException);
        }
        this.myPapers = null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == this.myPapers.size()) {
            return 1;
        }
        this.myPapers.get(n).print(graphics);
        return 0;
    }
}

