/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class TomcatFactory
implements DeploymentFactory {
    public static final String SERVER_ID_50 = "Tomcat";
    public static final String SERVER_ID_55 = "Tomcat55";
    public static final String SERVER_ID_60 = "Tomcat60";
    public static final String TOMCAT_URI_PREFIX_50 = "tomcat:";
    public static final String TOMCAT_URI_PREFIX_55 = "tomcat55:";
    public static final String TOMCAT_URI_PREFIX_60 = "tomcat60:";
    public static final String TOMCAT_URI_HOME_PREFIX = "home=";
    public static final String TOMCAT_URI_BASE_PREFIX = ":base=";
    private static final String DISCONNECTED_URI_50 = "tomcat:jakarta-tomcat-5.0.x";
    private static final String DISCONNECTED_URI_55 = "tomcat55:jakarta-tomcat-5.5.x";
    private static final String DISCONNECTED_URI_60 = "tomcat60:apache-tomcat-6.0.x";
    private static TomcatFactory instance;
    private static TomcatFactory instance55;
    private static TomcatFactory instance60;
    private static final WeakHashMap managerCache;
    private static Logger err;
    private final String tomcatUriPrefix;
    private final String disconnectedUri;
    private final TomcatManager.TomcatVersion version;
    private static final String PROP_CATALINA_HOME = "org.netbeans.modules.tomcat.autoregister.catalinaHome";
    private static final String PROP_TOKEN = "org.netbeans.modules.tomcat.autoregister.token";
    private static final String PROP_REMOVED_INSTANCE_TOKEN = "removed_instance_token";

    private TomcatFactory(TomcatManager.TomcatVersion tomcatVersion) {
        this.version = tomcatVersion;
        switch (tomcatVersion) {
            case TOMCAT_50: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_50;
                this.disconnectedUri = DISCONNECTED_URI_50;
                break;
            }
            case TOMCAT_55: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_55;
                this.disconnectedUri = DISCONNECTED_URI_55;
                break;
            }
            default: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_60;
                this.disconnectedUri = DISCONNECTED_URI_60;
            }
        }
    }

    public static synchronized TomcatFactory create50() {
        if (instance == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_50);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    public static synchronized TomcatFactory create55() {
        if (instance55 == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance55 = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_55);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance55);
        }
        return instance55;
    }

    public static synchronized TomcatFactory create60() {
        if (instance60 == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance60 = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_60);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance60);
        }
        return instance60;
    }

    public synchronized DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        if (!this.handlesURI(string)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + string);
        }
        InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
        if (instanceProperties == null && !this.disconnectedUri.equals(string)) {
            throw new DeploymentManagerCreationException("Tomcat instance: " + string + " is not registered in the IDE.");
        }
        TomcatManager tomcatManager = (TomcatManager)managerCache.get(instanceProperties);
        if (tomcatManager == null) {
            try {
                tomcatManager = new TomcatManager(true, string.substring(this.tomcatUriPrefix.length()), this.version);
                managerCache.put(instanceProperties, tomcatManager);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DeploymentManagerCreationException deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create deployment manager for Tomcat instance: " + string + ".");
                throw (DeploymentManagerCreationException)deploymentManagerCreationException.initCause(illegalArgumentException);
            }
        }
        return tomcatManager;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        return this.getDeploymentManager(string, null, null);
    }

    public String getDisplayName() {
        switch (this.version) {
            case TOMCAT_50: {
                return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory");
            }
            case TOMCAT_55: {
                return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory55");
            }
        }
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory60");
    }

    public String getProductVersion() {
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactoryVersion");
    }

    public boolean handlesURI(String string) {
        return string != null && string.startsWith(this.tomcatUriPrefix);
    }

    private static String getTomcatVersion(File file) throws IllegalStateException {
        File file2 = new File(file, "lib/catalina.jar");
        if (!file2.exists()) {
            file2 = new File(file, "server/lib/catalina.jar");
        }
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file2.toURL()});
            Class<?> clazz = uRLClassLoader.loadClass("org.apache.catalina.util.ServerInfo");
            Method method = clazz.getMethod("getServerInfo", new Class[0]);
            String string = (String)method.invoke(clazz, new Object[0]);
            int n = string.indexOf(47);
            if (n > 0) {
                return string.substring(n + 1);
            }
            throw new IllegalStateException("Cannot identify the version of the server.");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void autoregisterTomcatInstance() {
        void var8_17;
        String string;
        Repository repository = (Repository)Lookup.getDefault().lookup(Repository.class);
        FileObject fileObject = repository.getDefaultFileSystem().findResource("/J2EE/InstalledServers");
        if (fileObject == null) {
            err.log(Level.INFO, "Cannot register the default Tomcat server.  The //J2EE//InstalledServers folder cannot be found.");
            return;
        }
        String string2 = System.getProperty(PROP_CATALINA_HOME);
        final String string3 = System.getProperty(PROP_TOKEN);
        FileObject fileObject2 = null;
        for (FileObject illegalStateException : fileObject.getChildren()) {
            if (!Boolean.parseBoolean((String)illegalStateException.getAttribute("autoregistered"))) continue;
            fileObject2 = illegalStateException;
            break;
        }
        if (string2 == null || string3 == null) {
            if (fileObject2 != null) {
                try {
                    fileObject2.delete();
                }
                catch (IOException iOException) {
                    err.log(Level.INFO, "The server " + fileObject2.getAttribute("url") + " cannot be uregistered.");
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return;
        }
        String string4 = NbPreferences.forModule(TomcatFactory.class).get(PROP_REMOVED_INSTANCE_TOKEN, null);
        if (string3.equals(string4)) {
            return;
        }
        File file = new File(string2);
        if (!file.exists()) {
            err.log(Level.INFO, "Cannot register the default Tomcat server. The Catalina Home directory " + string2 + " passed through the " + PROP_CATALINA_HOME + " property does not exist.");
            return;
        }
        try {
            string = TomcatFactory.getTomcatVersion(file);
        }
        catch (IllegalStateException illegalStateException) {
            err.log(Level.INFO, "Cannot register the default Tomcat server.  Cannot recognize the Tomcat version.");
            err.log(Level.INFO, null, illegalStateException);
            return;
        }
        if (string.startsWith("5.0.")) {
            StringBuilder stringBuilder = new StringBuilder(TOMCAT_URI_PREFIX_50);
        } else if (string.startsWith("5.5.")) {
            StringBuilder stringBuilder = new StringBuilder(TOMCAT_URI_PREFIX_55);
        } else if (string.startsWith("6.")) {
            StringBuilder stringBuilder = new StringBuilder(TOMCAT_URI_PREFIX_60);
        } else {
            err.log(Level.INFO, "Cannot register the default Tomcat server.  The version " + string + " is not supported.");
            return;
        }
        var8_17.append(TOMCAT_URI_HOME_PREFIX);
        var8_17.append(string2);
        var8_17.append(TOMCAT_URI_BASE_PREFIX);
        var8_17.append("apache-tomcat-");
        var8_17.append(string);
        var8_17.append("_base");
        final String string5 = var8_17.toString();
        Deployment.getDefault().addInstanceListener(new InstanceListener(){

            public void changeDefaultInstance(String string, String string2) {
            }

            public void instanceAdded(String string) {
            }

            public void instanceRemoved(String string) {
                if (string5.equals(string)) {
                    NbPreferences.forModule(TomcatFactory.class).put(TomcatFactory.PROP_REMOVED_INSTANCE_TOKEN, string3);
                }
            }
        });
        for (FileObject fileObject3 : fileObject.getChildren()) {
            if (!string5.equals(fileObject3.getAttribute("url"))) continue;
            return;
        }
        if (fileObject2 != null && !string5.equals(fileObject2.getAttribute("url"))) {
            try {
                fileObject2.delete();
            }
            catch (IOException iOException) {
                err.log(Level.INFO, "The server " + fileObject2.getAttribute("url") + " cannot be uregistered.");
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        String string6 = TomcatFactory.generateUniqueDisplayName(fileObject, string);
        TomcatFactory.registerServerInstanceFO(fileObject, string5, string6);
    }

    private static String generateUniqueDisplayName(FileObject fileObject, String string) {
        String string2 = NbBundle.getMessage(TomcatFactory.class, (String)"LBL_ApacheTomcat", (Object)string);
        boolean bl = true;
        int n = 1;
        while (true) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!string2.equals(fileObject2.getAttribute("displayName"))) continue;
                bl = false;
                break;
            }
            if (bl) break;
            string2 = NbBundle.getMessage(TomcatFactory.class, (String)"LBL_ApacheTomcatAlt", (Object)string, (Object)n++);
            bl = true;
        }
        return string2;
    }

    private static void registerServerInstanceFO(FileObject fileObject, String string, String string2) {
        String string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"tomcat_autoregistered_instance", null);
        try {
            FileObject fileObject2 = fileObject.createData(string3);
            fileObject2.setAttribute("url", (Object)string);
            fileObject2.setAttribute("username", (Object)"ide");
            String string4 = TomcatInstallUtil.generatePassword(8);
            fileObject2.setAttribute("password", (Object)string4);
            fileObject2.setAttribute("displayName", (Object)string2);
            fileObject2.setAttribute("httpportnumber", (Object)"8084");
            fileObject2.setAttribute("admin_port", (Object)"8025");
            fileObject2.setAttribute("monitor_enabled", (Object)"true");
            fileObject2.setAttribute("is_it_bundled_tomcat", (Object)"true");
            fileObject2.setAttribute("autoregistered", (Object)"true");
        }
        catch (IOException iOException) {
            err.log(Level.INFO, "Cannot register the default Tomcat server.");
            err.log(Level.INFO, null, iOException);
        }
    }

    static {
        managerCache = new WeakHashMap();
        err = Logger.getLogger("org.netbeans.modules.tomcat5");
        TomcatFactory.autoregisterTomcatInstance();
    }
}

