/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.config;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.config.TomcatDatasource;
import org.netbeans.modules.tomcat5.config.gen.GlobalNamingResources;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;
import org.netbeans.modules.tomcat5.config.gen.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDatasourceManager
implements DatasourceManager {
    private final TomcatManager tm;

    public TomcatDatasourceManager(DeploymentManager deploymentManager) {
        this.tm = (TomcatManager)deploymentManager;
    }

    public Set<Datasource> getDatasources() {
        HashSet<Datasource> hashSet;
        block9: {
            Server server;
            hashSet = new HashSet<Datasource>();
            File file = this.tm.getTomcatProperties().getServerXml();
            try {
                server = Server.createGraph(file);
            }
            catch (IOException iOException) {
                Logger.getLogger(TomcatDatasourceManager.class.getName()).log(Level.INFO, null, iOException);
                return Collections.emptySet();
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(TomcatDatasourceManager.class.getName()).log(Level.INFO, null, runtimeException);
                return Collections.emptySet();
            }
            GlobalNamingResources[] globalNamingResourcesArray = server.getGlobalNamingResources();
            if (globalNamingResourcesArray.length <= 0) break block9;
            GlobalNamingResources globalNamingResources = globalNamingResourcesArray[0];
            if (this.tm.getTomcatVersion() != TomcatManager.TomcatVersion.TOMCAT_50) {
                int n = globalNamingResources.getResource().length;
                for (int i = 0; i < n; ++i) {
                    String string = globalNamingResources.getResourceType(i);
                    if (!"javax.sql.DataSource".equals(string)) continue;
                    String string2 = globalNamingResources.getResourceName(i);
                    String string3 = globalNamingResources.getResourceUsername(i);
                    String string4 = globalNamingResources.getResourceUrl(i);
                    String string5 = globalNamingResources.getResourcePassword(i);
                    String string6 = globalNamingResources.getResourceDriverClassName(i);
                    if (string2 == null || string3 == null || string4 == null || string6 == null) continue;
                    hashSet.add(new TomcatDatasource(string3, string4, string5, string2, string6));
                }
            } else {
                int n = globalNamingResources.getResource().length;
                ResourceParams[] resourceParamsArray = globalNamingResources.getResourceParams();
                for (int i = 0; i < n; ++i) {
                    String string = globalNamingResources.getResourceType(i);
                    if (!"javax.sql.DataSource".equals(string)) continue;
                    String string7 = globalNamingResources.getResourceName(i);
                    for (int j = 0; j < resourceParamsArray.length; ++j) {
                        Object object2;
                        if (!string7.equals(resourceParamsArray[j].getName())) continue;
                        Parameter[] parameterArray = resourceParamsArray[j].getParameter();
                        HashMap<String, String> hashMap = new HashMap<String, String>(parameterArray.length);
                        for (Object object2 : parameterArray) {
                            hashMap.put(object2.getName(), object2.getValue());
                        }
                        String object3 = (String)hashMap.get("username");
                        String string2 = (String)hashMap.get("url");
                        String string3 = (String)hashMap.get("password");
                        object2 = (String)hashMap.get("driverClassName");
                        if (object3 == null || string2 == null || object2 == null) continue;
                        hashSet.add(new TomcatDatasource(object3, string2, string3, string7, (String)object2));
                    }
                }
            }
        }
        return hashSet;
    }

    public void deployDatasources(Set<Datasource> set) throws ConfigurationException, DatasourceAlreadyExistsException {
    }
}

