/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassManager
implements JavaClassConstants,
CommonConstants {
    private static final RuntimeProfilingPoint[] EMPTY_PROFILEPOINT_ARRAY = new RuntimeProfilingPoint[0];
    private static Comparator ByBciComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            RuntimeProfilingPoint runtimeProfilingPoint = (RuntimeProfilingPoint)object;
            RuntimeProfilingPoint runtimeProfilingPoint2 = (RuntimeProfilingPoint)object2;
            return runtimeProfilingPoint.getBci() - runtimeProfilingPoint2.getBci();
        }
    };
    protected ProfilingSessionStatus status;

    protected ClassManager(ProfilingSessionStatus profilingSessionStatus) {
        this.status = profilingSessionStatus;
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray, ClassInfo classInfo) {
        ArrayList<RuntimeProfilingPoint> arrayList = null;
        String string = classInfo.getName().replace('/', '.');
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            if (!string.equals(runtimeProfilingPoint.getClassName()) || !runtimeProfilingPoint.resolve(classInfo)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<RuntimeProfilingPoint>(2);
            }
            arrayList.add(runtimeProfilingPoint);
        }
        if (arrayList == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        return arrayList.toArray(new RuntimeProfilingPoint[arrayList.size()]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray, int n) {
        ArrayList<RuntimeProfilingPoint> arrayList = null;
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            if (runtimeProfilingPoint.getMethodIdx() != n) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<RuntimeProfilingPoint>(2);
            }
            arrayList.add(runtimeProfilingPoint);
        }
        if (arrayList == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, ByBciComparator);
        }
        return arrayList.toArray(new RuntimeProfilingPoint[arrayList.size()]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray, ClassInfo classInfo, int n) {
        ArrayList<RuntimeProfilingPoint> arrayList = null;
        String string = classInfo.getName().replace('/', '.');
        string = string.replace('$', '.');
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            if (!string.equals(runtimeProfilingPoint.getClassName()) || !runtimeProfilingPoint.resolve(classInfo) || runtimeProfilingPoint.getMethodIdx() != n) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<RuntimeProfilingPoint>(2);
            }
            arrayList.add(runtimeProfilingPoint);
        }
        if (arrayList == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, ByBciComparator);
        }
        return arrayList.toArray(new RuntimeProfilingPoint[arrayList.size()]);
    }

    protected static DynamicClassInfo javaClassForName(String string, int n) {
        try {
            return ClassRepository.lookupClass(string, n);
        }
        catch (IOException iOException) {
            MiscUtils.printWarningMessage("Error reading class " + string);
            MiscUtils.printWarningMessage(iOException.getMessage());
        }
        catch (ClassFormatError classFormatError) {
            MiscUtils.printWarningMessage(classFormatError.getMessage());
        }
        return null;
    }

    protected static BaseClassInfo javaClassForObjectArrayType(String string) {
        BaseClassInfo baseClassInfo = ClassRepository.lookupSpecialClass("[" + string);
        return baseClassInfo;
    }

    protected static BaseClassInfo javaClassForPrimitiveArrayType(int n) {
        BaseClassInfo baseClassInfo = ClassRepository.lookupSpecialClass(PRIMITIVE_ARRAY_TYPE_NAMES[n]);
        return baseClassInfo;
    }

    protected static BaseClassInfo javaClassOrPlaceholderForName(String string, int n) {
        return ClassRepository.lookupClassOrCreatePlaceholder(string, n);
    }

    protected static BaseClassInfo loadedJavaClassOrExistingPlaceholderForName(String string, int n) {
        return ClassRepository.lookupLoadedClass(string, n, true);
    }

    protected static void registerPlaceholder(PlaceholderClassInfo placeholderClassInfo) {
        ClassRepository.addPlaceholder(placeholderClassInfo);
    }

    protected static void resetLoadedClassData() {
        ClassRepository.clearCache();
    }

    protected static void storeClassFileBytesForCustomLoaderClasses(String[] stringArray, int[] nArray, byte[][] byArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == null) continue;
            ClassRepository.addVMSuppliedClassFile(stringArray[i], nArray[i], byArray[i]);
        }
    }
}

