/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.DataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;

public abstract class AbstractDataFrameProcessor
implements DataFrameProcessor {
    protected static final Logger LOGGER = Logger.getLogger(DataFrameProcessor.class.getName());
    protected volatile ProfilerClient client = null;
    private final AtomicBoolean batchInProgress = new AtomicBoolean(false);
    private final Set listeners = Collections.synchronizedSet(new HashSet());

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataFrame(byte[] byArray) {
        try {
            this.fireBatchStart();
            this.doProcessDataFrame(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error while processing data frame", exception);
        }
        finally {
            this.fireBatchStop();
        }
    }

    public void removeAllListeners() {
        HashSet hashSet = new HashSet(this.listeners);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProfilingResultListener)iterator.next()).shutdown();
        }
        this.listeners.clear();
    }

    public void reset() {
        this.fireReset();
    }

    public void shutdown() {
        this.fireBatchStop();
        this.fireShutdown();
    }

    public void startup(ProfilerClient profilerClient) {
        this.client = profilerClient;
    }

    protected void addListener(ProfilingResultListener profilingResultListener) {
        this.listeners.add(profilingResultListener);
    }

    protected abstract void doProcessDataFrame(byte[] var1);

    protected void fireProfilingPoint(final int n, final int n2, final long l) {
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.profilingPoint(n, n2, l);
            }
        });
    }

    protected void fireReset() {
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.reset();
            }
        });
    }

    protected void foreachListener(ListenerFunctor listenerFunctor) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            listenerFunctor.execute((ProfilingResultListener)iterator.next());
        }
    }

    protected void removeListener(ProfilingResultListener profilingResultListener) {
        profilingResultListener.shutdown();
        this.listeners.remove(profilingResultListener);
    }

    private void fireBatchStart() {
        this.batchInProgress.set(true);
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.onBatchStart();
            }
        });
    }

    private void fireBatchStop() {
        if (this.batchInProgress.compareAndSet(true, false)) {
            this.foreachListener(new ListenerFunctor(){

                public void execute(ProfilingResultListener profilingResultListener) {
                    profilingResultListener.onBatchStop();
                }
            });
        }
    }

    private void fireShutdown() {
        this.foreachListener(new ListenerFunctor(){

            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.shutdown();
            }
        });
    }

    protected static interface ListenerFunctor {
        public void execute(ProfilingResultListener var1);
    }
}

