/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.CategoryCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.HierarchicalMark;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;

public final class CCTResultsFilter
extends CPUCCTVisitorAdapter {
    private static final Logger LOGGER = Logger.getLogger(CCTResultsFilter.class.getName());
    private Set evaluators = new HashSet();
    private Stack passFlagStack = new Stack();
    private boolean passingFilter;

    public CCTResultsFilter() {
        this.doReset();
    }

    public void addEvaluator(Evaluator evaluator) {
        this.evaluators.add(evaluator);
    }

    public synchronized boolean passesFilter() {
        return this.passingFilter;
    }

    public void removeAllEvaluators() {
        this.evaluators.clear();
    }

    public void removeEvaluator(Evaluator evaluator) {
        this.evaluators.remove(evaluator);
    }

    public void reset() {
        this.doReset();
    }

    public void visit(ThreadCPUCCTNode threadCPUCCTNode) {
        LOGGER.finest("visiting thread node");
        this.passFlagStack.push(this.passingFilter);
        this.passingFilter = true;
        Iterator iterator = this.evaluators.iterator();
        while (iterator.hasNext()) {
            Evaluator evaluator = (Evaluator)iterator.next();
            this.passingFilter &= evaluator.evaluate(HierarchicalMark.DEFAULT);
        }
        LOGGER.finest("Evaluator result: " + this.passingFilter);
        super.visit(threadCPUCCTNode);
    }

    public void visit(CategoryCPUCCTNode categoryCPUCCTNode) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Entering category " + categoryCPUCCTNode.getMark().getDescription());
        }
        this.passFlagStack.push(this.passingFilter);
        this.passingFilter = true;
        Iterator iterator = this.evaluators.iterator();
        while (iterator.hasNext()) {
            Evaluator evaluator = (Evaluator)iterator.next();
            this.passingFilter &= evaluator.evaluate(categoryCPUCCTNode.getMark());
        }
    }

    public void visitPost(ThreadCPUCCTNode threadCPUCCTNode) {
        super.visitPost(threadCPUCCTNode);
        if (!this.passFlagStack.isEmpty()) {
            this.passingFilter = (Boolean)this.passFlagStack.pop();
        }
    }

    public void visitPost(CategoryCPUCCTNode categoryCPUCCTNode) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Leaving category " + categoryCPUCCTNode.getMark().getDescription());
        }
        if (!this.passFlagStack.isEmpty()) {
            this.passingFilter = (Boolean)this.passFlagStack.pop();
        }
    }

    private void doReset() {
        this.passingFilter = false;
        this.passFlagStack.clear();
    }

    public static interface Evaluator {
        public boolean evaluate(Mark var1);
    }
}

