/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.Enumeration;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.openide.util.NbBundle;

public class WLDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "deployer:WebLogic:http://";
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentFactory.class.getName());
    private static WLDeploymentFactory instance;
    private static final WeakHashMap<InstanceProperties, WLDeploymentManager> managerCache;
    private static WLClassLoader loader;

    public static synchronized DeploymentFactory getInstance() {
        if (instance == null) {
            instance = new WLDeploymentFactory();
        }
        return instance;
    }

    public static synchronized ClassLoader getWLClassLoader(String string) {
        if (loader == null) {
            try {
                URL[] uRLArray = new URL[]{new File(string + "/server/lib/weblogic.jar").toURI().toURL()};
                loader = new WLClassLoader(uRLArray, WLDeploymentFactory.class.getClassLoader());
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, null, exception);
            }
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentManager getVendorDeploymentManager(String string, String string2, String string3, String string4, String string5) throws DeploymentManagerCreationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDM, uri:" + string + " username:" + string2 + " password:" + string3 + " host:" + string4 + " port:" + string5);
        }
        DeploymentManagerCreationException deploymentManagerCreationException = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String string6 = InstanceProperties.getInstanceProperties((String)string).getProperty("serverRoot");
            if (string6 == null) {
                string6 = WLPluginProperties.getInstance().getInstallLocation();
            }
            ClassLoader classLoader2 = WLDeploymentFactory.getWLClassLoader(string6);
            Thread.currentThread().setContextClassLoader(classLoader2);
            Class<?> clazz = Class.forName("weblogic.deploy.api.tools.SessionHelper", false, classLoader2);
            Method method = clazz.getDeclaredMethod("getDeploymentManager", String.class, String.class, String.class, String.class);
            Object object = method.invoke(null, string4, string5, string2, string3);
            if (DeploymentManager.class.isAssignableFrom(object.getClass())) {
                DeploymentManager deploymentManager = (DeploymentManager)object;
                return deploymentManager;
            }
            deploymentManagerCreationException = new DeploymentManagerCreationException("Instance created by weblogic is not DeploymentManager instance.");
        }
        catch (Exception exception) {
            deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            deploymentManagerCreationException.initCause((Throwable)exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            deploymentManagerCreationException.initCause((Throwable)noClassDefFoundError);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        throw deploymentManagerCreationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentManager getVendorDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        DeploymentManagerCreationException deploymentManagerCreationException = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String string2 = InstanceProperties.getInstanceProperties((String)string).getProperty("serverRoot");
            if (string2 == null) {
                string2 = WLPluginProperties.getInstance().getInstallLocation();
            }
            ClassLoader classLoader2 = WLDeploymentFactory.getWLClassLoader(string2);
            Thread.currentThread().setContextClassLoader(classLoader2);
            Class<?> clazz = Class.forName("weblogic.deploy.api.tools.SessionHelper", false, classLoader2);
            Method method = clazz.getDeclaredMethod("getDisconnectedDeploymentManager", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            if (DeploymentManager.class.isAssignableFrom(object.getClass())) {
                DeploymentManager deploymentManager = (DeploymentManager)object;
                return deploymentManager;
            }
            deploymentManagerCreationException = new DeploymentManagerCreationException("Instance created by weblogic is not disconnected DeploymentManager instance.");
        }
        catch (Exception exception) {
            deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create weblogic disconnected DeploymentManager instance.");
            deploymentManagerCreationException.initCause((Throwable)exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            deploymentManagerCreationException.initCause((Throwable)noClassDefFoundError);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        throw deploymentManagerCreationException;
    }

    public boolean handlesURI(String string) {
        return string != null && string.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDeploymentManager, uri:" + string + " username:" + string2 + " password:" + string3);
        }
        String[] stringArray = string.split(":");
        String string4 = stringArray[3].substring(2);
        String string5 = stringArray[4];
        WLDeploymentManager wLDeploymentManager = new WLDeploymentManager(this, string, string2, string3, string4, string5);
        this.updateManagerCache(wLDeploymentManager, string);
        return wLDeploymentManager;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDisconnectedDeploymentManager, uri:" + string);
        }
        String[] stringArray = string.split(":");
        String string2 = stringArray[3].substring(2);
        String string3 = stringArray[4];
        WLDeploymentManager wLDeploymentManager = new WLDeploymentManager(this, string, string2, string3);
        this.updateManagerCache(wLDeploymentManager, string);
        return wLDeploymentManager;
    }

    private void updateManagerCache(WLDeploymentManager wLDeploymentManager, String string) {
        InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
        if (managerCache.get(instanceProperties) != null) {
            wLDeploymentManager.setServerProcess(managerCache.get(instanceProperties).getServerProcess());
            wLDeploymentManager.setOutputManager(managerCache.get(instanceProperties).getOutputManager());
        }
        managerCache.put(instanceProperties, wLDeploymentManager);
    }

    public String getProductVersion() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_productVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_displayName");
    }

    static {
        managerCache = new WeakHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WLClassLoader
    extends URLClassLoader {
        public WLClassLoader(URL[] uRLArray, ClassLoader classLoader) throws MalformedURLException {
            super(uRLArray, classLoader);
        }

        public void addURL(File file) throws MalformedURLException {
            if (file.isFile()) {
                this.addURL(file.toURL());
            }
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            return permissions;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            if (string.indexOf("jndi.properties") != -1 || string.indexOf("i18n_user.properties") != -1) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(string);
        }
    }
}

