/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.codegen.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.compapp.javaee.codegen.model.AbstractProject;
import org.netbeans.modules.compapp.javaee.codegen.model.Endpoint;
import org.netbeans.modules.compapp.javaee.codegen.model.JarInJarProject;
import org.netbeans.modules.compapp.javaee.codegen.model.JavaEEProject;
import org.netbeans.modules.compapp.javaee.util.ProjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseAppProject
extends AbstractProject {
    private static Logger logger = Logger.getLogger(EnterpriseAppProject.class.getName());
    private static String JAR_SEPERATOR = "!/";
    private static String SU_FILE_EXT = "ear";
    private List<JavaEEProject> subProjs = new ArrayList<JavaEEProject>();

    public EnterpriseAppProject(String string) {
        super(string);
        this.projType = JavaEEProject.ProjectType.ENT;
        this.initEarProj();
    }

    @Override
    public void addSubproject(JavaEEProject javaEEProject) {
        this.subProjs.add(javaEEProject);
    }

    @Override
    protected String renameToSvcUnitExtension(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            stringBuffer.append(string.substring(0, n + 1));
            stringBuffer.append(SU_FILE_EXT);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initEarProj() {
        JarFile jarFile = null;
        String string = null;
        JarInJarProject jarInJarProject = null;
        URL uRL = null;
        try {
            File file = new File(this.jarPath);
            string = "jar:" + file.toURL().toString() + JAR_SEPERATOR;
            jarFile = new JarFile(this.jarPath);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            JarEntry jarEntry = null;
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".jar") && !jarEntry.getName().endsWith(".war")) continue;
                uRL = new URL(string + jarEntry.getName());
                jarInJarProject = new JarInJarProject(uRL);
                this.addSubproject(jarInJarProject);
            }
            if (jarFile == null) return;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception while reading EAR archive.", iOException);
            return;
        }
        finally {
            if (jarFile != null) {
                ProjectUtil.close(jarFile);
            }
        }
        ProjectUtil.close(jarFile);
        return;
    }

    @Override
    public List<Endpoint> getWebservicesEndpoints() throws IOException {
        Iterator<JavaEEProject> iterator = this.subProjs.iterator();
        JavaEEProject javaEEProject = null;
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        while (iterator.hasNext()) {
            javaEEProject = iterator.next();
            arrayList.addAll(javaEEProject.getWebservicesEndpoints());
        }
        return arrayList;
    }
}

