/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool.annotation;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.DependencyAnnotation;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.EJBAnnotation;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.CMap;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.CMapNode;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.EJBInterface;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.EJBNode;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.MDBNode;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.ServletNode;

public class JavaEEAnnotationProcessor {
    public static final String LOCAL_CLASSTYPE = "javax/ejb/Local";
    public static final String REMOTE_CLASSTYPE = "javax/ejb/Remote";
    public static final String STATEFUL_CLASSTYPE = "javax/ejb/Stateful";
    public static final String STATELESS_CLASSTYPE = "javax/ejb/Stateless";
    public static final String MDB_CLASSTYPE = "javax/ejb/MessageDriven";
    public static final String WEBSERVICE_CLASSTYPE = "javax/jws/WebService";
    public static final String EJB_CLASSTYPE = "javax/ejb/EJB";
    public static final String EJBS_CLASSTYPE = "javax/ejb/EJBs";
    public static final String RESOURCE_CLASSTYPE = "javax/annotation/Resource";
    public static final String RESOURCES_CLASSTYPE = "javax/annotation/Resources";
    public static final String WEBSERVICEREF_CLASSTYPE = "javax/xml/ws/WebServiceRef";
    public static final String WEBSERVICEREFS_CLASSTYPE = "javax/xml/ws/WebServiceRefs";
    public static final String SERVLET_CLASSTYPE = "javax/servlet/Servlet";
    public static final String GENERIC_SERVLET_CLASSTYPE = "javax/servlet/GenericServlet";
    public static final String HTTP_SERVLET_CLASSTYPE = "javax/servlet/http/HttpServlet";
    private EJBAnnotation ejbAnnotation;
    private DependencyAnnotation dependencyAnnotation;
    private CMap cmap;
    private Hashtable<String, EJBInterface.EJBInterfaceType> intfTable = new Hashtable();

    public JavaEEAnnotationProcessor(CMap cMap, ResourceAggregator resourceAggregator) {
        this.ejbAnnotation = new EJBAnnotation(resourceAggregator);
        this.dependencyAnnotation = new DependencyAnnotation(resourceAggregator);
        this.cmap = cMap;
    }

    public void process(ClassFile classFile) throws Exception {
        if ((classFile.getAccess() & 0x200) == 512) {
            if (classFile.isAnnotationPresent(ClassName.getClassName((String)LOCAL_CLASSTYPE))) {
                this.intfTable.put(classFile.getName().getExternalName(), EJBInterface.EJBInterfaceType.LOCAL);
            } else if (classFile.isAnnotationPresent(ClassName.getClassName((String)REMOTE_CLASSTYPE))) {
                this.intfTable.put(classFile.getName().getExternalName(), EJBInterface.EJBInterfaceType.REMOTE);
            }
        } else if (classFile.isAnnotationPresent(ClassName.getClassName((String)WEBSERVICE_CLASSTYPE)) && classFile.isAnnotationPresent(ClassName.getClassName((String)STATELESS_CLASSTYPE))) {
            EJBNode eJBNode = new EJBNode(classFile, CMapNode.CMapNodeType.STATELESS);
            eJBNode.setIsWebService(true);
            this.ejbAnnotation.fillWebServiceNode(eJBNode, classFile);
            this.dependencyAnnotation.fillDependencyInfo(eJBNode, classFile);
            this.cmap.addNode(classFile.getName().getExternalName(), eJBNode);
        } else if (classFile.isAnnotationPresent(ClassName.getClassName((String)STATELESS_CLASSTYPE))) {
            EJBNode eJBNode = new EJBNode(classFile, CMapNode.CMapNodeType.STATELESS);
            this.ejbAnnotation.fillStatelessNode(eJBNode, classFile);
            this.dependencyAnnotation.fillDependencyInfo(eJBNode, classFile);
            this.cmap.addNode(classFile.getName().getExternalName(), eJBNode);
        } else if (classFile.isAnnotationPresent(ClassName.getClassName((String)STATEFUL_CLASSTYPE))) {
            EJBNode eJBNode = new EJBNode(classFile, CMapNode.CMapNodeType.STATEFUL);
            this.ejbAnnotation.fillStatefulNode(eJBNode, classFile);
            this.dependencyAnnotation.fillDependencyInfo(eJBNode, classFile);
            this.cmap.addNode(classFile.getName().getExternalName(), eJBNode);
        } else if (classFile.isAnnotationPresent(ClassName.getClassName((String)MDB_CLASSTYPE))) {
            MDBNode mDBNode = new MDBNode(classFile, CMapNode.CMapNodeType.MDB);
            this.ejbAnnotation.fillMessageDrivenNode(mDBNode, classFile);
            this.dependencyAnnotation.fillDependencyInfo(mDBNode, classFile);
            this.cmap.addNode(classFile.getName().getExternalName(), mDBNode);
        } else if (this.isServlet(classFile)) {
            ServletNode servletNode = new ServletNode(classFile, CMapNode.CMapNodeType.SERVLET);
            this.dependencyAnnotation.fillDependencyInfo(servletNode, classFile);
            this.cmap.addNode(classFile.getName().getExternalName(), servletNode);
        }
    }

    public void postProcess() throws Exception {
        Iterator<CMapNode> iterator = this.cmap.getNodes();
        while (iterator.hasNext()) {
            CMapNode cMapNode = iterator.next();
            if (!(cMapNode instanceof EJBNode)) continue;
            EJBNode eJBNode = (EJBNode)cMapNode;
            ArrayList<EJBInterface> arrayList = eJBNode.getImplementedIntfs();
            for (int i = 0; i < arrayList.size(); ++i) {
                EJBInterface eJBInterface = arrayList.get(i);
                EJBInterface.EJBInterfaceType eJBInterfaceType = this.intfTable.get(eJBInterface.getIntf());
                if (eJBInterfaceType == null || eJBInterfaceType == eJBInterface.getIntfType()) continue;
                eJBInterface.setIntfType(eJBInterfaceType);
            }
        }
        this.cmap.postProcess();
    }

    private boolean isServlet(ClassFile classFile) {
        for (String string : classFile.getInterfaces()) {
            if (!SERVLET_CLASSTYPE.equals(string)) continue;
            return true;
        }
        return classFile.getSuperClass().equals((Object)ClassName.getClassName((String)GENERIC_SERVLET_CLASSTYPE)) || classFile.getSuperClass().equals((Object)ClassName.getClassName((String)HTTP_SERVLET_CLASSTYPE));
    }
}

