/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool.archive;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openide.util.NbBundle;

public class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static byte[] buffer = new byte[65536];
    private static int count = 0;

    public static String getArchiveName(String string) {
        return string.substring(0, string.lastIndexOf("."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File explode(File file, File file2) throws Exception {
        String string;
        File file3;
        if (!file.exists()) throw new Exception(NbBundle.getMessage(FileUtil.class, (String)"EXC_invalid_srcfile", (Object)file.getCanonicalPath()));
        if (!file.isFile()) {
            throw new Exception(NbBundle.getMessage(FileUtil.class, (String)"EXC_invalid_srcfile", (Object)file.getCanonicalPath()));
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new Exception(NbBundle.getMessage(FileUtil.class, (String)"EXC_dest_not_dir", (Object)file2.getCanonicalPath()));
            }
        } else {
            file2.mkdirs();
        }
        if ((file3 = new File(file2, string = FileUtil.getArchiveName(file.getName()))).exists()) {
            if (!FileUtil.deleteTree(file3)) {
                throw new Exception(NbBundle.getMessage(FileUtil.class, (String)"EXC_cannot_delete", (Object)file3.getCanonicalPath()));
            }
        } else {
            file3.mkdir();
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                File file4 = new File(file3, string2);
                if (string2.endsWith("/") || string2.endsWith("\\")) continue;
                file4.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file4);
                    int n = zipInputStream.read(buffer);
                    while (n > 0) {
                        fileOutputStream.write(buffer, 0, n);
                        n = zipInputStream.read(buffer);
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.safeclose(fileOutputStream);
                    throw throwable;
                }
                FileUtil.safeclose(fileOutputStream);
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeclose(zipInputStream);
            FileUtil.safeclose(bufferedInputStream);
            FileUtil.safeclose(fileInputStream);
            throw throwable;
        }
        FileUtil.safeclose(zipInputStream);
        FileUtil.safeclose(bufferedInputStream);
        FileUtil.safeclose(fileInputStream);
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File file, File file2) throws Exception {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 65536);
            zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            FileUtil.recurse(file, zipOutputStream, "");
        }
        catch (Throwable throwable) {
            FileUtil.safeclose(zipOutputStream);
            FileUtil.safeclose(bufferedOutputStream);
            FileUtil.safeclose(fileOutputStream);
            throw throwable;
        }
        FileUtil.safeclose(zipOutputStream);
        FileUtil.safeclose(bufferedOutputStream);
        FileUtil.safeclose(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recurse(File file, ZipOutputStream zipOutputStream, String string) throws Exception {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            File file2 = fileArray[i];
            String string3 = string2 = string.equals("") ? file2.getName() : string + "/" + file2.getName();
            if (file2.isDirectory()) {
                FileUtil.recurse(file2, zipOutputStream, string2);
                continue;
            }
            zipOutputStream.putNextEntry(new ZipEntry(string2));
            FileInputStream fileInputStream = new FileInputStream(file2);
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
                int n = bufferedInputStream.read(buffer);
                while (n > 0) {
                    zipOutputStream.write(buffer, 0, n);
                    n = bufferedInputStream.read(buffer);
                }
                zipOutputStream.closeEntry();
            }
            catch (Throwable throwable) {
                FileUtil.safeclose(bufferedInputStream);
                FileUtil.safeclose(fileInputStream);
                throw throwable;
            }
            FileUtil.safeclose(bufferedInputStream);
            FileUtil.safeclose(fileInputStream);
        }
    }

    public static void safecloseJar(JarFile jarFile) {
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void safeclose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean deleteTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile()) {
                if (file2.delete()) continue;
                try {
                    System.out.println("Unable to delete file " + file2.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            if (FileUtil.deleteTree(file2)) continue;
            return false;
        }
        return file.delete();
    }
}

