/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool.graph;

import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import org.netbeans.modules.compapp.javaee.sunresources.generated.graph.GraphType;
import org.netbeans.modules.compapp.javaee.sunresources.generated.graph.ObjectFactory;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.FileUtil;

public class JAXBHandler {
    private JAXBContext jc;
    private JAXBElement<?> graphElement;
    private List<GraphType.Node> nodeList;
    private Marshaller marshaller;
    private File xmlFile;

    public JAXBHandler(File file) throws Exception {
        Object object;
        this.xmlFile = file;
        this.jc = JAXBContext.newInstance((String)"com.sun.wasilla.jaxb.graph", (ClassLoader)this.getClass().getClassLoader());
        boolean bl = true;
        try {
            object = this.jc.createUnmarshaller();
            this.graphElement = (JAXBElement)object.unmarshal(file);
            this.nodeList = Collections.synchronizedList(((GraphType)this.graphElement.getValue()).getNode());
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            object = new ObjectFactory();
            GraphType graphType = ((ObjectFactory)object).createGraphType();
            this.graphElement = ((ObjectFactory)object).createGraph(graphType);
            this.nodeList = Collections.synchronizedList(((GraphType)this.graphElement.getValue()).getNode());
        }
    }

    public GraphType.Node findNode(String string) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            GraphType.Node node = this.nodeList.get(i);
            if (!string.equals(node.getLogicalname())) continue;
            return node;
        }
        return null;
    }

    public void addNode(GraphType.Node node) {
        this.nodeList.add(node);
    }

    public void updateNode(String string, Point point) {
        GraphType.Node node = this.findNode(string);
        if (node == null) {
            node = new GraphType.Node();
            node.setLogicalname(string);
            node.setLocX(String.valueOf(point.x));
            node.setLocY(String.valueOf(point.y));
            this.addNode(node);
        } else {
            node.setLocX(String.valueOf(point.x));
            node.setLocY(String.valueOf(point.y));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXML() throws Exception {
        if (this.marshaller == null) {
            this.marshaller = this.jc.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.xmlFile);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        try {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<!DOCTYPE resources PUBLIC \"-//Sun Microsystems Inc.//DTD Application Server 9.0 Domain//EN\" \"http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd\">");
            this.marshaller.marshal(this.graphElement, (Writer)printWriter);
        }
        finally {
            FileUtil.safeclose(printWriter);
            FileUtil.safeclose(fileOutputStream);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "C:/testcode/wasilla/graph2.xml";
            File file = new File(string);
            JAXBHandler jAXBHandler = new JAXBHandler(file);
            jAXBHandler.saveXML();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

