/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.ui;

import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.AdminObjectResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.ConnectorConnectionPool;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.ConnectorResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.CustomResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.ExternalJndiResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.JdbcConnectionPool;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.JdbcResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.MailResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.PersistenceManagerFactoryResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.ResourceAdapterConfig;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesTableModel
extends AbstractTableModel {
    private static String STR_YES = NbBundle.getMessage(ResourcesTableModel.class, (String)"LBL_yes");
    private static String STR_NO = NbBundle.getMessage(ResourcesTableModel.class, (String)"LBL_no");
    private String[] columnNames = new String[]{NbBundle.getMessage(ResourcesTableModel.class, (String)"LBL_col_resname"), NbBundle.getMessage(ResourcesTableModel.class, (String)"LBL_col_restype"), NbBundle.getMessage(ResourcesTableModel.class, (String)"LBL_col_anno_present"), NbBundle.getMessage(ResourcesTableModel.class, (String)"LBL_col_defined")};
    private ResourceAggregator resAggregator;

    public ResourcesTableModel(ResourceAggregator resourceAggregator) {
        this.resAggregator = resourceAggregator;
    }

    @Override
    public int getRowCount() {
        return this.resAggregator.getResources().size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ResourceAggregator.ResourceEntry resourceEntry = this.resAggregator.getResources().get(n);
        switch (n2) {
            case 0: {
                return this.getResourceName(resourceEntry.resource);
            }
            case 1: {
                return this.getResourceType(resourceEntry.resource);
            }
            case 2: {
                if (resourceEntry.orphanStatus == ResourceAggregator.OrphanStatus.ANNO_ONLY || resourceEntry.orphanStatus == ResourceAggregator.OrphanStatus.BOTH) {
                    return STR_YES;
                }
                return STR_NO;
            }
            case 3: {
                if (resourceEntry.orphanStatus == ResourceAggregator.OrphanStatus.FILE_ONLY || resourceEntry.orphanStatus == ResourceAggregator.OrphanStatus.BOTH) {
                    return STR_YES;
                }
                return STR_NO;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    private Object getResourceProps(Object object) {
        Properties properties = new Properties();
        return properties;
    }

    private void setResourceProps(Object object, Object object2) {
    }

    private String getResourceType(Object object) {
        return object.getClass().getSimpleName();
    }

    private String getResourceName(Object object) {
        if (object instanceof CustomResource) {
            CustomResource customResource = (CustomResource)object;
            return customResource.getJndiName();
        }
        if (object instanceof ExternalJndiResource) {
            ExternalJndiResource externalJndiResource = (ExternalJndiResource)object;
            return externalJndiResource.getJndiName();
        }
        if (object instanceof JdbcResource) {
            JdbcResource jdbcResource = (JdbcResource)object;
            return jdbcResource.getJndiName();
        }
        if (object instanceof MailResource) {
            MailResource mailResource = (MailResource)object;
            return mailResource.getJndiName();
        }
        if (object instanceof PersistenceManagerFactoryResource) {
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = (PersistenceManagerFactoryResource)object;
            return persistenceManagerFactoryResource.getJndiName();
        }
        if (object instanceof AdminObjectResource) {
            AdminObjectResource adminObjectResource = (AdminObjectResource)object;
            return adminObjectResource.getJndiName();
        }
        if (object instanceof ConnectorResource) {
            ConnectorResource connectorResource = (ConnectorResource)object;
            return connectorResource.getJndiName();
        }
        if (object instanceof ResourceAdapterConfig) {
            ResourceAdapterConfig resourceAdapterConfig = (ResourceAdapterConfig)object;
            return resourceAdapterConfig.getName();
        }
        if (object instanceof JdbcConnectionPool) {
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)object;
            return jdbcConnectionPool.getName();
        }
        if (object instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool connectorConnectionPool = (ConnectorConnectionPool)object;
            return connectorConnectionPool.getName();
        }
        return null;
    }

    private void setResourceName(String string, Object object) {
        if (object instanceof CustomResource) {
            CustomResource customResource = (CustomResource)object;
            customResource.setJndiName(string);
        } else if (object instanceof ExternalJndiResource) {
            ExternalJndiResource externalJndiResource = (ExternalJndiResource)object;
            externalJndiResource.setJndiName(string);
        } else if (object instanceof JdbcResource) {
            JdbcResource jdbcResource = (JdbcResource)object;
            jdbcResource.setJndiName(string);
        } else if (object instanceof MailResource) {
            MailResource mailResource = (MailResource)object;
            mailResource.setJndiName(string);
        } else if (object instanceof PersistenceManagerFactoryResource) {
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = (PersistenceManagerFactoryResource)object;
            persistenceManagerFactoryResource.setJndiName(string);
        } else if (object instanceof AdminObjectResource) {
            AdminObjectResource adminObjectResource = (AdminObjectResource)object;
            adminObjectResource.setJndiName(string);
        } else if (object instanceof ConnectorResource) {
            ConnectorResource connectorResource = (ConnectorResource)object;
            connectorResource.setJndiName(string);
        } else if (object instanceof ResourceAdapterConfig) {
            ResourceAdapterConfig resourceAdapterConfig = (ResourceAdapterConfig)object;
            resourceAdapterConfig.setName(string);
        } else if (object instanceof JdbcConnectionPool) {
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)object;
            jdbcConnectionPool.setName(string);
        } else if (object instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool connectorConnectionPool = (ConnectorConnectionPool)object;
            connectorConnectionPool.setName(string);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isEditButton(int n) {
        ResourceAggregator.ResourceEntry resourceEntry = this.resAggregator.getResources().get(n);
        return resourceEntry.orphanStatus != ResourceAggregator.OrphanStatus.ANNO_ONLY;
    }

    public boolean canDelete(int n) {
        ResourceAggregator.ResourceEntry resourceEntry = this.resAggregator.getResources().get(n);
        return resourceEntry.orphanStatus != ResourceAggregator.OrphanStatus.ANNO_ONLY;
    }

    public void deleteResourceFile(int n) throws Exception {
        this.resAggregator.deleteResourceFile(n);
    }

    public void writeToFile(int n) throws Exception {
        this.resAggregator.writeToSunXML(n);
    }

    public void writeToFile(int n, File file) throws Exception {
        this.resAggregator.writeToSunXML(n, file);
    }

    public Project getProject() {
        return this.resAggregator.getProject();
    }

    public Object getBean(int n) {
        return this.resAggregator.getResources().get((int)n).resource;
    }

    public FileObject getBeanFileObject(int n) {
        return this.resAggregator.getResources().get((int)n).fileObject;
    }

    public List<ResourceAggregator.ResourceUsage> getBeanUsages(int n) {
        return this.resAggregator.getResources().get((int)n).usages;
    }

    public ConnectorConnectionPool getConnectorConnectionPool(String string) {
        ResourceAggregator.PoolEntry poolEntry = this.resAggregator.getConnectorConnectionPoolEntry(string);
        if (poolEntry == null || !(poolEntry.pool instanceof ConnectorConnectionPool)) {
            return null;
        }
        return (ConnectorConnectionPool)poolEntry.pool;
    }

    public ConnectorConnectionPool createDefaultConnectorConnectionPool(String string) {
        ResourceAggregator.PoolEntry poolEntry = this.resAggregator.createDefaultConnectorConnectionPool(string);
        return (ConnectorConnectionPool)poolEntry.pool;
    }

    public JdbcConnectionPool getJdbcConnectionPool(String string) {
        ResourceAggregator.PoolEntry poolEntry = this.resAggregator.getJdbcConnectionPoolEntry(string);
        if (poolEntry == null || !(poolEntry.pool instanceof JdbcConnectionPool)) {
            return null;
        }
        return (JdbcConnectionPool)poolEntry.pool;
    }

    public JdbcConnectionPool createDefaultJdbcConnectionPool(String string) {
        ResourceAggregator.PoolEntry poolEntry = this.resAggregator.createDefaultJdbcConnectionPool(string);
        return (JdbcConnectionPool)poolEntry.pool;
    }
}

