/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualClassPathItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaHelper {
    public static String CASA_DIR_NAME = "/src/conf/";
    public static String CASA_EXT = ".casa";
    private static String WSDL_EXT = ".wsdl";
    private static String LOCK_FILE_PREFIX = ".LCK";
    private static String LOCK_FILE_SUFFIX = "~";
    private static final String CASA_NAMESPACE_URI = "http://java.sun.com/xml/ns/casa";
    private static final String WSIT_CALLBACK_ELEMENT = "WsitCallback";
    private static final String WSIT_CALLBACK_PROJECT = "CallbackProject";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.compapp.projects.jbi.CasaHelper");

    public static String getCasaFileName(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getName();
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        return file.getPath() + CASA_DIR_NAME + string + CASA_EXT;
    }

    public static FileObject getCasaFileObject(JbiProject jbiProject, boolean bl) {
        ProjectInformation projectInformation = (ProjectInformation)jbiProject.getLookup().lookup(ProjectInformation.class);
        assert (projectInformation != null);
        String string = projectInformation.getName();
        FileObject fileObject = jbiProject.getProjectDirectory().getFileObject(CASA_DIR_NAME);
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(string + CASA_EXT);
        if (fileObject2 == null && bl) {
            fileObject2 = CasaHelper.createDefaultCasaFileObject(jbiProject);
            CasaHelper.updateCasaWithJBIModules(jbiProject);
        }
        return fileObject2;
    }

    public static FileObject createDefaultCasaFileObject(JbiProject jbiProject) {
        ProjectInformation projectInformation = (ProjectInformation)jbiProject.getLookup().lookup(ProjectInformation.class);
        assert (projectInformation != null);
        String string = projectInformation.getName();
        FileObject fileObject = jbiProject.getProjectDirectory().getFileObject(CASA_DIR_NAME);
        FileObject fileObject2 = null;
        try {
            fileObject2 = FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-compapp-projects-jbi/project.casa"), (FileObject)fileObject, (String)string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return fileObject2;
    }

    public static FileObject getCompAppWSDLFileObject(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getName();
        FileObject fileObject = ((JbiProject)project).getSourceDirectory();
        return fileObject == null ? null : fileObject.getFileObject(string + WSDL_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsWSDLPort(JbiProject jbiProject) {
        FileObject fileObject = CasaHelper.getCasaFileObject(jbiProject, false);
        if (fileObject != null) {
            InputStream inputStream = null;
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                inputStream = fileObject.getInputStream();
                Document document = documentBuilder.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName("endpoint");
                NodeList nodeList2 = document.getElementsByTagName("port");
                block14: for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element = (Element)nodeList2.item(i);
                    String string = element.getAttribute("state");
                    if (string.equals("deleted")) continue;
                    Element element2 = (Element)element.getElementsByTagName("consumes").item(0);
                    String string2 = element2.getAttribute("endpoint");
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Element element3 = (Element)nodeList.item(j);
                        if (!element3.getAttribute("name").equals(string2)) continue;
                        String string3 = element3.getAttribute("interface-name");
                        if (string3.endsWith(":dummyCasaPortType")) continue block14;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error parsing CASA file: " + exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return false;
    }

    public static void saveCasa(JbiProject jbiProject) {
        FileObject fileObject = CasaHelper.getCasaFileObject(jbiProject, false);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                if (saveCookie != null) {
                    try {
                        saveCookie.save();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
        }
    }

    public static void updateCasaWithJBIModules(JbiProject jbiProject) {
        JbiProjectProperties jbiProjectProperties = jbiProject.getProjectProperties();
        CasaHelper.updateCasaWithJBIModules(jbiProject, jbiProjectProperties);
    }

    public static void updateCasaWithJBIModules(JbiProject jbiProject, JbiProjectProperties jbiProjectProperties) {
        FileObject fileObject = CasaHelper.getCasaFileObject(jbiProject, true);
        if (fileObject == null) {
            return;
        }
        try {
            String string;
            Object object2;
            int n;
            boolean bl = false;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileObject.getInputStream());
            Element element = (Element)document.getElementsByTagName("service-units").item(0);
            NodeList nodeList = element.getElementsByTagName("service-engine-service-unit");
            List list = (List)jbiProjectProperties.get("jbi.content.additional");
            List list2 = (List)jbiProjectProperties.get("jbi.content.component");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VisualClassPathItem visualClassPathItem : list) {
                arrayList.add(visualClassPathItem.getProjectName());
            }
            ArrayList arrayList2 = new ArrayList();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object2 = (Element)nodeList.item(n);
                string = object2.getAttribute("unit-name");
                arrayList2.add(string);
            }
            for (n = 0; n < nodeList.getLength(); ++n) {
                object2 = (Element)nodeList.item(n);
                string = object2.getAttribute("unit-name");
                if (arrayList.contains(string)) continue;
                element.removeChild((Node)object2);
                bl = true;
            }
            for (Object object2 : list) {
                string = ((VisualClassPathItem)object2).getProjectName();
                String string2 = ((VisualClassPathItem)object2).toString();
                if (arrayList2.contains(string)) continue;
                String string3 = "unknown";
                for (int i = 0; i < list.size(); ++i) {
                    if (!((VisualClassPathItem)list.get(i)).toString().equals(string2)) continue;
                    string3 = (String)list2.get(i);
                    break;
                }
                Element element2 = document.createElement("service-engine-service-unit");
                element2.setAttribute("x", "-1");
                element2.setAttribute("y", "-1");
                element2.setAttribute("internal", "true");
                element2.setAttribute("defined", "false");
                element2.setAttribute("unknown", "false");
                element2.setAttribute("name", string);
                element2.setAttribute("unit-name", string);
                element2.setAttribute("component-name", string3);
                element2.setAttribute("description", "some description");
                element2.setAttribute("artifacts-zip", string2);
                element.appendChild(element2);
                bl = true;
            }
            if (bl) {
                XmlUtil.writeToFileObject(fileObject, document);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static List<String> getWsitCallbackProjects(JbiProject jbiProject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileObject fileObject = CasaHelper.getCasaFileObject(jbiProject, true);
        if (fileObject == null) {
            return arrayList;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileObject.getInputStream());
            NodeList nodeList = document.getElementsByTagName("port");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element2;
                    String string;
                    if (!(nodeList2.item(j) instanceof Element) || CASA_NAMESPACE_URI.equals(string = (element2 = (Element)nodeList2.item(j)).getNamespaceURI()) || !element2.getLocalName().equals(WSIT_CALLBACK_ELEMENT)) continue;
                    String string2 = element2.getAttribute(WSIT_CALLBACK_PROJECT);
                    arrayList.add(string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static void cleanupLocks(Project project) {
        String string;
        Object object;
        File file = CasaHelper.getCasaLockFile(project);
        if (file != null && file.exists()) {
            object = NbBundle.getMessage(CasaHelper.class, (String)"CASA_LOCK_EXISTS");
            string = new NotifyDescriptor.Message(object, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
            if (!file.delete()) {
                object = NbBundle.getMessage(CasaHelper.class, (String)"FAIL_TO_DELETE_FILE", (Object)file);
                string = new NotifyDescriptor.Message(object, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
            }
        }
        if ((object = CasaHelper.getCompAppWSDLLockFile(project)) != null && ((File)object).exists()) {
            string = NbBundle.getMessage(CasaHelper.class, (String)"COMPAPP_WSDL_LOCK_EXISTS");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            if (!file.delete()) {
                string = NbBundle.getMessage(CasaHelper.class, (String)"FAIL_TO_DELETE_FILE", (Object)object);
                message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
    }

    private static File getCasaLockFile(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        assert (projectInformation != null);
        String string = projectInformation.getName();
        FileObject fileObject = project.getProjectDirectory().getFileObject(CASA_DIR_NAME);
        if (fileObject != null) {
            File file = new File(FileUtil.toFile((FileObject)fileObject), LOCK_FILE_PREFIX + string + CASA_EXT + LOCK_FILE_SUFFIX);
            return file;
        }
        return null;
    }

    private static File getCompAppWSDLLockFile(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getName();
        FileObject fileObject = ((JbiProject)project).getSourceDirectory();
        if (fileObject != null) {
            File file = new File(FileUtil.toFile((FileObject)fileObject), LOCK_FILE_PREFIX + string + WSDL_EXT + LOCK_FILE_SUFFIX);
            return file;
        }
        return null;
    }
}

