/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.jbiserver.JbiManager;
import org.netbeans.modules.compapp.projects.jbi.AdministrationServiceHelper;
import org.netbeans.modules.compapp.projects.jbi.CasaHelper;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBuildListener;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBuildTask;
import org.netbeans.modules.compapp.projects.jbi.api.ProjectValidator;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.compapp.test.ui.TestcaseNode;
import org.netbeans.modules.sun.manager.jbi.management.JBIMBeanTaskResultHandler;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JbiActionProvider
implements ActionProvider {
    private static final String[] supportedActions = new String[]{"clean", "undeploy", "redeploy", "redeploy", "jbiserver-build", "jbiserver-clean_build", "jbi-clean-config", "validate-portmaps", "test", "delete", "copy", "move", "rename", "build", "rebuild", "debug"};
    JbiProject project;
    private AntProjectHelper antProjectHelper;
    private ReferenceHelper refHelper;
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public JbiActionProvider(JbiProject jbiProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("redeploy", new String[]{"run"});
        this.commands.put("redeploy", new String[]{"run"});
        this.commands.put("undeploy", new String[]{"undeploy"});
        this.commands.put("jbiserver-build", new String[]{"jbi-build"});
        this.commands.put("jbi-clean-config", new String[]{"jbi-clean-config"});
        this.commands.put("jbiserver-clean_build", new String[]{"jbi-clean-build"});
        this.commands.put("validate-portmaps", new String[]{"validate-portmaps"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("build", new String[]{"jbi-build"});
        this.commands.put("rebuild", new String[]{"jbi-clean-build"});
        this.commands.put("debug", new String[]{"debug"});
        this.antProjectHelper = antProjectHelper;
        this.project = jbiProject;
        this.refHelper = referenceHelper;
    }

    String[] getTargetNames(String string, Lookup lookup, Properties properties) throws IllegalArgumentException {
        String[] stringArray = this.commands.get(string);
        return stringArray;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String string, Lookup lookup) throws IllegalArgumentException {
        new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object object;
                ExecutorTask executorTask;
                Object object2;
                if ("delete".equals(string)) {
                    DefaultProjectOperations.performDefaultDeleteOperation((Project)JbiActionProvider.this.project);
                    return;
                }
                if ("copy".equals(string)) {
                    DefaultProjectOperations.performDefaultCopyOperation((Project)JbiActionProvider.this.project);
                    return;
                }
                if ("move".equals(string)) {
                    DefaultProjectOperations.performDefaultMoveOperation((Project)JbiActionProvider.this.project);
                    return;
                }
                if ("rename".equals(string)) {
                    DefaultProjectOperations.performDefaultRenameOperation((Project)JbiActionProvider.this.project, null);
                    return;
                }
                Properties properties = null;
                String[] stringArray = JbiActionProvider.this.commands.get(string);
                if (string.equals("test") && !JbiActionProvider.this.setupTests()) {
                    return;
                }
                if (string.equals("redeploy") || string.equals("redeploy") || string.equals("undeploy") || string.equals("debug") || string.equals("test")) {
                    if (!JbiManager.isSelectedServer(JbiActionProvider.this.project)) {
                        return;
                    }
                    if (!JbiActionProvider.this.validateSubProjects()) {
                        return;
                    }
                    if (string.equals("test")) {
                        JbiManager.startServer(JbiActionProvider.this.project, true);
                        object2 = JbiActionProvider.this.antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
                        try {
                            String string3;
                            boolean bl;
                            executorTask = AdministrationServiceHelper.getRuntimeManagementServiceWrapper((String)object2);
                            executorTask.clearServiceAssemblyStatusCache();
                            object = JbiActionProvider.this.project.getProjectProperties();
                            String string2 = (String)((JbiProjectProperties)object).get("jbi.service-assembly.id");
                            ServiceAssemblyInfo serviceAssemblyInfo = executorTask.getServiceAssembly(string2, "server");
                            if (serviceAssemblyInfo == null) {
                                ArrayList<String> arrayList = new ArrayList<String>();
                                String[] stringArray2 = JbiActionProvider.this.commands.get("redeploy");
                                arrayList.addAll(Arrays.asList(stringArray2));
                                arrayList.addAll(Arrays.asList(stringArray));
                                stringArray = arrayList.toArray(new String[0]);
                            } else if (!serviceAssemblyInfo.getState().equals("Started") && !(bl = JBIMBeanTaskResultHandler.showRemoteInvokationResult((String)"Start", (String)string2, (String)(string3 = executorTask.startServiceAssembly(string2, "server"))))) {
                                return;
                            }
                        }
                        catch (ManagementRemoteException managementRemoteException) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                    }
                } else if (string.equals("jbi-clean-config") || string.equals("jbiserver-build") || string.equals("jbiserver-clean_build")) {
                    if (string.equals("jbi-clean-config")) {
                        object2 = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_CleanServiceAssembly"), NbBundle.getMessage(JbiActionProvider.class, (String)"TTL_CleanServiceAssembly"), 2);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)object2) != NotifyDescriptor.OK_OPTION) {
                            return;
                        }
                    }
                    JbiActionProvider.this.saveCasaChanges(JbiActionProvider.this.project);
                    object2 = JbiActionProvider.this.callWSITJavaCallbackProject(JbiActionProvider.this.project);
                    if (object2 != null) {
                        if (properties == null) {
                            properties = new Properties();
                        }
                        properties.setProperty("WsitCallbackProjects", (String)object2);
                    }
                    if (!JbiActionProvider.this.validateSubProjects()) {
                        return;
                    }
                } else {
                    properties = null;
                    if (stringArray == null) {
                        throw new IllegalArgumentException(string);
                    }
                }
                object2 = JbiActionProvider.this.getBuildListener(string);
                try {
                    executorTask = ActionUtils.runTarget((FileObject)JbiActionProvider.this.findBuildXml(), (String[])stringArray, properties);
                    if (object2 != null) {
                        object = new JbiBuildTask(){

                            public boolean isFinished() {
                                return executorTask.isFinished();
                            }

                            public int getResult() {
                                return executorTask.result();
                            }
                        };
                        object2.buildStarted((JbiBuildTask)object);
                        executorTask.addTaskListener(new TaskListener((JbiBuildListener)object2, executorTask){
                            final /* synthetic */ JbiBuildListener val$jbiBuildListener;
                            final /* synthetic */ ExecutorTask val$executorTask;
                            {
                                this.val$jbiBuildListener = jbiBuildListener;
                                this.val$executorTask = executorTask;
                            }

                            public void taskFinished(Task task) {
                                this.val$jbiBuildListener.buildCompleted(this.val$executorTask.result() == 0);
                            }
                        });
                    }
                    if (!string.equals("test")) return;
                    executorTask.addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            FileObject fileObject = JbiActionProvider.this.project.getTestDirectory();
                            if (fileObject != null) {
                                String string = FileUtil.toFile((FileObject)fileObject).getPath() + "/selected-tests.properties";
                                try {
                                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                                    String string2 = bufferedReader.readLine();
                                    assert (string2.startsWith("testcases="));
                                    String string3 = string2.substring(string2.indexOf(61));
                                    for (String string4 : string3.split(",")) {
                                        FileObject fileObject2 = fileObject.getFileObject(string4.trim());
                                        TestcaseNode.setTestCaseRunning(fileObject2, false);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    });
                    return;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }).start();
    }

    private JbiBuildListener getBuildListener(String string) {
        FileObject fileObject;
        if ((string.equals("redeploy") || string.equals("jbi-clean-config") || string.equals("jbiserver-build") || string.equals("jbiserver-clean_build")) && (fileObject = CasaHelper.getCasaFileObject(this.project, false)) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject != null) {
                    return (JbiBuildListener)dataObject.getLookup().lookup(JbiBuildListener.class);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean validateSubProjects() {
        try {
            Object object;
            Object object22;
            JbiProjectProperties jbiProjectProperties = this.project.getProjectProperties();
            List list = (List)jbiProjectProperties.get("jbi.content.additional");
            ArrayList<Project> arrayList = new ArrayList<Project>();
            HashMap hashMap = new HashMap();
            for (Object object22 : list) {
                object = ((VisualClassPathItem)object22).getAntArtifact().getProject();
                arrayList.add((Project)object);
                hashMap.put(object.getClass(), object);
            }
            Collection collection = Lookup.getDefault().lookupAll(ProjectValidator.class);
            object22 = collection.iterator();
            while (object22.hasNext()) {
                object = (ProjectValidator)object22.next();
                String string = object.validateProjects(arrayList);
                if (string == null) continue;
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private String callWSITJavaCallbackProject(JbiProject jbiProject) {
        List<String> list = CasaHelper.getWsitCallbackProjects(jbiProject);
        String string = null;
        boolean bl = true;
        for (String string2 : list) {
            File file = new File(string2 + "/build.xml");
            FileObject fileObject = FileUtil.toFileObject((File)file);
            String[] stringArray = new String[]{"compile"};
            Properties properties = null;
            try {
                ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, properties);
                if (!bl) {
                    string = string + ";" + string2;
                    continue;
                }
                bl = false;
                string = string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    private void saveCasaChanges(JbiProject jbiProject) {
        CasaHelper.saveCasa(jbiProject);
        FileObject fileObject = CasaHelper.getCompAppWSDLFileObject(jbiProject);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                if (saveCookie != null) {
                    saveCookie.save();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean setupTests() {
        try {
            Object object;
            Object object2;
            FileObject fileObject = this.project.getTestDirectory();
            if (fileObject == null) {
                fileObject = this.project.createTestDirectory();
                String string2 = NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoTestCase");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return false;
            }
            Enumeration enumeration = fileObject.getFolders(false);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            final ArrayList<Object> arrayList2 = new ArrayList<Object>();
            while (enumeration.hasMoreElements()) {
                object2 = (FileObject)enumeration.nextElement();
                object = object2.getName();
                if (((String)object).equals("results") || ((String)object).equalsIgnoreCase("cvs")) continue;
                if (!TestcaseNode.isTestCaseRunning((FileObject)object2)) {
                    arrayList.add(object);
                    continue;
                }
                arrayList2.add(object);
            }
            if (arrayList2.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_SkipTestCaseInProgress", (Object)arrayList2);
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                });
            }
            if (arrayList.size() == 0 && arrayList2.size() == 0) {
                object2 = NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoTestCase");
                object = new NotifyDescriptor.Message(object2, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                return false;
            }
            Collections.sort(arrayList);
            object2 = "";
            for (String string3 : arrayList) {
                object2 = (String)object2 + string3 + ",";
            }
            if (((String)object2).length() > 1) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            object = FileUtil.toFile((FileObject)fileObject).getPath() + "/all-tests.properties";
            EditableProperties editableProperties = new EditableProperties();
            editableProperties.setProperty("testcases", (String)object2);
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            editableProperties.store((OutputStream)fileOutputStream);
            fileOutputStream.close();
            object = FileUtil.toFile((FileObject)fileObject).getPath() + "/selected-tests.properties";
            EditableProperties editableProperties2 = new EditableProperties();
            editableProperties2.setProperty("testcases", (String)object2);
            fileOutputStream = new FileOutputStream((String)object);
            editableProperties2.store((OutputStream)fileOutputStream);
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        return this.findBuildXml() != null;
    }

    private boolean isDebugged() {
        return false;
    }

    private boolean isProjectEmpty() {
        String string = this.antProjectHelper.getStandardPropertyEvaluator().getProperty("jbi.content.additional");
        return string == null || string.trim().length() < 1;
    }
}

