/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.compapp.jbiserver.JbiManager;
import org.netbeans.modules.compapp.projects.jbi.CasaHelper;
import org.netbeans.modules.compapp.projects.jbi.ComponentInfoGenerator;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JbiProjectGenerator {
    private static final String DEFAULT_CONF_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_JBIASA_FOLDER = "jbiasa";
    private static final String DEFAULT_COMPONENTASA_FOLDER = "jbiServiceUnits";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_JBI_ROUTING = "true";
    private static final String DEFAULT_JBI_SA_INTERNAL_ROUTING = "true";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String DEFAULT_TEST_RESULTS_FOLDER = "${basedir}/test/results";

    private JbiProjectGenerator() {
    }

    public static AntProjectHelper createProject(File file, String string, String string2) throws IOException {
        file.mkdirs();
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        assert (fileObject != null) : "At least disk roots must be mounted! " + file2;
        fileObject.getFileSystem().refresh(false);
        fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            throw new IOException("Can't create " + file.getName());
        }
        assert (fileObject.isFolder()) : "Not really a dir: " + file;
        assert (fileObject.getChildren().length == 0) : "Dir must have been empty: " + file;
        AntProjectHelper antProjectHelper = JbiProjectGenerator.setupProject(fileObject, string, string2);
        FileObject fileObject2 = fileObject.createFolder(DEFAULT_SRC_FOLDER);
        fileObject2.createFolder(DEFAULT_JBIASA_FOLDER);
        FileObject fileObject3 = fileObject2.createFolder(DEFAULT_CONF_FOLDER);
        fileObject.createFolder(DEFAULT_TEST_FOLDER);
        String string3 = FileUtil.toFile((FileObject)fileObject3).getPath();
        new ComponentInfoGenerator(string3).doIt();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.put("source.root", DEFAULT_SRC_FOLDER);
        editableProperties.setProperty("meta.inf", "${source.root}/conf");
        editableProperties.setProperty("src.dir", "${source.root}/jbiasa");
        editableProperties.setProperty("src.build.dir", "${source.root}/jbiServiceUnits");
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", charset.name());
        editableProperties.setProperty("com.sun.jbi.routing", "true");
        editableProperties.setProperty("com.sun.jbi.sa.internal.routing", "true");
        editableProperties.setProperty("test.dir", DEFAULT_TEST_FOLDER);
        editableProperties.setProperty("test.results.dir", DEFAULT_TEST_RESULTS_FOLDER);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        Project project = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject(project);
        CasaHelper.createDefaultCasaFileObject((JbiProject)project);
        return antProjectHelper;
    }

    public static AntProjectHelper importProject(File file, String string, FileObject fileObject, FileObject fileObject2, FileObject fileObject3, String string2, String string3) throws IOException {
        File file2;
        file.mkdirs();
        File file3 = file;
        while (file3.getParentFile() != null) {
            file3 = file3.getParentFile();
        }
        FileObject fileObject4 = FileUtil.toFileObject((File)file3);
        assert (fileObject4 != null) : "At least disk roots must be mounted! " + file3;
        fileObject4.getFileSystem().refresh(false);
        fileObject4 = FileUtil.toFileObject((File)file);
        if (fileObject4 == null) {
            throw new IOException("Can't create " + file.getName());
        }
        assert (fileObject4.isFolder()) : "Not really a dir: " + file;
        AntProjectHelper antProjectHelper = JbiProjectGenerator.setupProject(fileObject4, string, string2);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        if (FileUtil.isParentOf((FileObject)fileObject4, (FileObject)fileObject) || fileObject4.equals(fileObject)) {
            editableProperties.put("source.root", ".");
            editableProperties.setProperty("src.dir", JbiProjectGenerator.relativePath(fileObject4, fileObject2));
            editableProperties.setProperty("meta.inf", JbiProjectGenerator.relativePath(fileObject4, fileObject3));
        } else {
            file2 = FileUtil.toFile((FileObject)fileObject);
            editableProperties.put("source.root", file2.getAbsolutePath());
            String string4 = JbiProjectGenerator.relativePath(fileObject, fileObject3);
            string4 = string4.length() > 0 ? "${source.root}/" + string4 : "${source.root}";
            String string5 = JbiProjectGenerator.relativePath(fileObject, fileObject2);
            string5 = string5.length() > 0 ? "${source.root}/" + string5 : "${source.root}";
            editableProperties.setProperty("src.dir", string5);
            editableProperties.setProperty("meta.inf", string4);
        }
        if (!"build.xml".equals(string3)) {
            editableProperties.setProperty("buildfile", string3);
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        file2 = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject((Project)file2);
        return antProjectHelper;
    }

    private static String relativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            throw new IllegalArgumentException(NbBundle.getMessage(JbiProjectGenerator.class, (String)"MSG_Cannot_find_relative_path", (Object)fileObject, (Object)fileObject2));
        }
        return fileObject2.getPath().substring(fileObject.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject fileObject, String string, String string2) throws IOException {
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.compapp.projects.jbi");
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-jbi/1", "name");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/j2ee-jbi/1", "minimum-ant-version");
        element3.appendChild(document.createTextNode("1.6"));
        element.appendChild(element3);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("dist.dir", "dist");
        editableProperties.setProperty("dist.jar", "${dist.dir}/" + string + ".zip");
        editableProperties.setProperty("j2ee.platform", string2);
        editableProperties.setProperty("jar.compress", "false");
        Deployment deployment = Deployment.getDefault();
        editableProperties.setProperty("javac.source", "1.4");
        editableProperties.setProperty("javac.debug", "true");
        editableProperties.setProperty("javac.deprecation", "false");
        editableProperties.setProperty("javac.target", "1.4");
        editableProperties.setProperty("build.dir", DEFAULT_BUILD_DIR);
        editableProperties.setProperty("build.generated.dir", "${build.dir}/generated");
        editableProperties.setProperty("build.classes.dir", "${build.dir}/jar");
        editableProperties.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        editableProperties.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        editableProperties.setProperty("platform.active", "default_platform");
        editableProperties.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}");
        editableProperties.setProperty("javadoc.private", "false");
        editableProperties.setProperty("javadoc.notree", "false");
        editableProperties.setProperty("javadoc.use", "true");
        editableProperties.setProperty("javadoc.nonavbar", "false");
        editableProperties.setProperty("javadoc.noindex", "false");
        editableProperties.setProperty("javadoc.splitindex", "true");
        editableProperties.setProperty("javadoc.author", "false");
        editableProperties.setProperty("javadoc.version", "false");
        editableProperties.setProperty("javadoc.windowtitle", "");
        editableProperties.setProperty("javadoc.encoding", "");
        editableProperties.setProperty("javadoc.preview", "true");
        editableProperties.setProperty("jbi.service-assembly.id", string);
        editableProperties.setProperty("jbi.service-assembly.description", NbBundle.getMessage(JbiProjectGenerator.class, (String)"SERVICE_ASSEMBLY_DESCRIPTION", (Object)string));
        editableProperties.setProperty("jbi.service-unit.description", NbBundle.getMessage(JbiProjectGenerator.class, (String)"DEFAULT_SERVICE_UNIT_DESCRIPTION"));
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        String[] stringArray = JbiManager.getAppServers();
        if (stringArray != null && stringArray.length == 1) {
            editableProperties.setProperty("j2ee.server.instance", stringArray[0]);
        }
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }
}

