/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.awt.Image;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.test.ui.TestcaseNode;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseResultCookie;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseResultDiffAction;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseResultSaveAsOutputAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseResultNode
extends FilterNode {
    private static final Logger mLogger = Logger.getLogger("org.netbeans.modules.compapp.projects.jbi.ui.TestCaseResultNode");
    private static final Image RESULT_SUCCESS_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/test/ui/resources/result_success.png", (boolean)true);
    private static final Image RESULT_FAILURE_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/test/ui/resources/result_failure.png", (boolean)true);
    private JbiProject mProject;
    private FileObject mActualFile;
    private boolean mSuccess;
    private TestCaseResultCookie mTestCaseResultCookie;

    public TestCaseResultNode(JbiProject jbiProject, DataObject dataObject) {
        super(dataObject.getNodeDelegate(), FilterNode.Children.LEAF);
        this.mProject = jbiProject;
        this.mActualFile = dataObject.getPrimaryFile();
        String string = this.mActualFile.getName();
        this.mSuccess = string.endsWith("_S");
        this.mTestCaseResultCookie = new TestCaseResultCookie(this);
    }

    public String getDisplayName() {
        String string = this.mActualFile.getName();
        String string2 = TestCaseResultNode.getActualResultTimeStamp(string);
        if (!this.mSuccess) {
            String string3 = NbBundle.getMessage(TestCaseResultNode.class, (String)"FAILED_RESULT_SUFFIX");
            string2 = string2 + string3;
        }
        return string2;
    }

    public boolean isSuccessful() {
        return this.mSuccess;
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public Image getIcon(int n) {
        return this.mSuccess ? RESULT_SUCCESS_ICON : RESULT_FAILURE_ICON;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(TestCaseResultDiffAction.class), SystemAction.get(TestCaseResultSaveAsOutputAction.class), null, SystemAction.get(EditAction.class), SystemAction.get(DeleteAction.class)};
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz == TestCaseResultCookie.class) {
            return (T)this.mTestCaseResultCookie;
        }
        return (T)super.getCookie(clazz);
    }

    public JbiProject getProject() {
        return this.mProject;
    }

    public TestcaseNode getTestCaseNode() {
        return (TestcaseNode)this.getParentNode();
    }

    public void destroy() throws IOException {
        final TestcaseNode testcaseNode = this.getTestCaseNode();
        super.destroy();
        if (testcaseNode.isDiffTopComponentVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    testcaseNode.refreshDiffTopComponent();
                }
            });
        }
    }

    public static String getActualResultTimeStamp(String string) {
        String string2;
        try {
            String string3 = string.substring(7, 11);
            String string4 = string.substring(11, 13);
            String string5 = string.substring(13, 15);
            String string6 = string.substring(15, 17);
            String string7 = string.substring(17, 19);
            String string8 = string.substring(19, 21);
            int n = Integer.parseInt(string3);
            int n2 = Integer.parseInt(string4);
            int n3 = Integer.parseInt(string5);
            int n4 = Integer.parseInt(string6);
            int n5 = Integer.parseInt(string7);
            int n6 = Integer.parseInt(string8);
            Calendar calendar = Calendar.getInstance();
            calendar.set(n, n2 - 1, n3, n4, n5, n6);
            Date date = calendar.getTime();
            Object[] objectArray = new Object[]{date};
            String string9 = "{0, date} {0, time}";
            string2 = MessageFormat.format(string9, objectArray);
        }
        catch (Exception exception) {
            string2 = "<Unknown Time Stamp>";
        }
        return string2;
    }
}

