/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.wsdl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.netbeans.modules.compapp.test.wsdl.SchemaException;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlSupport {
    private static final Logger mLog = Logger.getLogger("org.netbeans.modules.compapp.test.wsdl.WsdlSupport");
    private String mWsdlUrl;
    private WSDLModel mWsdlModel;
    private SchemaTypeLoader mSchemaTypeLoader;
    private String mWsdlSupportErrStr = "";

    public WsdlSupport(FileObject fileObject) {
        this.mWsdlUrl = "file:" + FileUtil.toFile((FileObject)fileObject).getPath();
        try {
            ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)true);
            this.mWsdlModel = WSDLModelFactory.getDefault().getModel(modelSource);
            this.mSchemaTypeLoader = WsdlSupport.loadSchemaTypes(this.mWsdlUrl);
        }
        catch (Exception exception) {
            String string = NbBundle.getMessage(WsdlSupport.class, (String)"LBL_Fail_to_load_schema_types", (Object)this.mWsdlUrl);
            if (exception.getMessage() != null) {
                string = string + "\n" + exception.getMessage();
                String string2 = System.getProperty("line.separator");
                string = string + string2;
                string = string + string2;
                string = string + "The original error message is:";
                string = string + string2;
                string = string + exception.getMessage();
            }
            this.mWsdlSupportErrStr = this.mWsdlSupportErrStr + string;
            mLog.severe(string);
        }
    }

    WsdlSupport(FileObject fileObject, ModelSource modelSource) {
        this.mWsdlUrl = "file:" + FileUtil.toFile((FileObject)fileObject).getPath();
        try {
            this.mWsdlModel = WSDLModelFactory.getDefault().getModel(modelSource);
            this.mSchemaTypeLoader = WsdlSupport.loadSchemaTypes(this.mWsdlUrl);
        }
        catch (Exception exception) {
            String string = NbBundle.getMessage(WsdlSupport.class, (String)"LBL_Fail_to_load_schema_types", (Object)this.mWsdlUrl);
            if (exception.getMessage() != null) {
                string = string + "\n" + exception.getMessage();
                String string2 = System.getProperty("line.separator");
                string = string + string2;
                string = string + string2;
                string = string + "The original error message is:";
                string = string + string2;
                string = string + exception.getMessage();
            }
            this.mWsdlSupportErrStr = this.mWsdlSupportErrStr + string;
            mLog.severe(string);
        }
    }

    public WSDLModel getWsdlModel() {
        return this.mWsdlModel;
    }

    public SchemaTypeLoader getSchemaTypeLoader() {
        return this.mSchemaTypeLoader;
    }

    public String getWsdlSupportError() {
        return this.mWsdlSupportErrStr;
    }

    public void setWsdlSupportError(String string) {
        this.mWsdlSupportErrStr = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SchemaTypeLoader loadSchemaTypes(String string) throws XmlException, SchemaException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(XmlObject.class.getClassLoader());
        try {
            XmlObject xmlObject2;
            HashMap<String, XmlObject> hashMap = new HashMap<String, XmlObject>();
            WsdlSupport.getSchemas(string, hashMap, new ArrayList<String>());
            ArrayList arrayList = new ArrayList(hashMap.values());
            for (XmlObject xmlObject2 : arrayList) {
                WsdlSupport.removeImportAndInclude(xmlObject2);
            }
            SchemaTypeLoader schemaTypeLoader = WsdlSupport.loadSchemaTypes(arrayList);
            xmlObject2 = schemaTypeLoader;
            return xmlObject2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static SchemaTypeLoader loadSchemaTypes(List list) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setCompileNoValidation();
        xmlOptions.setCompileNoPvrRule();
        xmlOptions.setCompileDownloadUrls();
        xmlOptions.setCompileNoUpaRule();
        xmlOptions.setValidateTreatLaxAsSkip();
        xmlOptions.setLoadStripProcinsts();
        xmlOptions.setCompileNoAnnotations();
        xmlOptions.setLoadStripComments();
        xmlOptions.setLoadStripWhitespace();
        xmlOptions.setLoadTrimTextBuffer();
        ArrayList arrayList = new ArrayList();
        xmlOptions.setErrorListener(arrayList);
        try {
            list.add(XmlObject.Factory.parse((URL)WsdlSupport.class.getResource("/org/netbeans/modules/compapp/test/wsdl/resources/soapEncoding.xsd")));
            XmlObject[] xmlObjectArray = list.toArray(new XmlObject[0]);
            return XmlBeans.loadXsd((XmlObject[])xmlObjectArray, (XmlOptions)xmlOptions);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static void getSchemas(String string, Map<String, XmlObject> map, List<String> list) throws SchemaException {
        if (map.containsKey(string)) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        HashMap<String, XmlObject> hashMap = new HashMap<String, XmlObject>();
        try {
            Object object;
            XmlObject[] xmlObjectArray;
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setCompileNoValidation();
            xmlOptions.setSaveUseOpenFrag();
            xmlOptions.setErrorListener(arrayList);
            xmlOptions.setLoadStripProcinsts();
            xmlOptions.setCompileNoAnnotations();
            xmlOptions.setLoadStripComments();
            xmlOptions.setLoadStripWhitespace();
            xmlOptions.setLoadTrimTextBuffer();
            xmlOptions.setSaveSyntheticDocumentElement(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
            XmlObject xmlObject = XmlObject.Factory.parse((URL)new URL(string), (XmlOptions)xmlOptions);
            Document document = (Document)xmlObject.getDomNode();
            Element element = document.getDocumentElement();
            if (element.getLocalName().equals("schema") && element.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                hashMap.put(string, xmlObject);
            } else {
                xmlObjectArray = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:schema");
                for (int i = 0; i < xmlObjectArray.length; ++i) {
                    XmlCursor xmlCursor = xmlObjectArray[i].newCursor();
                    object = xmlCursor.getObject().xmlText(xmlOptions);
                    xmlObjectArray[i] = XmlObject.Factory.parse((String)object, (XmlOptions)xmlOptions);
                    xmlObjectArray[i].documentProperties().setSourceName(string);
                    hashMap.put(string + "@" + (i + 1), xmlObjectArray[i]);
                }
                XmlObject[] xmlObjectArray2 = xmlObject.selectPath("declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
                for (int i = 0; i < xmlObjectArray2.length; ++i) {
                    object = ((SimpleValue)xmlObjectArray2[i]).getStringValue();
                    if (object == null) continue;
                    if (!object.startsWith("file:") && object.indexOf("://") <= 0) {
                        object = WsdlSupport.resolveRelativeUrl(string, (String)object);
                    }
                    WsdlSupport.getSchemas((String)object, map, list);
                }
            }
            xmlObjectArray = hashMap.values().toArray(new XmlObject[hashMap.size()]);
            for (int i = 0; i < xmlObjectArray.length; ++i) {
                xmlObject = xmlObjectArray[i];
                XmlObject[] xmlObjectArray3 = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
                object = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
                List<XmlObject> list2 = Arrays.asList(xmlObjectArray3);
                List<XmlObject> list3 = Arrays.asList(object);
                ArrayList<XmlObject> arrayList2 = new ArrayList<XmlObject>();
                arrayList2.addAll(list2);
                arrayList2.addAll(list3);
                for (XmlObject xmlObject2 : arrayList2) {
                    String string2 = ((SimpleValue)xmlObject2).getStringValue();
                    if (string2 == null || string2.equals("http://schemas.xmlsoap.org/soap/encoding/")) continue;
                    if (!string2.startsWith("file:") && string2.indexOf("://") <= 0) {
                        string2 = WsdlSupport.resolveRelativeUrl(string, string2);
                    }
                    if (list.contains(string2)) continue;
                    list.add(string2);
                    WsdlSupport.getSchemas(string2, map, list);
                }
            }
            map.putAll(hashMap);
        }
        catch (Exception exception) {
            throw new SchemaException(exception, arrayList);
        }
    }

    private static void removeImportAndInclude(XmlObject xmlObject) throws XmlException {
        XmlObject[] xmlObjectArray = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import");
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            xmlObjectArray[i].newCursor().removeXml();
        }
        XmlObject[] xmlObjectArray2 = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include");
        for (int i = 0; i < xmlObjectArray2.length; ++i) {
            xmlObjectArray2[i].newCursor().removeXml();
        }
    }

    private static String resolveRelativeUrl(String string, String string2) {
        int n;
        int n2;
        if (string.startsWith("file:")) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(string.substring(5)));
            try {
                ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)false);
                CatalogWriteModel catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(fileObject);
                ModelSource modelSource2 = catalogWriteModel.getModelSource(new URI(string2), modelSource);
                FileObject fileObject2 = (FileObject)modelSource2.getLookup().lookup(FileObject.class);
                return "file:" + FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((n2 = (string = string.replaceAll("\\\\", "/")).lastIndexOf(47)) == -1) {
            n2 = string.lastIndexOf(47);
        }
        while (string2.startsWith("../") && (n = string.lastIndexOf(47, n2 - 1)) != -1) {
            string = string.substring(0, n + 1);
            n2 = n;
            string2 = string2.substring(3);
        }
        return string.substring(0, n2 + 1) + string2;
    }
}

