/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.html.HTMLLexerFormatter;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.parser.SyntaxParser;
import org.netbeans.editor.ext.html.parser.SyntaxParserListener;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.gsfret.InstantRenameAction;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.SelectCodeElementAction;
import org.netbeans.modules.gsf.api.BracketCompletion;
import org.netbeans.modules.html.editor.coloring.EmbeddingUpdater;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.deprecated.ELDrawLayerFactory;
import org.netbeans.modules.web.core.syntax.deprecated.Jsp11Syntax;
import org.netbeans.modules.web.core.syntax.formatting.JSPLexerFormatter;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.spi.jsp.lexer.JspParseData;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

public class JSPKit
extends NbEditorKit
implements HelpCtx.Provider {
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String TAG_MIME_TYPE = "text/x-tag";
    private static final long serialVersionUID = 8933974837050367142L;
    public static final boolean debug = false;
    private final String mimeType;

    private static JSPKit createKitForJsp() {
        return new JSPKit(JSP_MIME_TYPE);
    }

    private static JSPKit createKitForTag() {
        return new JSPKit(TAG_MIME_TYPE);
    }

    public JSPKit(String string) {
        this.mimeType = string;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public Object clone() {
        return new JSPKit(this.mimeType);
    }

    public Syntax createSyntax(Document document) {
        this.initLexerColoringListener(document);
        Syntax syntax = JSPKit.getSyntaxForLanguage(document, JspUtils.getContentLanguage());
        Syntax syntax2 = JSPKit.getSyntaxForLanguage(document, JspUtils.getScriptingLanguage());
        Jsp11Syntax jsp11Syntax = new Jsp11Syntax(syntax, syntax2);
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        FileObject fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
        JSPColoringData jSPColoringData = JspUtils.getJSPColoringData(document, fileObject);
        ColoringListener coloringListener = new ColoringListener(document, jSPColoringData, jsp11Syntax);
        if (jSPColoringData != null) {
            jSPColoringData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)coloringListener, (Object)jSPColoringData));
        }
        return jsp11Syntax;
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new JspInsertBreakAction(), new JspDefaultKeyTypedAction(), new JspDeleteCharAction("delete-previous", false), new JspDeleteCharAction("delete-next", true), new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new InstantRenameAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public static Syntax getSyntaxForLanguage(Document document, String string) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        if (editorKit instanceof JavaKit) {
            JavaKit javaKit = (JavaKit)editorKit;
            String string2 = javaKit.getSourceLevel((BaseDocument)document);
            return new JavaSyntax(string2, true);
        }
        return new HTMLSyntax();
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.addLayer((DrawLayer)new JavaDrawLayerFactory.JavaLayer(), 1010);
        baseDocument.addLayer((DrawLayer)new ELDrawLayerFactory.ELLayer(), 1010);
        LanguagePath languagePath = LanguagePath.get((Language)JspTokenId.language());
        LanguagePath languagePath2 = LanguagePath.get((LanguagePath)languagePath, (Language)HTMLTokenId.language());
        baseDocument.getDocumentProperties().put("mimeType", "text/x-java");
        SyntaxParser.get((Document)baseDocument, (LanguagePath)languagePath2).addSyntaxParserListener((SyntaxParserListener)new EmbeddingUpdater((Document)baseDocument));
    }

    private void initLexerColoringListener(Document document) {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        FileObject fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
        JSPColoringData jSPColoringData = JspUtils.getJSPColoringData(document, fileObject);
        if (jSPColoringData == null) {
            return;
        }
        JspParseData jspParseData = new JspParseData();
        jspParseData.updateParseData(jSPColoringData.getPrefixMapper(), jSPColoringData.isELIgnored(), jSPColoringData.isXMLSyntax());
        LexerColoringListener lexerColoringListener = new LexerColoringListener(document, jSPColoringData, jspParseData);
        jSPColoringData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)lexerColoringListener, (Object)jSPColoringData));
        document.putProperty(LexerColoringListener.class, lexerColoringListener);
        InputAttributes inputAttributes = new InputAttributes();
        inputAttributes.setValue(JspTokenId.language(), JspParseData.class, (Object)jspParseData, false);
        document.putProperty(InputAttributes.class, inputAttributes);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSPKit.class);
    }

    static BracketCompletion getBracketCompletion(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (org.netbeans.modules.gsf.Language language : list) {
            if (language.getBracketCompletion() == null) continue;
            return language.getBracketCompletion();
        }
        return null;
    }

    private static boolean completionSettingEnabled() {
        return true;
    }

    public static class JspDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        JTextComponent currentTarget;

        public JspDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Action action;
            JavaKit javaKit;
            TokenSequence tokenSequence;
            this.currentTarget = jTextComponent;
            if (jTextComponent != null && (tokenSequence = JspSyntaxSupport.tokenSequence(TokenHierarchy.get((Document)jTextComponent.getDocument()), JavaTokenId.language(), jTextComponent.getCaret().getDot() - 1)) != null && (javaKit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = javaKit.getActionByName(this.nextChar ? "delete-next" : "delete-previous")) != null && action instanceof JavaKit.JavaDeleteCharAction) {
                ((JavaKit.JavaDeleteCharAction)action).actionPerformed(actionEvent, jTextComponent);
                return;
            }
            super.actionPerformed(actionEvent, jTextComponent);
            this.currentTarget = null;
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            BracketCompletion bracketCompletion;
            if (JSPKit.completionSettingEnabled() && (bracketCompletion = JSPKit.getBracketCompletion((Document)baseDocument, n)) != null) {
                boolean bl = bracketCompletion.charBackspaced((Document)baseDocument, n, this.currentTarget, c);
                return;
            }
            super.charBackspaced(baseDocument, n, caret, c);
        }
    }

    public static class JspDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private JTextComponent currentTarget;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.currentTarget = jTextComponent;
            if (jTextComponent != null) {
                Action action;
                JavaKit javaKit;
                TokenSequence tokenSequence;
                AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
                abstractDocument.readLock();
                try {
                    tokenSequence = JspSyntaxSupport.tokenSequence(TokenHierarchy.get((Document)jTextComponent.getDocument()), JavaTokenId.language(), jTextComponent.getCaret().getDot() - 1);
                }
                finally {
                    abstractDocument.readUnlock();
                }
                if (tokenSequence != null && (javaKit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = javaKit.getActionByName("default-typed")) != null && action instanceof JavaKit.JavaDefaultKeyTypedAction) {
                    ((JavaKit.JavaDefaultKeyTypedAction)action).actionPerformed(actionEvent, jTextComponent);
                    return;
                }
            }
            super.actionPerformed(actionEvent, jTextComponent);
            this.currentTarget = null;
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            BracketCompletion bracketCompletion;
            if (JSPKit.completionSettingEnabled() && (bracketCompletion = JSPKit.getBracketCompletion((Document)baseDocument, n)) != null) {
                boolean bl2 = bracketCompletion.beforeCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                if (!bl2) {
                    super.insertString(baseDocument, n, caret, string, bl);
                    bl2 = bracketCompletion.afterCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                }
                return;
            }
            super.insertString(baseDocument, n, caret, string, bl);
            this.handleTagClosingSymbol(baseDocument, n, string.charAt(0));
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            Document document = jTextComponent.getDocument();
            if (document instanceof BaseDocument) {
                BracketCompletion bracketCompletion;
                BaseDocument baseDocument = (BaseDocument)document;
                if (JSPKit.completionSettingEnabled() && (bracketCompletion = JSPKit.getBracketCompletion((Document)baseDocument, n)) != null) {
                    try {
                        int n2 = caret.getDot();
                        boolean bl2 = bracketCompletion.beforeCharInserted((Document)baseDocument, n2, jTextComponent, c);
                        int n3 = Math.min(caret.getDot(), caret.getMark());
                        int n4 = Math.max(caret.getDot(), caret.getMark());
                        if (n3 != n4) {
                            baseDocument.remove(n3, n4 - n3);
                        }
                        if (!bl2) {
                            if (string != null && string.length() > 0) {
                                baseDocument.insertString(n3, string, null);
                            }
                            bracketCompletion.afterCharInserted((Document)baseDocument, caret.getDot() - 1, jTextComponent, c);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    return;
                }
            }
            super.replaceSelection(jTextComponent, n, caret, string, bl);
        }

        private void handleTagClosingSymbol(BaseDocument baseDocument, int n, char c) throws BadLocationException {
            if (c == '>') {
                LanguagePath languagePath = LanguagePath.get((Language)JspTokenId.language());
                LanguagePath languagePath2 = LanguagePath.get((LanguagePath)languagePath, (Language)HTMLTokenId.language());
                HTMLLexerFormatter hTMLLexerFormatter = new HTMLLexerFormatter(languagePath2);
                if (hTMLLexerFormatter.isJustAfterClosingTag(baseDocument, n)) {
                    this.reformat(baseDocument, n);
                } else {
                    JSPLexerFormatter jSPLexerFormatter = new JSPLexerFormatter();
                    if (jSPLexerFormatter.isJustAfterClosingTag(baseDocument, n)) {
                        this.reformat(baseDocument, n);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reformat(BaseDocument baseDocument, int n) throws BadLocationException {
            Reformat reformat = Reformat.get((Document)baseDocument);
            reformat.lock();
            try {
                baseDocument.atomicLock();
                try {
                    int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    reformat.reformat(n2, n3);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            finally {
                reformat.unlock();
            }
        }
    }

    public static class JspInsertBreakAction
    extends BaseKit.InsertBreakAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Action action;
                JavaKit javaKit;
                TokenSequence tokenSequence;
                AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
                abstractDocument.readLock();
                try {
                    tokenSequence = JspSyntaxSupport.tokenSequence(TokenHierarchy.get((Document)jTextComponent.getDocument()), JavaTokenId.language(), jTextComponent.getCaret().getDot() - 1);
                }
                finally {
                    abstractDocument.readUnlock();
                }
                if (tokenSequence != null && (javaKit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = javaKit.getActionByName("insert-break")) != null && action instanceof JavaKit.JavaInsertBreakAction) {
                    ((JavaKit.JavaInsertBreakAction)action).actionPerformed(actionEvent, jTextComponent);
                    return;
                }
            }
            super.actionPerformed(actionEvent, jTextComponent);
        }

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            BracketCompletion bracketCompletion;
            if (JSPKit.completionSettingEnabled() && (bracketCompletion = JSPKit.getBracketCompletion((Document)baseDocument, caret.getDot())) != null) {
                try {
                    int n = bracketCompletion.beforeBreak((Document)baseDocument, caret.getDot(), jTextComponent);
                    if (n >= 0) {
                        return new Integer(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (JSPKit.completionSettingEnabled() && object != null && object instanceof Integer) {
                int n = (Integer)object;
                if (n != -1) {
                    caret.setDot(n);
                } else {
                    int n2 = caret.getDot();
                    caret.setDot(n2 + 1);
                }
            }
        }
    }

    private static class LexerColoringListener
    implements PropertyChangeListener {
        private Document doc;
        private JSPColoringData data;
        private JspParseData jspParseData;

        private LexerColoringListener(Document document, JSPColoringData jSPColoringData, JspParseData jspParseData) {
            this.doc = document;
            this.data = jSPColoringData;
            this.jspParseData = jspParseData;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("coloringChange".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        NbEditorDocument nbEditorDocument = (NbEditorDocument)LexerColoringListener.this.doc;
                        nbEditorDocument.extWriteLock();
                        try {
                            LexerColoringListener.this.recolor();
                        }
                        finally {
                            nbEditorDocument.extWriteUnlock();
                        }
                    }
                });
            }
        }

        private void recolor() {
            this.jspParseData.updateParseData(this.data.getPrefixMapper(), this.data.isELIgnored(), this.data.isXMLSyntax());
            MutableTextInput mutableTextInput = (MutableTextInput)this.doc.getProperty(MutableTextInput.class);
            if (mutableTextInput != null) {
                mutableTextInput.tokenHierarchyControl().rebuild();
            }
        }
    }

    private static class ColoringListener
    implements PropertyChangeListener {
        private Document doc;
        private Object parsedDataRef;
        private Jsp11Syntax syntax;

        public ColoringListener(Document document, JSPColoringData jSPColoringData, Jsp11Syntax jsp11Syntax) {
            this.doc = document;
            this.parsedDataRef = jSPColoringData;
            this.syntax = jsp11Syntax;
            jsp11Syntax.listenerReference = this;
            jsp11Syntax.data = jSPColoringData;
        }

        private void recolor() {
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).invalidateSyntaxMarks();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.syntax == null) {
                return;
            }
            if (this.syntax.listenerReference != this) {
                this.syntax = null;
                return;
            }
            if ("coloringChange".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        NbEditorDocument nbEditorDocument = (NbEditorDocument)ColoringListener.this.doc;
                        nbEditorDocument.extWriteLock();
                        try {
                            ColoringListener.this.recolor();
                        }
                        finally {
                            nbEditorDocument.extWriteUnlock();
                        }
                    }
                });
            }
        }
    }
}

