/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaSourceProvider;
import org.netbeans.modules.web.core.syntax.SimplifiedJSPServlet;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class JavaSourceProviderImpl
implements JavaSourceProvider {
    public boolean accept(FileObject fileObject) {
        if (FileOwnerQuery.getOwner((FileObject)fileObject) == null) {
            return false;
        }
        return "text/x-jsp".equals(fileObject.getMIMEType()) || "text/x-tag".equals(fileObject.getMIMEType());
    }

    public JavaSourceProvider.PositionTranslatingJavaFileFilterImplementation forFileObject(FileObject fileObject) {
        if (this.accept(fileObject)) {
            return new FilterImpl(fileObject);
        }
        return null;
    }

    private static final class FilterImpl
    implements JavaSourceProvider.PositionTranslatingJavaFileFilterImplementation {
        private FileObject file;
        private SimplifiedJSPServlet data;

        private FilterImpl(FileObject fileObject) {
            this.file = fileObject;
        }

        public int getOriginalPosition(int n) {
            if (this.data != null) {
                return this.data.getRealOffset(n);
            }
            return n;
        }

        public int getJavaSourcePosition(int n) {
            if (this.data != null) {
                return this.data.getShiftedOffset(n);
            }
            return n;
        }

        public Reader filterReader(Reader reader) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                Logger.global.log(Level.WARNING, "Cannot close stream.", iOException);
            }
            return new StringReader("class SimplifiedJSPServlet {}");
        }

        public CharSequence filterCharSequence(CharSequence charSequence) {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                StyledDocument styledDocument = editorCookie.openDocument();
                this.data = new SimplifiedJSPServlet(styledDocument, charSequence);
                this.data.process();
                return this.data.getVirtualClassBody();
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                this.data = null;
                return charSequence;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                this.data = null;
                return charSequence;
            }
        }

        public Writer filterWriter(Writer writer) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

