/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.web.core.syntax.spi.ErrorAnnotation;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class JspParserErrorAnnotation
extends ErrorAnnotation.LineSetAnnotation {
    private Line docline;
    private final int line;
    private final int column;
    private final String error;
    private NbEditorDocument document;

    public JspParserErrorAnnotation(int n, int n2, String string, NbEditorDocument nbEditorDocument) {
        this.line = n;
        this.column = n2;
        this.error = string;
        this.document = nbEditorDocument;
    }

    public String getShortDescription() {
        return this.error;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getError() {
        return this.error;
    }

    public String getAnnotationType() {
        return "org-netbeans-modules-web-core-syntax-JspParserErrorAnnotation";
    }

    public void attachToLineSet(Line.Set set) {
        try {
            this.docline = set.getCurrent(this.line - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        String string = this.docline.getText();
        if (string == null) {
            return;
        }
        int n = NbDocument.findLineOffset((StyledDocument)this.document, (int)this.docline.getLineNumber()) + this.column + 1;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        if (n < 1) {
            this.textOnLine(this.docline);
            return;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n - 1);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            this.textOnLine(this.docline);
            return;
        }
        n2 = NbDocument.findLineColumn((StyledDocument)this.document, (int)tokenSequence.token().offset(tokenHierarchy));
        n = tokenSequence.token().offset(tokenHierarchy);
        if (tokenSequence.token().id() != JspTokenId.EL) {
            while ((tokenSequence.token().id() != JspTokenId.SYMBOL || ((Object)tokenSequence.token().text()).toString().charAt(0) != '<') && tokenSequence.token().id() != JspTokenId.TAG && tokenSequence.token().id() != JspTokenId.EOL && tokenSequence.movePrevious()) {
                n2 = NbDocument.findLineColumn((StyledDocument)this.document, (int)tokenSequence.token().offset(tokenHierarchy));
                n = tokenSequence.token().offset(tokenHierarchy);
            }
            while ((tokenSequence.token().id() != JspTokenId.SYMBOL || ((Object)tokenSequence.token().text()).toString().trim().length() > 0 && ((Object)tokenSequence.token().text()).toString().charAt(((Object)tokenSequence.token().text()).toString().trim().length() - 1) != '>') && tokenSequence.token().id() != JspTokenId.EOL && tokenSequence.moveNext()) {
            }
        }
        n3 = tokenSequence.token().offset(tokenHierarchy) + tokenSequence.token().length() - n;
        Line.Part part = this.docline.createPart(n2, n3);
        this.attach((Annotatable)part);
    }

    private void textOnLine(Line line) {
        int n;
        char[] cArray = line.getText().toCharArray();
        int n2 = cArray.length - 1;
        for (n = 0; n <= n2 && cArray[n] <= ' '; ++n) {
        }
        while (n <= n2 && cArray[n2] <= ' ') {
            --n2;
        }
        Line.Part part = n <= n2 ? line.createPart(n, n2 - n + 1) : line.createPart(0, cArray.length);
        this.attach((Annotatable)part);
    }

    public boolean equals(Object object) {
        if (object instanceof JspParserErrorAnnotation) {
            JspParserErrorAnnotation jspParserErrorAnnotation = (JspParserErrorAnnotation)((Object)object);
            if (this == object) {
                return true;
            }
            if (this.line != jspParserErrorAnnotation.getLine()) {
                return false;
            }
            if (this.column != jspParserErrorAnnotation.getColumn()) {
                return false;
            }
            return this.error.equals(jspParserErrorAnnotation.getError());
        }
        return false;
    }
}

