/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathProvider;
import org.netbeans.modules.web.project.GsfBootClassPathImplementation;
import org.netbeans.modules.web.project.GsfSourcePathImplementation;
import org.netbeans.modules.web.project.WebSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class GsfClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final WebSources sourceRoots;
    private final ClassPath[] cache = new ClassPath[8];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public GsfClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, WebSources webSources) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sourceRoots = webSources;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    private synchronized FileObject getDir(String string) {
        String string2;
        FileObject fileObject = this.dirCache.get(string);
        if (!(fileObject != null && fileObject.isValid() || (string2 = this.evaluator.getProperty(string)) == null)) {
            fileObject = this.helper.resolveFileObject(string2);
            this.dirCache.put(string, fileObject);
        }
        return fileObject;
    }

    private FileObject[] getPrimarySrcPath() {
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (SourceGroup sourceGroup : sourceGroupArray = this.sourceRoots.getSourceGroups("generic")) {
            arrayList.add(sourceGroup.getRootFolder());
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private int getType(FileObject fileObject) {
        return 0;
    }

    private synchronized ClassPath getSourcepath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getSourcepath(n);
    }

    private ClassPath getSourcepath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[n];
        if (classPath == null) {
            switch (n) {
                case 0: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new GsfSourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                }
            }
        }
        this.cache[n] = classPath;
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache[7];
        if (classPath == null) {
            this.cache[7] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new GsfBootClassPathImplementation(this.projectDirectory, this.evaluator));
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/source")) {
            return this.getSourcepath(fileObject);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (string.equals("classpath/compile")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/source".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getSourcepath(0)};
            return classPathArray;
        }
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(0);
        }
        if ("classpath/compile".equals(string)) {
            return this.getBootClassPath();
        }
        return null;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }
}

