/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.api.client.WebServicesClientConstants;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebProjectWebServicesClientSupport
implements WebServicesClientSupportImpl {
    private WebProject project;
    private AntProjectHelper helper;
    private ReferenceHelper referenceHelper;
    private static final String[] WSCOMPILE_CLIENT_FEATURES = new String[]{"datahandleronly", "explicitcontext", "jaxbenumtype", "nodatabinding", "noencodedtypes", "nomultirefs", "norpcstructures", "novalidation", "resolveidref", "searchschema", "serializeinterfaces", "strict", "wsi", "unwrap", "donotoverride", "donotunwrap"};
    private static final List allClientFeatures = Arrays.asList(WSCOMPILE_CLIENT_FEATURES);
    private static final String[] WSCOMPILE_KEY_CLIENT_FEATURES = new String[]{"wsi", "strict", "norpcstructures", "unwrap", "donotunwrap", "donotoverride", "datahandleronly", "nodatabinding", "novalidation", "searchschema"};
    private static final List importantClientFeatures = Arrays.asList(WSCOMPILE_KEY_CLIENT_FEATURES);
    private static final JAXRPCClientStubDescriptor jsr109ClientStub = new JAXRPCClientStubDescriptor("jsr-109_client", NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"LBL_JSR109ClientStub"), new String[]{"wsi", "strict"});
    private static final JAXRPCClientStubDescriptor jaxrpcClientStub = new JAXRPCClientStubDescriptor("jaxrpc_static_client", NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"LBL_JAXRPCStaticClientStub"), new String[]{"wsi", "strict"});
    private String proxyHost;
    private String proxyPort;

    public WebProjectWebServicesClientSupport(WebProject webProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.project = webProject;
        this.helper = antProjectHelper;
        this.referenceHelper = referenceHelper;
    }

    private WebApp getWebApp() {
        try {
            FileObject fileObject = this.getDeploymentDescriptor();
            if (fileObject != null) {
                return DDProvider.getDefault().getDDRoot(fileObject);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, iOException.getLocalizedMessage());
        }
        return null;
    }

    public FileObject getWsDDFolder() {
        return this.getWebInf();
    }

    public String getArchiveDDFolderName() {
        return "WEB-INF";
    }

    public String getImplementationBean(String string) {
        WebApp webApp = this.getWebApp();
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            if (!servletArray[i].getServletName().equals(string)) continue;
            return servletArray[i].getServletClass();
        }
        return null;
    }

    public void removeServiceEntry(String string) {
        ServletMapping servletMapping;
        WebApp webApp = this.getWebApp();
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            Servlet servlet = servletArray[i];
            if (!servlet.getServletName().equals(string)) continue;
            webApp.removeServlet(servlet);
            break;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            servletMapping = servletMappingArray[i];
            if (!servletMapping.getServletName().equals(string)) continue;
            webApp.removeServletMapping(servletMapping);
        }
        try {
            webApp.write(this.getDeploymentDescriptor());
        }
        catch (IOException iOException) {
            servletMapping = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_Unable_WRITE_WS_DD"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)servletMapping);
        }
    }

    private void removeServiceRef(String string) {
        FileObject fileObject = this.getDeploymentDescriptor();
        if (fileObject != null) {
            String string2 = "WEB-INF/wsdl/" + string + ".wsdl";
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                ServiceRef serviceRef = null;
                for (ServiceRef serviceRef2 : webApp.getServiceRef()) {
                    URI uRI = serviceRef2.getWsdlFile();
                    if (!string2.equals(serviceRef2.getWsdlFile().getPath())) continue;
                    serviceRef = serviceRef2;
                }
                if (serviceRef != null) {
                    webApp.removeServiceRef(serviceRef);
                    webApp.write(fileObject);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                Logger.getLogger("global").log(Level.INFO, null, versionNotSupportedException);
            }
        }
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.referenceHelper;
    }

    public void addServiceClient(String string, String string2, String string3, FileObject fileObject, ClientStubDescriptor clientStubDescriptor) {
        this.addServiceClient(string, string2, string3, fileObject, clientStubDescriptor, null);
    }

    public void addServiceClient(String string, String string2, String string3, FileObject fileObject, ClientStubDescriptor clientStubDescriptor, String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Element element;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Element element2 = this.helper.getPrimaryConfigurationData(true);
        Document document = element2.getOwnerDocument();
        NodeList nodeList = element2.getElementsByTagName("web-service-clients");
        Element element3 = null;
        if (nodeList.getLength() == 0) {
            element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service-clients");
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
            assert (nodeList2.getLength() == 1) : "Invalid project.xml.";
            element2.insertBefore(element3, nodeList2.item(0));
        } else {
            element3 = (Element)nodeList.item(0);
        }
        boolean bl4 = false;
        NodeList nodeList3 = element3.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-client-name");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            element = (Element)nodeList3.item(i);
            object3 = element.getChildNodes();
            if (object3.getLength() < 1 || (object2 = object3.item(0)).getNodeType() != 3 || !string.equalsIgnoreCase(object2.getNodeValue())) continue;
            bl4 = true;
        }
        if (!bl4) {
            Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service-client");
            element3.appendChild(element4);
            element = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service-client-name");
            element4.appendChild(element);
            element.appendChild(document.createTextNode(string));
            object3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service-stub-type");
            element4.appendChild((Node)object3);
            object3.appendChild(document.createTextNode(clientStubDescriptor.getName()));
            object2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "client-source-url");
            element4.appendChild((Node)object2);
            object2.appendChild(document.createTextNode(string3));
            this.helper.putPrimaryConfigurationData(element2, true);
            bl = true;
        }
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        element = this.helper.getProperties("nbproject/private/private.properties");
        object3 = "wscompile.client." + string + ".features";
        object2 = "wsi, strict";
        if (clientStubDescriptor instanceof JAXRPCClientStubDescriptor) {
            object = (JAXRPCClientStubDescriptor)clientStubDescriptor;
            if (stringArray != null) {
                ((JAXRPCClientStubDescriptor)((Object)object)).setDefaultFeatures(stringArray);
            }
            object2 = ((JAXRPCClientStubDescriptor)((Object)object)).getDefaultFeaturesAsArgument();
        }
        if (!((String)object2).equals(object = editableProperties.getProperty((String)object3))) {
            editableProperties.put((String)object3, (String)object2);
            bl2 = true;
        }
        if (!string2.equals(object2 = editableProperties.getProperty((String)(object3 = "wscompile.client." + string + ".package")))) {
            editableProperties.put((String)object3, string2);
            bl2 = true;
        }
        if (this.proxyHost != null && this.proxyHost.length() > 0 && !((String)(object3 = "wscompile.client." + string + ".proxy")).equals(object2 = element.getProperty((String)object3))) {
            element.put((String)object3, this.proxyHost + ":" + (this.proxyPort == null ? "8080" : this.proxyPort));
            bl3 = true;
        }
        if (bl2) {
            this.helper.putProperties("nbproject/project.properties", editableProperties);
            bl = true;
        }
        if (bl3) {
            this.helper.putProperties("nbproject/private/private.properties", (EditableProperties)element);
            bl = true;
        }
        if (this.updateWsCompileProperties(string)) {
            bl = true;
        }
        if (bl) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException iOException) {
                object2 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)string, (Object)iOException.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object2);
            }
        }
    }

    public void addInfrastructure(String string, FileObject fileObject) {
    }

    public FileObject getDeploymentDescriptor() {
        FileObject fileObject = this.getWebInf();
        if (fileObject == null) {
            if (this.isProjectOpened()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"MSG_WebInfCorrupted"), 0));
            }
            return null;
        }
        return this.getWebInf().getFileObject("web.xml");
    }

    public FileObject getWebInf() {
        return this.getFileObject("webinf.dir");
    }

    public FileObject getDocumentBase() {
        return this.getFileObject("web.docbase.dir");
    }

    private FileObject getFileObject(String string) {
        String string2 = this.helper.getStandardPropertyEvaluator().getProperty(string);
        if (string2 != null) {
            return this.helper.resolveFileObject(string2);
        }
        return null;
    }

    private boolean updateWsCompileProperties(String string) {
        EditableProperties editableProperties;
        boolean bl = false;
        EditableProperties editableProperties2 = PropertyUtils.getGlobalProperties();
        if (editableProperties2.getProperty("wscompile.tools.classpath") == null) {
            editableProperties2.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            try {
                PropertyUtils.putGlobalProperties((EditableProperties)editableProperties2);
            }
            catch (IOException iOException) {
                editableProperties = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingGlobalProperties", (Object)string, (Object)iOException.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)editableProperties);
            }
            bl = true;
        }
        boolean bl2 = false;
        editableProperties = this.helper.getProperties("nbproject/project.properties");
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl3 = false;
        String string2 = editableProperties.getProperty("wscompile.classpath");
        if (string2 != null) {
            String[] stringArray = PropertyUtils.tokenizePath((String)string2);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        for (int i = 0; i < WebServicesClientConstants.WSCOMPILE_JARS.length; ++i) {
            if (hashSet.contains(WebServicesClientConstants.WSCOMPILE_JARS[i])) continue;
            hashSet.add(WebServicesClientConstants.WSCOMPILE_JARS[i]);
            bl3 = true;
        }
        if (bl3) {
            StringBuffer stringBuffer = new StringBuffer(256);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(':');
            }
            editableProperties.put("wscompile.classpath", stringBuffer.toString());
            bl2 = true;
        }
        if (editableProperties.getProperty("wscompile.tools.classpath") == null) {
            editableProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            bl2 = true;
        }
        if (bl2) {
            this.helper.putProperties("nbproject/project.properties", editableProperties);
        }
        return bl || bl2;
    }

    public void removeServiceClient(String string) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "wscompile.client." + string + ".features";
        String string3 = "wscompile.client." + string + ".package";
        String string4 = "wscompile.client." + string + ".proxy";
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.helper.getProperties("nbproject/private/private.properties");
        if (editableProperties.getProperty(string2) != null) {
            editableProperties.remove((Object)string2);
            bl = true;
        }
        if (editableProperties.getProperty(string3) != null) {
            editableProperties.remove((Object)string3);
            bl = true;
        }
        if (editableProperties2.getProperty(string4) != null) {
            editableProperties2.remove((Object)string4);
            bl2 = true;
        }
        if (bl) {
            this.helper.putProperties("nbproject/project.properties", editableProperties);
        }
        if (bl2) {
            this.helper.putProperties("nbproject/private/private.properties", editableProperties2);
        }
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagName("web-service-clients");
        Element element2 = null;
        if (nodeList.getLength() >= 1) {
            element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-client-name");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node;
                Element element3 = (Element)nodeList2.item(i);
                NodeList nodeList3 = element3.getChildNodes();
                if (nodeList3.getLength() != 1 || (node = nodeList3.item(0)).getNodeType() != 3 || !string.equalsIgnoreCase(node.getNodeValue())) continue;
                Node node2 = element3.getParentNode();
                element2.removeChild(node2);
                this.helper.putPrimaryConfigurationData(element, true);
                bl = true;
            }
        }
        if (bl || bl2) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException iOException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingOnWSClientRemove", (Object)string, (Object)iOException.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        this.removeServiceRef(string);
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        FileObject fileObject = null;
        FileObject fileObject2 = this.getWebInf();
        if (fileObject2 != null) {
            fileObject = fileObject2.getFileObject("wsdl");
            if (fileObject == null && bl) {
                fileObject = fileObject2.createFolder("wsdl");
            }
        } else if (bl) {
            Logger.getLogger("global").log(Level.INFO, NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"MSG_WebInfNotFoundForWsdlFolder"));
        }
        return fileObject;
    }

    public List getStubDescriptors() {
        ArrayList<JAXRPCClientStubDescriptor> arrayList = new ArrayList<JAXRPCClientStubDescriptor>(2);
        String string = this.project.getWebModule().getJ2eePlatformVersion();
        if ("1.4".equals(string)) {
            arrayList.add(jsr109ClientStub);
        }
        arrayList.add(jaxrpcClientStub);
        return arrayList;
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (!projectArray[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    public List getServiceClients() {
        ArrayList<WsCompileClientEditorSupport.ServiceSettings> arrayList = new ArrayList<WsCompileClientEditorSupport.ServiceSettings>();
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagName("web-service-clients");
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        if (nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-client-name");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node;
                Element element3 = (Element)nodeList2.item(i);
                NodeList nodeList3 = element3.getChildNodes();
                if (nodeList3.getLength() != 1 || (node = nodeList3.item(0)).getNodeType() != 3) continue;
                String string = node.getNodeValue();
                String string2 = editableProperties.getProperty("wscompile.client." + string + ".features");
                if (string2 == null) {
                    string2 = "wsi, strict";
                }
                ClientStubDescriptor clientStubDescriptor = this.getClientStubDescriptor(element3.getParentNode());
                boolean bl = "true".equalsIgnoreCase(editableProperties.getProperty("wscompile.client." + string + ".verbose"));
                boolean bl2 = "true".equalsIgnoreCase(editableProperties.getProperty("wscompile.client." + string + ".debug"));
                boolean bl3 = "true".equalsIgnoreCase(editableProperties.getProperty("wscompile.client." + string + ".xPrintStackTrace"));
                boolean bl4 = "true".equalsIgnoreCase(editableProperties.getProperty("wscompile.client." + string + ".xSerializable"));
                boolean bl5 = "true".equalsIgnoreCase(editableProperties.getProperty("wscompile.client." + string + ".optimize"));
                boolean[] blArray = new boolean[]{bl, bl2, bl3, bl4, bl5};
                WsCompileClientEditorSupport.ServiceSettings serviceSettings = new WsCompileClientEditorSupport.ServiceSettings(string, clientStubDescriptor, blArray, string2, allClientFeatures, importantClientFeatures);
                arrayList.add(serviceSettings);
            }
        }
        return arrayList;
    }

    private ClientStubDescriptor getClientStubDescriptor(Node node) {
        Node node2;
        Element element;
        NodeList nodeList;
        Element element2;
        NodeList nodeList2;
        JAXRPCClientStubDescriptor jAXRPCClientStubDescriptor = null;
        if (node instanceof Element && (nodeList2 = (element2 = (Element)node).getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-stub-type")).getLength() == 1 && (nodeList = (element = (Element)nodeList2.item(0)).getChildNodes()).getLength() == 1 && (node2 = nodeList.item(0)).getNodeType() == 3) {
            String string = node2.getNodeValue();
            if ("jsr-109_client".equals(string)) {
                jAXRPCClientStubDescriptor = jsr109ClientStub;
            } else if ("jaxrpc_static_client".equals(string)) {
                jAXRPCClientStubDescriptor = jaxrpcClientStub;
            }
        }
        return jAXRPCClientStubDescriptor;
    }

    public String getWsdlSource(String string) {
        Node node;
        Element element;
        NodeList nodeList;
        NodeList nodeList2;
        Element element2 = this.helper.getPrimaryConfigurationData(true);
        String string2 = null;
        Element element3 = this.getWebServiceClientNode(element2, string);
        if (element3 != null && (nodeList2 = element3.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "client-source-url")).getLength() == 1 && (nodeList = (element = (Element)nodeList2.item(0)).getChildNodes()).getLength() == 1 && (node = nodeList.item(0)).getNodeType() == 3) {
            string2 = node.getNodeValue();
        }
        return string2;
    }

    public void setWsdlSource(String string, String string2) {
        Element element;
        Element element2 = this.helper.getPrimaryConfigurationData(true);
        Document document = element2.getOwnerDocument();
        boolean bl = false;
        Element element3 = this.getWebServiceClientNode(element2, string);
        if (element3 != null) {
            NodeList nodeList = element3.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "client-source-url");
            if (nodeList.getLength() > 0) {
                element = (Element)nodeList.item(0);
                NodeList nodeList2 = element.getChildNodes();
                if (nodeList2.getLength() > 0) {
                    Node node = nodeList2.item(0);
                    node.setNodeValue(string2);
                } else {
                    element.appendChild(document.createTextNode(string2));
                }
            } else {
                element = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "client-source-url");
                element3.appendChild(element);
                element.appendChild(document.createTextNode(string2));
            }
            bl = true;
        }
        if (bl) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException iOException) {
                element = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)string, (Object)iOException.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)element);
            }
        }
    }

    private Element getWebServiceClientNode(Element element, String string) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName("web-service-clients");
        if (nodeList.getLength() != 0) {
            Element element3 = (Element)nodeList.item(0);
            NodeList nodeList2 = element3.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-client-name");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                String string2;
                Node node;
                Element element4 = (Element)nodeList2.item(i);
                NodeList nodeList3 = element4.getChildNodes();
                if (nodeList3.getLength() != 1 || (node = nodeList3.item(0)).getNodeType() != 3 || !string.equals(string2 = node.getNodeValue())) continue;
                Node node2 = element4.getParentNode();
                element2 = node2 instanceof Element ? (Element)node2 : null;
                break;
            }
        }
        return element2;
    }

    public void addServiceClientReference(String string, String string2, String string3, String string4, String[] stringArray) {
        FileObject fileObject = this.getDeploymentDescriptor();
        if (fileObject != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                ServiceRef serviceRef = (ServiceRef)webApp.findBeanByName("ServiceRef", "ServiceRefName", string);
                if (serviceRef == null) {
                    serviceRef = (ServiceRef)webApp.addBean("ServiceRef", new String[]{"ServiceRefName", "ServiceInterface", "WsdlFile", "JaxrpcMappingFile"}, (Object[])new String[]{string, string2, string3, string4}, "ServiceRefName");
                } else {
                    serviceRef.setServiceInterface(string2);
                    serviceRef.setWsdlFile(new URI(string3));
                    serviceRef.setJaxrpcMappingFile(string4);
                }
                PortComponentRef[] portComponentRefArray = new PortComponentRef[stringArray.length];
                for (int i = 0; i < portComponentRefArray.length; ++i) {
                    portComponentRefArray[i] = (PortComponentRef)serviceRef.createBean("PortComponentRef");
                    portComponentRefArray[i].setServiceEndpointInterface(stringArray[i]);
                }
                serviceRef.setPortComponentRef(portComponentRefArray);
                webApp.write(fileObject);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
            catch (NameAlreadyUsedException nameAlreadyUsedException) {
                Logger.getLogger("global").log(Level.INFO, null, nameAlreadyUsedException);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger("global").log(Level.INFO, null, uRISyntaxException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger("global").log(Level.INFO, null, classNotFoundException);
            }
        }
    }

    public void setProxyJVMOptions(String string, String string2) {
        this.proxyHost = string;
        this.proxyPort = string2;
    }

    public String getServiceRefName(String string) {
        return "service/" + string;
    }

    private static class JAXRPCClientStubDescriptor
    extends ClientStubDescriptor {
        private String[] defaultFeatures;

        public JAXRPCClientStubDescriptor(String string, String string2, String[] stringArray) {
            super(string, string2);
            this.defaultFeatures = stringArray;
        }

        public String[] getDefaultFeatures() {
            return this.defaultFeatures;
        }

        public String getDefaultFeaturesAsArgument() {
            StringBuffer stringBuffer = new StringBuffer(this.defaultFeatures.length * 32);
            for (int i = 0; i < this.defaultFeatures.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.defaultFeatures[i]);
            }
            return stringBuffer.toString();
        }

        void setDefaultFeatures(String[] stringArray) {
            this.defaultFeatures = stringArray;
        }
    }
}

