/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProjectUtilities {
    public static final String SRC_STRUCT_BLUEPRINTS = "BluePrints";
    public static final String SRC_STRUCT_JAKARTA = "Jakarta";
    private static final String DEFAULT_DOC_BASE_FOLDER = "web";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_CONF_FOLDER = "conf";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String WEB_INF = "WEB-INF";
    private static final String SOURCE_ROOT_REF = "${source.root}";
    public static final String MINIMUM_ANT_VERSION = "1.6";
    private static final Logger LOGGER = Logger.getLogger(WebProjectUtilities.class.getName());

    private WebProjectUtilities() {
    }

    @Deprecated
    public static AntProjectHelper createProject(File file, String string, String string2, String string3, String string4, String string5) throws IOException {
        WebProjectCreateData webProjectCreateData = new WebProjectCreateData();
        webProjectCreateData.setProjectDir(file);
        webProjectCreateData.setName(string);
        webProjectCreateData.setServerInstanceID(string2);
        webProjectCreateData.setSourceStructure(string3);
        webProjectCreateData.setJavaEEVersion(string4);
        webProjectCreateData.setContextPath(string5);
        return WebProjectUtilities.createProject(webProjectCreateData);
    }

    public static AntProjectHelper createProject(final WebProjectCreateData webProjectCreateData) throws IOException {
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        File file = webProjectCreateData.getProjectDir();
        assert (file != null) : "Project folder can't be null";
        final FileObject fileObject = FileUtil.createFolder((File)file);
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = WebProjectUtilities.createProjectImpl(webProjectCreateData, fileObject);
            }
        });
        return antProjectHelperArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AntProjectHelper createProjectImpl(final WebProjectCreateData webProjectCreateData, FileObject fileObject) throws IOException {
        String string = webProjectCreateData.getName();
        String string2 = webProjectCreateData.getServerInstanceID();
        String string3 = webProjectCreateData.getSourceStructure();
        String string4 = webProjectCreateData.getJavaEEVersion();
        String string5 = webProjectCreateData.getContextPath();
        String string6 = webProjectCreateData.getJavaPlatformName();
        String string7 = webProjectCreateData.getSourceLevel();
        assert (string != null) : "Project name can't be null";
        assert (string2 != null) : "Server instance ID can't be null";
        assert (string3 != null) : "Source structure can't be null";
        assert (string4 != null) : "Java EE version can't be null";
        boolean bl = SRC_STRUCT_BLUEPRINTS.equals(string3);
        boolean bl2 = SRC_STRUCT_JAKARTA.equals(string3);
        String string8 = WebProjectUtilities.configureServerLibrary(webProjectCreateData.getLibrariesDefinition(), string2, fileObject, webProjectCreateData.getServerLibraryName() != null);
        final AntProjectHelper antProjectHelper = WebProjectUtilities.setupProject(fileObject, string, string2, string4, webProjectCreateData.getLibrariesDefinition(), string8);
        FileObject fileObject2 = fileObject.createFolder(DEFAULT_SRC_FOLDER);
        FileObject fileObject3 = null;
        if (bl) {
            fileObject2.createFolder(DEFAULT_JAVA_FOLDER);
            fileObject3 = fileObject2.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (bl2) {
            fileObject3 = fileObject.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (fileObject3 != null) {
            FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/MANIFEST.MF"), (FileObject)fileObject3, (String)"MANIFEST");
        }
        FileUtil.createFolder((FileObject)fileObject, (String)DEFAULT_TEST_FOLDER);
        FileObject fileObject4 = fileObject.createFolder(DEFAULT_DOC_BASE_FOLDER);
        FileObject fileObject5 = fileObject4.createFolder(WEB_INF);
        String string9 = null;
        if ("1.5".equals(string4)) {
            string9 = WebProjectUtilities.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/web-2.5.xml").getInputStream());
        } else if ("1.4".equals(string4)) {
            string9 = WebProjectUtilities.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/web-2.4.xml").getInputStream());
        } else if ("1.3".equals(string4)) {
            string9 = WebProjectUtilities.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/web-2.3.xml").getInputStream());
        }
        assert (string9 != null) : "Cannot find web.xml template for J2EE specification level:" + string4;
        String string10 = string9;
        FileObject fileObject6 = FileUtil.createData((FileObject)fileObject5, (String)"web.xml");
        FileLock fileLock = fileObject6.lock();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject6.getOutputStream(fileLock)));
        try {
            bufferedWriter.write(string10);
        }
        finally {
            bufferedWriter.close();
            fileLock.releaseLock();
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        element3.setAttribute("id", "src.dir");
        element3.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
        element2.appendChild(element3);
        if (bl) {
            editableProperties.setProperty("src.dir", "src/java");
        } else {
            editableProperties.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        element.appendChild(element2);
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        element5.setAttribute("id", "test.src.dir");
        element5.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
        element4.appendChild(element5);
        editableProperties.setProperty("test.src.dir", DEFAULT_TEST_FOLDER);
        element.appendChild(element4);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        editableProperties.put("source.root", bl ? DEFAULT_SRC_FOLDER : ".");
        editableProperties.setProperty("web.docbase.dir", DEFAULT_DOC_BASE_FOLDER);
        if (bl) {
            editableProperties.setProperty("src.dir", "${source.root}/java");
            editableProperties.setProperty("conf.dir", "${source.root}/conf");
        } else {
            editableProperties.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        if (bl2) {
            editableProperties.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        }
        editableProperties.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        editableProperties.setProperty("lib.dir", "${web.docbase.dir}/WEB-INF/lib");
        editableProperties.setProperty("webinf.dir", "web/WEB-INF");
        WebProject webProject = (WebProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        UpdateHelper updateHelper = webProject.getUpdateHelper();
        if (string7 == null) {
            string7 = "1.5";
        }
        PlatformUiSupport.storePlatform((EditableProperties)editableProperties, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/web-project/3", (String)string6, (SpecificationVersion)new SpecificationVersion(string7));
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        ProjectManager.getDefault().saveProject((Project)webProject);
        final ReferenceHelper referenceHelper = webProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    WebProjectUtilities.copyRequiredLibraries(antProjectHelper, referenceHelper, webProjectCreateData);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException.getException());
        }
        ProjectWebModule projectWebModule = (ProjectWebModule)webProject.getLookup().lookup(ProjectWebModule.class);
        if (projectWebModule != null) {
            projectWebModule.setContextPath(string5);
        }
        return antProjectHelper;
    }

    public static Set<FileObject> ensureWelcomePage(FileObject fileObject, FileObject fileObject2) throws IOException {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        try {
            FileObject fileObject3;
            WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject2);
            WelcomeFileList welcomeFileList = webApp.getSingleWelcomeFileList();
            if (welcomeFileList == null) {
                welcomeFileList = (WelcomeFileList)webApp.createBean("WelcomeFileList");
                webApp.setWelcomeFileList(welcomeFileList);
            }
            if (welcomeFileList.sizeWelcomeFile() == 0 && (fileObject3 = WebProjectUtilities.createIndexJSP(fileObject)) != null) {
                hashSet.add(fileObject3);
                welcomeFileList.addWelcomeFile("index.jsp");
                webApp.write(fileObject2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return hashSet;
    }

    private static FileObject createIndexJSP(FileObject fileObject) throws IOException {
        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Templates/JSP_Servlet/JSP.jsp");
        if (fileObject2 == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, "index").getPrimaryFile();
    }

    @Deprecated
    public static AntProjectHelper importProject(File file, String string, FileObject fileObject, FileObject fileObject2, FileObject fileObject3, FileObject fileObject4, String string2, String string3, String string4) throws IOException {
        WebProjectCreateData webProjectCreateData = new WebProjectCreateData();
        webProjectCreateData.setProjectDir(file);
        webProjectCreateData.setName(string);
        webProjectCreateData.setWebModuleFO(fileObject);
        webProjectCreateData.setSourceFolders(new File[]{FileUtil.toFile((FileObject)fileObject2)});
        webProjectCreateData.setTestFolders(null);
        webProjectCreateData.setDocBase(fileObject3);
        webProjectCreateData.setLibFolder(fileObject4);
        webProjectCreateData.setJavaEEVersion(string2);
        webProjectCreateData.setServerInstanceID(string3);
        webProjectCreateData.setBuildfile(string4);
        return WebProjectUtilities.importProject(webProjectCreateData);
    }

    @Deprecated
    public static AntProjectHelper importProject(File file, String string, FileObject fileObject, File[] fileArray, File[] fileArray2, FileObject fileObject2, FileObject fileObject3, String string2, String string3, String string4) throws IOException {
        WebProjectCreateData webProjectCreateData = new WebProjectCreateData();
        webProjectCreateData.setProjectDir(file);
        webProjectCreateData.setName(string);
        webProjectCreateData.setWebModuleFO(fileObject);
        webProjectCreateData.setSourceFolders(fileArray);
        webProjectCreateData.setTestFolders(fileArray2);
        webProjectCreateData.setDocBase(fileObject2);
        webProjectCreateData.setLibFolder(fileObject3);
        webProjectCreateData.setJavaEEVersion(string2);
        webProjectCreateData.setServerInstanceID(string3);
        webProjectCreateData.setBuildfile(string4);
        return WebProjectUtilities.importProject(webProjectCreateData);
    }

    public static AntProjectHelper importProject(final WebProjectCreateData webProjectCreateData) throws IOException {
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        File file = webProjectCreateData.getProjectDir();
        assert (file != null) : "Project folder can't be null";
        final FileObject fileObject = FileUtil.createFolder((File)file);
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = WebProjectUtilities.importProjectImpl(webProjectCreateData, fileObject);
            }
        });
        return antProjectHelperArray[0];
    }

    private static AntProjectHelper importProjectImpl(final WebProjectCreateData webProjectCreateData, FileObject fileObject) throws IOException {
        Object object;
        FileObject[] fileObjectArray;
        String string = webProjectCreateData.getName();
        FileObject fileObject2 = webProjectCreateData.getWebModuleFO();
        final File[] fileArray = webProjectCreateData.getSourceFolders();
        File[] fileArray2 = webProjectCreateData.getTestFolders();
        FileObject fileObject3 = webProjectCreateData.getDocBase();
        FileObject fileObject4 = webProjectCreateData.getLibFolder();
        String string2 = webProjectCreateData.getJavaEEVersion();
        String string3 = webProjectCreateData.getServerInstanceID();
        String string4 = webProjectCreateData.getBuildfile();
        String string5 = webProjectCreateData.getJavaPlatformName();
        String string6 = webProjectCreateData.getSourceLevel();
        boolean bl = webProjectCreateData.getJavaSourceBased();
        FileObject fileObject5 = webProjectCreateData.getWebInfFolder();
        assert (string != null) : "Project name can't be null";
        assert (fileObject2 != null) : "File object representation of the imported web project location can't be null";
        assert (fileArray != null) : "Source package root can't be null";
        assert (fileObject3 != null) : "Web Pages folder can't be null";
        assert (string3 != null) : "Server instance ID can't be null";
        assert (string2 != null) : "Java EE version can't be null";
        String string7 = WebProjectUtilities.configureServerLibrary(webProjectCreateData.getLibrariesDefinition(), string3, fileObject, webProjectCreateData.getServerLibraryName() != null);
        final AntProjectHelper antProjectHelper = WebProjectUtilities.setupProject(fileObject, string, string3, string2, webProjectCreateData.getLibrariesDefinition(), string7);
        final WebProject webProject = (WebProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        final ReferenceHelper referenceHelper = webProject.getReferenceHelper();
        EditableProperties editableProperties = new EditableProperties(true);
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject.equals(fileObject2)) {
            editableProperties.setProperty("source.root", ".");
        } else {
            editableProperties.setProperty("source.root", referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)fileObject2), null));
        }
        editableProperties.setProperty("web.docbase.dir", WebProjectUtilities.createFileReference(referenceHelper, fileObject, fileObject2, fileObject3));
        final File[] fileArray3 = fileArray2;
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties editableProperties;
                    String string;
                    String string2;
                    int n;
                    Element element = antProjectHelper.getPrimaryConfigurationData(true);
                    Document document = element.getOwnerDocument();
                    Element element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    element.appendChild(element2);
                    Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    element.appendChild(element3);
                    NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    assert (nodeList.getLength() == 1);
                    element2 = (Element)nodeList.item(0);
                    nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    assert (nodeList.getLength() == 1);
                    element3 = (Element)nodeList.item(0);
                    for (n = 0; n < fileArray.length; ++n) {
                        string2 = "src.dir" + (n == 0 ? "" : Integer.toString(n + 1));
                        string = referenceHelper.createForeignFileReference(fileArray[n], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                        Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                        element4.setAttribute("id", string2);
                        element4.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
                        element2.appendChild(element4);
                        editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.put(string2, string);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    if (fileArray3 == null || fileArray3.length == 0) {
                        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties2.put("test.src.dir", "");
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties2);
                    } else {
                        for (n = 0; n < fileArray3.length; ++n) {
                            if (!fileArray3[n].exists()) {
                                FileUtil.createFolder((File)fileArray3[n]);
                            }
                            string2 = fileArray3[n].getName();
                            string = "test." + string2 + ".dir";
                            int n2 = 1;
                            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            while (editableProperties.containsKey((Object)string)) {
                                string = "test." + string2 + ++n2 + ".dir";
                            }
                            String string3 = referenceHelper.createForeignFileReference(fileArray3[n], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                            Element element5 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                            element5.setAttribute("id", string);
                            element5.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
                            element3.appendChild(element5);
                            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put(string, string3);
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        }
                    }
                    antProjectHelper.putPrimaryConfigurationData(element, true);
                    ProjectManager.getDefault().saveProject((Project)webProject);
                    WebProjectUtilities.copyRequiredLibraries(antProjectHelper, referenceHelper, webProjectCreateData);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            IOException iOException = new IOException("project creation failed");
            iOException.initCause(mutexException);
            throw iOException;
        }
        if (fileObject4 != null) {
            editableProperties.setProperty("lib.dir", WebProjectUtilities.createFileReference(referenceHelper, fileObject, fileObject2, fileObject4));
            if (fileObject4.isFolder()) {
                fileObjectArray = fileObject4.getChildren();
                object = new LinkedList();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!FileUtil.isArchiveFile((FileObject)fileObjectArray[i])) continue;
                    object.add(URLMapper.findURL((FileObject)FileUtil.getArchiveRoot((FileObject)fileObjectArray[i]), (int)1));
                }
                webProject.getClassPathModifier().addRoots(object.toArray(new URL[object.size()]), "javac.classpath");
            }
        }
        if (!"build.xml".equals(string4)) {
            editableProperties.setProperty("buildfile", string4);
        }
        fileObjectArray = FileSearchUtility.getChildrenToDepth((FileObject)fileObject, (int)4, (boolean)true);
        object = "";
        while (fileObjectArray.hasMoreElements()) {
            FileObject fileObject6 = (FileObject)fileObjectArray.nextElement();
            if (!fileObject6.isFolder() || !fileObject6.getName().equalsIgnoreCase(DEFAULT_CONF_FOLDER)) continue;
            object = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject6);
            break;
        }
        if (((String)object).equals("")) {
            fileObject.createFolder(DEFAULT_CONF_FOLDER);
            editableProperties.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        } else {
            editableProperties.setProperty("conf.dir", (String)object);
        }
        editableProperties.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        String string8 = WebProjectUtilities.createFileReference(referenceHelper, fileObject, fileObject2, fileObject5);
        editableProperties.setProperty("webinf.dir", string8);
        editableProperties.setProperty("java.source.based", bl + "");
        UpdateHelper updateHelper = webProject.getUpdateHelper();
        if (string6 != null && (string6.equals(MINIMUM_ANT_VERSION) || string6.equals("1.7"))) {
            string6 = "1.5";
        }
        PlatformUiSupport.storePlatform((EditableProperties)editableProperties, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/web-project/3", (String)string5, (SpecificationVersion)(string6 != null ? new SpecificationVersion(string6) : null));
        Utils.updateProperties(antProjectHelper, "nbproject/project.properties", editableProperties);
        ProjectManager.getDefault().saveProject((Project)webProject);
        return antProjectHelper;
    }

    private static void copyRequiredLibraries(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, WebProjectCreateData webProjectCreateData) throws IOException {
        if (!antProjectHelper.isSharableProject()) {
            return;
        }
        if (referenceHelper.getProjectLibraryManager().getLibrary("junit") == null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (referenceHelper.getProjectLibraryManager().getLibrary("junit_4") == null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
    }

    private static String configureServerLibrary(final String string, final String string2, final FileObject fileObject, boolean bl) {
        String string3 = null;
        if (string != null && bl) {
            try {
                string3 = (String)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                    public String run() throws Exception {
                        return SharabilityUtility.findOrCreateLibrary((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)fileObject), (String)string), (String)string2).getName();
                    }
                });
            }
            catch (MutexException mutexException) {
                Exceptions.printStackTrace((Throwable)mutexException.getException());
            }
        }
        return string3;
    }

    private static String createFileReference(ReferenceHelper referenceHelper, FileObject fileObject, FileObject fileObject2, FileObject fileObject3) {
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject3)) {
            return WebProjectUtilities.relativePath(fileObject, fileObject3);
        }
        if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3)) {
            String string = WebProjectUtilities.relativePath(fileObject2, fileObject3);
            return string.length() > 0 ? "${source.root}/" + string : SOURCE_ROOT_REF;
        }
        return referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)fileObject3), null);
    }

    private static String relativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            throw new IllegalArgumentException("Cannot find relative path, " + fileObject + " is not parent of " + fileObject2);
        }
        return fileObject2.getPath().substring(fileObject.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject fileObject, String string, String string2, String string3, String string4, String string5) throws IOException {
        File[] fileArray;
        Object object;
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.web.project", (String)string4);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "name");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "minimum-ant-version");
        element3.appendChild(document.createTextNode(MINIMUM_ANT_VERSION));
        element.appendChild(element3);
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-libraries");
        element.appendChild(element4);
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-additional-libraries");
        element.appendChild(element5);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("dist.dir", "dist");
        editableProperties.setProperty("dist.war", "${dist.dir}/${war.name}");
        editableProperties.setProperty("dist.ear.war", "${dist.dir}/${war.ear.name}");
        Deployment deployment = Deployment.getDefault();
        String string6 = deployment.getServerID(string2);
        if (antProjectHelper.isSharableProject() && string5 != null) {
            editableProperties.setProperty("javac.classpath", "${libs." + string5 + "." + "classpath" + "}");
            editableProperties.setProperty("j2ee.platform.classpath", "${libs." + string5 + "." + "classpath" + "}");
            editableProperties.setProperty("j2ee.platform.wscompile.classpath", "${libs." + string5 + "." + "wscompile" + "}");
            editableProperties.setProperty("j2ee.platform.wsimport.classpath", "${libs." + string5 + "." + "wsimport" + "}");
            editableProperties.setProperty("j2ee.platform.wsgen.classpath", "${libs." + string5 + "." + "wsgenerate" + "}");
            editableProperties.setProperty("j2ee.platform.wsit.classpath", "${libs." + string5 + "." + "wsinterop" + "}");
            editableProperties.setProperty("j2ee.platform.jwsdp.classpath", "${libs." + string5 + "." + "wsjwsdp" + "}");
        } else {
            editableProperties.setProperty("javac.classpath", "");
        }
        editableProperties.setProperty("jspcompilation.classpath", "${jspc.classpath}:${javac.classpath}");
        editableProperties.setProperty("j2ee.platform", string3);
        editableProperties.setProperty("war.name", PropertyUtils.getUsablePropertyName((String)string) + ".war");
        editableProperties.setProperty("war.ear.name", PropertyUtils.getUsablePropertyName((String)string) + ".war");
        editableProperties.setProperty("jar.compress", "false");
        editableProperties.setProperty("war.content.additional", "");
        editableProperties.setProperty("client.urlPart", "");
        editableProperties.setProperty("display.browser", "true");
        editableProperties.setProperty("debug.server", "true");
        editableProperties.setProperty("j2ee.server.type", string6);
        editableProperties.setProperty("javac.debug", "true");
        editableProperties.setProperty("javac.deprecation", "false");
        editableProperties.setProperty("javac.compilerargs", "");
        editableProperties.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_javac.compilerargs")}, false);
        editableProperties.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}:", "${libs.junit_4.classpath}"});
        editableProperties.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        editableProperties.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        editableProperties.setProperty("build.dir", DEFAULT_BUILD_DIR);
        editableProperties.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        editableProperties.setProperty("build.test.results.dir", "${build.dir}/test/results");
        editableProperties.setProperty("build.web.dir", "${build.dir}/web");
        editableProperties.setProperty("build.generated.dir", "${build.dir}/generated");
        editableProperties.setProperty("build.classes.dir", "${build.web.dir}/WEB-INF/classes");
        editableProperties.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        editableProperties.setProperty("build.web.excludes", "${build.classes.excludes}");
        editableProperties.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        editableProperties.setProperty("no.dependencies", "false");
        editableProperties.setProperty("platform.active", "default_platform");
        editableProperties.setProperty("debug.classpath", Utils.getDefaultDebugClassPath());
        editableProperties.setProperty("runmain.jvmargs", "");
        editableProperties.setComment("runmain.jvmargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs"), "# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs_2")}, false);
        editableProperties.setProperty("javadoc.private", "false");
        editableProperties.setProperty("javadoc.notree", "false");
        editableProperties.setProperty("javadoc.use", "true");
        editableProperties.setProperty("javadoc.nonavbar", "false");
        editableProperties.setProperty("javadoc.noindex", "false");
        editableProperties.setProperty("javadoc.splitindex", "true");
        editableProperties.setProperty("javadoc.author", "false");
        editableProperties.setProperty("javadoc.version", "false");
        editableProperties.setProperty("javadoc.windowtitle", "");
        editableProperties.setProperty("javadoc.encoding", "${source.encoding}");
        editableProperties.setProperty("javadoc.preview", "true");
        editableProperties.setProperty("javadoc.additionalparam", "");
        editableProperties.setProperty("compile.jsps", "false");
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", charset.name());
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        editableProperties.setProperty("j2ee.server.instance", string2);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string2);
        if (!j2eePlatform.getSupportedSpecVersions(J2eeModule.WAR).contains(string3)) {
            Logger.getLogger("global").log(Level.WARNING, "J2EE level:" + string3 + " not supported by server " + Deployment.getDefault().getServerInstanceDisplayName(string2) + " for module type WAR");
        }
        if (!antProjectHelper.isSharableProject() || string5 == null) {
            object = Utils.toClasspathString(j2eePlatform.getClasspathEntries());
            editableProperties.setProperty("j2ee.platform.classpath", (String)object);
            if (j2eePlatform.isToolSupported("wscompile")) {
                fileArray = j2eePlatform.getToolClasspathEntries("wscompile");
                editableProperties.setProperty("j2ee.platform.wscompile.classpath", Utils.toClasspathString(fileArray));
            }
            if (j2eePlatform.isToolSupported("wsimport")) {
                fileArray = j2eePlatform.getToolClasspathEntries("wsimport");
                editableProperties.setProperty("j2ee.platform.wsimport.classpath", Utils.toClasspathString(fileArray));
            }
            if (j2eePlatform.isToolSupported("wsgen")) {
                fileArray = j2eePlatform.getToolClasspathEntries("wsgen");
                editableProperties.setProperty("j2ee.platform.wsgen.classpath", Utils.toClasspathString(fileArray));
            }
            if (j2eePlatform.isToolSupported("wsit")) {
                fileArray = j2eePlatform.getToolClasspathEntries("wsit");
                editableProperties.setProperty("j2ee.platform.wsit.classpath", Utils.toClasspathString(fileArray));
            }
            if (j2eePlatform.isToolSupported("jwsdp")) {
                fileArray = j2eePlatform.getToolClasspathEntries("jwsdp");
                editableProperties.setProperty("j2ee.platform.jwsdp.classpath", Utils.toClasspathString(fileArray));
            }
        }
        if (j2eePlatform.isToolSupported("jsr109")) {
            editableProperties.setProperty("j2ee.platform.is.jsr109", "true");
        }
        object = FileUtil.toFile((FileObject)fileObject);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File((File)object, "nbproject/ant-deploy.xml"), (Object)J2eeModule.WAR, (String)string2);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        fileArray = AntDeploymentHelper.getDeploymentPropertiesFile((String)string2);
        if (fileArray != null) {
            editableProperties.setProperty("deploy.ant.properties.file", fileArray.getAbsolutePath());
        }
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
        return antProjectHelper;
    }

    private static String readResource(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }
}

