/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.j2ee.common.ui.BrokenDatasourceSupport;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

public class WebLogicalViewProvider
implements LogicalViewProvider {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("WebLogicalViewProvider.BROKEN_LINKS_RP");
    private static final RequestProcessor BROKEN_DATASOURCE_RP = new RequestProcessor("WebLogicalViewProvider.BROKEN_DATASOURCE_RP");
    private final WebProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath", "war.content.additional", "web.docbase.dir"};

    public WebLogicalViewProvider(WebProject webProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = webProject;
        assert (webProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new WebLogicalViewRootNode();
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            for (Node node2 : node.getChildren().getNodes(true)) {
                Node node3 = PackageView.findPath((Node)node2, (Object)object);
                if (node3 == null) continue;
                return node3;
            }
            Node node4 = this.findNodeInConfigFiles(node, fileObject);
            if (node4 != null) {
                return node4;
            }
            node4 = this.findNodeInDocBase(node, fileObject);
            if (node4 != null) {
                return node4;
            }
        }
        return null;
    }

    private Node findNodeInDocBase(Node node, FileObject fileObject) {
        FileObject fileObject2 = this.helper.getAntProjectHelper().resolveFileObject(this.evaluator.getProperty("web.docbase.dir"));
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node2 = NodeOp.findChild((Node)node, (String)fileObject2.getName());
        while (stringTokenizer.hasMoreTokens()) {
            node2 = NodeOp.findChild((Node)node2, (String)stringTokenizer.nextToken());
        }
        return node2;
    }

    private Node findNodeInConfigFiles(Node node, FileObject fileObject) {
        String string;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string = dataObject.getName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string = fileObject.getName();
        }
        dataObject = node.getChildren().findChild("configurationFiles");
        if (dataObject == null) {
            return null;
        }
        return NodeOp.findChild((Node)dataObject, (String)string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void testBroken() {
        this.changeSupport.fireChange();
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    private String[] getBreakableProperties() {
        SourceRoots sourceRoots = this.project.getSourceRoots();
        String[] stringArray = sourceRoots.getRootProperties();
        sourceRoots = this.project.getTestSourceRoots();
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = new String[BREAKABLE_PROPERTIES.length + stringArray.length + stringArray2.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, stringArray3, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(stringArray, 0, stringArray3, BREAKABLE_PROPERTIES.length, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, BREAKABLE_PROPERTIES.length + stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static class Actions {
        private Actions() {
        }

        public static Action createAction(String string, String string2, boolean bl) {
            return new ActionImpl(string, string2, (Lookup)(bl ? Utilities.actionsGlobalContext() : null));
        }

        private static class ActionImpl
        extends AbstractAction
        implements ContextAwareAction {
            Lookup context;
            String name;
            String command;

            public ActionImpl(String string, String string2, Lookup lookup) {
                super(string2);
                this.context = lookup;
                this.command = string;
                this.name = string2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Project project = (Project)this.context.lookup(Project.class);
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.command, this.context);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                return new ActionImpl(this.command, this.name, lookup);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WebLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private final Action brokenLinksAction;
        private final BrokenServerAction brokenServerAction;
        private final BrokenDatasourceAction brokenDatasourceAction;
        private boolean broken;
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;

        public WebLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)WebLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-web-project/Nodes"), Lookups.singleton((Object)WebLogicalViewProvider.this.project));
            this.privateLock = new Object();
            this.setIconBaseWithExtension("org/netbeans/modules/web/project/ui/resources/webProjectIcon.gif");
            super.setName(ProjectUtils.getInformation((Project)WebLogicalViewProvider.this.project).getDisplayName());
            if (WebLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.brokenServerAction = new BrokenServerAction();
            this.brokenDatasourceAction = new BrokenDatasourceAction();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)WebLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)j2eeModuleProvider));
            this.setProjectFiles(WebLogicalViewProvider.this.project);
        }

        protected void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private void setGroups(Collection<SourceGroup> collection) {
            if (this.groupsListeners != null) {
                for (Map.Entry<SourceGroup, PropertyChangeListener> object : this.groupsListeners.entrySet()) {
                    object.getKey().removePropertyChangeListener(object.getValue());
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet hashSet = new HashSet();
            for (SourceGroup sourceGroup : collection) {
                PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup);
                this.groupsListeners.put(sourceGroup, propertyChangeListener);
                sourceGroup.addPropertyChangeListener(propertyChangeListener);
                FileObject fileObject = sourceGroup.getRootFolder();
                if (WebLogicalViewProvider.this.project.getProjectDirectory().equals(fileObject)) {
                    Enumeration enumeration = WebLogicalViewProvider.this.project.getProjectDirectory().getChildren(false);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject2 = (FileObject)enumeration.nextElement();
                        if (FileOwnerQuery.getOwner((FileObject)fileObject2) != WebLogicalViewProvider.this.project) continue;
                        hashSet.add(fileObject2);
                    }
                    continue;
                }
                hashSet.add(fileObject);
            }
            this.setFiles(hashSet);
        }

        protected void setFiles(Set<FileObject> set) {
            if (this.fileSystemListeners != null) {
                for (Map.Entry<FileSystem, FileStatusListener> object : this.fileSystemListeners.entrySet()) {
                    object.getKey().removeFileStatusListener(object.getValue());
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = set;
            if (set == null) {
                return;
            }
            HashSet hashSet = new HashSet();
            for (FileObject fileObject : set) {
                try {
                    FileSystem fileStateInvalidException = fileObject.getFileSystem();
                    if (hashSet.contains(fileStateInvalidException)) continue;
                    hashSet.add(fileStateInvalidException);
                    FileStatusListener fileStatusListener = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                    fileStateInvalidException.addFileStatusListener(fileStatusListener);
                    this.fileSystemListeners.put(fileStateInvalidException, fileStatusListener);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)fileStateInvalidException, (String)("Cannot get " + fileObject + " filesystem, ignoring...")));
                }
            }
        }

        public Image getIcon(int n) {
            Image image = this.getMyIcon(n);
            if (this.files != null && !this.files.isEmpty()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = this.getMyOpenedIcon(n);
            if (this.files != null && !this.files.isEmpty()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return image;
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)WebLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(WebLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setProjectFiles(WebLogicalViewProvider.this.project);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setProjectFiles(WebLogicalViewProvider.this.project);
        }

        public Image getMyIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken || this.brokenServerAction.isEnabled() || this.brokenDatasourceAction.isEnabled() ? Utilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public Image getMyOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken || this.brokenServerAction.isEnabled() || this.brokenDatasourceAction.isEnabled() ? Utilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.broken || this.brokenServerAction.isEnabled() || this.brokenDatasourceAction.isEnabled() ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)WebLogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(WebLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(WebLogicalViewProvider.class);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)WebLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            if (j2eeModuleProvider != null && j2eeModuleProvider.hasVerifierSupport()) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)resourceBundle.getString("LBL_VerifyAction_Name"), null));
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)resourceBundle.getString("LBL_JavadocAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)resourceBundle.getString("LBL_RedeployAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            this.addFromLayers(arrayList, "Projects/Profiler_Actions_temporary");
            this.addFromLayers(arrayList, "Projects/Rest_Actions_holder");
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            this.addFromLayers(arrayList, "Projects/Actions");
            arrayList.add(null);
            if (this.brokenLinksAction != null && this.brokenLinksAction.isEnabled()) {
                arrayList.add(this.brokenLinksAction);
            }
            if (this.brokenServerAction.isEnabled()) {
                arrayList.add(this.brokenServerAction);
            }
            if (this.brokenDatasourceAction.isEnabled()) {
                arrayList.add(this.brokenDatasourceAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private void addFromLayers(List<Action> list, String string) {
            Lookup lookup = Lookups.forPath((String)string);
            for (Object e : lookup.lookupAll(Object.class)) {
                if (e instanceof Action) {
                    list.add((Action)e);
                    continue;
                }
                if (!(e instanceof JSeparator)) continue;
                list.add(null);
            }
        }

        private class BrokenDatasourceAction
        extends AbstractAction
        implements Runnable,
        ConnectionListener {
            private volatile boolean brokenDatasource;
            private RequestProcessor.Task task = null;

            public BrokenDatasourceAction() {
                ConnectionManager.getDefault().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this, (Object)ConnectionManager.getDefault()));
                this.putValue("Name", NbBundle.getMessage(WebLogicalViewProvider.class, (String)"LBL_Fix_Broken_Datasource_Action"));
                this.checkMissingDatabaseConnection();
            }

            private boolean isVisualWebLegacyProject() {
                String string;
                boolean bl = false;
                AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)WebLogicalViewProvider.this.project.getLookup().lookup(AuxiliaryConfiguration.class);
                Element element = auxiliaryConfiguration.getConfigurationFragment("creator-data", "http://www.sun.com/creator/ns", true);
                if (element != null && (string = element.getAttribute("jsf.project.version")) != null && !string.equals("4.0")) {
                    bl = true;
                }
                return bl;
            }

            public boolean isEnabled() {
                return this.brokenDatasource;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BrokenDatasourceSupport.fixDatasources((Project)WebLogicalViewProvider.this.project);
                this.checkMissingDatabaseConnection();
            }

            private void checkMissingDatabaseConnection() {
                if (this.task == null) {
                    this.task = BROKEN_DATASOURCE_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }

            public void run() {
                this.doCheckMissingDatabaseConnection();
            }

            private void doCheckMissingDatabaseConnection() {
                boolean bl = this.brokenDatasource;
                this.brokenDatasource = !BrokenDatasourceSupport.getBrokenDatasources((Project)WebLogicalViewProvider.this.project).isEmpty();
                if (bl != this.brokenDatasource) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BrokenDatasourceAction.this.setEnabled(BrokenDatasourceAction.this.brokenDatasource);
                            WebLogicalViewRootNode.this.fireIconChange();
                            WebLogicalViewRootNode.this.fireOpenedIconChange();
                            WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                            if (BrokenDatasourceAction.this.brokenDatasource && !BrokenDatasourceAction.this.isVisualWebLegacyProject()) {
                                BrokenDatasourceSupport.showAlert();
                            }
                        }
                    });
                }
            }

            public void connectionsChanged() {
                this.checkMissingDatabaseConnection();
            }
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(WebLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                WebLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = WebLogicalViewProvider.this.helper.getProperties("nbproject/project.properties").getProperty("j2ee.platform");
                String string2 = BrokenServerSupport.selectServer((String)string, (Object)J2eeModule.WAR);
                if (string2 != null) {
                    WebProjectProperties.setServerInstance(WebLogicalViewProvider.this.project, WebLogicalViewProvider.this.helper, string2);
                }
                this.checkMissingServer();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("j2ee.server.instance".equals(propertyChangeEvent.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String string, String string2) {
            }

            public void instanceAdded(String string) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String string) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean bl = this.brokenServer;
                String string = WebLogicalViewProvider.this.evaluator.getProperty("j2ee.server.instance");
                this.brokenServer = BrokenServerSupport.isBroken((String)string);
                if (bl != this.brokenServer) {
                    WebLogicalViewRootNode.this.fireIconChange();
                    WebLogicalViewRootNode.this.fireOpenedIconChange();
                    WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private final PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(WebLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(WebLogicalViewRootNode.this.broken);
                WebLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                WebLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)WebLogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WebLogicalViewProvider.this.helper.requestUpdate();
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)WebLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)WebLogicalViewProvider.this.resolver, (String[])WebLogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                    this.run();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean bl = WebLogicalViewRootNode.this.broken;
                WebLogicalViewRootNode.this.broken = WebLogicalViewProvider.this.hasBrokenLinks();
                if (bl != WebLogicalViewRootNode.this.broken) {
                    this.setEnabled(WebLogicalViewRootNode.this.broken);
                    WebLogicalViewRootNode.this.fireIconChange();
                    WebLogicalViewRootNode.this.fireOpenedIconChange();
                    WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            }

            public void refsMayChanged() {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

