/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.web.project.ui.wizards.FolderList;
import org.netbeans.modules.web.project.ui.wizards.SettingsPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private final Panel firer;
    private WizardDescriptor wizardDescriptor;
    private JButton jButtonLibraries;
    private JButton jButtonWebInf;
    private JButton jButtonWebpagesLocation;
    private JLabel jLabel3;
    private JLabel jLabelLibraries;
    private JLabel jLabelWebInf;
    private JLabel jLabelWebPages;
    private JTextField jTextFieldLibraries;
    private JTextField jTextFieldWebInf;
    private JTextField jTextFieldWebPages;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelSourceFolders.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_WebExtSources"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel);
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }
        };
        this.jTextFieldWebPages.getDocument().addDocumentListener(documentListener);
        this.jTextFieldWebInf.getDocument().addDocumentListener(documentListener);
    }

    public void initValues(FileObject fileObject) {
        ((FolderList)this.sourcePanel).setLastUsedDir(FileUtil.toFile((FileObject)fileObject));
        ((FolderList)this.testsPanel).setLastUsedDir(FileUtil.toFile((FileObject)fileObject));
        String string = "";
        String string2 = "";
        String string3 = "";
        File[] fileArray = null;
        FileObject fileObject2 = FileSearchUtility.guessDocBase((FileObject)fileObject);
        if (fileObject2 != null) {
            string = FileUtil.toFile((FileObject)fileObject2).getPath();
        }
        if ((fileObject2 = FileSearchUtility.guessWebInf((FileObject)fileObject)) != null) {
            string2 = FileUtil.toFile((FileObject)fileObject2).getPath();
        }
        if ((fileObject2 = FileSearchUtility.guessLibrariesFolder((FileObject)fileObject)) != null) {
            string3 = FileUtil.toFile((FileObject)fileObject2).getPath();
        }
        fileArray = FileSearchUtility.guessJavaRootsAsFiles((FileObject)fileObject);
        if (this.jTextFieldWebPages.getText().trim().equals("")) {
            this.jTextFieldWebPages.setText(string);
        }
        if (this.jTextFieldWebInf.getText().trim().equals("")) {
            this.jTextFieldWebInf.setText(string2);
        }
        if (this.jTextFieldLibraries.getText().trim().equals("")) {
            this.jTextFieldLibraries.setText(string3);
        }
        if (((FolderList)this.sourcePanel).getFiles().length == 0 && fileArray.length > 0) {
            ((FolderList)this.sourcePanel).setFiles(fileArray);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("files".equals(propertyChangeEvent.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor wizardDescriptor) {
        File[] fileArray;
        this.wizardDescriptor = wizardDescriptor;
        File[] fileArray2 = (File[])wizardDescriptor.getProperty("javaRoot");
        if (fileArray2 != null) {
            ((FolderList)this.sourcePanel).setFiles(fileArray2);
        }
        if ((fileArray = (File[])wizardDescriptor.getProperty("testRoot")) != null) {
            ((FolderList)this.testsPanel).setFiles(fileArray);
        }
        File file = (File)wizardDescriptor.getProperty("sourceRoot");
        ((FolderList)this.sourcePanel).setProjectFolder(file);
        ((FolderList)this.testsPanel).setProjectFolder(file);
        this.initValues(FileUtil.toFileObject((File)file));
    }

    void store(WizardDescriptor wizardDescriptor) {
        File[] fileArray = ((FolderList)this.sourcePanel).getFiles();
        File[] fileArray2 = ((FolderList)this.testsPanel).getFiles();
        wizardDescriptor.putProperty("javaRoot", (Object)fileArray);
        wizardDescriptor.putProperty("testRoot", (Object)fileArray2);
        wizardDescriptor.putProperty("docBase", (Object)this.jTextFieldWebPages.getText().trim());
        wizardDescriptor.putProperty("libFolder", (Object)this.jTextFieldLibraries.getText().trim());
        wizardDescriptor.putProperty("webInfFolder", (Object)this.jTextFieldWebInf.getText().trim());
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File[] fileArray;
        File[] fileArray2;
        File file;
        File file2 = (File)wizardDescriptor.getProperty("projdir");
        if (this.jTextFieldWebPages.getText().trim().length() == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesMandatory"));
            return false;
        }
        if (this.jTextFieldWebInf.getText().trim().length() == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebInfMandatory"));
            return false;
        }
        File file3 = this.getWebPages();
        String string = this.checkValidity(file2, file3, file = this.getWebInfDir(), fileArray2 = ((FolderList)this.sourcePanel).getFiles(), fileArray = ((FolderList)this.testsPanel).getFiles());
        if (string == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return false;
    }

    private String checkValidity(File file, File file2, File file3, File[] fileArray, File[] fileArray2) {
        String string;
        int n;
        String string2 = file.getAbsolutePath();
        if (file.equals(file2)) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesFolderOverlapsProjectFolder");
        }
        if (!file2.exists() || !file2.isDirectory()) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesFolderDoesNotExist");
        }
        if (!file3.exists() || !file3.isDirectory()) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebInfFolderDoesNotExist");
        }
        FileObject fileObject = FileUtil.toFileObject((File)file3);
        FileObject fileObject2 = fileObject.getFileObject("web.xml");
        if (fileObject2 != null && !fileObject2.isValid()) {
            fileObject2 = null;
        }
        String string3 = (String)this.wizardDescriptor.getProperty("j2eeLevel");
        if (fileObject2 == null && (string3.equals("1.3") || string3.equals("1.4"))) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FileNotFound", (Object)file3.getPath());
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory() || !fileArray[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), fileArray[n].getAbsolutePath());
            }
            string = fileArray[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (n = 0; n < fileArray2.length; ++n) {
            if (!fileArray2[n].isDirectory() || !fileArray2[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), fileArray[n].getAbsolutePath());
            }
            string = fileArray2[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] fileArray) throws WizardValidationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            object4 = FileUtil.toFileObject((File)fileArray[i]);
            if (object4 == null) continue;
            object3 = object4.getData(true);
            while (!bl && object3.hasMoreElements()) {
                object2 = object3.nextElement();
                assert (object2 instanceof FileObject) : "Instance of FileObject: " + object2;
                object = (FileObject)object2;
                bl = "class".equals(object.getExt());
            }
        }
        if (bl) {
            String string = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption");
            object4 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption");
            object3 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption");
            object2 = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{string, object4, object3}, null);
            object = DialogDisplayer.getDefault().notify(object2);
            if (string.equals(object)) {
                this.deleteClassFiles(fileArray);
            } else if (!object4.equals(object)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)fileArray[i]);
            Enumeration enumeration = fileObject.getData(true);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                assert (e instanceof FileObject) : "Instance of FileObject: " + e;
                FileObject fileObject2 = (FileObject)e;
                try {
                    if (!"class".equals(fileObject2.getExt())) continue;
                    fileObject2.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jLabelWebPages = new JLabel();
        this.jTextFieldWebPages = new JTextField();
        this.jButtonWebpagesLocation = new JButton();
        this.jLabelWebInf = new JLabel();
        this.jTextFieldWebInf = new JTextField();
        this.jButtonWebInf = new JButton();
        this.jLabelLibraries = new JLabel();
        this.jTextFieldLibraries = new JTextField();
        this.jButtonLibraries = new JButton();
        this.sourcePanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.setPreferredSize(new Dimension(500, 340));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LocationDesc_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName("null");
        this.jLabel3.getAccessibleContext().setAccessibleDescription("null");
        this.jLabelWebPages.setDisplayedMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_WebPagesLocation_LabelMnemonic").charAt(0));
        this.jLabelWebPages.setLabelFor(this.jTextFieldWebPages);
        this.jLabelWebPages.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_WebPagesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelWebPages, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 11);
        this.add((Component)this.jTextFieldWebPages, gridBagConstraints);
        this.jTextFieldWebPages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_WebPagesFolder"));
        this.jButtonWebpagesLocation.setMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_WebPagesFolder_MNE").charAt(0));
        this.jButtonWebpagesLocation.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_BrowseWebPagesLocation_Button"));
        this.jButtonWebpagesLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelSourceFolders.this.jButtonWebpagesLocationActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonWebpagesLocation, gridBagConstraints);
        this.jButtonWebpagesLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_BrowseWebPageFolder"));
        this.jLabelWebInf.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/wizards/Bundle").getString("MNE_DeploymentDescriptorFolder").charAt(0));
        this.jLabelWebInf.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_DeploymentDescriptorFolder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelWebInf, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 11);
        this.add((Component)this.jTextFieldWebInf, gridBagConstraints);
        this.jButtonWebInf.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/wizards/Bundle").getString("MNE_BrowseWebInfLocation").charAt(0));
        this.jButtonWebInf.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"PanelSourceFolderes.browseWebInf"));
        this.jButtonWebInf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelSourceFolders.this.jButtonWebInfActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonWebInf, gridBagConstraints);
        this.jLabelLibraries.setDisplayedMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LibrariesLocation_LabelMnemonic").charAt(0));
        this.jLabelLibraries.setLabelFor(this.jTextFieldLibraries);
        this.jLabelLibraries.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LibrariesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelLibraries, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 11);
        this.add((Component)this.jTextFieldLibraries, gridBagConstraints);
        this.jTextFieldLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_LibrariesFolder"));
        this.jButtonLibraries.setMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_BrowseLibrariesLocation").charAt(0));
        this.jButtonLibraries.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_BrowseLibrariesLocation_Button"));
        this.jButtonLibraries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelSourceFolders.this.jButtonLibrariesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jButtonLibraries, gridBagConstraints);
        this.jButtonLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_BrowseLibrariesFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.testsPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("null");
        this.getAccessibleContext().setAccessibleDescription("null");
    }

    private void jButtonWebInfActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.jTextFieldWebInf.getText().length() > 0 && this.getWebInfDir().exists()) {
            jFileChooser.setSelectedFile(this.getWebInfDir());
        } else {
            jFileChooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextFieldWebInf.setText(file.getAbsolutePath());
        }
    }

    private void jButtonLibrariesActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.jTextFieldLibraries.getText().length() > 0 && this.getLibraries().exists()) {
            jFileChooser.setSelectedFile(this.getLibraries());
        } else {
            jFileChooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextFieldLibraries.setText(file.getAbsolutePath());
        }
    }

    private void jButtonWebpagesLocationActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.jTextFieldWebPages.getText().length() > 0 && this.getWebPages().exists()) {
            jFileChooser.setSelectedFile(this.getWebPages());
        } else {
            jFileChooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextFieldWebPages.setText(file.getAbsolutePath());
        }
    }

    private File getAsFile(String string) {
        return FileUtil.normalizeFile((File)new File(string));
    }

    public File getWebPages() {
        return this.getAsFile(this.jTextFieldWebPages.getText());
    }

    public File getLibraries() {
        return this.getAsFile(this.jTextFieldLibraries.getText());
    }

    private File getWebInfDir() {
        return this.getAsFile(this.jTextFieldWebInf.getText());
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void readSettings(Object object) {
            this.settings = (WizardDescriptor)object;
            this.component.read(this.settings);
            Object object2 = this.component.getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.settings.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }
    }
}

