/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.infos.ConnectionOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.util.Exceptions;

public class ConnectionNodeInfo
extends DatabaseNodeInfo
implements ConnectionOperations {
    static final long serialVersionUID = -8322295510950137669L;
    private static final Logger LOGGER = Logger.getLogger(ConnectionNodeInfo.class.getName());

    protected ConnectionNodeInfo() {
        this.addConnectionListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("db") || string.equals("schema") || string.equals("user")) {
                    ConnectionNodeInfo.this.setDisplayName(ConnectionNodeInfo.this.getDatabaseConnection().getName());
                } else if (string.equals("connection")) {
                    try {
                        ConnectionNodeInfo.this.update((Connection)propertyChangeEvent.getNewValue());
                    }
                    catch (DatabaseException databaseException) {
                        Exceptions.printStackTrace((Throwable)databaseException);
                    }
                }
                ConnectionNodeInfo.this.notifyChange();
            }
        });
        this.put("mixedCaseIdentifiers", (Object)Boolean.FALSE);
        this.put("mixedCaseQuotedIdentifiers", (Object)Boolean.FALSE);
        this.put("alterTableWithAddColumn", (Object)Boolean.FALSE);
        this.put("alterTableWithDropColumn", (Object)Boolean.FALSE);
        this.put("convert", (Object)Boolean.FALSE);
        this.put("tableCorrelationNames", (Object)Boolean.FALSE);
        this.put("tableCorrelationNames", (Object)Boolean.FALSE);
        this.put("expressionsInOrderBy", (Object)Boolean.FALSE);
        this.put("orderByUnrelated", (Object)Boolean.FALSE);
        this.put("groupBy", (Object)Boolean.FALSE);
        this.put("groupByUnrelated", (Object)Boolean.FALSE);
        this.put("groupByBeyondSelect", (Object)Boolean.FALSE);
        this.put("likeEscapeClause", (Object)Boolean.FALSE);
        this.put("multipleResultSets", (Object)Boolean.FALSE);
        this.put("multipleTransactions", (Object)Boolean.FALSE);
        this.put("nonNullableColumns", (Object)Boolean.FALSE);
        this.put("minimumSQLGrammar", (Object)Boolean.FALSE);
        this.put("coreSQLGrammar", (Object)Boolean.FALSE);
        this.put("extendedSQLGrammar", (Object)Boolean.FALSE);
        this.put("ANSI92EntryLevelSQL", (Object)Boolean.FALSE);
        this.put("ANSI92IntermediateSQL", (Object)Boolean.FALSE);
        this.put("ANSI92FullSQL", (Object)Boolean.FALSE);
        this.put("IntegrityEnhancementFacility", (Object)Boolean.FALSE);
        this.put("outerJoins", (Object)Boolean.FALSE);
        this.put("fullOuterJoins", (Object)Boolean.FALSE);
        this.put("limitedOuterJoins", (Object)Boolean.FALSE);
        this.put("schemasInDataManipulation", (Object)Boolean.FALSE);
        this.put("schemasInProcedureCalls", (Object)Boolean.FALSE);
        this.put("schemasInTableDefinitions", (Object)Boolean.FALSE);
        this.put("schemasInIndexDefinitions", (Object)Boolean.FALSE);
        this.put("schemasInPrivilegeDefinitions", (Object)Boolean.FALSE);
        this.put("catalogsInDataManipulation", (Object)Boolean.FALSE);
        this.put("catalogsInProcedureCalls", (Object)Boolean.FALSE);
        this.put("catalogsInTableDefinitions", (Object)Boolean.FALSE);
        this.put("catalogsInIndexDefinitions", (Object)Boolean.FALSE);
        this.put("catalogsInPrivilegeDefinitions", (Object)Boolean.FALSE);
        this.put("positionedDelete", (Object)Boolean.FALSE);
        this.put("positionedUpdate", (Object)Boolean.FALSE);
        this.put("selectForUpdate", (Object)Boolean.FALSE);
        this.put("storedProcedures", (Object)Boolean.FALSE);
        this.put("subqueriesInComparisons", (Object)Boolean.FALSE);
        this.put("subqueriesInExists", (Object)Boolean.FALSE);
        this.put("subqueriesInIns", (Object)Boolean.FALSE);
        this.put("subqueriesInQuantifieds", (Object)Boolean.FALSE);
        this.put("correlatedSubqueries", (Object)Boolean.FALSE);
        this.put("union", (Object)Boolean.FALSE);
        this.put("unionAll", (Object)Boolean.FALSE);
        this.put("openCursorsAcrossCommit", (Object)Boolean.FALSE);
        this.put("openCursorsAcrossRollback", (Object)Boolean.FALSE);
        this.put("openStatementsAcrossCommit", (Object)Boolean.FALSE);
        this.put("openStatementsAcrossRollback", (Object)Boolean.FALSE);
        this.put("transactions", (Object)Boolean.FALSE);
        this.put("dataDefinitionAndDataManipulationTransactions", (Object)Boolean.FALSE);
        this.put("dataManipulationTransactionsOnly", (Object)Boolean.FALSE);
        this.put("batchUpdates", (Object)Boolean.FALSE);
        this.put("catalogAtStart", (Object)Boolean.FALSE);
        this.put("columnAliasing", (Object)Boolean.FALSE);
        this.put("dataDefinitionCausesTransactionCommit", (Object)Boolean.FALSE);
        this.put("dataDefinitionIgnoredInTransactions", (Object)Boolean.FALSE);
        this.put("differentTableCorrelationNames", (Object)Boolean.FALSE);
        this.put("localFiles", (Object)Boolean.FALSE);
        this.put("localFilePerTable", (Object)Boolean.FALSE);
        this.put("maxRowSizeIncludeBlobs", (Object)Boolean.FALSE);
        this.put("nullPlusNonNullIsNull", (Object)Boolean.FALSE);
        this.put("proceduresAreCallable", (Object)Boolean.FALSE);
        this.put("tablesAreSelectable", (Object)Boolean.FALSE);
        this.put("readOnly", (Object)(this.isReadOnly() ? Boolean.TRUE : Boolean.FALSE));
        try {
            this.update(null);
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
    }

    protected void initChildren(Vector vector) throws DatabaseException {
        if (this.isConnected()) {
            vector.add(ConnectionNodeInfo.createNodeInfo(this, "tablelist"));
            vector.add(ConnectionNodeInfo.createNodeInfo(this, "viewlist"));
            vector.add(ConnectionNodeInfo.createNodeInfo(this, "procedurelist"));
        }
    }

    private void update(Connection connection) throws DatabaseException {
        if (connection == null) {
            this.setChildren(new Vector());
            return;
        }
        this.setProperties();
        this.refreshChildren();
    }

    private void setProperties() {
        try {
            DatabaseMetaData databaseMetaData = this.getSpecification().getMetaData();
            this.put("databaseProductName", (Object)databaseMetaData.getDatabaseProductName());
            this.put("mixedCaseIdentifiers", (Object)(databaseMetaData.supportsMixedCaseIdentifiers() ? Boolean.TRUE : Boolean.FALSE));
            this.put("mixedCaseQuotedIdentifiers", (Object)(databaseMetaData.supportsMixedCaseQuotedIdentifiers() ? Boolean.TRUE : Boolean.FALSE));
            this.put("alterTableWithAddColumn", (Object)(databaseMetaData.supportsAlterTableWithAddColumn() ? Boolean.TRUE : Boolean.FALSE));
            this.put("alterTableWithDropColumn", (Object)(databaseMetaData.supportsAlterTableWithDropColumn() ? Boolean.TRUE : Boolean.FALSE));
            this.put("convert", (Object)(databaseMetaData.supportsConvert() ? Boolean.TRUE : Boolean.FALSE));
            this.put("tableCorrelationNames", (Object)(databaseMetaData.supportsTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE));
            this.put("tableCorrelationNames", (Object)(databaseMetaData.supportsDifferentTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE));
            this.put("expressionsInOrderBy", (Object)(databaseMetaData.supportsExpressionsInOrderBy() ? Boolean.TRUE : Boolean.FALSE));
            this.put("orderByUnrelated", (Object)(databaseMetaData.supportsOrderByUnrelated() ? Boolean.TRUE : Boolean.FALSE));
            this.put("groupBy", (Object)(databaseMetaData.supportsGroupBy() ? Boolean.TRUE : Boolean.FALSE));
            this.put("groupByUnrelated", (Object)(databaseMetaData.supportsGroupByUnrelated() ? Boolean.TRUE : Boolean.FALSE));
            this.put("groupByBeyondSelect", (Object)(databaseMetaData.supportsGroupByBeyondSelect() ? Boolean.TRUE : Boolean.FALSE));
            this.put("likeEscapeClause", (Object)(databaseMetaData.supportsLikeEscapeClause() ? Boolean.TRUE : Boolean.FALSE));
            this.put("multipleResultSets", (Object)(databaseMetaData.supportsMultipleResultSets() ? Boolean.TRUE : Boolean.FALSE));
            this.put("multipleTransactions", (Object)(databaseMetaData.supportsMultipleTransactions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("nonNullableColumns", (Object)(databaseMetaData.supportsNonNullableColumns() ? Boolean.TRUE : Boolean.FALSE));
            this.put("minimumSQLGrammar", (Object)(databaseMetaData.supportsMinimumSQLGrammar() ? Boolean.TRUE : Boolean.FALSE));
            this.put("coreSQLGrammar", (Object)(databaseMetaData.supportsCoreSQLGrammar() ? Boolean.TRUE : Boolean.FALSE));
            this.put("extendedSQLGrammar", (Object)(databaseMetaData.supportsExtendedSQLGrammar() ? Boolean.TRUE : Boolean.FALSE));
            this.put("ANSI92EntryLevelSQL", (Object)(databaseMetaData.supportsANSI92EntryLevelSQL() ? Boolean.TRUE : Boolean.FALSE));
            this.put("ANSI92IntermediateSQL", (Object)(databaseMetaData.supportsANSI92IntermediateSQL() ? Boolean.TRUE : Boolean.FALSE));
            this.put("ANSI92FullSQL", (Object)(databaseMetaData.supportsANSI92FullSQL() ? Boolean.TRUE : Boolean.FALSE));
            this.put("IntegrityEnhancementFacility", (Object)(databaseMetaData.supportsIntegrityEnhancementFacility() ? Boolean.TRUE : Boolean.FALSE));
            this.put("outerJoins", (Object)(databaseMetaData.supportsOuterJoins() ? Boolean.TRUE : Boolean.FALSE));
            this.put("fullOuterJoins", (Object)(databaseMetaData.supportsFullOuterJoins() ? Boolean.TRUE : Boolean.FALSE));
            this.put("limitedOuterJoins", (Object)(databaseMetaData.supportsLimitedOuterJoins() ? Boolean.TRUE : Boolean.FALSE));
            this.put("schemasInDataManipulation", (Object)(databaseMetaData.supportsSchemasInDataManipulation() ? Boolean.TRUE : Boolean.FALSE));
            this.put("schemasInProcedureCalls", (Object)(databaseMetaData.supportsSchemasInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE));
            this.put("schemasInTableDefinitions", (Object)(databaseMetaData.supportsSchemasInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("schemasInIndexDefinitions", (Object)(databaseMetaData.supportsSchemasInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("schemasInPrivilegeDefinitions", (Object)(databaseMetaData.supportsSchemasInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("catalogsInDataManipulation", (Object)(databaseMetaData.supportsCatalogsInDataManipulation() ? Boolean.TRUE : Boolean.FALSE));
            this.put("catalogsInProcedureCalls", (Object)(databaseMetaData.supportsCatalogsInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE));
            this.put("catalogsInTableDefinitions", (Object)(databaseMetaData.supportsCatalogsInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("catalogsInIndexDefinitions", (Object)(databaseMetaData.supportsCatalogsInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("catalogsInPrivilegeDefinitions", (Object)(databaseMetaData.supportsCatalogsInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("positionedDelete", (Object)(databaseMetaData.supportsPositionedDelete() ? Boolean.TRUE : Boolean.FALSE));
            this.put("positionedUpdate", (Object)(databaseMetaData.supportsPositionedUpdate() ? Boolean.TRUE : Boolean.FALSE));
            this.put("selectForUpdate", (Object)(databaseMetaData.supportsSelectForUpdate() ? Boolean.TRUE : Boolean.FALSE));
            this.put("storedProcedures", (Object)(databaseMetaData.supportsStoredProcedures() ? Boolean.TRUE : Boolean.FALSE));
            this.put("subqueriesInComparisons", (Object)(databaseMetaData.supportsSubqueriesInComparisons() ? Boolean.TRUE : Boolean.FALSE));
            this.put("subqueriesInExists", (Object)(databaseMetaData.supportsSubqueriesInExists() ? Boolean.TRUE : Boolean.FALSE));
            this.put("subqueriesInIns", (Object)(databaseMetaData.supportsSubqueriesInIns() ? Boolean.TRUE : Boolean.FALSE));
            this.put("subqueriesInQuantifieds", (Object)(databaseMetaData.supportsSubqueriesInQuantifieds() ? Boolean.TRUE : Boolean.FALSE));
            this.put("correlatedSubqueries", (Object)(databaseMetaData.supportsCorrelatedSubqueries() ? Boolean.TRUE : Boolean.FALSE));
            this.put("union", (Object)(databaseMetaData.supportsUnion() ? Boolean.TRUE : Boolean.FALSE));
            this.put("unionAll", (Object)(databaseMetaData.supportsUnionAll() ? Boolean.TRUE : Boolean.FALSE));
            this.put("openCursorsAcrossCommit", (Object)(databaseMetaData.supportsOpenCursorsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE));
            this.put("openCursorsAcrossRollback", (Object)(databaseMetaData.supportsOpenCursorsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE));
            this.put("openStatementsAcrossCommit", (Object)(databaseMetaData.supportsOpenStatementsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE));
            this.put("openStatementsAcrossRollback", (Object)(databaseMetaData.supportsOpenStatementsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE));
            this.put("transactions", (Object)(databaseMetaData.supportsTransactions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("dataDefinitionAndDataManipulationTransactions", (Object)(databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("dataManipulationTransactionsOnly", (Object)(databaseMetaData.supportsDataManipulationTransactionsOnly() ? Boolean.TRUE : Boolean.FALSE));
            this.put("batchUpdates", (Object)(databaseMetaData.supportsBatchUpdates() ? Boolean.TRUE : Boolean.FALSE));
            this.put("catalogAtStart", (Object)(databaseMetaData.isCatalogAtStart() ? Boolean.TRUE : Boolean.FALSE));
            this.put("columnAliasing", (Object)(databaseMetaData.supportsColumnAliasing() ? Boolean.TRUE : Boolean.FALSE));
            this.put("dataDefinitionCausesTransactionCommit", (Object)(databaseMetaData.dataDefinitionCausesTransactionCommit() ? Boolean.TRUE : Boolean.FALSE));
            this.put("dataDefinitionIgnoredInTransactions", (Object)(databaseMetaData.dataDefinitionIgnoredInTransactions() ? Boolean.TRUE : Boolean.FALSE));
            this.put("differentTableCorrelationNames", (Object)(databaseMetaData.supportsDifferentTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE));
            this.put("localFiles", (Object)(databaseMetaData.usesLocalFiles() ? Boolean.TRUE : Boolean.FALSE));
            this.put("localFilePerTable", (Object)(databaseMetaData.usesLocalFilePerTable() ? Boolean.TRUE : Boolean.FALSE));
            this.put("maxRowSizeIncludeBlobs", (Object)(databaseMetaData.doesMaxRowSizeIncludeBlobs() ? Boolean.TRUE : Boolean.FALSE));
            this.put("nullPlusNonNullIsNull", (Object)(databaseMetaData.nullPlusNonNullIsNull() ? Boolean.TRUE : Boolean.FALSE));
            this.put("proceduresAreCallable", (Object)(databaseMetaData.allProceduresAreCallable() ? Boolean.TRUE : Boolean.FALSE));
            this.put("tablesAreSelectable", (Object)(databaseMetaData.allTablesAreSelectable() ? Boolean.TRUE : Boolean.FALSE));
            this.put("maxBinaryLiteralLength", (Object)new Integer(databaseMetaData.getMaxBinaryLiteralLength()));
            this.put("maxCharLiteralLength", (Object)new Integer(databaseMetaData.getMaxCharLiteralLength()));
            this.put("maxColumnNameLength", (Object)new Integer(databaseMetaData.getMaxColumnNameLength()));
            this.put("maxColumnsInGroupBy", (Object)new Integer(databaseMetaData.getMaxColumnsInGroupBy()));
            this.put("maxColumnsInIndex", (Object)new Integer(databaseMetaData.getMaxColumnsInIndex()));
            this.put("maxColumnsInOrderBy", (Object)new Integer(databaseMetaData.getMaxColumnsInOrderBy()));
            this.put("maxColumnsInSelect", (Object)new Integer(databaseMetaData.getMaxColumnsInSelect()));
            this.put("maxColumnsInTable", (Object)new Integer(databaseMetaData.getMaxColumnsInTable()));
            this.put("maxConnections", (Object)new Integer(databaseMetaData.getMaxConnections()));
            this.put("maxCursorNameLength", (Object)new Integer(databaseMetaData.getMaxCursorNameLength()));
            this.put("maxIndexLength", (Object)new Integer(databaseMetaData.getMaxIndexLength()));
            this.put("maxSchemaNameLength", (Object)new Integer(databaseMetaData.getMaxSchemaNameLength()));
            this.put("maxProcedureNameLength", (Object)new Integer(databaseMetaData.getMaxProcedureNameLength()));
            this.put("maxCatalogNameLength", (Object)new Integer(databaseMetaData.getMaxCatalogNameLength()));
            this.put("maxRowSize", (Object)new Integer(databaseMetaData.getMaxRowSize()));
            this.put("maxStatementLength", (Object)new Integer(databaseMetaData.getMaxStatementLength()));
            this.put("maxStatements", (Object)new Integer(databaseMetaData.getMaxStatements()));
            this.put("maxTableNameLength", (Object)new Integer(databaseMetaData.getMaxTableNameLength()));
            this.put("maxTablesInSelect", (Object)new Integer(databaseMetaData.getMaxTablesInSelect()));
            this.put("maxUserNameLength", (Object)new Integer(databaseMetaData.getMaxUserNameLength()));
            this.put("defaultTransactionIsolation", (Object)new Integer(databaseMetaData.getDefaultTransactionIsolation()));
            this.put("URL", (Object)databaseMetaData.getURL());
            this.put("userName", (Object)databaseMetaData.getUserName());
            this.put("databaseProductVersion", (Object)databaseMetaData.getDatabaseProductVersion());
            this.put("driverName", (Object)databaseMetaData.getDriverName());
            this.put("driverVersion", (Object)databaseMetaData.getDriverVersion());
            this.put("driverMajorVersion", (Object)new Integer(databaseMetaData.getDriverMajorVersion()));
            this.put("driverMinorVersion", (Object)new Integer(databaseMetaData.getDriverMinorVersion()));
            this.put("identifierQuoteString", (Object)databaseMetaData.getIdentifierQuoteString());
            this.put("SQLKeywords", (Object)databaseMetaData.getSQLKeywords());
            this.put("numericFunctions", (Object)databaseMetaData.getNumericFunctions());
            this.put("stringFunctions", (Object)databaseMetaData.getStringFunctions());
            this.put("systemFunctions", (Object)databaseMetaData.getSystemFunctions());
            this.put("timeDateFunctions", (Object)databaseMetaData.getTimeDateFunctions());
            this.put("searchStringEscape", (Object)databaseMetaData.getSearchStringEscape());
            this.put("extraNameCharacters", (Object)databaseMetaData.getExtraNameCharacters());
            this.put("schemaTerm", (Object)databaseMetaData.getSchemaTerm());
            this.put("procedureTerm", (Object)databaseMetaData.getProcedureTerm());
            this.put("catalogTerm", (Object)databaseMetaData.getCatalogTerm());
            this.put("catalogSeparator", (Object)databaseMetaData.getCatalogSeparator());
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
        }
    }

    private void connect(String string) throws DatabaseException {
        String string2 = this.getDriver();
        String string3 = this.getDatabase();
        try {
            DatabaseConnection databaseConnection = new DatabaseConnection(string2, string3, this.getUser(), this.getPassword());
            Connection connection = databaseConnection.createJDBCConnection();
            this.finishConnect(string, databaseConnection, connection);
        }
        catch (Exception exception) {
            DatabaseException databaseException = new DatabaseException(exception.getMessage());
            databaseException.initCause(exception);
            throw databaseException;
        }
    }

    public void connect() throws DatabaseException {
        this.connect((String)null);
    }

    public void connect(DBConnection dBConnection) throws DatabaseException {
        try {
            DatabaseConnection databaseConnection = (DatabaseConnection)dBConnection;
            Connection connection = databaseConnection.getConnection();
            SpecificationFactory specificationFactory = (SpecificationFactory)this.getSpecificationFactory();
            this.setReadOnly(false);
            Specification specification = (Specification)specificationFactory.createSpecification(databaseConnection, connection);
            this.put("dbproduct", specification.getProperties().get("dbproduct"));
            this.setSpecification(specification);
            DriverSpecification driverSpecification = specificationFactory.createDriverSpecification(specification.getMetaData().getDriverName().trim());
            if (specification.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                driverSpecification.setMetaData(connection.getMetaData());
            } else {
                driverSpecification.setMetaData(specification.getMetaData());
            }
            driverSpecification.setCatalog(connection.getCatalog());
            driverSpecification.setSchema(this.getSchema());
            this.setDriverSpecification(driverSpecification);
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException databaseProductNotFoundException) {
            this.setReadOnly(false);
            this.connect("GenericDatabaseSystem");
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void finishConnect(String string, DatabaseConnection databaseConnection, Connection connection) throws DatabaseException {
        try {
            Specification specification;
            SpecificationFactory specificationFactory = (SpecificationFactory)this.getSpecificationFactory();
            if (string != null) {
                specification = (Specification)specificationFactory.createSpecification(databaseConnection, string, connection);
            } else {
                this.setReadOnly(false);
                specification = (Specification)specificationFactory.createSpecification(databaseConnection, connection);
            }
            this.put("dbproduct", specification.getProperties().get("dbproduct"));
            this.setSpecification(specification);
            DriverSpecification driverSpecification = specificationFactory.createDriverSpecification(specification.getMetaData().getDriverName().trim());
            if (specification.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                driverSpecification.setMetaData(connection.getMetaData());
            } else {
                driverSpecification.setMetaData(specification.getMetaData());
            }
            driverSpecification.setCatalog(connection.getCatalog());
            driverSpecification.setSchema(this.getSchema());
            this.setDriverSpecification(driverSpecification);
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException databaseProductNotFoundException) {
            this.setReadOnly(false);
            this.connect("GenericDatabaseSystem");
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void disconnect() throws DatabaseException {
        Connection connection = this.getConnection();
        if (connection != null) {
            String string = null;
            try {
                connection.close();
                this.setConnection(null);
            }
            catch (Exception exception) {
                this.setConnection(null);
                string = MessageFormat.format(ConnectionNodeInfo.bundle().getString("EXC_ConnectionError"), exception.getMessage());
            }
            DerbyConectionEventListener.getDefault().afterDisconnect(this.getDatabaseConnection(), connection);
            if (string != null) {
                throw new DatabaseException(string);
            }
        }
    }

    public void delete() throws IOException {
        try {
            DatabaseConnection databaseConnection = this.getDatabaseConnection();
            ConnectionList.getDefault().remove(databaseConnection);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public Object put(String string, Object object) {
        if (string.equals("user") || string.equals("driver") || string.equals("db") || string.equals("schema") || string.equals("rememberpwd")) {
            this.updateConnection(string, object);
        }
        return super.put(string, object);
    }

    private void updateConnection(String string, Object object) {
        DatabaseConnection databaseConnection = this.getDatabaseConnection();
        DatabaseConnection databaseConnection2 = ConnectionList.getDefault().getConnection(databaseConnection);
        if (databaseConnection2 != null) {
            if (string.equals("schema")) {
                databaseConnection2.setSchema((String)object);
            } else if (string.equals("user")) {
                databaseConnection2.setUser((String)object);
            } else if (string.equals("driver")) {
                databaseConnection2.setDriver((String)object);
            } else if (string.equals("db")) {
                databaseConnection2.setDatabase((String)object);
            } else if (string.equals("rememberpwd")) {
                databaseConnection2.setRememberPassword((Boolean)object);
            }
        }
        this.setName(databaseConnection.getName());
    }

    public void refreshChildren() throws DatabaseException {
        Vector vector = this.getChildren();
        for (DatabaseNodeInfo databaseNodeInfo : vector) {
            databaseNodeInfo.refreshChildren();
        }
    }
}

