/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.impl.CommentView;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.RenameView;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.infos.DDLHelper;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class ViewNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = 8370676447530973161L;

    public void initChildren(Vector vector) throws DatabaseException {
        try {
            String string = (String)this.get("view");
            DriverSpecification driverSpecification = this.getDriverSpecification();
            driverSpecification.getColumns(string, "%");
            ResultSet resultSet = driverSpecification.getResultSet();
            if (resultSet != null) {
                while (resultSet.next()) {
                    DatabaseNodeInfo databaseNodeInfo = DatabaseNodeInfo.createNodeInfo(this, "viewcolumn", driverSpecification.getRow());
                    if (databaseNodeInfo == null) continue;
                    vector.add(databaseNodeInfo);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setProperty(String string, Object object) {
        try {
            if (string.equals("remarks")) {
                this.setRemarks((String)object);
            }
            this.put(string, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setRemarks(String string) throws DatabaseException {
        String string2 = (String)this.get("view");
        Specification specification = (Specification)this.getSpecification();
        try {
            CommentView commentView = specification.createCommandCommentView(string2, string);
            commentView.setObjectOwner((String)this.get("schema"));
            commentView.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void delete() throws IOException {
        try {
            DDLHelper.deleteView((Specification)this.getSpecification(), (String)this.get("schema"), this.getName());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void setName(String string) {
        try {
            Specification specification = (Specification)this.getSpecification();
            RenameView renameView = specification.createCommandRenameView(this.getName(), string);
            renameView.setObjectOwner((String)this.get("schema"));
            renameView.execute();
            super.setName(string);
            this.put("table", (Object)string);
            this.put("view", (Object)string);
            this.notifyChange();
        }
        catch (CommandNotSupportedException commandNotSupportedException) {
            String string2 = MessageFormat.format(ViewNodeInfo.bundle().getString("EXC_UnableToChangeName"), commandNotSupportedException.getCommand());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public String getShortDescription() {
        return ViewNodeInfo.bundle().getString("ND_View");
    }
}

