/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.Messages;
import com.sun.perseus.platform.MathSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;

public class Transform
implements SVGMatrix {
    float m0;
    float m1;
    float m2;
    float m3;
    float m4;
    float m5;

    public Transform(float m0, float m1, float m2, float m3, float m4, float m5) {
        this.setTransform(m0, m1, m2, m3, m4, m5);
    }

    public void setTransform(float m0, float m1, float m2, float m3, float m4, float m5) {
        this.m0 = m0;
        this.m1 = m1;
        this.m2 = m2;
        this.m3 = m3;
        this.m4 = m4;
        this.m5 = m5;
    }

    public void setTransform(SVGMatrix transform) {
        Transform txf = (Transform)transform;
        if (txf == null) {
            this.m0 = 1.0f;
            this.m1 = 0.0f;
            this.m2 = 0.0f;
            this.m3 = 1.0f;
            this.m4 = 0.0f;
            this.m5 = 0.0f;
            return;
        }
        this.m0 = txf.m0;
        this.m1 = txf.m1;
        this.m2 = txf.m2;
        this.m3 = txf.m3;
        this.m4 = txf.m4;
        this.m5 = txf.m5;
    }

    public void transformPoint(float[] pt, float[] opt) {
        opt[0] = pt[0] * this.m0 + pt[1] * this.m2 + this.m4;
        opt[1] = pt[0] * this.m1 + pt[1] * this.m3 + this.m5;
    }

    public Transform(SVGMatrix transform) {
        this.setTransform(transform);
    }

    public float getComponent(int index) throws DOMException {
        switch (index) {
            case 0: {
                return this.m0;
            }
            case 1: {
                return this.m1;
            }
            case 2: {
                return this.m2;
            }
            case 3: {
                return this.m3;
            }
            case 4: {
                return this.m4;
            }
            case 5: {
                return this.m5;
            }
        }
        throw new DOMException(1, Messages.formatMessage("error.out.of.bound.parameter.value", new String[]{"SVGMatrix", "getComponent", "index", "" + index}));
    }

    public SVGMatrix mMultiply(SVGMatrix secondMatrix) throws NullPointerException {
        if (secondMatrix == null) {
            throw new NullPointerException();
        }
        Transform sm = (Transform)secondMatrix;
        float t0 = sm.m0;
        float t1 = sm.m1;
        float t2 = sm.m2;
        float t3 = sm.m3;
        float t4 = sm.m4;
        float t5 = sm.m5;
        float mM0 = this.m0;
        float mM1 = this.m2;
        this.m0 = t0 * mM0 + t1 * mM1;
        this.m2 = t2 * mM0 + t3 * mM1;
        this.m4 += t4 * mM0 + t5 * mM1;
        mM0 = this.m1;
        mM1 = this.m3;
        this.m1 = t0 * mM0 + t1 * mM1;
        this.m3 = t2 * mM0 + t3 * mM1;
        this.m5 += t4 * mM0 + t5 * mM1;
        return this;
    }

    public SVGMatrix inverse() throws SVGException {
        Transform svm = new Transform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.inverse(svm);
        return svm;
    }

    public boolean isInvertible() {
        return this.m0 * this.m3 - this.m1 * this.m2 != 0.0f;
    }

    public SVGMatrix inverse(SVGMatrix txf) throws SVGException {
        Transform svm = (Transform)txf;
        float det = this.m0 * this.m3 - this.m2 * this.m1;
        if (MathSupport.abs(det) <= Float.MIN_VALUE) {
            throw new SVGException(2, this.toString());
        }
        if (svm == null) {
            svm = new Transform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        if (this.isIdentity()) {
            svm.setTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            return svm;
        }
        svm.m0 = this.m3 / det;
        svm.m2 = -this.m2 / det;
        svm.m4 = (this.m2 * this.m5 - this.m3 * this.m4) / det;
        svm.m1 = -this.m1 / det;
        svm.m3 = this.m0 / det;
        svm.m5 = (this.m1 * this.m4 - this.m0 * this.m5) / det;
        return svm;
    }

    public SVGMatrix mTranslate(float x, float y) {
        this.m4 = x * this.m0 + y * this.m2 + this.m4;
        this.m5 = x * this.m1 + y * this.m3 + this.m5;
        return this;
    }

    public SVGMatrix mScale(float scaleFactor) {
        this.m0 *= scaleFactor;
        this.m2 *= scaleFactor;
        this.m1 *= scaleFactor;
        this.m3 *= scaleFactor;
        return this;
    }

    public SVGMatrix mScale(float scaleFactorX, float scaleFactorY) {
        this.m0 *= scaleFactorX;
        this.m2 *= scaleFactorY;
        this.m1 *= scaleFactorX;
        this.m3 *= scaleFactorY;
        return this;
    }

    public SVGMatrix mRotate(float angle) {
        float angl = MathSupport.toRadians(angle);
        float trigTOLERANCE = 1.0E-7f;
        float sin = MathSupport.sin(angl);
        float cos = MathSupport.cos(angl);
        if (MathSupport.abs(sin) < 1.0E-7f) {
            if (cos < 0.0f) {
                this.m0 = -this.m0;
                this.m3 = -this.m3;
                this.m2 = -this.m2;
                this.m1 = -this.m1;
            }
            return this;
        }
        if (MathSupport.abs(cos) < 1.0E-7f) {
            if (sin < 0.0f) {
                float mM0 = this.m0;
                this.m0 = -this.m2;
                this.m2 = mM0;
                mM0 = this.m1;
                this.m1 = -this.m3;
                this.m3 = mM0;
            } else {
                float mM0 = this.m0;
                this.m0 = this.m2;
                this.m2 = -mM0;
                mM0 = this.m1;
                this.m1 = this.m3;
                this.m3 = -mM0;
            }
            return this;
        }
        float mM0 = this.m0;
        float mM1 = this.m2;
        this.m0 = cos * mM0 + sin * mM1;
        this.m2 = -sin * mM0 + cos * mM1;
        mM0 = this.m1;
        mM1 = this.m3;
        this.m1 = cos * mM0 + sin * mM1;
        this.m3 = -sin * mM0 + cos * mM1;
        return this;
    }

    public boolean isIdentity() {
        return this.m0 == 1.0f && this.m2 == 0.0f && this.m4 == 0.0f && this.m1 == 0.0f && this.m3 == 1.0f && this.m5 == 0.0f;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Transform)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Transform t = (Transform)obj;
        return t.m0 == this.m0 && t.m1 == this.m1 && t.m2 == this.m2 && t.m3 == this.m3 && t.m4 == this.m4 && t.m5 == this.m5;
    }

    public boolean equals(float[][] m) {
        return m[0][0] == this.m0 && m[1][0] == this.m1 && m[2][0] == this.m2 && m[3][0] == this.m3 && m[4][0] == this.m4 && m[5][0] == this.m5;
    }
}

